/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3d;
import pattern.DrawPanel;
import pattern.Graphics2;
import pattern.Piece;
import sweater.AddingParts;
import sweater.AdjustmentInputStroke;
import sweater.Cursors;
import sweater.Decorations;
import sweater.Eraser;
import sweater.ExtrusionOneStroke;
import sweater.Flattening;
import sweater.JaliceFrame;
import sweater.Model;
import sweater.ObjFile;
import sweater.PatchGenerater;
import sweater.Plane;
import sweater.Pull;
import sweater.SnapTarget;
import sweater.Suggestion;
import sweater.SurfaceLine;
import sweater.TmpCamera;
import sweater.Undo;
import teddy.CameraInterface;
import teddy.CleanStroke;
import teddy.Edge;
import teddy.Face;
import teddy.Inflate;
import teddy.Polyhedron;
import teddy.StrokeAnalyzer;
import teddy.SurfacePath;
import teddy.Vertex;
import teddy.Vertex2D;
import timer.Timer;
import timer.TimerCaller;

public class Sweater
implements MouseListener,
MouseMotionListener,
KeyListener,
TimerCaller {
    public List stroke = new ArrayList();
    private List temp_stroke = new ArrayList();
    private boolean modelingMode = true;
    private boolean deformingMode = false;
    private boolean clearStroke = true;
    private boolean renderingPieceNumbers = false;
    private boolean pullMode = false;
    private boolean eyeMode = false;
    private boolean noseMode = false;
    private boolean stuffedMode = true;
    boolean do_not_paint_laser = false;
    boolean do_not_paint_label = false;
    public Font font = new Font("Helvetica", 0, 36);
    boolean cross_notice = false;
    boolean cannot_undo_notice = false;
    CameraInterface camera;
    private int ongoing_operation;
    private final int POP = 1;
    private final int CUT = 2;
    private final int FILLET = 3;
    private List models = new ArrayList();
    int R = 20;
    public Model targetModel;
    private int TRASH_SIZE = 50;
    public static int inflation_mode;
    static final int ROTUND = 0;
    static final int PLATE = 1;
    boolean inflating = false;
    public boolean laser = false;
    static double auto_rotation_angle;
    static double auto_rotation_speed;
    boolean prev_timer_on;
    private Visual pickedVisual;
    private Transformable pickedVehicle;
    private Model pickedModel;
    int operation_status;
    final int NONE = 0;
    final int DRAWING = 1;
    final int ROTATING = 2;
    final int SLIDING = 3;
    final int PULLING = 4;
    final int PINNING = 5;
    final int ZOOMING = 6;
    final int CUTTING = 7;
    final int ERASING = 8;
    final int ALLSLIDING = 9;
    final int ALLROTATING = 10;
    final int SEAMING = 11;
    final int HIGHLIGHT_PIECE = 12;
    final int FLATTING = 13;
    final int MODELING = 14;
    final int EXTRUSION = 16;
    final int SEAM_ON_EDGE = 17;
    final int SEAMING_BY_CLICK = 18;
    final int DEFORMING = 19;
    final int GENERATE = 20;
    final int DRAW_SURFACE_LINE = 21;
    final int SEAM_ERASING = 22;
    final int ADDING_PARTS = 23;
    final int DECORATION = 24;
    final int DRAW_SEAM_LINE = 25;
    int prev_x;
    int prev_y;
    static boolean instant_mode;
    static boolean sharp_edge;
    Timer timer;
    public static JaliceFrame jaliceFrame;
    public static String renderername;
    public static Sweater sweater;

    static {
        auto_rotation_angle = 360.0;
        auto_rotation_speed = 10.0;
        instant_mode = false;
        sharp_edge = false;
    }

    private void clear_stroke() {
        this.temp_stroke = this.stroke;
        this.stroke = new ArrayList();
    }

    public void paintOverlay(Graphics g) {
        g.setColor(Color.red);
        int i = 0;
        while (i < this.stroke.size() - 1) {
            Point p0 = (Point)this.stroke.get(i);
            Point p1 = (Point)this.stroke.get(i + 1);
            Graphics2.drawWideLine((Graphics)g, (int)p0.x, (int)p0.y, (int)p1.x, (int)p1.y, (double)6.0);
            ++i;
        }
        if (this.stroke.size() > 2 && this.models.size() > 0) {
            Point p = (Point)this.stroke.get(0);
            Point q = (Point)this.stroke.get(this.stroke.size() - 1);
            double d = StrokeAnalyzer.getLength_Points((List)this.stroke, (boolean)false);
        }
        if (this.laser && !this.do_not_paint_laser) {
            g.drawString("LASER", 10, 20);
        }
        if (this.renderingPieceNumbers) {
            this.paint_patch_numbers(g);
        }
        if (this.do_not_paint_label) {
            this.do_not_paint_label = false;
        } else {
            this.paint_lable(g);
        }
        this.paint_notice(g);
        Decorations.paint(g);
        Suggestion.paintSuggestions(g);
    }

    public void repaint() {
        jaliceFrame.repaint();
    }

    private void paint_notice(Graphics g) {
        g.setColor(Color.red);
        g.setFont(this.font);
        if (this.cross_notice) {
            g.drawString("draw stroke again", 20, 600);
        }
        if (this.cannot_undo_notice) {
            g.drawString("can not undo", 20, 600);
        }
    }

    private void paint_lable(Graphics g) {
        g.setColor(Color.black);
        g.setFont(this.font);
        g.drawString(this.get_label(), 20, 50);
    }

    private void paint_patch_numbers(Graphics g) {
        g.setColor(Color.MAGENTA);
        g.setFont(this.font);
        if (this.pickedModel == null) {
            return;
        }
        if (this.pickedModel.patches == null) {
            return;
        }
        int i = 0;
        while (i < this.pickedModel.patches.size()) {
            teddy.Vector3 normal;
            Polyhedron patch = (Polyhedron)this.pickedModel.patches.get(i);
            Piece piece = patch.piece;
            int number = piece.id;
            TmpCamera camera = new TmpCamera(this.pickedModel);
            Face center_face = patch.get_center_face();
            Vertex center = center_face.get_center();
            if (camera.front_facing(center, normal = center_face.normal)) {
                Vector3 vec = this.pickedModel.teddyVertex_to_jaliceVector3(center);
                vec = jaliceFrame.local_coords_to_screen_coords(vec, (ReferenceFrame)this.pickedModel.modelVehicle);
                g.drawString("" + number, (int)vec.x, (int)vec.y);
            }
            ++i;
        }
    }

    private String get_label() {
        switch (this.ongoing_operation) {
            case 0: {
                return "";
            }
            case 1: {
                return "EXTRUSION";
            }
            case 2: {
                return "CUT";
            }
            case 3: {
                return "FILLET";
            }
        }
        return "";
    }

    private void initialize_notice() {
        this.cross_notice = false;
        this.cannot_undo_notice = false;
    }

    private void startStroke(Point p) {
        jaliceFrame.setCursor(Cursors.brushCursor);
        this.timer.turn_off();
        this.stroke = new ArrayList();
        this.extendStroke(p);
    }

    private void extendStroke(Point p) {
        this.stroke.add(p);
        this.do_not_paint_laser = true;
        this.do_not_paint_label = true;
        jaliceFrame.paintOverlay();
        this.do_not_paint_laser = false;
    }

    private void finishStroke(MouseEvent mouseEvent) {
        jaliceFrame.setCursor(Cursors.defaultCursor);
        jaliceFrame.lock();
        if (CleanStroke.isCrossStroke_forPoints((List)this.stroke)) {
            System.out.println("cross!");
            this.cross_notice = true;
        } else if (this.stroke.size() < 5) {
            this.click((Point)this.stroke.get(0));
        } else if (this.ongoing_operation == 1) {
            this.extrude(this.targetModel);
            AdjustmentInputStroke.setInputVertices(this.targetModel);
            this.timer.turn_on();
        } else {
            Suggestion.clearSuggestions();
            this.pickedModel = this.pick_during_stroke_and_set_mode(this.stroke);
            switch (this.operation_status) {
                case 20: {
                    this.generate(this.stroke);
                    this.timer.turn_on();
                    break;
                }
                case 2: {
                    this.draw_cut_line(this.pickedModel);
                    this.pickedModel.removeSurfaceLine();
                    this.cut(this.pickedModel);
                    AdjustmentInputStroke.setInputVertices(this.pickedModel);
                    this.timer.turn_on();
                    break;
                }
                case 1: {
                    this.extrude_one_stroke(this.pickedModel);
                    AdjustmentInputStroke.setInputVertices(this.pickedModel);
                    break;
                }
                case 21: {
                    boolean loop = this.drawSurfaceLine(this.pickedModel);
                    if (loop) break;
                    this.operation_status = 25;
                    this.drawDartsLine_and_Flattening(this.pickedModel);
                    break;
                }
                case 25: {
                    if ((mouseEvent.getModifiers() & 1) != 0) {
                        this.draw_darts_line_on_edge(this.pickedModel);
                    } else {
                        this.draw_darts_line(this.pickedModel);
                    }
                    Flattening.flattening_update(this.pickedModel);
                    Inflate.update_target_length((Model)this.pickedModel);
                    break;
                }
            }
        }
        if (this.clearStroke) {
            this.clear_stroke();
        }
        jaliceFrame.unlock();
    }

    private Rectangle trashbox() {
        Dimension size = Sweater.jaliceFrame.awtComponent.getSize();
        return new Rectangle((int)((double)size.width - (double)this.TRASH_SIZE * 1.2), (int)((double)size.height - (double)this.TRASH_SIZE * 1.2), this.TRASH_SIZE, this.TRASH_SIZE);
    }

    public void undo() {
        this.timer.turn_off();
        this.clear_stroke();
        Inflate.set_target_length((Polyhedron)this.pickedModel.polyhedron);
        this.ongoing_operation = 0;
        this.operation_status = 0;
        jaliceFrame.repaint();
        this.timer.turn_on();
    }

    public void pushUndo() {
        Undo.pushUndo();
    }

    public void again() {
        this.generate(this.temp_stroke);
    }

    private void extrude_one_stroke(Model model) {
        ExtrusionOneStroke.extrude_one_stroke(model, this.stroke);
    }

    private void extrude(Model model) {
        if (model == null) {
            return;
        }
        model.removeSurfaceLine();
        model.extrude(model.getSurfacePath(), this.stroke);
        Flattening.flattening_update(model);
        model.update();
        Inflate.update_target_length((Model)model);
        this.inflate();
        this.ongoing_operation = 0;
        this.operation_status = 0;
        this.pickedModel = this.targetModel;
    }

    private boolean drawSurfaceLine(Model pickedModel) {
        boolean loop = false;
        if (Vertex2D.distance((Point)((Point)this.stroke.get(0)), (Point)((Point)this.stroke.get(this.stroke.size() - 1))) < 20.0) {
            loop = true;
            this.stroke = Model.adjust_stroke_direction(this.stroke);
        }
        SurfacePath surfacePath = pickedModel.getSurfacePath(this.stroke, loop);
        pickedModel.setSurfacePath(surfacePath);
        pickedModel.addSurfaceLine(surfacePath, SurfaceLine.RED);
        surfacePath = pickedModel.getSurfacePath();
        if (surfacePath.loop) {
            this.ongoing_operation = 1;
            this.targetModel = pickedModel;
        }
        Sweater.jaliceFrame.renderTarget.markDirty();
        return loop;
    }

    private void draw_cut_line(Model pickedModel) {
        SurfacePath surfacePath = pickedModel.getSurfacePathForCut(this.stroke, false);
        surfacePath.loop = true;
        pickedModel.setSurfacePath(surfacePath);
        pickedModel.addSurfaceLine(surfacePath, SurfaceLine.RED);
        this.ongoing_operation = 2;
        this.targetModel = pickedModel;
        jaliceFrame.repaint();
    }

    private void draw_darts_line(Model model) {
        SurfacePath surfacePath = model.getSurfacePath(this.stroke, false);
        model.setSurfacePath(surfacePath);
        model.remesh_no_loop(model.getSurfacePath());
        model.update();
        this.ongoing_operation = 0;
    }

    private void draw_darts_line_on_edge(Model model) {
        SurfacePath surfacePath = model.getSurfacePath(this.stroke, false);
        int i = 0;
        while (i < surfacePath.size()) {
            boolean onEdge = surfacePath.onEdge(i);
            if (onEdge) {
                Edge edge = surfacePath.getEdge(i);
                edge.seam = true;
            }
            ++i;
        }
        model.update();
    }

    private void highlight_piece(Point p) {
        this.pickedModel = this.pickModel(p);
        Vertex v = this.pickedModel.pickVertex(p);
        Polyhedron pickedPatch = new Polyhedron();
        int i = 0;
        while (i < this.pickedModel.patches.size()) {
            Polyhedron patch = (Polyhedron)this.pickedModel.patches.get(i);
            if (patch.include_vertex(v)) {
                pickedPatch = patch;
                break;
            }
            ++i;
        }
        DrawPanel panel = DrawPanel.getInstance();
        DrawPanel.dragged_piece = pickedPatch.piece;
        panel.repaint();
    }

    private void highlight_seam(Point p) {
        this.pickedModel = this.pickModel(p);
        if (this.pickedModel == null) {
            return;
        }
        Vertex v = this.pickedModel.pickVertex(p);
        Polyhedron pickedPatch = new Polyhedron();
        int i = 0;
        while (i < this.pickedModel.patches.size()) {
            Polyhedron patch = (Polyhedron)this.pickedModel.patches.get(i);
            if (patch.include_vertex(v)) {
                pickedPatch = patch;
                break;
            }
            ++i;
        }
        List boundary_points = PatchGenerater.trace_boundary(pickedPatch);
        int i2 = 0;
        while (i2 < boundary_points.size()) {
            Vertex vertex = (Vertex)boundary_points.get(i2);
            ++i2;
        }
        DrawPanel panel = DrawPanel.getInstance();
        DrawPanel.dragged_piece = pickedPatch.piece;
        panel.repaint();
    }

    private boolean check_stroke(List stroke) {
        boolean ret_val = false;
        if (this.models.size() == 0) {
            ret_val = false;
        } else {
            Point p = (Point)stroke.get(0);
            this.pickedVisual = this.pickVisual(p.x, p.y);
            this.pickedModel = this.pickModel(this.pickedVisual);
            if (this.pickedModel == null) {
                ret_val = false;
            } else {
                ret_val = true;
                int i = 1;
                while (i < stroke.size() - 1) {
                    p = (Point)stroke.get(i);
                    Visual visual = this.pickVisual(p.x, p.y);
                    Model model = this.pickModel(visual);
                    if (model == null) {
                        ret_val = false;
                    }
                    ++i;
                }
            }
        }
        return ret_val;
    }

    private Model pick_during_stroke_and_set_mode(List stroke) {
        this.operation_status = 0;
        if (this.models.size() == 0) {
            this.operation_status = 20;
            this.pickedModel = null;
        } else {
            Point p = (Point)stroke.get(0);
            this.pickedVisual = this.pickVisual(p.x, p.y);
            this.pickedModel = this.pickModel(this.pickedVisual);
            if (this.pickedModel == null) {
                this.pickedModel = this.pick_during_stroke(stroke);
                this.operation_status = this.pickedModel == null ? 0 : 2;
                this.operation_status = 0;
            } else {
                int i = 1;
                while (i < stroke.size() - 1) {
                    p = (Point)stroke.get(i);
                    Visual visual = this.pickVisual(p.x, p.y);
                    Model model = this.pickModel(visual);
                    if (model == null) {
                        this.operation_status = 1;
                    }
                    ++i;
                }
                this.operation_status = 0;
                p = (Point)stroke.get(stroke.size() - 1);
                Visual visual = this.pickVisual(p.x, p.y);
                Model model = this.pickModel(visual);
                if (this.operation_status == 0) {
                    this.operation_status = 21;
                }
            }
        }
        return this.pickedModel;
    }

    private void remeshDrawLine_and_Flattening(Model model) {
        model.remesh(model.getSurfacePath());
        model.update();
        Flattening.ABF(model, true);
        Inflate.update_target_length((Model)model);
        model.removeSurfaceLine();
    }

    private void drawDartsLine_and_Flattening(Model model) {
        this.draw_darts_line(model);
        Flattening.flattening_update(model);
        Inflate.update_target_length((Model)model);
        model.removeSurfaceLine();
    }

    private Model pick_during_stroke(List stroke) {
        if (this.models.size() == 0) {
            return null;
        }
        int i = 1;
        while (i < stroke.size()) {
            Point p = (Point)stroke.get(i);
            this.pickedVisual = this.pickVisual(p.x, p.y);
            this.pickedModel = this.pickModel(this.pickedVisual);
            if (this.pickedModel != null) break;
            ++i;
        }
        return this.pickedModel;
    }

    private void click(Point p) {
        System.out.println("click");
        if (this.pickedModel != null) {
            if (this.ongoing_operation == 1) {
                SurfacePath surfacePath = this.pickedModel.getSurfacePath();
                System.out.println("surfacePath" + surfacePath);
                if (surfacePath == null) {
                    return;
                }
                if (surfacePath.loop) {
                    System.out.println("loop");
                    this.remeshDrawLine_and_Flattening(this.pickedModel);
                } else {
                    this.pushUndo();
                    this.pickedModel.removeSurfaceLine();
                }
                this.ongoing_operation = 0;
                this.targetModel = null;
            } else if (this.ongoing_operation == 3) {
                this.pickedModel.removeSurfaceLine();
                this.ongoing_operation = 0;
                this.targetModel = null;
            }
        }
    }

    private void cut(Model model) {
        SurfacePath surfacePath = this.pickedModel.getSurfacePath();
        this.pickedModel.laplacian_cut(surfacePath);
        Flattening.flattening_update_for_cut(this.pickedModel);
        this.pickedModel.update();
        Inflate.update_target_length((Model)this.pickedModel);
        this.inflate();
        this.ongoing_operation = 0;
    }

    private void remesh(Model model) {
        SurfacePath surfacePath = this.pickedModel.getSurfacePath();
        this.pickedModel.laplacian_remesh(surfacePath);
        this.pickedModel.update();
        this.ongoing_operation = 0;
    }

    private void deleteSurfaceLine(SurfaceLine surfaceLine) {
        surfaceLine.model.removeSurfaceLine(surfaceLine);
        this.repaint();
    }

    void generate(List stroke) {
        Model model = new Model(stroke, Sweater.jaliceFrame.scene);
        if (model == null || model.polyhedron == null) {
            return;
        }
        AdjustmentInputStroke.setInputVertices(model);
        this.models.add(model);
        model.modelVehicle.setParent((Container)Sweater.jaliceFrame.scene);
        this.pickedModel = model;
        Flattening.flatteningForGenerate(this.pickedModel);
        this.pickedModel.update();
        Inflate.update_target_length((Model)this.pickedModel);
        this.inflate();
    }

    public void clear() {
        int i = 0;
        while (i < this.models.size()) {
            ((Model)this.models.get(i)).delete();
            ++i;
        }
        this.models = new ArrayList();
        this.stroke = new ArrayList();
        this.pickedModel = null;
        this.inflating = false;
        Sweater.jaliceFrame.scale = 1.0;
        jaliceFrame.update_camera();
        this.timer.turn_off();
        this.timer = new Timer(null, 100);
    }

    void convert() {
        this.inflating = false;
    }

    public void makeSeams() {
        if (this.pickedModel == null) {
            return;
        }
        Polyhedron h = this.pickedModel.polyhedron;
        int i = 0;
        while (i < h.edges.size()) {
            Edge edge = h.edges(i);
            teddy.Vector3 r_normal = edge.right_face.normal;
            teddy.Vector3 l_normal = edge.left_face.normal;
            double angle = Vertex.cos((teddy.Vector3)r_normal, (teddy.Vector3)l_normal);
            if (angle > -0.8 && angle < 0.8) {
                edge.seam = true;
            }
            ++i;
        }
        this.pickedModel.setLineArray();
        this.do_not_paint_laser = true;
        jaliceFrame.paintOverlay();
        this.do_not_paint_laser = false;
    }

    public void drift() {
        if (this.pickedModel != null) {
            this.pickedModel.drift();
        }
    }

    public void remesh() {
        if (this.pickedModel == null) {
            return;
        }
        this.timer.turn_off();
        this.pickedModel.remesh();
    }

    public void divide() {
        if (this.pickedModel == null) {
            return;
        }
        this.pickedModel.divide();
        Flattening.ABF(this.pickedModel, true);
    }

    public void inflate() {
        if (this.timer.on) {
            this.timer.turn_off();
        } else {
            this.timer.turn_on((TimerCaller)this);
        }
    }

    public void inflate_debug() {
        if (this.pickedModel == null) {
            return;
        }
        int i = 0;
        while (i < 4) {
            this.pickedModel.inflate();
            ++i;
        }
    }

    public void tick() {
        if (this.pickedModel == null) {
            return;
        }
        this.pickedModel.inflate();
        this.auto_rotation();
    }

    public void style() {
        if (this.pickedModel != null) {
            this.pickedModel.style();
        }
    }

    public void laser() {
        this.set_laser(!this.laser);
        jaliceFrame.repaint();
    }

    public void set_laser(boolean _laser) {
        this.laser = _laser;
        DrawPanel panel = DrawPanel.getInstance();
        panel.laser = this.laser;
        panel.repaint();
    }

    public void delete() {
        if (this.pickedModel == null || this.pickedModel == this.models.get(0)) {
            return;
        }
        this.pickedModel.delete();
        this.models.remove(this.pickedModel);
        this.pickedModel = null;
    }

    public void texture() {
        if (this.pickedModel == null) {
            return;
        }
        this.pickedModel.setTextureEnabled(!this.pickedModel.isTextureEnabled());
    }

    public void save() {
        if (this.models.size() == 0) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Save Model", 1);
        fileDialog.setDirectory(".\\data");
        fileDialog.setFile("*.obj");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            ObjFile.save(this.pickedModel, filename);
        }
        fileDialog.dispose();
    }

    public void load() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Load Model", 0);
        fileDialog.setDirectory(".\\data");
        fileDialog.setFile("*.obj");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            this.load(filename);
        }
        fileDialog.dispose();
    }

    public void load(String filename) {
        int i = 0;
        while (i < this.models.size()) {
            ((Model)this.models.get(i)).delete();
            ++i;
        }
        this.models = new ArrayList();
        Model model = ObjFile.load(filename);
        Inflate.init((Polyhedron)model.polyhedron);
        this.models.add(model);
        model.modelVehicle.setParent((Container)Sweater.jaliceFrame.scene);
        this.pickedModel = model;
        Flattening.ABF(this.pickedModel, true);
        this.pickedModel.setLineArray();
        this.pickedModel.update();
        this.do_not_paint_laser = true;
        jaliceFrame.paintOverlay();
        this.do_not_paint_laser = false;
    }

    private void rotate(int x, int y) {
        Vector3 pos = this.pickedVehicle.getPosition((ReferenceFrame)Sweater.jaliceFrame.scene);
        this.pickedVehicle.setPosition((Vector3d)new Vector3(), (ReferenceFrame)Sweater.jaliceFrame.scene);
        this.pickedVehicle.rotate((Vector3d)Vector3.Y_AXIS, (double)(-(x - this.prev_x)) / 100.0, (ReferenceFrame)Sweater.jaliceFrame.cameraVehicle);
        this.pickedVehicle.rotate((Vector3d)Vector3.X_AXIS, (double)(-(y - this.prev_y)) / 100.0, (ReferenceFrame)Sweater.jaliceFrame.cameraVehicle);
        this.pickedVehicle.setPosition((Vector3d)pos, (ReferenceFrame)Sweater.jaliceFrame.scene);
        this.prev_x = x;
        this.prev_y = y;
    }

    static void start_auto_rotation() {
        auto_rotation_angle = 0.0;
    }

    void auto_rotation() {
        if (auto_rotation_angle >= 360.0) {
            return;
        }
        auto_rotation_angle += auto_rotation_speed;
        this.pickedVehicle = this.getPickedModel().modelVehicle;
        Vector3 pos = this.pickedVehicle.getPosition((ReferenceFrame)Sweater.jaliceFrame.scene);
        this.pickedVehicle.setPosition((Vector3d)new Vector3(), (ReferenceFrame)Sweater.jaliceFrame.scene);
        this.pickedVehicle.rotate((Vector3d)Vector3.Y_AXIS, auto_rotation_speed / 360.0 * 2.0 * Math.PI, (ReferenceFrame)Sweater.jaliceFrame.scene);
        this.pickedVehicle.setPosition((Vector3d)pos, (ReferenceFrame)Sweater.jaliceFrame.scene);
    }

    private void all_rotate(int x, int y) {
        int i = 0;
        while (i < this.models.size()) {
            this.pickedModel = (Model)this.models.get(i);
            this.pickedVehicle = this.pickedModel.modelVehicle;
            Vector3 pos = this.pickedVehicle.getPosition((ReferenceFrame)Sweater.jaliceFrame.scene);
            this.pickedVehicle.setPosition((Vector3d)new Vector3(), (ReferenceFrame)Sweater.jaliceFrame.scene);
            this.pickedVehicle.rotate((Vector3d)Vector3.Y_AXIS, (double)(-(x - this.prev_x)) / 100.0, (ReferenceFrame)Sweater.jaliceFrame.cameraVehicle);
            this.pickedVehicle.rotate((Vector3d)Vector3.X_AXIS, (double)(-(y - this.prev_y)) / 100.0, (ReferenceFrame)Sweater.jaliceFrame.cameraVehicle);
            this.pickedVehicle.setPosition((Vector3d)pos, (ReferenceFrame)Sweater.jaliceFrame.scene);
            ++i;
        }
        this.prev_x = x;
        this.prev_y = y;
    }

    private void slide(Point p) {
        Vector3 base = this.pickedVehicle.getPosition((ReferenceFrame)Sweater.jaliceFrame.scene);
        Vector3 normal = Sweater.jaliceFrame.cameraVehicle.getOrientation((ReferenceFrame)Sweater.jaliceFrame.scene)[0];
        normal.normalize();
        Plane plane = new Plane(base, normal);
        Vector3 pos = plane.project(p);
        Vector3 prev_pos = plane.project(new Point(this.prev_x, this.prev_y));
        Vector3 vec = Vector3.subtract((Vector3d)pos, (Vector3d)prev_pos);
        this.pickedVehicle.translate((Vector3d)vec, (ReferenceFrame)Sweater.jaliceFrame.scene);
        this.prev_x = p.x;
        this.prev_y = p.y;
    }

    private void all_slide(Point p) {
        int i = 0;
        while (i < this.models.size()) {
            this.pickedModel = (Model)this.models.get(i);
            this.pickedVehicle = this.pickedModel.modelVehicle;
            Vector3 base = this.pickedVehicle.getPosition((ReferenceFrame)Sweater.jaliceFrame.scene);
            Vector3 normal = Sweater.jaliceFrame.cameraVehicle.getOrientation((ReferenceFrame)Sweater.jaliceFrame.scene)[0];
            normal.normalize();
            Plane plane = new Plane(base, normal);
            Vector3 pos = plane.project(p);
            Vector3 prev_pos = plane.project(new Point(this.prev_x, this.prev_y));
            Vector3 vec = Vector3.subtract((Vector3d)pos, (Vector3d)prev_pos);
            this.pickedVehicle.translate((Vector3d)vec, (ReferenceFrame)Sweater.jaliceFrame.scene);
            ++i;
        }
        this.prev_x = p.x;
        this.prev_y = p.y;
    }

    private void start_sliding(Point p) {
        this.prev_timer_on = this.timer.on;
        this.timer.turn_off();
    }

    private void finish_sliding() {
    }

    private void start_rotating() {
        this.prev_timer_on = this.timer.on;
        this.timer.turn_off();
    }

    private void finish_rotating() {
    }

    public void start_zooming(Point p) {
    }

    public void zooming(Point p) {
        Sweater.jaliceFrame.scale *= Math.pow(1.02, -(p.y - this.prev_y));
        jaliceFrame.update_camera();
        this.prev_x = p.x;
        this.prev_y = p.y;
    }

    public void finish_zooming(Point p) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point p = mouseEvent.getPoint();
        if (this.isEyeMode()) {
            jaliceFrame.setCursor(Cursors.eyeCursor);
        } else if (this.isNoseMode()) {
            jaliceFrame.setCursor(Cursors.noseCursor);
        } else if (this.isPullMode()) {
            if (SnapTarget.grab_snap_target(p)) {
                jaliceFrame.setCursor(Cursors.pullCursor);
            } else {
                jaliceFrame.setCursor(Cursors.defaultCursor);
            }
        } else if ((mouseEvent.getModifiers() & 8) != 0) {
            jaliceFrame.setCursor(Cursors.eraserCursor);
        } else if (SnapTarget.grab_snap_target(p)) {
            jaliceFrame.setCursor(Cursors.brushRedCursor);
        } else {
            jaliceFrame.setCursor(Cursors.defaultCursor);
        }
    }

    private void print_operation_status() {
        switch (this.operation_status) {
            case 0: {
                System.out.println("NONE");
                break;
            }
            case 1: {
                System.out.println("DRAWING");
                break;
            }
            case 2: {
                System.out.println("ROTATING");
                break;
            }
            case 3: {
                System.out.println("SLIDING");
                break;
            }
            case 4: {
                System.out.println("PULLING");
                break;
            }
            case 5: {
                System.out.println("PINNING");
                break;
            }
            case 6: {
                System.out.println("ZOOMING");
                break;
            }
            case 7: {
                System.out.println("CUTTING");
                break;
            }
            case 8: {
                System.out.println("ERASING");
                break;
            }
            case 9: {
                System.out.println("ALLSLIDING");
                break;
            }
            case 10: {
                System.out.println("ALLROTATING");
                break;
            }
            case 11: {
                System.out.println("SEAMING");
                break;
            }
            case 12: {
                System.out.println("HIGHLIGHT_PIECE");
                break;
            }
            case 13: {
                System.out.println("FLATTING");
                break;
            }
            case 14: {
                System.out.println("MODELING");
                break;
            }
            case 16: {
                System.out.println("EXTRUSION");
                break;
            }
            case 18: {
                System.out.println("SEAMING_BY_CLICK");
                break;
            }
            case 19: {
                System.out.println("DEFORMING");
                break;
            }
            case 20: {
                System.out.println("GENERATE");
                break;
            }
            case 21: {
                System.out.println("DRAW_SURFACE_LINE");
                break;
            }
            case 22: {
                System.out.println("SEAM_ERASING");
                break;
            }
            case 23: {
                System.out.println("ADDING_PARTS");
                break;
            }
            default: {
                System.out.println("other");
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point p = mouseEvent.getPoint();
        switch (this.operation_status) {
            case 1: {
                this.extendStroke(p);
                break;
            }
            case 2: {
                this.rotate(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            case 10: {
                this.all_rotate(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            case 3: {
                this.slide(p);
                break;
            }
            case 9: {
                this.all_slide(p);
                break;
            }
            case 4: 
            case 5: {
                Pull.pulling_for_piece(p);
                break;
            }
            case 6: {
                this.zooming(p);
                break;
            }
            case 18: {
                break;
            }
            case 8: {
                Eraser.extendErasing(p);
                break;
            }
            case 22: {
                Eraser.extendSeamErasing(p);
                break;
            }
            case 23: {
                AddingParts.extendStroke(p);
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Point p = mouseEvent.getPoint();
        if (Suggestion.pressSuggestion(p)) {
            Suggestion s = Suggestion.currentSuggestion;
            this.pickedModel = (Model)this.models.get(0);
            this.pickedModel.hide();
            this.pickedModel = s.getModel();
            Flattening.flattening_update(this.pickedModel);
            Inflate.update_target_length((Model)this.pickedModel);
            DrawPanel.getInstance().repaint();
            this.models = new ArrayList();
            this.models.add(this.pickedModel);
            this.pickedModel.show();
        }
        switch (this.operation_status) {
            case 1: {
                this.finishStroke(mouseEvent);
                this.operation_status = 0;
                break;
            }
            case 2: 
            case 10: {
                this.finish_rotating();
                this.operation_status = 0;
                break;
            }
            case 3: 
            case 9: {
                this.finish_sliding();
                this.operation_status = 0;
                break;
            }
            case 4: {
                Suggestion.clearSuggestions();
                Pull.finish_pulling_for_piece();
                this.operation_status = 0;
                this.timer.turn_on();
                break;
            }
            case 6: {
                this.finish_zooming(p);
                this.operation_status = 0;
                break;
            }
            case 18: {
                break;
            }
            case 8: {
                Eraser.finishErasing();
                break;
            }
            case 22: {
                Eraser.finishSeamErasing();
                break;
            }
            case 23: {
                AddingParts.finishStroke(p);
            }
        }
        SnapTarget.update_onscreen_snap_targets(this.pickedModel);
        jaliceFrame.setCursor(Cursors.defaultCursor);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.initialize_notice();
        this.repaint();
        if (this.ongoing_operation != 1) {
            this.pickedModel = null;
        }
        this.timer.turn_off();
        Point p = mouseEvent.getPoint();
        this.prev_x = p.x;
        this.prev_y = p.y;
        this.pickedVisual = this.pickVisual(p.x, p.y);
        this.pickedModel = this.pickModel(this.pickedVisual);
        if ((mouseEvent.getModifiers() & 4) == 4) {
            if (p.x > Sweater.jaliceFrame.awtComponent.getSize().width - 20) {
                this.operation_status = 6;
                this.start_zooming(p);
                return;
            }
            if (this.pickedModel != null) {
                if ((mouseEvent.getModifiers() & 1) != 0) {
                    this.operation_status = 3;
                    this.pickedVehicle = this.pickedModel.modelVehicle;
                    this.start_sliding(p);
                } else {
                    this.operation_status = 2;
                    this.pickedVehicle = (Transformable)this.pickedVisual.getParent();
                    this.start_rotating();
                    this.stroke = new ArrayList();
                }
            } else {
                this.operation_status = 9;
                this.start_sliding(p);
            }
        } else {
            SurfaceLine surfaceLine = this.pickSurfaceLine(p);
            if (surfaceLine != null) {
                this.deleteSurfaceLine(surfaceLine);
                return;
            }
            if (this.pullMode && this.ongoing_operation == 0 && SnapTarget.grabbed_snap_target != null) {
                this.operation_status = 4;
                Pull.start_pulling_for_piece(p);
            } else if (this.eyeMode || this.noseMode) {
                if (this.pickedModel == null) {
                    return;
                }
                this.operation_status = 24;
                this.pickedModel.setDecoration(p);
            } else if ((mouseEvent.getModifiers() & 8) != 0) {
                this.operation_status = 8;
                Eraser.startErasing(p);
            } else if (this.ongoing_operation == 0 && SnapTarget.grabbed_snap_target != null) {
                this.operation_status = 23;
                jaliceFrame.setCursor(Cursors.brushCursor);
                AddingParts.startStroke(p);
            } else {
                this.operation_status = 1;
                this.startStroke(p);
            }
        }
    }

    public Model pickModel(Visual pickedVisual) {
        int i = 0;
        while (i < this.models.size()) {
            Model model = (Model)this.models.get(i);
            if (model.modelVisual == pickedVisual) {
                return model;
            }
            int j = 0;
            while (j < model.patchVisuals.size()) {
                if (model.patchVisuals.get(j) == pickedVisual) {
                    return model;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Visual pickVisual(int x, int y) {
        PickInfo pickInfo = Sweater.jaliceFrame.renderTarget.pick(x, y, true, true);
        if (pickInfo == null) {
            return null;
        }
        Visual[] visuals = pickInfo.getVisuals();
        if (visuals == null) {
            return null;
        }
        if (visuals.length == 0) {
            return null;
        }
        return visuals[0];
    }

    public Model pickModel(Point p) {
        PickInfo pickInfo = Sweater.jaliceFrame.renderTarget.pick(p.x, p.y, true, true);
        if (pickInfo == null) {
            return null;
        }
        Visual[] visuals = pickInfo.getVisuals();
        if (visuals == null) {
            return null;
        }
        int i = 0;
        while (i < visuals.length) {
            int j = 0;
            while (j < this.models.size()) {
                Model model = (Model)this.models.get(j);
                if (model.modelVisual == visuals[i]) {
                    return model;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Model pickModel(int x, int y) {
        Visual pickedVisual = this.pickVisual(x, y);
        System.out.println("models size in pickedModel" + this.models.size());
        int i = 0;
        while (i < this.models.size()) {
            Model model = (Model)this.models.get(i);
            if (model.modelVisual == pickedVisual) {
                return model;
            }
            int j = 0;
            while (j < model.patchVisuals.size()) {
                if (model.patchVisuals.get(j) == pickedVisual) {
                    return model;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public SurfaceLine pickSurfaceLine(Point p) {
        PickInfo pickInfo = Sweater.jaliceFrame.renderTarget.pick(p.x, p.y, true, true);
        if (pickInfo == null) {
            return null;
        }
        Visual[] visuals = pickInfo.getVisuals();
        if (visuals == null) {
            return null;
        }
        int i = 0;
        while (i < this.models.size()) {
            Model model = (Model)this.models.get(i);
            List surfaceLines = model.getSurfaceLines();
            int j = 0;
            while (j < surfaceLines.size()) {
                SurfaceLine surfaceLine = (SurfaceLine)surfaceLines.get(j);
                if (surfaceLine.lineVisual == visuals[0]) {
                    return surfaceLine;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private Vertex center_of_bbox(Model model) {
        double x_min = Double.MAX_VALUE;
        double x_max = -1.7976931348623157E308;
        double y_min = Double.MAX_VALUE;
        double y_max = -1.7976931348623157E308;
        double z_min = Double.MAX_VALUE;
        double z_max = -1.7976931348623157E308;
        Polyhedron h = model.polyhedron;
        int i = 0;
        while (i < h.vertices.size()) {
            Vertex v = (Vertex)h.vertices.get(i);
            if (v.x < x_min) {
                x_min = v.x;
            }
            if (v.x > x_max) {
                x_max = v.x;
            }
            if (v.y < y_min) {
                y_min = v.y;
            }
            if (v.y > y_max) {
                y_max = v.y;
            }
            if (v.z < z_min) {
                z_min = v.z;
            }
            if (v.z > z_max) {
                z_max = v.z;
            }
            ++i;
        }
        return new Vertex((x_min + x_max) / 2.0, (y_min + y_max) / 2.0, (z_min + z_max) / 2.0);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.style();
        } else if (e.getKeyCode() == 83) {
            DrawPanel.getInstance().piecesSmoothing();
            DrawPanel.getInstance().repaint();
        } else if (e.getKeyCode() != 16) {
            if (e.getKeyCode() == 80) {
                Inflate.pressure = !Inflate.pressure;
            } else if (e.getKeyCode() == 65) {
                AdjustmentInputStroke.setAdjust(!AdjustmentInputStroke.isAdjust());
            } else if (e.getKeyCode() == 82) {
                this.stroke = new ArrayList();
                Sweater.start_auto_rotation();
            } else if (e.getKeyCode() == 73) {
                Model pickedModel = this.getPickedModel();
                Inflate.update_target_length((Model)pickedModel);
                this.inflate();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        jaliceFrame.setCursor(Cursors.defaultCursor);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void initialize() {
        this.timer = new Timer(null, 100);
    }

    public Sweater() {
        sweater = this;
    }

    public Cursor init_cursor(String filename, Point hotSpot) {
        return Toolkit.getDefaultToolkit().createCustomCursor(this.loadImage(filename), hotSpot, "");
    }

    protected Image loadImage(String pathname) {
        Image image = jaliceFrame.getToolkit().getImage(pathname);
        if (image != null) {
            MediaTracker mt = new MediaTracker(jaliceFrame);
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return image;
    }

    public void setClearStroke(boolean clearStroke) {
        this.clearStroke = clearStroke;
    }

    public void setDeformingMode(boolean deformingMode) {
        this.deformingMode = deformingMode;
    }

    public void setModelingMode(boolean modelingMode) {
        this.modelingMode = modelingMode;
    }

    public void setStuffedMode(boolean stuffedMode) {
        this.stuffedMode = stuffedMode;
    }

    public boolean isClearStroke() {
        return this.clearStroke;
    }

    public boolean isDeformingMode() {
        return this.deformingMode;
    }

    public boolean isModelingMode() {
        return this.modelingMode;
    }

    public boolean isStuffedMode() {
        return this.stuffedMode;
    }

    public boolean isRenderingPieceNumbers() {
        return this.renderingPieceNumbers;
    }

    public void setRenderinPieceNumbers(boolean renderingPieceNumbers) {
        this.renderingPieceNumbers = renderingPieceNumbers;
    }

    public void setModels(List _models) {
        this.models = _models;
    }

    public List getModels() {
        return this.models;
    }

    public Model getPickedModel() {
        if (this.pickedModel == null && this.models.size() != 0) {
            this.pickedModel = (Model)this.models.get(0);
        }
        return this.pickedModel;
    }

    public void setPickedModel(Model _model) {
        this.pickedModel = _model;
    }

    public Transformable getPickedVehicle() {
        return this.pickedVehicle;
    }

    public void setPickedVehicle(Transformable _pickedVehicle) {
        this.pickedVehicle = _pickedVehicle;
    }

    public void setPullMode(boolean _pullMode) {
        this.pullMode = _pullMode;
    }

    public boolean isPullMode() {
        return this.pullMode;
    }

    public void setOngoingOperation(int _operation) {
        this.ongoing_operation = _operation;
    }

    public int getOngoingOperation() {
        return this.ongoing_operation;
    }

    public boolean isEyeMode() {
        return this.eyeMode;
    }

    public void setEyeMode(boolean _eyeMode) {
        this.eyeMode = _eyeMode;
    }

    public void setNoseMode(boolean _noseMode) {
        this.noseMode = _noseMode;
    }

    public boolean isNoseMode() {
        return this.noseMode;
    }
}

