/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3d;
import sweater.Model;
import sweater.Util;
import teddy.SurfacePath;

public class SurfaceLine {
    public static final Color RED = Color.RED;
    public static final Color BLUE = Color.BLUE;
    Model model;
    List face_indices;
    List positions;
    List normals;
    Color color;
    Vector3 center = null;
    SurfacePath surfacePath;
    Visual lineVisual;
    Appearance lineAppearance;
    int size;
    public final int DIV = 8;
    public final double RADIUS = 0.002;

    public SurfaceLine(Model model) {
        this.model = model;
        this.face_indices = new ArrayList();
        this.positions = new ArrayList();
        this.normals = new ArrayList();
    }

    public SurfaceLine(Model model, Color color) {
        this.model = model;
        this.face_indices = new ArrayList();
        this.positions = new ArrayList();
        this.normals = new ArrayList();
        this.color = color;
    }

    public void delete() {
        this.lineVisual.setParent(null);
    }

    public void addPoint(Vector3 pos, int n) {
        this.positions.add(pos);
        this.face_indices.add(new Integer(n));
    }

    public void addPoint(Vector3 pos, Vector3 normal) {
        this.positions.add(pos);
        this.normals.add(normal);
    }

    public Vector3 getPosition(int i) {
        return (Vector3)this.positions.get(i);
    }

    public Vector3 getNormal(int i) {
        return (Vector3)this.normals.get(i);
    }

    public int getFaceIndex(int i) {
        return (Integer)this.face_indices.get(i);
    }

    public Vector3 getCenter() {
        this.center = new Vector3();
        double total_length = 0.0;
        Vector3 prev = this.getPosition(this.size - 1);
        int i = 0;
        while (i < this.size) {
            Vector3 next = this.getPosition(i);
            double l = Vector3.subtract((Vector3d)next, (Vector3d)prev).getLength();
            Vector3 v = Vector3.multiply((Vector3d)Vector3.add((Vector3d)next, (Vector3d)prev), (double)0.5);
            this.center = Vector3.add((Vector3d)this.center, (Vector3d)Vector3.multiply((Vector3d)v, (double)l));
            total_length += l;
            prev = next;
            ++i;
        }
        this.center = Vector3.multiply((Vector3d)this.center, (double)(1.0 / total_length));
        return this.center;
    }

    public Vector3 getNormal() {
        if (this.center == null) {
            this.center = this.getCenter();
        }
        Vector3 normal = new Vector3();
        Vector3 prev = this.getPosition(this.size - 1);
        int i = 0;
        while (i < this.size) {
            Vector3 next = this.getPosition(i);
            Vector3 vec0 = Vector3.subtract((Vector3d)prev, (Vector3d)this.center);
            Vector3 vec1 = Vector3.subtract((Vector3d)next, (Vector3d)this.center);
            normal = Vector3.add((Vector3d)normal, (Vector3d)Vector3.crossProduct((Vector3d)vec1, (Vector3d)vec0));
            prev = next;
            ++i;
        }
        normal.normalize();
        return normal;
    }

    public SurfaceLine(Model model, SurfacePath surfacePath) {
        this(model);
        this.surfacePath = surfacePath;
        int i = 0;
        while (i < surfacePath.size()) {
            Vector3 normal = new Vector3();
            normal = surfacePath.onFace(i) ? model.teddyVector3_to_jaliceVector3(surfacePath.getFace((int)i).normal) : (surfacePath.onEdge(i) ? model.teddyVector3_to_jaliceVector3(surfacePath.getEdge(i).get_normal()) : model.teddyVector3_to_jaliceVector3(surfacePath.getVertex((int)i).normal));
            Vector3 pos = model.teddyVertex_to_jaliceVector3(surfacePath.getVertex(i));
            this.addPoint(pos, normal);
            ++i;
        }
        this.set_lineVisual();
    }

    public Visual set_lineVisual() {
        this.lineVisual = new Visual();
        this.size = this.positions.size() - 1;
        Vertex[] lineVertices = new Vertex[4 * this.size + 3];
        int[] lineIndices = new int[6 * this.size + 3];
        int i = 0;
        while (i < this.size) {
            this.lineVisual_sub(i, lineVertices, lineIndices);
            ++i;
        }
        this.lineVisual_head(this.size - 1, lineVertices, lineIndices);
        IndexedTriangleArray lineArray = new IndexedTriangleArray();
        lineArray.setVertices((Vertex3d[])lineVertices);
        lineArray.setIndices(lineIndices);
        this.lineVisual.setGeometry((Geometry)lineArray);
        this.lineAppearance = new Appearance();
        this.lineVisual.setFrontFacingAppearance(this.lineAppearance);
        this.lineAppearance.setAmbientColor(Color.RED);
        this.lineAppearance.setEmissiveColor(Color.RED);
        this.lineAppearance.setDiffuseColor(Color.RED);
        this.lineAppearance.setShadingStyle(ShadingStyle.FLAT);
        this.lineAppearance.setFillingStyle(FillingStyle.SOLID);
        return this.lineVisual;
    }

    public Visual lineVisual() {
        Vector3 vec1;
        Vector3 p2;
        Vector3 up;
        this.lineVisual = new Visual();
        this.size = this.positions.size() - 1;
        if (this.size == 0) {
            return null;
        }
        ArrayList total_vertices = new ArrayList();
        ArrayList<Integer> total_indices = new ArrayList<Integer>();
        Vector3 p0 = this.getPosition(0);
        Vector3 p1 = this.getPosition(1);
        Vector3 vec0 = Vector3.subtract((Vector3d)p1, (Vector3d)p0);
        if (Vector3.crossProduct((Vector3d)vec0, (Vector3d)(up = Vector3.X_AXIS)).getLength() == 0.0) {
            up = Vector3.Y_AXIS;
        }
        Vector3 cross0 = Vector3.crossProduct((Vector3d)vec0, (Vector3d)up);
        cross0.normalize();
        Vector3 cross1 = Vector3.crossProduct((Vector3d)vec0, (Vector3d)cross0);
        cross1.normalize();
        this.add_ring(p0, cross0, cross1, total_vertices);
        int i = 1;
        while (i < this.size) {
            p0 = this.getPosition(i - 1);
            p1 = this.getPosition(i);
            p2 = this.getPosition(i + 1);
            vec0 = Vector3.subtract((Vector3d)p1, (Vector3d)p0);
            vec1 = Vector3.subtract((Vector3d)p2, (Vector3d)p1);
            cross1 = Vector3.add((Vector3d)Vector3.crossProduct((Vector3d)vec0, (Vector3d)cross0), (Vector3d)Vector3.crossProduct((Vector3d)vec1, (Vector3d)cross0));
            cross1.normalize();
            cross0 = Vector3.add((Vector3d)Vector3.crossProduct((Vector3d)cross1, (Vector3d)vec0), (Vector3d)Vector3.crossProduct((Vector3d)cross1, (Vector3d)vec1));
            cross0.normalize();
            this.add_ring(p1, cross0, cross1, total_vertices);
            ++i;
        }
        p0 = this.getPosition(this.size - 2);
        p1 = this.getPosition(this.size - 1);
        p2 = this.getPosition(this.size);
        vec1 = Vector3.subtract((Vector3d)p2, (Vector3d)p1);
        if (vec1.x == 0.0 && vec1.y == 0.0 && vec1.z == 0.0) {
            System.out.println("isNaN in SurfaceLine ");
            vec1 = Vector3.subtract((Vector3d)p2, (Vector3d)p0);
        }
        cross1 = Vector3.crossProduct((Vector3d)vec1, (Vector3d)cross0);
        cross1.normalize();
        cross0 = Vector3.crossProduct((Vector3d)cross1, (Vector3d)vec1);
        cross0.normalize();
        this.add_ring(p2, cross0, cross1, total_vertices);
        i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < 8) {
                total_indices.add(new Integer(i * 8 + Util.mod(j + 0, 8)));
                total_indices.add(new Integer(i * 8 + Util.mod(j + 1, 8)));
                total_indices.add(new Integer((i + 1) * 8 + Util.mod(j + 0, 8)));
                total_indices.add(new Integer(i * 8 + Util.mod(j + 1, 8)));
                total_indices.add(new Integer((i + 1) * 8 + Util.mod(j + 1, 8)));
                total_indices.add(new Integer((i + 1) * 8 + Util.mod(j + 0, 8)));
                ++j;
            }
            ++i;
        }
        Vertex[] lineVertices = new Vertex[total_vertices.size()];
        int[] lineIndices = new int[total_indices.size()];
        int i2 = 0;
        while (i2 < total_vertices.size()) {
            lineVertices[i2] = (Vertex)total_vertices.get(i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < total_indices.size()) {
            lineIndices[i2] = (Integer)total_indices.get(i2);
            ++i2;
        }
        IndexedTriangleArray lineArray = new IndexedTriangleArray();
        lineArray.setVertices((Vertex3d[])lineVertices);
        lineArray.setIndices(lineIndices);
        this.lineVisual.setGeometry((Geometry)lineArray);
        Appearance lineAppearance = new Appearance();
        this.lineVisual.setFrontFacingAppearance(lineAppearance);
        lineAppearance.setAmbientColor(this.color);
        lineAppearance.setEmissiveColor(this.color);
        lineAppearance.setDiffuseColor(this.color);
        lineAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        lineAppearance.setFillingStyle(FillingStyle.SOLID);
        return this.lineVisual;
    }

    public void add_ring(Vector3 p, Vector3 cross0, Vector3 cross1, List vertices) {
        int j = 0;
        while (j < 8) {
            double angle = Math.PI * 2 * (double)j / 8.0;
            double x = Math.cos(angle);
            double y = Math.sin(angle);
            Vector3 normal = Vector3.add((Vector3d)Vector3.multiply((Vector3d)cross0, (double)x), (Vector3d)Vector3.multiply((Vector3d)cross1, (double)y));
            Vector3 v0 = Vector3.add((Vector3d)p, (Vector3d)Vector3.multiply((Vector3d)normal, (double)0.002));
            vertices.add(this.createVertex(v0, normal));
            ++j;
        }
    }

    public void lineVisual_head(int i, Vertex[] lineVertices, int[] lineIndices) {
        Vector3 pos0 = this.getPosition(i);
        Vector3 pos1 = this.getPosition(i + 1);
        Vector3 normal0 = this.getNormal(i);
        Vector3 normal1 = this.getNormal(i + 1);
        Vector3 normal = Vector3.multiply((Vector3d)Vector3.add((Vector3d)normal0, (Vector3d)normal1), (double)0.5);
        Vector3 vec = Vector3.subtract((Vector3d)pos1, (Vector3d)pos0);
        vec.normalize();
        vec.multiply(0.025);
        pos0 = Vector3.subtract((Vector3d)pos1, (Vector3d)vec);
        pos1 = Vector3.add((Vector3d)pos1, (Vector3d)vec);
        Vector3 cross = Vector3.crossProduct((Vector3d)normal, (Vector3d)vec);
        cross.multiply(1.4);
        pos0 = Vector3.add((Vector3d)pos0, (Vector3d)Vector3.multiply((Vector3d)normal0, (double)0.01));
        pos1 = Vector3.add((Vector3d)pos1, (Vector3d)Vector3.multiply((Vector3d)normal1, (double)0.01));
        Vector3 pos2 = Vector3.add((Vector3d)pos0, (Vector3d)cross);
        Vector3 pos3 = Vector3.subtract((Vector3d)pos0, (Vector3d)cross);
        lineVertices[i * 4 + 4 + 0] = this.createVertex(pos1, normal);
        lineVertices[i * 4 + 4 + 1] = this.createVertex(pos2, normal);
        lineVertices[i * 4 + 4 + 2] = this.createVertex(pos3, normal);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] indices = nArray;
        int j = 0;
        while (j < 3) {
            lineIndices[i * 6 + 6 + j] = indices[j] + i * 4 + 4;
            ++j;
        }
    }

    public void lineVisual_sub(int i, Vertex[] lineVertices, int[] lineIndices) {
        Vector3 pos0 = this.getPosition(i);
        Vector3 pos1 = this.getPosition(i + 1);
        Vector3 normal0 = this.getNormal(i);
        Vector3 normal1 = this.getNormal(i + 1);
        Vector3 normal = Vector3.multiply((Vector3d)Vector3.add((Vector3d)normal0, (Vector3d)normal1), (double)0.5);
        Vector3 vec = Vector3.subtract((Vector3d)pos1, (Vector3d)pos0);
        vec.normalize();
        Vector3 cross = Vector3.crossProduct((Vector3d)normal, (Vector3d)vec);
        cross.multiply(0.01);
        vec.multiply(0.001);
        pos0 = Vector3.subtract((Vector3d)pos0, (Vector3d)vec);
        pos1 = Vector3.add((Vector3d)pos1, (Vector3d)vec);
        pos0 = Vector3.add((Vector3d)pos0, (Vector3d)Vector3.multiply((Vector3d)normal0, (double)0.01));
        pos1 = Vector3.add((Vector3d)pos1, (Vector3d)Vector3.multiply((Vector3d)normal1, (double)0.01));
        Vector3 pos2 = Vector3.add((Vector3d)pos0, (Vector3d)cross);
        Vector3 pos3 = Vector3.add((Vector3d)pos1, (Vector3d)cross);
        pos0 = Vector3.subtract((Vector3d)pos0, (Vector3d)cross);
        pos1 = Vector3.subtract((Vector3d)pos1, (Vector3d)cross);
        lineVertices[i * 4 + 0] = this.createVertex(pos0, normal);
        lineVertices[i * 4 + 1] = this.createVertex(pos1, normal);
        lineVertices[i * 4 + 2] = this.createVertex(pos2, normal);
        lineVertices[i * 4 + 3] = this.createVertex(pos3, normal);
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 2;
        int[] indices = nArray;
        int j = 0;
        while (j < 6) {
            lineIndices[i * 6 + j] = indices[j] + i * 4;
            ++j;
        }
    }

    public Vertex createVertex(Vector3 v, Vector3 normal) {
        Vertex vertex = new Vertex(19);
        vertex.setXYZ(new Vector3(v.x, v.y, v.z));
        vertex.setIJK(normal);
        vertex.setU(0.0);
        vertex.setV(0.0);
        return vertex;
    }
}

