/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.vecmath.Vector3d;
import sweater.Model;
import sweater.Sweater;

public class Suggestion {
    static final double WIDTH = 0.4;
    static final double HEIGHT = 0.4;
    static final int PREVIEW_FRAME = 20;
    static final int margin = 2;
    private Model model;
    private Component awtComponent;
    private Image thumbnailImage;
    private Rectangle bbox;
    static Suggestion currentSuggestion = null;
    Suggestion prevSuggestion = null;
    Transformable suggestionVehicle;
    Visual suggestionVisual;
    Appearance suggestionAppearance;
    IndexedTriangleArray suggestionITA;
    public static boolean TEXTURE_ENABLED = true;
    public final edu.cmu.cs.stage3.alice.scenegraph.Color GROUND_COLOR = new edu.cmu.cs.stage3.alice.scenegraph.Color(1.0f, 1.0f, 1.0f);
    int[][] suggestion_data;
    Vector3[] bounds;
    public static List suggestions = new ArrayList();

    Suggestion(Model _model) {
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[3];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[2] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        nArrayArray[3] = nArray3;
        this.suggestion_data = nArrayArray;
        this.model = _model;
        this.model.show();
        this.thumbnailImage = Sweater.jaliceFrame.getOffscreenImage();
        this.model.hide();
    }

    void add_thumbnail_to_scenegraph() {
        suggestions.add(this);
        this.addToScenegraph(Sweater.jaliceFrame.scene);
        this.setBoundingBox();
        this.show();
    }

    private void createSuggestionVisual() {
        this.suggestionVisual = new Visual();
        this.suggestionAppearance = new Appearance();
        this.suggestionAppearance.setDiffuseColor(this.GROUND_COLOR);
        this.suggestionAppearance.setOpacity(1.0);
        this.suggestionAppearance.setFillingStyle(FillingStyle.SOLID);
        this.suggestionAppearance.setShadingStyle(ShadingStyle.NONE);
        this.suggestionVisual.setFrontFacingAppearance(this.suggestionAppearance);
        TextureMap thumbnail = new TextureMap();
        thumbnail.setImage(this.thumbnailImage);
        this.suggestionAppearance.setDiffuseColorMap(thumbnail);
        if (this.suggestionITA == null) {
            this.suggestionITA = this.create_suggestionITA();
        }
        this.suggestionVisual.setGeometry((Geometry)this.suggestionITA);
    }

    private void output_imagefile() {
        BufferedImage bufferedImage = (BufferedImage)this.thumbnailImage;
        File file = new File("hello.png");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
    }

    public IndexedTriangleArray create_suggestionITA() {
        IndexedTriangleArray suggestionITA = new IndexedTriangleArray();
        Vertex[] suggestionVertices = new Vertex[4];
        this.bounds = new Vector3[4];
        int i = 0;
        while (i < 4) {
            suggestionVertices[i] = new Vertex(19);
            double vx = (double)this.suggestion_data[i][0] * 0.4;
            double vy = 0.0;
            double vz = (double)this.suggestion_data[i][2] * 0.4;
            this.bounds[i] = new Vector3(vx, vy, vz);
            suggestionVertices[i].setXYZ(this.bounds[i]);
            suggestionVertices[i].setIJK(new Vector3(0.0, 1.0, 0.0));
            suggestionVertices[i].setU((double)(1 - this.suggestion_data[i][0]));
            suggestionVertices[i].setV((double)this.suggestion_data[i][2]);
            ++i;
        }
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        int[] suggestionIndices = nArray;
        suggestionITA.setVertices((Vertex3d[])suggestionVertices);
        suggestionITA.setIndices(suggestionIndices);
        return suggestionITA;
    }

    public Image getThumbnailImage() {
        return this.thumbnailImage;
    }

    public void show() {
        if (this.suggestionVehicle != null) {
            this.suggestionVisual.setParent((Container)this.suggestionVehicle);
        }
    }

    public void delete() {
        if (this.suggestionVehicle != null) {
            this.suggestionVehicle.setParent(null);
        }
    }

    public void addToScenegraph(Scene parent) {
        if (this.suggestionVehicle == null) {
            this.createSuggestionVisual();
            this.suggestionVehicle = new Transformable();
            this.suggestionVehicle.setParent((Container)parent);
            int size = suggestions.size() - 1;
            Vector3 base = new Vector3(0.5 - 0.5 * (double)size, -1.0, 0.0);
            System.out.println("base " + base);
            this.setPosition(base, (ReferenceFrame)parent);
        } else {
            this.suggestionVehicle.setParent((Container)parent);
        }
    }

    public void removeFromScenegraph() {
        if (this.suggestionVehicle != null) {
            this.suggestionVehicle.setParent(null);
        }
    }

    public Transformable getVehicle() {
        return this.suggestionVehicle;
    }

    public void setPosition(Vector3 base, ReferenceFrame parent) {
        this.suggestionVehicle.setPosition((Vector3d)base, parent);
        Vector3 normal = new Vector3(0.0, 0.0, 1.0);
        Vector3 head = new Vector3(0.0, 1.0, 0.0);
        this.suggestionVehicle.setOrientation((Vector3d)head, (Vector3d)normal, parent);
    }

    public void setBoundingBox() {
        if (this.bounds == null) {
            return;
        }
        Vector3 b0 = Sweater.jaliceFrame.local_coords_to_screen_coords(this.bounds[0], (ReferenceFrame)this.getVehicle());
        Vector3 b2 = Sweater.jaliceFrame.local_coords_to_screen_coords(this.bounds[2], (ReferenceFrame)this.getVehicle());
        Rectangle bbox = new Rectangle((int)Math.min(b0.x, b2.x), (int)Math.min(b0.y, b2.y), (int)Math.abs(b2.x - b0.x), (int)Math.abs(b0.y - b2.y));
        this.setBoundingBox(bbox);
    }

    public void setBoundingBox(Rectangle bbox) {
        this.bbox = bbox;
    }

    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    public static boolean pressSuggestion(Point p) {
        Suggestion suggestion = null;
        int i = 0;
        while (i < suggestions.size()) {
            Suggestion s = (Suggestion)suggestions.get(i);
            Rectangle bbox = s.getBoundingBox();
            if (bbox.contains(p)) {
                suggestion = s;
            }
            ++i;
        }
        currentSuggestion = suggestion;
        return suggestion != null;
    }

    public static void clearSuggestions() {
        int i = 0;
        while (i < suggestions.size()) {
            Suggestion s = (Suggestion)suggestions.get(i);
            s.removeFromScenegraph();
            ++i;
        }
        suggestions = new ArrayList();
    }

    public static void paintSuggestions(Graphics g) {
        int i = 0;
        while (i < suggestions.size()) {
            Suggestion s = (Suggestion)suggestions.get(i);
            Color col = s == currentSuggestion ? Color.RED : Color.white;
            if (s.bbox != null) {
                g.setColor(col);
                g.drawRect(s.bbox.x - 1, s.bbox.y - 1, s.bbox.width, s.bbox.height);
                g.drawRect(s.bbox.x, s.bbox.y, s.bbox.width - 2, s.bbox.height - 2);
            }
            ++i;
        }
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model _model) {
        this.model = _model;
    }
}

