/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import sweater.ControlCurve;
import sweater.Debug;
import sweater.Model;
import teddy.CameraInterface;
import teddy.Edge;
import teddy.Face;
import teddy.LaplacianCurveEdit;
import teddy.SurfacePath;
import teddy.Vertex;
import teddy.Vertex2D;

public class SnapTarget {
    ControlCurve curve;
    int index;
    Vertex2D p;
    Vertex vertex;
    private static List snap_targets = new ArrayList();
    private static Model model;
    private static CameraInterface camera;
    static SnapTarget grabbed_snap_target;
    static ControlCurve grabbed_curve;
    static LaplacianCurveEdit curveEdit;

    SnapTarget(ControlCurve curve, int index, Vertex vertex, Vertex2D p) {
        this.curve = curve;
        this.index = index;
        this.p = p;
        this.vertex = vertex;
    }

    static boolean grab_snap_target(Point p) {
        grabbed_snap_target = null;
        Debug.vertices_max = new ArrayList();
        int i = 0;
        while (i < snap_targets.size()) {
            SnapTarget target = (SnapTarget)snap_targets.get(i);
            if (Vertex2D.distance((Vertex2D)target.p, (Point)p) < 10.0) {
                grabbed_snap_target = target;
                Debug.vertices_max.add(SnapTarget.grabbed_snap_target.vertex);
                return true;
            }
            ++i;
        }
        return false;
    }

    static SnapTarget nearist_snap_target(Point p) {
        SnapTarget snapTarget = null;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < snap_targets.size()) {
            SnapTarget target = (SnapTarget)snap_targets.get(i);
            double distance = Vertex2D.distance((Vertex2D)target.p, (Point)p);
            if (distance < min) {
                min = distance;
                snapTarget = target;
            }
            ++i;
        }
        return snapTarget;
    }

    static void update_onscreen_snap_targets(Model _model) {
        if (_model == null) {
            return;
        }
        model = _model;
        camera = model.get_camera();
        snap_targets = new ArrayList();
        int i = 0;
        while (i < SnapTarget.model.curves.size()) {
            ControlCurve curve = (ControlCurve)SnapTarget.model.curves.get(i);
            int j = 0;
            while (j < curve.surfacePath.size()) {
                if (curve.surfacePath.onEdge(j)) {
                    if (SnapTarget.front_facing(curve.surfacePath.getEdge(j))) {
                        snap_targets.add(new SnapTarget(curve, j, curve.surfacePath.getVertex(j), camera.local_coords_to_screen_coords(curve.surfacePath.getVertex(j))));
                    }
                } else if (curve.surfacePath.onFace(j)) {
                    if (SnapTarget.front_facing(curve.surfacePath.getFace(j))) {
                        snap_targets.add(new SnapTarget(curve, j, curve.surfacePath.getVertex(j), camera.local_coords_to_screen_coords(curve.surfacePath.getVertex(j))));
                    }
                } else if (curve.surfacePath.onVertex(j) && SnapTarget.front_facing(curve.surfacePath.getParentVertex(j))) {
                    snap_targets.add(new SnapTarget(curve, j, curve.surfacePath.getVertex(j), camera.local_coords_to_screen_coords(curve.surfacePath.getVertex(j))));
                }
                ++j;
            }
            ++i;
        }
    }

    static boolean front_facing(Vertex vertex) {
        List faces = vertex.get_faces();
        int i = 0;
        while (i < faces.size()) {
            Face face = (Face)faces.get(i);
            if (SnapTarget.front_facing(face)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean front_facing(Edge edge) {
        if (edge.left_face != null && SnapTarget.front_facing(edge.left_face)) {
            return true;
        }
        return edge.right_face != null && SnapTarget.front_facing(edge.right_face);
    }

    static boolean front_facing(Face face) {
        return camera.front_facing(face.get_vertex(0), face.normal);
    }

    static void paintGrabbedSnapTarget(Graphics g) {
        if (grabbed_snap_target == null) {
            return;
        }
        System.out.println("grabbed_snap_target " + grabbed_snap_target);
        ControlCurve controlCurve = SnapTarget.grabbed_snap_target.curve;
        SurfacePath surfacePath = controlCurve.surfacePath;
        Vertex prev_v = surfacePath.getVertex(0);
        int i = 1;
        while (i < surfacePath.size()) {
            Vertex v = surfacePath.getVertex(i);
            g.drawLine((int)prev_v.x, (int)prev_v.y, (int)v.x, (int)v.y);
            ++i;
        }
    }

    public static void set_snap_targets(List _snap_targets) {
        snap_targets = _snap_targets;
    }

    public static List get_snap_targets() {
        return snap_targets;
    }

    public static void set_grabbed_snap_target(SnapTarget _grabbed_snap_target) {
        grabbed_snap_target = _grabbed_snap_target;
    }

    public static SnapTarget get_grabbed_snap_target() {
        return grabbed_snap_target;
    }

    public static void set_grabbed_curve(ControlCurve _grabbed_curve) {
        grabbed_curve = _grabbed_curve;
    }

    public static ControlCurve get_grabbed_curve() {
        return grabbed_curve;
    }
}

