/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import pattern.DrawPanel;
import pattern.Piece;
import pattern.Seam;
import sweater.ControlCurve;
import sweater.Flattening;
import sweater.Model;
import sweater.PlaneVisual;
import sweater.SnapTarget;
import sweater.Sweater;
import sweater.Util;
import teddy.CameraInterface;
import teddy.Inflate;
import teddy.LaplacianCurveEdit;
import teddy.Line;
import teddy.Plane;
import teddy.Polyhedron;
import teddy.Vector2;
import teddy.Vertex;
import teddy.Vertex2D;

public class Pull {
    private static CameraInterface camera;
    private static SnapTarget grabbed_snap_target;
    private static ControlCurve grabbed_curve;
    private static Vertex[] original_positions;
    private static Vertex start_v;
    private static Vertex picked_v;
    private static teddy.Vector3 picked_v_initial_normal;
    static Point start_p;
    static double depth;
    static teddy.Vector3 plane_normal;
    static teddy.Vector3 x_vec;
    static teddy.Vector3 y_vec;
    static Vector2[] total_displacement_2D;
    static Model pullingModel;
    static PlaneVisual plane;
    static LaplacianCurveEdit curveEdit;
    static int index;
    static int index0;
    static int index1;
    public static double SCOPE_SCALE;
    static double max_pull_length;
    static double original_curve_length;

    static {
        depth = 0.0;
        SCOPE_SCALE = 2.0;
    }

    static boolean start_pulling_for_piece(Point p) {
        grabbed_snap_target = SnapTarget.get_grabbed_snap_target();
        if (grabbed_snap_target == null) {
            return false;
        }
        Model model = Sweater.sweater.getPickedModel();
        if (model == null) {
            List models = Sweater.sweater.getModels();
            model = (Model)models.get(0);
        }
        camera = model.get_camera();
        start_p = p;
        picked_v = Pull.grabbed_snap_target.vertex;
        start_v = picked_v.copy();
        grabbed_snap_target = SnapTarget.get_grabbed_snap_target();
        if (grabbed_snap_target == null) {
            return false;
        }
        grabbed_curve = Pull.grabbed_snap_target.curve;
        original_positions = new Vertex[Pull.grabbed_curve.surfacePath.size()];
        int i = 0;
        while (i < Pull.grabbed_curve.surfacePath.size()) {
            Vertex v = Pull.grabbed_curve.surfacePath.getVertex(i);
            Pull.original_positions[i] = new Vertex(v.x, v.y, v.z);
            ++i;
        }
        original_curve_length = 0.0;
        i = 0;
        while (i < original_positions.length) {
            original_curve_length += Vertex.distance((Vertex)original_positions[i], (Vertex)original_positions[Util.mod(i + 1, original_positions.length)]);
            ++i;
        }
        index1 = index = Pull.grabbed_snap_target.index;
        index0 = index;
        plane = Pull.createPullingPlane();
        if (plane != null) {
            plane.addToScenegraph(pullingModel.getModelVehicle());
            plane.show();
        }
        y_vec = Pull.picked_v.normal;
        x_vec = teddy.Vector3.cross_product((teddy.Vector3)y_vec, (teddy.Vector3)plane_normal);
        Vertex camera_pos = camera.get_camera_position();
        teddy.Vector3 camera_lay = camera.get_camera_lay(new Vertex2D(p));
        depth = (Pull.picked_v.x - camera_pos.x) / camera_lay.x;
        picked_v_initial_normal = Pull.picked_v.normal;
        total_displacement_2D = new Vector2[Pull.picked_v.child_vertices.size()];
        int i2 = 0;
        while (i2 < Pull.picked_v.child_vertices.size()) {
            Vertex child = (Vertex)Pull.picked_v.child_vertices.get(i2);
            Vertex2D patternCoord = child.getPatternCoord();
            Seam seam = DrawPanel.pick_seam((Point)new Point((int)patternCoord.x, (int)patternCoord.y));
            Piece piece = seam.getPiece();
            piece.prepare_start_pulling(patternCoord, seam);
            Pull.total_displacement_2D[i2] = new Vector2();
            ++i2;
        }
        return true;
    }

    static void pulling_for_piece(Point p) {
        Vertex target_v = Pull.project_onto_drag_plane(p);
        teddy.Vector3 target_displacement_vector_3D = new teddy.Vector3((teddy.Vector3)picked_v, (teddy.Vector3)target_v);
        Vector2 target_displacement_vector_in_local_coords = new Vector2(teddy.Vector3.dot_product((teddy.Vector3)x_vec, (teddy.Vector3)target_displacement_vector_3D), teddy.Vector3.dot_product((teddy.Vector3)y_vec, (teddy.Vector3)target_displacement_vector_3D));
        int i = 0;
        while (i < pattern.Pull.pulls.size()) {
            pattern.Pull pull = (pattern.Pull)pattern.Pull.pulls.get(i);
            Vector2 vector2 = pull.mapping_to_2D_vector(target_displacement_vector_in_local_coords);
            vector2.multiply(10.0);
            Pull.total_displacement_2D[i] = Vector2.add((Vector2)total_displacement_2D[i], (Vector2)vector2);
            pull.pulling(total_displacement_2D[i]);
            ++i;
        }
        Model model = Sweater.sweater.getPickedModel();
        Inflate.update_target_length((Model)model);
        model.inflate();
        Sweater.jaliceFrame.repaint();
    }

    static void finish_pulling_for_piece() {
        int i = 0;
        while (i < pattern.Pull.pulls.size()) {
            pattern.Pull pull = (pattern.Pull)pattern.Pull.pulls.get(i);
            pull.finish_pulling();
            pull.piece = null;
            ++i;
        }
        Model model = Sweater.sweater.getPickedModel();
        Inflate.update_target_length((Model)model);
        pattern.Pull.pulls = new ArrayList();
        plane.delete();
        Sweater.jaliceFrame.repaint();
    }

    static PlaneVisual createPullingPlane() {
        if (Pull.grabbed_curve.surfacePath.size() <= 2) {
            System.out.println("grabbed_curve.surfacePath.size() <= 2");
            return null;
        }
        Vertex base = original_positions[index];
        Vertex v0 = original_positions[0];
        Vertex v1 = original_positions[Pull.grabbed_curve.surfacePath.size() - 2];
        teddy.Vector3 vec0 = new teddy.Vector3((teddy.Vector3)base, (teddy.Vector3)v0);
        teddy.Vector3 vec1 = new teddy.Vector3((teddy.Vector3)base, (teddy.Vector3)v1);
        plane_normal = teddy.Vector3.cross_product((teddy.Vector3)vec1, (teddy.Vector3)vec0);
        plane_normal.normalize();
        pullingModel = Pull.pullingModel();
        Vector3 base_vec = pullingModel.teddyVertex_to_jaliceVector3(base);
        Vector3 normal_vec = pullingModel.teddyVector3_to_jaliceVector3(plane_normal);
        return new PlaneVisual(base_vec, normal_vec);
    }

    private static Model pullingModel() {
        Model model = Sweater.sweater.getPickedModel();
        if (model == null) {
            List models = Sweater.sweater.getModels();
            model = (Model)models.get(0);
        }
        return model;
    }

    static boolean start_pulling(Point p) {
        grabbed_snap_target = SnapTarget.get_grabbed_snap_target();
        if (grabbed_snap_target == null) {
            return false;
        }
        grabbed_curve = Pull.grabbed_snap_target.curve;
        original_positions = new Vertex[Pull.grabbed_curve.surfacePath.size()];
        int i = 0;
        while (i < Pull.grabbed_curve.surfacePath.size()) {
            Vertex v = Pull.grabbed_curve.surfacePath.getVertex(i);
            Pull.original_positions[i] = new Vertex(v.x, v.y, v.z);
            ++i;
        }
        original_curve_length = 0.0;
        i = 0;
        while (i < original_positions.length) {
            original_curve_length += Vertex.distance((Vertex)original_positions[i], (Vertex)original_positions[Util.mod(i + 1, original_positions.length)]);
            ++i;
        }
        index1 = index = Pull.grabbed_snap_target.index;
        index0 = index;
        plane = Pull.createPullingPlane();
        if (plane != null) {
            plane.addToScenegraph(pullingModel.getModelVehicle());
            plane.show();
        }
        start_v = Pull.project_onto_drag_plane(p);
        max_pull_length = -1.0;
        return true;
    }

    static Vertex project_onto_drag_plane(Point p) {
        Vertex2D v_screen_coords = new Vertex2D(p);
        System.out.println("pullingModel" + pullingModel);
        camera = pullingModel.get_camera();
        Vertex v_world_coords = camera.screen_coords_to_local_coords(v_screen_coords);
        teddy.Vector3 camera_vector = camera.get_camera_lay(v_screen_coords);
        Line line = new Line(v_world_coords, camera_vector);
        Plane drag_plane = new Plane(pullingModel.jaliceVector3_to_teddyVertex(Pull.plane.base), (teddy.Vector3)pullingModel.jaliceVector3_to_teddyVector3(Pull.plane.normal));
        return drag_plane.cross_point(line);
    }

    static void pulling(Point p) {
        Vertex v = Pull.project_onto_drag_plane(p);
        teddy.Vector3 vec = new teddy.Vector3((teddy.Vector3)start_v, (teddy.Vector3)v);
        boolean scope_adjusted = Pull.adjust_scope(Vertex.distance((Vertex)start_v, (Vertex)v));
        if (Math.abs(index0 - index1) <= 2) {
            Vertex target_position = Vertex.translate((Vertex)original_positions[index], (teddy.Vector3)vec);
            Pull.grabbed_curve.surfacePath.getVertex(index).set_position(target_position);
        } else {
            if (scope_adjusted) {
                int i = 0;
                while (i < Pull.grabbed_curve.surfacePath.size()) {
                    Pull.grabbed_curve.surfacePath.getVertex(i).set_position(original_positions[i]);
                    ++i;
                }
                curveEdit = new LaplacianCurveEdit();
                curveEdit.compile(Pull.grabbed_curve.surfacePath, index0, index, index1);
            }
            Vertex target_position = Vertex.translate((Vertex)original_positions[index], (teddy.Vector3)vec);
            Pull.grabbed_curve.surfacePath.getVertex(index).set_position(target_position);
            curveEdit.update();
        }
        Pull.grabbed_snap_target.curve.surfaceLine.set_lineVisual();
        Flattening.ABF(pullingModel, true);
        pullingModel.update();
    }

    static void finish_pulling() {
        pullingModel.update();
        SnapTarget.update_onscreen_snap_targets(pullingModel);
        Inflate.set_target_length((Polyhedron)Pull.pullingModel.polyhedron);
        plane.delete();
    }

    static boolean adjust_scope(double pull_length) {
        pull_length *= SCOPE_SCALE;
        if (Pull.grabbed_curve.surfacePath.loop && pull_length >= 0.9 * original_curve_length / 2.0) {
            pull_length = 0.9 * original_curve_length / 2.0;
        }
        if (pull_length <= max_pull_length) {
            return false;
        }
        max_pull_length = pull_length;
        index0 = Pull.adjust_scope_sub(pull_length, -1);
        index1 = Pull.adjust_scope_sub(pull_length, 1);
        return true;
    }

    static int adjust_scope_sub(double pull_length, int step) {
        double total = 0.0;
        int i = index;
        Vertex prev_v = original_positions[i];
        i += step;
        while (Pull.grabbed_curve.surfacePath.loop || i >= 0 && i <= original_positions.length - 1) {
            Vertex v = original_positions[Util.mod(i, original_positions.length)];
            if ((total += Vertex.distance((Vertex)prev_v, (Vertex)v)) > pull_length) {
                return i - step;
            }
            i += step;
            prev_v = v;
        }
        return i - step;
    }
}

