/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import sweater.JaliceFrame;

public class Print
implements Printable {
    private final JaliceFrame jaliceFrame;

    private Print(JaliceFrame jaliceFrame) {
        this.jaliceFrame = jaliceFrame;
    }

    public static void print(JaliceFrame jaliceFrame) throws PrinterException {
        if (jaliceFrame == null) {
            throw new NullPointerException("Panel is null.");
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new Print(jaliceFrame));
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        if (printerJob.printDialog(attributes)) {
            System.err.println("PRINT START");
            printerJob.print(attributes);
        }
    }

    private static double ratio(double printerWidth, double printerHeight, int panelWidth, int panelHeight) {
        double widthRatio = printerWidth / (double)panelWidth;
        double heightRatio = printerHeight / (double)panelHeight;
        return Math.min(widthRatio, heightRatio);
    }

    public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
        if (pageIndex != 0) {
            return 1;
        }
        double printerWidth = format.getImageableWidth();
        double printerHeight = format.getImageableHeight();
        int panelWidth = this.jaliceFrame.getWidth();
        int panelHeight = this.jaliceFrame.getHeight();
        BufferedImage bufferedImage = new BufferedImage(panelWidth, panelHeight, 2);
        Graphics imageGraphics = bufferedImage.getGraphics();
        this.jaliceFrame.print(imageGraphics);
        imageGraphics.dispose();
        double ratio = Print.ratio(printerWidth, printerHeight, panelWidth, panelHeight);
        printerWidth = ratio * (double)panelWidth;
        printerHeight = ratio * (double)panelHeight;
        g.drawImage(bufferedImage, 0, 0, (int)printerWidth, (int)printerHeight, 0, 0, panelWidth, panelHeight, null);
        return 0;
    }
}

