/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3d;
import sweater.Plane;
import sweater.Sweater;
import teddy.Line;

public class PlaneVisual {
    Vector3 base;
    Vector3 normal;
    ReferenceFrame reference;
    public final Color DRAWING_PLANE_COLOR = new Color(0.3764705882352941, 0.3764705882352941, 0.7686274509803922);
    private static final double ERROR = 0.001;
    Vector lines = new Vector();
    Vector3 x_axis;
    Vector3 y_axis;
    Transformable planeVehicle;
    Visual planeVisual;
    Appearance planeAppearance;
    int[][] plane_data;
    static IndexedTriangleArray ground_planeITA;
    static IndexedTriangleArray planeITA;

    PlaneVisual() {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
    }

    public PlaneVisual(Vector3 _base, Vector3 _normal) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
        this.base = _base;
        this.normal = _normal;
        this.normal.normalize();
        this.reference = null;
    }

    PlaneVisual(Vector3 _base, Vector3 _normal, ReferenceFrame reference) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
        this.base = _base;
        this.normal = _normal;
        this.normal.normalize();
        this.reference = reference;
    }

    PlaneVisual(Vector3 _base, Vector3 _normal, Vector3 _up_vec, ReferenceFrame _reference) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
        this.base = _base;
        this.normal = _normal;
        this.reference = _reference;
        this.x_axis = Vector3.crossProduct((Vector3d)_up_vec, (Vector3d)_normal);
        this.y_axis = _up_vec;
    }

    public void refresh_network(Hashtable hash) {
        Vector<Line> revised_lines = new Vector<Line>();
        int i = 0;
        while (i < this.lines.size()) {
            Line original_line = (Line)this.lines.elementAt(i);
            Line line = (Line)hash.get(original_line);
            revised_lines.addElement(line);
            ++i;
        }
        this.lines = revised_lines;
    }

    public PlaneVisual duplicate() {
        PlaneVisual plane = new PlaneVisual();
        plane.base = this.base;
        plane.normal = this.normal;
        plane.lines = this.lines;
        plane.planeVehicle = this.planeVehicle;
        plane.planeVisual = this.planeVisual;
        return plane;
    }

    public boolean parallel(Plane plane) {
        return Math.abs(Vector3.crossProduct((Vector3d)this.normal, (Vector3d)plane.normal).length()) < 0.001;
    }

    public boolean perpendicular(Vector3 vec) {
        return Math.abs(Vector3.crossProduct((Vector3d)this.normal, (Vector3d)vec).length() / vec.length()) < 0.001;
    }

    public boolean equivalent(Plane plane) {
        Vector3 vec;
        return Math.abs(Vector3.crossProduct((Vector3d)this.normal, (Vector3d)plane.normal).getLength()) < 0.001 && Math.abs(Vector3.dotProduct((Vector3d)this.normal, (Vector3d)(vec = Vector3.subtract((Vector3d)plane.base, (Vector3d)this.base)))) < 0.001;
    }

    public boolean contains(Vector3 v) {
        Vector3 vec = Vector3.subtract((Vector3d)v, (Vector3d)this.base);
        return Math.abs(Vector3.dotProduct((Vector3d)this.normal, (Vector3d)vec)) < 0.001;
    }

    public double signed_distance(Vector3 p) {
        return Vector3.dotProduct((Vector3d)this.normal, (Vector3d)Vector3.subtract((Vector3d)p, (Vector3d)this.base));
    }

    public double distance(Vector3 p) {
        return Math.abs(this.signed_distance(p));
    }

    public void show() {
        if (this.planeVehicle != null) {
            this.planeVisual.setParent((Container)this.planeVehicle);
        }
    }

    public void delete() {
        if (this.planeVehicle != null) {
            this.planeVehicle.setParent(null);
        }
    }

    public void addToScenegraph(Scene parent) {
        if (this.planeVehicle == null) {
            this.createPlaneVisual();
            this.planeVehicle = new Transformable();
            this.planeVehicle.setParent((Container)parent);
            this.setPosition((ReferenceFrame)parent);
        } else {
            this.planeVehicle.setParent((Container)parent);
        }
    }

    public void removeFromScenegraph() {
        if (this.planeVehicle != null) {
            this.planeVehicle.setParent(null);
        }
    }

    public Transformable getVehicle() {
        return this.planeVehicle;
    }

    public void addToScenegraph(Transformable parent) {
        if (this.planeVehicle == null) {
            this.createPlaneVisual();
            this.planeVehicle = new Transformable();
        }
        this.planeVehicle.setParent((Container)parent);
        this.setPosition((ReferenceFrame)parent);
    }

    public void setPosition(ReferenceFrame parent) {
        this.planeVehicle.setPosition((Vector3d)this.base, parent);
        Vector3 head = this.getHead();
        this.planeVehicle.setOrientation((Vector3d)head, (Vector3d)this.normal, parent);
    }

    public Vector3 getHead() {
        Vector3 head0 = Vector3.crossProduct((Vector3d)this.normal, (Vector3d)Vector3.Y_AXIS);
        Vector3 head1 = Vector3.crossProduct((Vector3d)this.normal, (Vector3d)Vector3.X_AXIS);
        Vector3 head = head0.getLength() > head1.getLength() ? head0 : head1;
        return head;
    }

    public void moveTo(Vector3 pos, ReferenceFrame parent) {
        if (this.contains(pos)) {
            this.planeVehicle.setPosition((Vector3d)pos, parent);
        }
    }

    private void createPlaneVisual() {
        this.planeVisual = new Visual();
        this.planeAppearance = new Appearance();
        this.planeVisual.setFrontFacingAppearance(this.planeAppearance);
        this.planeAppearance.setDiffuseColor(this.DRAWING_PLANE_COLOR);
        this.planeAppearance.setFillingStyle(FillingStyle.SOLID);
        this.planeAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        this.planeAppearance.setOpacity(0.5);
        if (planeITA == null) {
            planeITA = this.create_planeITA(1);
        }
        this.planeVisual.setGeometry((Geometry)planeITA);
    }

    public IndexedTriangleArray create_planeITA(int size) {
        IndexedTriangleArray planeITA = new IndexedTriangleArray();
        Vertex[] planeVertices = new Vertex[12];
        int i = 0;
        while (i < 6) {
            planeVertices[i] = new Vertex(19);
            double vx = this.plane_data[i][0] * size;
            double vy = this.plane_data[i][1] * size;
            double vz = this.plane_data[i][2] * size;
            planeVertices[i].setXYZ(new Vector3(vx, vy, vz));
            planeVertices[i].setIJK(new Vector3(0.0, 1.0, 0.0));
            planeVertices[i].setU(0.0);
            planeVertices[i].setV(0.0);
            planeVertices[i + 6] = new Vertex(19);
            planeVertices[i + 6].setXYZ(new Vector3(vx, vy, vz));
            planeVertices[i + 6].setIJK(new Vector3(0.0, -1.0, 0.0));
            planeVertices[i + 6].setU(0.0);
            planeVertices[i + 6].setV(0.0);
            ++i;
        }
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 8;
        nArray[8] = 7;
        nArray[9] = 9;
        nArray[10] = 11;
        nArray[11] = 10;
        int[] planeIndices = nArray;
        planeITA.setVertices((Vertex3d[])planeVertices);
        planeITA.setIndices(planeIndices);
        return planeITA;
    }

    public Vector3 project(Point p) {
        return this.project(p.x, p.y);
    }

    public Vector3 project(double x, double y) {
        if (Sweater.jaliceFrame.camera instanceof OrthographicCamera) {
            return this.project_parallel(x, y);
        }
        Vector3 cameraPt = Sweater.jaliceFrame.cameraVehicle.getPosition(this.reference);
        Vector3 screenPt = Sweater.jaliceFrame.screen_coords_to_local_coords(x, y, this.reference);
        Vector3 cameraToBase = Vector3.subtract((Vector3d)this.base, (Vector3d)cameraPt);
        Vector3 cameraToScreen = Vector3.subtract((Vector3d)screenPt, (Vector3d)cameraPt);
        double t = Vector3.dotProduct((Vector3d)cameraToBase, (Vector3d)this.normal) / Vector3.dotProduct((Vector3d)cameraToScreen, (Vector3d)this.normal);
        Vector3 result = Vector3.add((Vector3d)cameraPt, (Vector3d)Vector3.multiply((Vector3d)cameraToScreen, (double)t));
        return result;
    }

    public Vector3 project_parallel(double x, double y) {
        Vector3 cameraDirection = Sweater.jaliceFrame.getCameraDirection(this.reference);
        Vector3 screenPt = Sweater.jaliceFrame.screen_coords_to_local_coords(x, y, this.reference);
        Vector3 screenToBase = Vector3.subtract((Vector3d)this.base, (Vector3d)screenPt);
        double t = Vector3.dotProduct((Vector3d)screenToBase, (Vector3d)this.normal) / Vector3.dotProduct((Vector3d)cameraDirection, (Vector3d)this.normal);
        Vector3 result = Vector3.add((Vector3d)screenPt, (Vector3d)Vector3.multiply((Vector3d)cameraDirection, (double)t));
        return result;
    }
}

