/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import VisualNumerics.math.DoubleMatrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pattern.DrawPanel;
import sweater.Debug;
import sweater.Lscm;
import sweater.Model;
import sweater.UncuttableException;
import sweater.Util;
import teddy.Edge;
import teddy.Face;
import teddy.PatchVertex;
import teddy.Polyhedron;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class PatchGenerater {
    static HashMap seedface_corresponding_polyhedron = new HashMap();
    public static List around_edges = new ArrayList();
    public static final int NL_STATE_INITIAL = 0;
    public static final int NL_STATE_SYSTEM = 1;
    public static final int NL_STATE_MATRIX = 2;
    public static final int NL_STATE_ROW = 3;
    public static final int NL_STATE_MATRIX_CONSTRUCTED = 4;
    public static final int NL_STATE_SYSTEM_CONSTRUCTED = 5;
    public static final int NL_STATE_SOLVED = 6;
    static final int NL_FALSE = 0;
    static final int NL_TRUE = 1;
    static final int NL_SYSTEM = 0;
    static final int NL_MATRIX = 1;
    static final int NL_ROW = 2;
    static final int NL_SOLVER = 256;
    static final int NL_NB_VARIABLES = 257;
    static final int NL_LEAST_SQUARES = 258;
    static final int NL_MAX_ITERATIONS = 259;
    static final int NL_THRESHOLD = 260;
    static final int NL_OMEGA = 261;
    static final int NL_SYMMETRIC = 262;
    static final int NL_USED_ITERATIONS = 263;
    static final int NL_ERROR = 264;
    static final int NL_INNER_ITERATIONS = 265;
    static final int NL_ELAPSED_TIME = 266;
    static final int NL_PRECONDITIONER = 267;
    static final int NL_CG = 512;
    static final int NL_BICGSTAB = 513;
    static final int NL_GMRES = 514;
    static final int NL_SUPERLU_EXT = 528;
    static final int NL_PERM_SUPERLU_EXT = 529;
    static final int NL_SYMMETRIC_SUPERLU_EXT = 530;
    static final int NL_SOLVER_USER = 531;
    public static final int NL_PRECOND_NONE = 0;
    static final int NL_PRECOND_JACOBI = 768;
    static final int NL_PRECOND_SSOR = 769;
    static final int NL_PRECOND_USER = 771;
    static final int NL_NORMALIZE_ROWS = 1024;
    final int NL_RIGHT_HAND_SIDE = 1280;
    final int NL_ROW_SCALING = 1281;
    static final int NL_FUNC_SOLVER = 1536;
    final int NL_FUNC_MATRIX = 1537;
    final int NL_FUNC_PRECONDITIONER = 1538;

    public static void set_stitchPoint(Polyhedron h) {
        int i = 0;
        while (i < h.vertices.size()) {
            Vertex v = (Vertex)h.vertices.get(i);
            int count = 0;
            int j = 0;
            while (j < v.edges.size()) {
                Edge edge = (Edge)v.edges.get(j);
                if (edge.seam) {
                    ++count;
                }
                ++j;
            }
            if (count > 2) {
                v.stitchPoint = true;
            }
            ++i;
        }
    }

    public static List make_patches(Model model) {
        ArrayList<Polyhedron> patches = new ArrayList<Polyhedron>();
        PatchGenerater.initialize_for_make_patches(model);
        DrawPanel.connectores.clear();
        Face seedFace = PatchGenerater.find_next_seedface(model);
        while (seedFace != null) {
            ArrayList faces = new ArrayList();
            Polyhedron patch = new Polyhedron();
            PatchGenerater.make_patch(seedFace, patch, faces);
            Polyhedron h = (Polyhedron)seedface_corresponding_polyhedron.get(seedFace);
            PatchGenerater.create_polyhedron_from_faces(patch, faces, h);
            patches.add(patch);
            seedFace = PatchGenerater.find_next_seedface(model);
        }
        return patches;
    }

    private static void initialize_for_make_patches(Model model) {
        Polyhedron h = model.getPolyhedron();
        PatchGenerater.initialize_for_make_patches_sub(h);
        int i = 0;
        while (i < h.child_polyhedrons.size()) {
            PatchGenerater.initialize_for_make_patches_sub((Polyhedron)h.child_polyhedrons.get(i));
            ++i;
        }
    }

    private static void initialize_for_make_patches_sub(Polyhedron h) {
        int i = 0;
        while (i < h.faces.size()) {
            Face face = (Face)h.faces.get(i);
            face.patch = null;
            ++i;
        }
        i = 0;
        while (i < h.edges.size()) {
            Edge edge = (Edge)h.edges.get(i);
            edge.include_seam = null;
            edge.parent_edge = null;
            edge.child_edges = new ArrayList();
            ++i;
        }
    }

    public static void update_patches(Model model) {
        Debug.vertices_max = new ArrayList();
        Debug.vertices_min = new ArrayList();
        int i = 0;
        while (i < model.patches.size()) {
            Polyhedron patch = (Polyhedron)model.patches.get(i);
            ArrayList<Face> obsolute_faces = new ArrayList<Face>();
            int j = 0;
            while (j < patch.faces.size()) {
                Face face = (Face)patch.faces.get(j);
                if (face.parent_face.disposed) {
                    obsolute_faces.add(face);
                }
                ++j;
            }
            j = 0;
            while (j < obsolute_faces.size()) {
                patch.remove((Face)obsolute_faces.get(j));
                ++j;
            }
            boolean[] face_included = new boolean[model.polyhedron.faces.size()];
            int j2 = 0;
            while (j2 < patch.faces.size()) {
                Face face = (Face)patch.faces.get(j2);
                face_included[face.parent_face.index] = true;
                ++j2;
            }
            List<Face> new_faces = new ArrayList();
            int j3 = 0;
            while (j3 < model.polyhedron.faces.size()) {
                Face face = (Face)model.polyhedron.faces.get(j3);
                if (face.patch == patch && !face_included[face.index]) {
                    new_faces.add(face);
                    Debug.vertices_max.add(face.get_center());
                } else if (face.patch == null) {
                    Debug.vertices_min.add(face.get_center());
                }
                ++j3;
            }
            new_faces = PatchGenerater.collect_adjacent_faces(patch);
            j3 = 0;
            while (j3 < new_faces.size()) {
                Face parent_face = (Face)new_faces.get(j3);
                Edge edge0 = PatchGenerater.get_patch_edge(parent_face.edges[0], patch);
                Edge edge1 = PatchGenerater.get_patch_edge(parent_face.edges[1], patch);
                Edge edge2 = PatchGenerater.get_patch_edge(parent_face.edges[2], patch);
                Face face = new Face(edge0, edge1, edge2, patch);
                face.parent_face = parent_face;
                patch.faces.add(face);
                ++j3;
            }
            PatchGenerater.assign_uvs_to_new_vertices(patch, obsolute_faces);
            ++i;
        }
        ArrayList<Polyhedron> updated_patches = new ArrayList<Polyhedron>();
        int i2 = 0;
        while (i2 < model.patches.size()) {
            Polyhedron patch = (Polyhedron)model.patches.get(i2);
            if (patch.faces.size() != 0) {
                updated_patches.add(patch);
            } else {
                System.out.println("remove empty patch (Segmentation.update_patches)");
            }
            ++i2;
        }
        model.patches = updated_patches;
        seedface_corresponding_polyhedron = new HashMap();
        Face seedFace = PatchGenerater.find_next_seedface(model);
        while (true) {
            System.out.println("seedFace" + seedFace);
            if (seedFace == null) break;
            ArrayList faces = new ArrayList();
            Polyhedron patch = new Polyhedron();
            PatchGenerater.make_patch(seedFace, patch, faces);
            Polyhedron h = (Polyhedron)seedface_corresponding_polyhedron.get(seedFace);
            PatchGenerater.create_polyhedron_from_faces(patch, faces, h);
            model.patches.add(patch);
            seedFace = PatchGenerater.find_next_seedface(model);
        }
        int i3 = 0;
        while (i3 < model.patches.size()) {
            ((Polyhedron)model.patches.get(i3)).set_parameters();
            ++i3;
        }
    }

    static int count_boundary_edges(Polyhedron h) {
        int count = 0;
        int i = 0;
        while (i < h.edges.size()) {
            if (((Edge)h.edges.get((int)i)).left_face == null || ((Edge)h.edges.get((int)i)).right_face == null) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    static Edge get_patch_edge(Edge parent_edge, Polyhedron patch) {
        int i = 0;
        while (i < parent_edge.child_edges.size()) {
            Edge edge = (Edge)parent_edge.child_edges.get(i);
            if (edge.left_face != null && edge.left_face.patch == patch) {
                if (edge.disposed) {
                    PatchGenerater.recover_edge_if_disposed(patch, edge);
                }
                return edge;
            }
            if (edge.right_face != null && edge.right_face.patch == patch) {
                if (edge.disposed) {
                    PatchGenerater.recover_edge_if_disposed(patch, edge);
                }
                return edge;
            }
            ++i;
        }
        Vertex start = PatchGenerater.get_patch_vertex(parent_edge.start, patch);
        Vertex end = PatchGenerater.get_patch_vertex(parent_edge.end, patch);
        Edge new_edge = new Edge(start, end);
        patch.add(new_edge);
        new_edge.seam = parent_edge.seam;
        new_edge.parent_edge = parent_edge;
        parent_edge.child_edges.add(new_edge);
        return new_edge;
    }

    static void recover_edge_if_disposed(Polyhedron patch, Edge edge) {
        if (!edge.disposed) {
            return;
        }
        patch.add(edge);
        edge.disposed = false;
        PatchGenerater.recover_vertex_if_disposed(patch, edge.start);
        PatchGenerater.recover_vertex_if_disposed(patch, edge.end);
    }

    static void recover_vertex_if_disposed(Polyhedron patch, Vertex v) {
        if (!v.disposed) {
            return;
        }
        v.disposed = false;
        patch.add(v);
    }

    static Vertex get_patch_vertex(Vertex parent_vertex, Polyhedron patch) {
        int i = 0;
        while (i < parent_vertex.child_vertices.size()) {
            PatchVertex v = (PatchVertex)parent_vertex.child_vertices.get(i);
            if (v.patch == patch) {
                PatchGenerater.recover_vertex_if_disposed(patch, (Vertex)v);
                return v;
            }
            ++i;
        }
        PatchVertex new_v = new PatchVertex(parent_vertex, patch);
        patch.add((Vertex)new_v);
        parent_vertex.child_vertices.add(new_v);
        new_v.position = parent_vertex;
        if (parent_vertex.stitchPoint) {
            new_v.stitchPoint = true;
        }
        return new_v;
    }

    static List collect_adjacent_faces(Polyhedron patch) {
        ArrayList new_faces = new ArrayList();
        int i = 0;
        while (i < patch.faces.size()) {
            Face face = (Face)patch.faces.get(i);
            PatchGenerater.propagate(face.parent_face, patch, new_faces);
            ++i;
        }
        return new_faces;
    }

    static void propagate(Face face, Polyhedron patch, List new_faces) {
        int j = 0;
        while (j < 3) {
            Edge edge = face.edges[j];
            if (!edge.seam) {
                Face face2 = edge.get_opposite_face(face);
                if (face2 != null && face2.patch == null) {
                    face2.patch = patch;
                    new_faces.add(face2);
                    PatchGenerater.propagate(face2, patch, new_faces);
                } else if (face2 != null) {
                    Polyhedron cfr_ignored_0 = face2.patch;
                }
            }
            ++j;
        }
    }

    static void assign_uvs_to_new_vertices(Polyhedron patch, List obsolute_faces) {
        int i = 0;
        while (i < patch.vertices.size()) {
            Vertex v = (Vertex)patch.vertices.get(i);
            if (v.u == 0.0 && v.v == 0.0) {
                PatchGenerater.assign_uv_to_new_vertex(v, obsolute_faces);
            }
            ++i;
        }
    }

    static void assign_uv_to_new_vertex(Vertex v, List obsolute_faces) {
        Face closest = null;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < obsolute_faces.size()) {
            Face face = (Face)obsolute_faces.get(i);
            double d = Vertex.distance((Vertex)face.get_center(), (Vertex)v);
            if (d < min) {
                min = d;
                closest = face;
            }
            ++i;
        }
        Face face = closest;
        double[][] A = new double[3][2];
        double[] B = new double[3];
        Vertex v0 = face.get_vertex(0);
        Vertex v1 = face.get_vertex(1);
        Vertex v2 = face.get_vertex(2);
        Vector3 vec01 = new Vector3((Vector3)v0, (Vector3)v1);
        Vector3 vec02 = new Vector3((Vector3)v0, (Vector3)v2);
        Vector3 vec = new Vector3((Vector3)v0, (Vector3)v);
        A[0][0] = vec01.x;
        A[1][0] = vec01.y;
        A[2][0] = vec01.z;
        A[0][1] = vec02.x;
        A[1][1] = vec02.y;
        A[2][1] = vec02.z;
        B[0] = vec.x;
        B[1] = vec.y;
        B[2] = vec.z;
        double[][] AT = DoubleMatrix.transpose((double[][])A);
        double[][] ATA = DoubleMatrix.multiply((double[][])AT, (double[][])A);
        double[] ATB = DoubleMatrix.multiply((double[][])AT, (double[])B);
        try {
            double[] coords = DoubleMatrix.solve((double[][])ATA, (double[])ATB);
            v.u = v0.u + (v1.u - v0.u) * coords[0] + (v2.u - v0.u) * coords[1];
            v.v = v0.v + (v1.v - v0.v) * coords[0] + (v2.v - v0.v) * coords[1];
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void create_polyhedron_from_faces(Polyhedron patch, List faces, Polyhedron h) {
        try {
            h.set_parameters();
            visited = new boolean[h.edges.size()];
            edges = new ArrayList<Edge>();
            i = 0;
            while (i < faces.size()) {
                face = (Face)faces.get(i);
                j = 0;
                while (j < 3) {
                    edge = face.edges[j];
                    if (!visited[edge.index]) {
                        visited[edge.index] = true;
                        edges.add(edge);
                    }
                    ++j;
                }
                ++i;
            }
            visited = new boolean[h.vertices.size()];
            vertices = new ArrayList<Vertex>();
            i = 0;
            while (i < edges.size()) {
                edge = (Edge)edges.get(i);
                if (!visited[edge.start.index]) {
                    visited[edge.start.index] = true;
                    vertices.add(edge.start);
                }
                if (edge.end.index >= h.vertices.size()) {
                    throw new UncuttableException();
                }
                if (!visited[edge.end.index]) {
                    visited[edge.end.index] = true;
                    vertices.add(edge.end);
                }
                ++i;
            }
            hash = new HashMap<Object, Object>();
            new_vertices = new ArrayList<PatchVertex>();
            i = 0;
            while (i < vertices.size()) {
                v = (Vertex)vertices.get(i);
                new_v = new PatchVertex(v, patch);
                new_v.position = v;
                v.child_vertices.add(new_v);
                if (v.stitchPoint) {
                    new_v.stitchPoint = true;
                }
                new_v.u = v.u;
                new_v.v = v.v;
                hash.put(v, new_v);
                new_vertices.add(new_v);
                ++i;
            }
            new_edges = new ArrayList<Edge>();
            i = 0;
            while (i < edges.size()) {
                edge = (Edge)edges.get(i);
                new_edge = new Edge((Vertex)hash.get(edge.start), (Vertex)hash.get(edge.end));
                new_edge.seam = edge.seam;
                new_edge.parent_edge = edge;
                edge.child_edges.add(new_edge);
                hash.put(edge, new_edge);
                new_edges.add(new_edge);
                ++i;
            }
            new_faces = new ArrayList<Face>();
            i = 0;
            while (i < faces.size()) {
                face = (Face)faces.get(i);
                new_face = new Face((Edge)hash.get(face.edges[0]), (Edge)hash.get(face.edges[1]), (Edge)hash.get(face.edges[2]), patch);
                new_face.parent_face = face;
                j = 0;
                while (j < 3) {
                    if (face.edges[j].left_face == face) {
                        new_face.edges[j].left_face = new_face;
                    } else {
                        new_face.edges[j].right_face = new_face;
                    }
                    ++j;
                }
                new_faces.add(new_face);
                ++i;
            }
            seam_vertices = new ArrayList<Vertex>();
            new_new_edges = new ArrayList<Edge>();
            i = 0;
            while (i < new_edges.size()) {
                edge = (Edge)new_edges.get(i);
                if (edge.parent_edge.seam && edge.left_face != null && edge.right_face != null) {
                    new_edge = new Edge(edge.start, edge.end);
                    new_edge.parent_edge = edge.parent_edge;
                    edge.parent_edge.child_edges.add(new_edge);
                    new_edge.left_face = edge.left_face;
                    edge.left_face = null;
                    new_edge.left_face.replace_edge(edge, new_edge);
                    if (!seam_vertices.contains(edge.start)) {
                        seam_vertices.add(edge.start);
                    }
                    if (!seam_vertices.contains(edge.end)) {
                        seam_vertices.add(edge.end);
                    }
                    new_new_edges.add(new_edge);
                }
                ++i;
            }
            Util.append(new_edges, new_new_edges);
            i = 0;
            while (i < seam_vertices.size()) {
                block30: {
                    v = (PatchVertex)seam_vertices.get(i);
                    seams = new ArrayList<Edge>();
                    j = 0;
                    while (j < v.edges.size()) {
                        edge = (Edge)v.edges.get(j);
                        if (edge.parent_edge.seam) {
                            seams.add(edge);
                        }
                        ++j;
                    }
                    if (seams.size() > 2) ** GOTO lbl161
                    break block30;
lbl-1000:
                    // 1 sources

                    {
                        edge = (Edge)seams.get(0);
                        seams.remove(edge);
                        visited_edges = new ArrayList<Edge>();
                        visited_edges.add(edge);
                        v0 = face = edge.left_face != null ? edge.left_face : edge.right_face;
                        while (true) {
                            if (face == null) {
                                System.out.println("face == null");
                            }
                            if (v == null) {
                                System.out.println("v == null");
                            }
                            if (edge == null) {
                                System.out.println("edge == null");
                            }
                            edge = PatchGenerater.get_next_edge((Vertex)v, face, edge);
                            visited_edges.add(edge);
                            if (edge.parent_edge.seam) break;
                            face = edge.get_opposite_face(face);
                        }
                        seams.remove(edge);
                        new_v = new PatchVertex((Vertex)v, patch);
                        new_v.position = v.position;
                        if (v.stitchPoint) {
                            new_v.stitchPoint = true;
                        }
                        j = 0;
                        while (j < visited_edges.size()) {
                            edge = (Edge)visited_edges.get(j);
                            PatchGenerater.replace_vertex(edge, (Vertex)v, (Vertex)new_v);
                            ++j;
                        }
                        new_vertices.add(new_v);
lbl161:
                        // 2 sources

                        ** while (seams.size() > 0)
                    }
lbl162:
                    // 1 sources

                    new_vertices.remove(v);
                }
                ++i;
            }
            patch.vertices = new_vertices;
            patch.edges = new_edges;
            patch.faces = new_faces;
            patch.set_parameters();
        }
        catch (Exception e) {
            System.err.println("PatchGenerater can not create polyhedron from faces" + e);
            return;
        }
    }

    public static Edge get_next_edge(Vertex v, Face face, Edge edge) {
        Edge prev_edge = face.get_prev_edge(edge);
        if (prev_edge == null) {
            System.out.println("prev_edge == null");
            return null;
        }
        if (prev_edge.contains(v)) {
            return prev_edge;
        }
        return face.get_next_edge(edge);
    }

    public static void replace_vertex(Edge edge, Vertex v, Vertex new_v) {
        if (edge.start == v) {
            edge.start = new_v;
        } else {
            edge.end = new_v;
        }
        new_v.edges.add(edge);
    }

    public static Face find_next_seedface(Model model) {
        Polyhedron h = model.getPolyhedron();
        Face face = PatchGenerater.find_next_seedface_sub(h);
        if (face == null) {
            int i = 0;
            while (i < h.child_polyhedrons.size()) {
                Polyhedron child = (Polyhedron)h.child_polyhedrons.get(i);
                face = PatchGenerater.find_next_seedface_sub(child);
                if (face != null) break;
                ++i;
            }
        }
        return face;
    }

    private static Face find_next_seedface_sub(Polyhedron h) {
        int i = 0;
        while (i < h.faces.size()) {
            Face f = (Face)h.faces.get(i);
            if (f.patch == null) {
                seedface_corresponding_polyhedron.put(f, h);
                return f;
            }
            ++i;
        }
        return null;
    }

    public static void make_patch(Face seedface, Polyhedron patch, List total_faces) {
        around_edges = new ArrayList();
        seedface.patch = patch;
        total_faces.add(seedface);
        int i = 0;
        while (i < seedface.edges.length) {
            Edge edge = seedface.edges[i];
            if (!edge.seam) {
                Face newface = edge.get_opposite_face(seedface);
                if (newface == null) {
                    System.out.println("null in make_patch");
                    break;
                }
                if (newface.patch == null) {
                    PatchGenerater.make_patch(newface, patch, total_faces);
                }
            } else {
                around_edges.add(edge);
            }
            ++i;
        }
    }

    public static void segmentation(Model model) {
        if (model == null) {
            return;
        }
        model.patches = PatchGenerater.make_patches(model);
    }

    public static List convert_Vertex2DList_from_VertexList(List points) {
        ArrayList<Vertex2D> points2D = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < points.size()) {
            Vertex v = (Vertex)points.get(i);
            Vertex2D texturecoord = v.getPatternCoord();
            texturecoord.setStitchPoint(v.stitchPoint);
            points2D.add(texturecoord);
            ++i;
        }
        return points2D;
    }

    public static List trace_boundary2D(Polyhedron h) {
        List points = PatchGenerater.trace_boundary(h);
        List points2D = PatchGenerater.convert_Vertex2DList_from_VertexList(points);
        return points2D;
    }

    public static List trace_boundary(Polyhedron polyhedron) {
        boolean[] visited = new boolean[polyhedron.edges.size()];
        Edge start_edge = PatchGenerater.find_seed_edge(polyhedron, visited);
        ArrayList<Vertex> points = new ArrayList<Vertex>();
        Vertex prev_v = start_edge.start;
        Edge prev_edge = start_edge;
        while (true) {
            points.add(prev_v);
            Edge next_edge = PatchGenerater.find_next_edge(prev_edge, prev_v);
            if (next_edge == start_edge) break;
            prev_v = next_edge.get_opposite_vertex(prev_v);
            prev_edge = next_edge;
        }
        return points;
    }

    public static Edge find_next_edge(Edge prev_edge, Vertex prev_v) {
        int i = 0;
        while (i < prev_v.edges.size()) {
            Edge edge = (Edge)prev_v.edges.get(i);
            if (edge != prev_edge && (edge.left_face == null || edge.right_face == null)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public static Edge find_seed_edge(Polyhedron h, boolean[] visited) {
        int i = 0;
        while (i < h.edges.size()) {
            Edge edge = (Edge)h.edges.get(i);
            if (!(edge.left_face != null && edge.right_face != null || visited[edge.index])) {
                visited[edge.index] = true;
                return edge;
            }
            ++i;
        }
        return null;
    }

    public static void apply(Polyhedron polyhedron) {
        PatchGenerater.project(polyhedron);
        int nb_vertices = polyhedron.vertices.size();
        Lscm.nlNewContext();
        if (Lscm.nlInitExtension("SUPERLU")) {
            Lscm.nlSolverParameteri(256, 529);
            System.out.println("Using SuperLU, cool !");
        } else {
            Lscm.nlSolverParameteri(256, 512);
            Lscm.nlSolverParameteri(267, 768);
            System.out.println("Using Jacobi pre-conditioned conjugate gradient");
        }
        Lscm.nlSolverParameteri(257, 2 * nb_vertices);
        Lscm.nlSolverParameteri(258, 1);
        Lscm.nlSolverParameteri(259, 5 * nb_vertices);
        Lscm.nlSolverParameterd(260, 1.0E-10);
        Lscm.nlBegin(0);
        PatchGenerater.mesh_to_solver(polyhedron);
        Lscm.nlBegin(1);
        PatchGenerater.setup_lscm(polyhedron);
        Lscm.nlEnd(1);
        Lscm.nlEnd(0);
        System.out.println("Solving...");
        Lscm.nlSolve();
        PatchGenerater.solver_to_mesh(polyhedron);
        Lscm.nlDeleteCurrentContext();
    }

    static void setup_lscm(Polyhedron p) {
        int i = 0;
        while (i < p.faces.size()) {
            Face face = (Face)p.faces.get(i);
            PatchGenerater.setup_lscm(face);
            ++i;
        }
    }

    static void setup_lscm(Face face) {
        PatchGenerater.setup_conformal_map_relations(face);
    }

    static void project_triangle(Face face) {
        Vertex p0 = face.get_vertex(0);
        Vertex p1 = face.get_vertex(1);
        Vertex p2 = face.get_vertex(2);
        Vector3 x = Vertex.subtract((Vector3)p1, (Vector3)p0);
        x.normalize();
        Vector3 p02 = Vertex.subtract((Vector3)p2, (Vector3)p0);
        Vector3 z = Vertex.cross_product((Vector3)x, (Vector3)p02);
        z.normalize();
        Vector3 y = Vertex.cross_product((Vector3)z, (Vector3)x);
        Vertex originalPoint = p0;
        Vector3 v1 = Vertex.subtract((Vector3)p1, (Vector3)originalPoint);
        Vector3 v2 = Vertex.subtract((Vector3)p2, (Vector3)originalPoint);
        p0.u = 0.0;
        p0.v = 0.0;
        p1.u = v1.length();
        p1.v = 0.0;
        p2.u = Vertex.dot_product((Vector3)v2, (Vector3)x);
        p2.v = Vertex.dot_product((Vector3)v2, (Vector3)y);
    }

    static void setup_conformal_map_relations(Face face) {
        PatchGenerater.project_triangle(face);
        Vertex v0 = face.get_vertex(0);
        Vertex v1 = face.get_vertex(1);
        Vertex v2 = face.get_vertex(2);
        Vector2 z01 = new Vector2(v1.u - v0.u, v1.v - v0.v);
        Vector2 z02 = new Vector2(v2.u - v0.u, v2.v - v0.v);
        double a = z01.x;
        double b = z01.y;
        double c = z02.x;
        double d = z02.y;
        if (b != 0.0) {
            System.out.println("error : b!=0 ");
            return;
        }
        int id0 = v0.index;
        int id1 = v1.index;
        int id2 = v2.index;
        int u0_id = 2 * id0;
        int v0_id = 2 * id0 + 1;
        int u1_id = 2 * id1;
        int v1_id = 2 * id1 + 1;
        int u2_id = 2 * id2;
        int v2_id = 2 * id2 + 1;
        Lscm.nlBegin(2);
        Lscm.nlCoefficient(u0_id, -a + c);
        Lscm.nlCoefficient(v0_id, b - d);
        Lscm.nlCoefficient(u1_id, -c);
        Lscm.nlCoefficient(v1_id, d);
        Lscm.nlCoefficient(u2_id, a);
        Lscm.nlEnd(2);
        Lscm.nlBegin(2);
        Lscm.nlCoefficient(u0_id, -b + d);
        Lscm.nlCoefficient(v0_id, -a + c);
        Lscm.nlCoefficient(u1_id, -d);
        Lscm.nlCoefficient(v1_id, -c);
        Lscm.nlCoefficient(v2_id, a);
        Lscm.nlEnd(2);
    }

    static void solver_to_mesh(Polyhedron p) {
        int i = 0;
        while (i < p.vertices.size()) {
            Vertex it = p.vertices(i);
            it.u = Lscm.nlGetVariable(2 * it.index);
            it.v = Lscm.nlGetVariable(2 * it.index + 1);
            ++i;
        }
    }

    static void mesh_to_solver(Polyhedron p) {
        int i = 0;
        while (i < p.vertices.size()) {
            Vertex it = p.vertices(i);
            it.index = i;
            Lscm.nlSetVariable(2 * it.index, it.u);
            Lscm.nlSetVariable(2 * it.index + 1, it.v);
            if (it.fixed) {
                System.out.println("fixed");
                Lscm.nlLockVariable(2 * it.index);
                Lscm.nlLockVariable(2 * it.index + 1);
            }
            ++i;
        }
    }

    static double f_min(double m, double n) {
        if (m < n) {
            return m;
        }
        return n;
    }

    static double f_max(double m, double n) {
        if (m > n) {
            return m;
        }
        return n;
    }

    static void project(Polyhedron p) {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double zmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymax = -1.7976931348623157E308;
        double zmax = -1.7976931348623157E308;
        int i = 0;
        while (i < p.vertices.size()) {
            Vertex v = p.vertices(i);
            xmin = PatchGenerater.f_min(v.x, xmin);
            ymin = PatchGenerater.f_min(v.y, ymin);
            zmin = PatchGenerater.f_min(v.z, zmin);
            xmax = PatchGenerater.f_max(v.x, xmax);
            ymax = PatchGenerater.f_max(v.y, ymax);
            zmax = PatchGenerater.f_max(v.z, zmax);
            ++i;
        }
        double dx = xmax - xmin;
        double dy = ymax - ymin;
        double dz = zmax - zmin;
        Vector3 V1 = new Vector3();
        Vector3 V2 = new Vector3();
        Vector3 V3 = new Vector3();
        if (dx < dy && dx < dz) {
            V1 = new Vector3(0.0, 1.0, 0.0);
            V2 = new Vector3(0.0, 0.0, 1.0);
            V3 = new Vector3(1.0, 0.0, 0.0);
        } else if (dy < dx && dy < dz) {
            V1 = new Vector3(1.0, 0.0, 0.0);
            V2 = new Vector3(0.0, 0.0, 1.0);
            V3 = new Vector3(0.0, 1.0, 0.0);
        } else if (dz < dx && dz < dy) {
            V1 = new Vector3(1.0, 0.0, 0.0);
            V2 = new Vector3(0.0, 1.0, 0.0);
            V3 = new Vector3(0.0, 0.0, 1.0);
        }
        Vertex vxmin = new Vertex();
        double umin = Double.MAX_VALUE;
        Vertex vxmax = new Vertex();
        double umax = -1.7976931348623157E308;
        int i2 = 0;
        while (i2 < p.vertices.size()) {
            Vertex vertex = p.vertices(i2);
            vertex.fixed = false;
            Face centerFace = p.get_center_face();
            double w = Vertex.dot_product((Vector3)centerFace.normal, (Vector3)V3);
            vertex.u = w > 0.0 ? Vertex.dot_product((Vector3)vertex, (Vector3)V1) : -Vertex.dot_product((Vector3)vertex, (Vector3)V1);
            vertex.v = Vertex.dot_product((Vector3)vertex, (Vector3)V2);
            if (vertex.u < umin) {
                vxmin = vertex;
                umin = vertex.u;
            }
            if (vertex.u > umax) {
                vxmax = vertex;
                umax = vertex.u;
            }
            ++i2;
        }
        vxmin.fixed = true;
        vxmax.fixed = true;
    }
}

