/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.math.Vector3;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import sweater.Model;
import teddy.Edge;
import teddy.Face;
import teddy.Polyhedron;
import teddy.Vertex;

public class ObjFile {
    public static final double LOAD_RATIO = 1.0;
    private static final int SEAM_MAX_NUMBER = 2000;
    private static List vertices = new ArrayList();
    private static List faces = new ArrayList();
    private static int[][] seams = new int[2000][2];
    private static int n_seams = 0;
    private static int[] seams1 = new int[2000];
    private static int n_seams1 = 0;

    public static Model load(String filename) {
        ObjFile.initialize();
        Polyhedron polyhedron = ObjFile.load_sub(filename);
        Model model = new Model(polyhedron);
        return model;
    }

    public static Polyhedron load_sub(String filename) {
        try {
            String line;
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader r = new BufferedReader(new InputStreamReader(fis));
            int[] vertex_count = new int[]{1};
            n_seams = 0;
            int child_size = 0;
            while ((line = r.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) continue;
                String head = st.nextToken();
                if (head.equals("v")) {
                    double x = new Double(st.nextToken()) * 1.0;
                    double y = new Double(st.nextToken()) * 1.0;
                    double z = new Double(st.nextToken()) * 1.0;
                    vertices.add(new Vector3(x, y, z));
                    continue;
                }
                if (head.equals("f")) {
                    int x = new Integer(st.nextToken()) - vertex_count[0];
                    int y = new Integer(st.nextToken()) - vertex_count[0];
                    int z = new Integer(st.nextToken()) - vertex_count[0];
                    faces.add(new Vector3((double)x, (double)y, (double)z));
                    continue;
                }
                if (head.equals("#")) {
                    String string = st.nextToken();
                    if (string == null) break;
                    if (!string.equals("seam")) continue;
                    int start_index = new Integer(st.nextToken());
                    int end_index = new Integer(st.nextToken());
                    ObjFile.seams[ObjFile.n_seams][0] = start_index;
                    ObjFile.seams[ObjFile.n_seams][1] = end_index;
                    ++n_seams;
                    continue;
                }
                if (!head.equals("child")) continue;
                child_size = new Integer(st.nextToken());
            }
            r.close();
            int n_vertices = vertices.size();
            double[][] vertices_array = new double[n_vertices][3];
            int i = 0;
            while (i < n_vertices) {
                Vector3 v = (Vector3)vertices.get(i);
                vertices_array[i][0] = v.x;
                vertices_array[i][1] = v.y;
                vertices_array[i][2] = v.z;
                ++i;
            }
            int n_triangles = faces.size();
            int[] indices = new int[n_triangles * 3];
            int i2 = 0;
            while (i2 < n_triangles) {
                Vector3 v = (Vector3)faces.get(i2);
                indices[i2 * 3] = (int)v.x;
                indices[i2 * 3 + 1] = (int)v.y;
                indices[i2 * 3 + 2] = (int)v.z;
                ++i2;
            }
            double min_x = 1000.0;
            double max_x = -1000.0;
            double min_y = 1000.0;
            double max_y = -1000.0;
            int i3 = 0;
            while (i3 < vertices_array.length) {
                double[] v = vertices_array[i3];
                if (v[0] < min_x) {
                    min_x = v[0];
                }
                if (v[0] > max_x) {
                    max_x = v[0];
                }
                if (v[1] < min_y) {
                    min_y = v[1];
                }
                if (v[1] > max_y) {
                    max_y = v[1];
                }
                ++i3;
            }
            Polyhedron polyhedron = new Polyhedron(vertices_array, indices);
            vertex_count[0] = vertex_count[0] + n_vertices;
            int i4 = 0;
            while (i4 < n_seams) {
                int start_index = seams[i4][0];
                int end_index = seams[i4][1];
                Vertex start_v = (Vertex)polyhedron.vertices.get(start_index);
                Vertex end_v = (Vertex)polyhedron.vertices.get(end_index);
                Edge edge = start_v.get_common_edge(end_v);
                edge.seam = true;
                ++i4;
            }
            r.close();
            i4 = 0;
            while (i4 < child_size) {
                Polyhedron child_polyhedron = ObjFile.load_sub(String.valueOf(filename) + i4);
                polyhedron.child_polyhedrons.add(child_polyhedron);
                ++i4;
            }
            return polyhedron;
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
            return null;
        }
    }

    public static Model load_sub1(BufferedReader r, Model parentModel, int[] vertex_count) {
        try {
            String line;
            while ((line = r.readLine()) != null) {
                int seam_id;
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) continue;
                String head = st.nextToken();
                if (head.equals("v")) {
                    double x = new Double(st.nextToken()) * 1.0;
                    double y = new Double(st.nextToken()) * 1.0;
                    double z = new Double(st.nextToken()) * 1.0;
                    vertices.add(new Vector3(x, y, z));
                    continue;
                }
                if (head.equals("f")) {
                    int x = new Integer(st.nextToken()) - vertex_count[0];
                    int y = new Integer(st.nextToken()) - vertex_count[0];
                    int z = new Integer(st.nextToken()) - vertex_count[0];
                    faces.add(new Vector3((double)x, (double)y, (double)z));
                    continue;
                }
                if (!head.equals("#")) continue;
                String string = st.nextToken();
                if (string == null) break;
                if (!string.equals("seam")) continue;
                ObjFile.seams1[ObjFile.n_seams1] = seam_id = new Integer(st.nextToken()).intValue();
                ++n_seams1;
            }
            r.close();
            int n_vertices = vertices.size();
            double[][] vertices_array = new double[n_vertices][3];
            int i = 0;
            while (i < n_vertices) {
                Vector3 v = (Vector3)vertices.get(i);
                vertices_array[i][0] = v.x;
                vertices_array[i][1] = v.y;
                vertices_array[i][2] = v.z;
                ++i;
            }
            int n_triangles = faces.size();
            int[] indices = new int[n_triangles * 3];
            int i2 = 0;
            while (i2 < n_triangles) {
                Vector3 v = (Vector3)faces.get(i2);
                indices[i2 * 3] = (int)v.x;
                indices[i2 * 3 + 1] = (int)v.y;
                indices[i2 * 3 + 2] = (int)v.z;
                ++i2;
            }
            double min_x = 1000.0;
            double max_x = -1000.0;
            double min_y = 1000.0;
            double max_y = -1000.0;
            int i3 = 0;
            while (i3 < vertices_array.length) {
                double[] v = vertices_array[i3];
                if (v[0] < min_x) {
                    min_x = v[0];
                }
                if (v[0] > max_x) {
                    max_x = v[0];
                }
                if (v[1] < min_y) {
                    min_y = v[1];
                }
                if (v[1] > max_y) {
                    max_y = v[1];
                }
                ++i3;
            }
            System.out.println("Model width  " + min_x + ", " + max_x + "  " + (max_x - min_x));
            System.out.println("Model height " + min_y + ", " + max_y + "  " + (max_y - min_y));
            System.out.println("Model poly-count " + n_triangles);
            Model model = new Model(vertices_array, indices);
            vertex_count[0] = vertex_count[0] + n_vertices;
            System.out.println("n_seams " + n_seams);
            int i4 = 0;
            while (i4 < n_seams1) {
                int j = seams1[i4];
                Edge edge = (Edge)model.polyhedron.edges.get(j);
                edge.seam = true;
                ++i4;
            }
            return model;
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
            return null;
        }
    }

    public static void save(Model model, String filename) {
        ObjFile.save(model.polyhedron, filename);
    }

    public static void save(Polyhedron polyhedron, String filename) {
        ArrayList<Integer> indices;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList faces = new ArrayList();
        ArrayList seams = new ArrayList();
        int i = 0;
        while (i < polyhedron.vertices.size()) {
            Vertex v = (Vertex)polyhedron.vertices.get(i);
            vertices.add(v);
            v.index = i++;
        }
        i = 0;
        while (i < polyhedron.faces.size()) {
            Face f = (Face)polyhedron.faces.get(i);
            f.index = i;
            indices = new ArrayList<Integer>();
            int j = 0;
            while (j < f.edges.length) {
                indices.add(new Integer(f.get_vertex((int)j).index + 1));
                ++j;
            }
            faces.add(indices);
            ++i;
        }
        i = 0;
        while (i < polyhedron.edges.size()) {
            Edge e = (Edge)polyhedron.edges.get(i);
            if (e.seam) {
                indices = new ArrayList();
                indices.add(new Integer(e.start.index));
                indices.add(new Integer(e.end.index));
                seams.add(indices);
            }
            ++i;
        }
        try {
            int j;
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            String line = "child " + polyhedron.child_polyhedrons.size();
            out.write(line, 0, line.length());
            out.newLine();
            int i2 = 0;
            while (i2 < vertices.size()) {
                Vertex v = (Vertex)vertices.get(i2);
                line = "v " + v.x + " " + v.y + " " + v.z;
                out.write(line, 0, line.length());
                out.newLine();
                ++i2;
            }
            i2 = 0;
            while (i2 < faces.size()) {
                List indices2 = (List)faces.get(i2);
                line = "f";
                j = 0;
                while (j < indices2.size()) {
                    line = String.valueOf(line) + " " + ((Integer)indices2.get(j)).toString();
                    ++j;
                }
                out.write(line, 0, line.length());
                out.newLine();
                ++i2;
            }
            i2 = 0;
            while (i2 < seams.size()) {
                List indices3 = (List)seams.get(i2);
                line = "# seam";
                j = 0;
                while (j < indices3.size()) {
                    line = String.valueOf(line) + " " + ((Integer)indices3.get(j)).toString();
                    ++j;
                }
                out.write(line, 0, line.length());
                out.newLine();
                ++i2;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
        i = 0;
        while (i < polyhedron.child_polyhedrons.size()) {
            Polyhedron child_polyhedron = (Polyhedron)polyhedron.child_polyhedrons.get(i);
            ObjFile.save(child_polyhedron, String.valueOf(filename) + i);
            ++i;
        }
    }

    public static void initialize() {
        vertices.clear();
        faces.clear();
        seams = new int[2000][2];
        n_seams = 0;
    }
}

