/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.LineArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import pattern.DrawPanel;
import pattern.Piece;
import sweater.AdjustmentInputStroke;
import sweater.ControlCurve;
import sweater.EdgePair;
import sweater.Eye;
import sweater.Nose;
import sweater.Plane;
import sweater.SurfaceLine;
import sweater.Sweater;
import sweater.TmpCamera;
import sweater.Util;
import sweater.VertexPair;
import teddy.CameraInterface;
import teddy.CleanStroke;
import teddy.Edge;
import teddy.Face;
import teddy.Inflate;
import teddy.Inflation;
import teddy.LaplacianCut;
import teddy.LaplacianExtrusion;
import teddy.LaplacianRemesh;
import teddy.PatchVertex;
import teddy.Polyhedron;
import teddy.Remesh;
import teddy.Skin;
import teddy.StuffInflation;
import teddy.SurfacePath;
import teddy.Vector2;
import teddy.Vertex2D;

public class Model {
    private static final edu.cmu.cs.stage3.alice.scenegraph.Color BODY_COLOR = new edu.cmu.cs.stage3.alice.scenegraph.Color(1.0, 1.0, 1.0);
    private static final edu.cmu.cs.stage3.alice.scenegraph.Color BODY_COLOR_ACTIVE = new edu.cmu.cs.stage3.alice.scenegraph.Color(1.0, 1.0, 1.0);
    private static final edu.cmu.cs.stage3.alice.scenegraph.Color CLOTH_COLOR = new edu.cmu.cs.stage3.alice.scenegraph.Color(0.7058823529411765, 0.8352941176470589, 1.0);
    private static final edu.cmu.cs.stage3.alice.scenegraph.Color CLOTH_COLOR_GREEN = new edu.cmu.cs.stage3.alice.scenegraph.Color(0.5019607843137255, 0.8431372549019608, 0.5019607843137255);
    private static final edu.cmu.cs.stage3.alice.scenegraph.Color REVERSE_COLOR = new edu.cmu.cs.stage3.alice.scenegraph.Color(0.3764705882352941, 0.3764705882352941, 0.7686274509803922);
    private static final edu.cmu.cs.stage3.alice.scenegraph.Color BLACK = new edu.cmu.cs.stage3.alice.scenegraph.Color(0.0f, 0.0f, 0.0f);
    private static final edu.cmu.cs.stage3.alice.scenegraph.Color WHITE = new edu.cmu.cs.stage3.alice.scenegraph.Color(1.0f, 1.0f, 1.0f);
    private boolean TEXTURE_ENABLED = true;
    private boolean REVERSE_SIDE_ENABLED = false;
    public List patches = new ArrayList();
    public List vertex_pairs = new ArrayList();
    public List edge_pairs = new ArrayList();
    HashMap modelVisuals = new HashMap();
    private List decorations = new ArrayList();
    List stroke;
    private SurfacePath surfacePath;
    private List stuffs;
    Vector3 center;
    private static int inflate_count = 0;
    private static final int MAX_INFLATE = 30;
    boolean pieceSmoothed = false;
    TextureMap modelTextureMap = new TextureMap();
    public CameraInterface camera;
    Transformable modelVehicle;
    Visual modelVisual;
    Appearance modelAppearance;
    IndexedTriangleArray modelITA;
    boolean deleted = false;
    private final int SMOOTH = 1;
    private final int WIREFRAME = 0;
    private int style = 0;
    edu.cmu.cs.stage3.alice.scenegraph.Color base_color = BODY_COLOR;
    private List surfaceLines = new ArrayList();
    Polyhedron polyhedron;
    List patchITAs = new ArrayList();
    List patchVisuals = new ArrayList();
    LineArray lineArray;
    Visual lineVisual;
    Appearance lineAppearance;
    private SurfaceLine surfaceLine;
    List curves = new ArrayList();

    public Model() {
        this.modelVehicle = new Transformable();
        this.modelVisual = new Visual();
        this.modelVisual.setParent((Container)this.modelVehicle);
        this.modelITA = new IndexedTriangleArray();
        this.modelVisual.setGeometry((Geometry)this.modelITA);
        this.modelAppearance = new Appearance();
        this.modelVisual.setFrontFacingAppearance(this.modelAppearance);
        this.modelAppearance.setDiffuseColor(BODY_COLOR);
        this.modelAppearance.setFillingStyle(FillingStyle.SOLID);
        this.modelAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        this.initialize_texture();
    }

    Model(Polyhedron polyhedron) {
        this();
        this.polyhedron = polyhedron;
    }

    Model(List _stroke, Scene scene) {
        this((Container)scene);
        _stroke = CleanStroke.clean((List)_stroke, (int)30, (int)60, (boolean)true);
        this.stroke = this.screen_coords_to_model_coords(_stroke);
        this.polyhedron = Inflation.generate((List)this.stroke);
        if (this.polyhedron == null) {
            return;
        }
        this.stuffs = StuffInflation.init((Polyhedron)this.polyhedron);
        this.modelVehicle.setPosition((Vector3d)this.center, (ReferenceFrame)scene);
        this.initialize_texture();
    }

    Model(Container parent) {
        this.modelVehicle = new Transformable();
        this.modelVehicle.setParent(parent);
        this.modelVisual = new Visual();
        this.modelVisual.setParent((Container)this.modelVehicle);
        this.modelITA = new IndexedTriangleArray();
        this.modelVisual.setGeometry((Geometry)this.modelITA);
        this.modelAppearance = new Appearance();
        this.modelVisual.setFrontFacingAppearance(this.modelAppearance);
        this.modelAppearance.setDiffuseColor(BODY_COLOR);
        this.modelAppearance.setFillingStyle(FillingStyle.SOLID);
        this.modelAppearance.setShadingStyle(ShadingStyle.SMOOTH);
    }

    Model(double[][] vertices, int[] indices) {
        this();
        this.polyhedron = new Polyhedron(vertices, indices);
        this.initialize_texture();
        this.update();
    }

    void show() {
        this.modelVehicle.setParent((Container)Sweater.jaliceFrame.scene);
    }

    void hide() {
        this.modelVehicle.setParent(null);
    }

    public void update() {
        System.out.println("Model.update");
        int i = 0;
        while (i < this.patchVisuals.size()) {
            ((Visual)this.patchVisuals.get(i)).setParent(null);
            ++i;
        }
        i = 0;
        while (i < this.patchVisuals.size()) {
            ((Visual)this.patchVisuals.get(i)).setParent((Container)this.modelVehicle);
            ++i;
        }
        this.updateControlCurves();
        this.setITA();
    }

    public void update_old() {
        this.init_patches();
        this.updateControlCurves();
        System.out.println("curves" + this.curves.size());
        this.setITA();
    }

    public List screen_coords_to_model_coords(List stroke) {
        ArrayList<Vertex2D> list = new ArrayList<Vertex2D>();
        this.center = new Vector3();
        Plane plane = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.get(i);
            Vector3 pos = plane.project(p.point());
            this.center.add(pos);
            if (pos != null) {
                p.x = pos.x;
                p.y = pos.y;
                list.add(p);
            }
            ++i;
        }
        this.center.multiply(1.0 / (double)stroke.size());
        Vector2 centerVector = new Vector2(-this.center.x, -this.center.y);
        int i2 = 0;
        while (i2 < list.size()) {
            Vertex2D v = (Vertex2D)list.get(i2);
            v.add(centerVector);
            ++i2;
        }
        return list;
    }

    public static void inflate_count_initialize() {
        inflate_count = 0;
        AdjustmentInputStroke.nearest_evaluate_value = Double.MAX_VALUE;
    }

    public void _inflate() {
        Inflate.update_target_length((Model)this);
        Inflate.inflate((Polyhedron)this.polyhedron);
        AdjustmentInputStroke.adjustment_to_input_stroke(this);
        this.setITA();
    }

    public void inflate() {
        teddy.Vertex before_v = this.polyhedron.get_center();
        if (++inflate_count > 30 && !AdjustmentInputStroke.nearest_input_stroke(this) && !this.pieceSmoothed) {
            DrawPanel.getInstance().piecesSmoothing();
            DrawPanel.getInstance().repaint();
            this.pieceSmoothed = true;
            Inflate.update_target_length((Model)this);
        }
        Inflate.inflate((Polyhedron)this.polyhedron);
        teddy.Vertex after_v = this.polyhedron.get_center();
        this.polyhedron.move_all(teddy.Vector3.subtract((teddy.Vector3)before_v, (teddy.Vector3)after_v));
        this.setITA();
    }

    public void set_cloth_color() {
        this.base_color = this.TEXTURE_ENABLED ? CLOTH_COLOR : CLOTH_COLOR_GREEN;
        this.modelAppearance.setDiffuseColor(this.base_color);
        if (this.REVERSE_SIDE_ENABLED) {
            Appearance reverseAppearance = new Appearance();
            this.modelVisual.setBackFacingAppearance(reverseAppearance);
            reverseAppearance.setFillingStyle(FillingStyle.SOLID);
            reverseAppearance.setShadingStyle(ShadingStyle.SMOOTH);
            reverseAppearance.setDiffuseColor(REVERSE_COLOR);
            System.out.println("reverse_side");
        }
    }

    public void loadTexture() {
        FileDialog fileDialog = new FileDialog((Frame)Sweater.jaliceFrame, "Load Texture", 0);
        fileDialog.setDirectory(".\\texture");
        fileDialog.setFile("*.jpg");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            this.setTexture(filename);
        }
        fileDialog.dispose();
    }

    private void setTexture(String filename) {
        this.modelTextureMap.setImage(Sweater.jaliceFrame.getToolkit().getImage(filename));
    }

    public void setTexture(Image image) {
        this.modelTextureMap.setImage(image);
    }

    public void initialize_texture() {
        if (this.TEXTURE_ENABLED) {
            this.modelTextureMap = new TextureMap();
            this.modelTextureMap.setImage(Sweater.jaliceFrame.getToolkit().getImage("texture\\CHECK_big.png"));
            this.modelAppearance.setDiffuseColorMap(this.modelTextureMap);
        }
    }

    public static Image loadImage_awt(String filename) {
        Component panel = Sweater.jaliceFrame.awtComponent;
        Image image = Toolkit.getDefaultToolkit().getImage(filename);
        if (image != null) {
            MediaTracker mt = new MediaTracker(panel);
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return image;
    }

    public void laplacian_cut(SurfacePath path) {
        LaplacianCut.cut((Polyhedron)this.polyhedron, (SurfacePath)path);
        this.setITA();
    }

    public void laplacian_remesh(SurfacePath path) {
        LaplacianRemesh.remesh_no_hole_cut((Polyhedron)this.polyhedron, (SurfacePath)path);
        this.setITA();
    }

    public void remesh_no_loop(SurfacePath path) {
        Remesh.remesh_no_loop((Polyhedron)this.polyhedron, (SurfacePath)path);
    }

    public void divide() {
        Skin.subdivide((Polyhedron)this.polyhedron);
        this.setITA();
    }

    public void drift() {
        Skin.drift((Polyhedron)this.polyhedron);
        this.setITA();
    }

    public void remesh() {
        Skin.refine((Polyhedron)this.polyhedron);
        this.setITA();
    }

    public void cut(List stroke) {
        SurfacePath surfacePath = this.getSurfacePath(stroke, false);
        LaplacianCut.cut((Polyhedron)this.polyhedron, (SurfacePath)surfacePath);
        this.setITA();
    }

    void setDecoration(Point p) {
        teddy.Vertex v = this.pickVertex(p);
        if (Sweater.sweater.isEyeMode()) {
            Eye eye = new Eye(v);
            this.decorations.add(eye);
        } else if (Sweater.sweater.isNoseMode()) {
            Nose nose = new Nose(v);
            this.decorations.add(nose);
        }
        int i = 0;
        while (i < v.child_vertices.size()) {
            teddy.Vertex child_v = (teddy.Vertex)v.child_vertices.get(i);
            Vertex2D patternCoord = child_v.getPatternCoord();
            Piece piece = patternCoord.piece;
            System.out.println("piece in set_pin" + piece);
            List piece_decorations = piece.getDecorations();
            piece_decorations.add(patternCoord);
            ++i;
        }
        DrawPanel.getInstance().repaint();
    }

    public void extrude(SurfacePath path, List stroke) {
        TmpCamera camera = new TmpCamera(this);
        stroke = CleanStroke.clean((List)stroke, (int)30, (int)50, (boolean)false);
        stroke.remove(0);
        stroke.remove(stroke.size() - 1);
        LaplacianExtrusion.extrude((Polyhedron)this.polyhedron, (SurfacePath)path, (List)stroke, (CameraInterface)camera);
    }

    public void remesh(SurfacePath path) {
        LaplacianRemesh.remesh_no_hole_extrusion((Polyhedron)this.polyhedron, (SurfacePath)path);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.modelVehicle != null) {
            this.modelVehicle.setParent(null);
        }
    }

    public void style() {
        if (this.modelAppearance.getShadingStyle() != ShadingStyle.FLAT) {
            this.setStyleWireframe();
        } else {
            this.setStyleSmooth();
        }
    }

    private void setStyleWireframe() {
        this.style = 0;
        this.setFillingStyle(FillingStyle.WIREFRAME);
        this.modelAppearance.setDiffuseColorMap(null);
        this.modelAppearance.setDiffuseColor(edu.cmu.cs.stage3.alice.scenegraph.Color.BLACK);
        this.modelAppearance.setShadingStyle(ShadingStyle.FLAT);
    }

    private void setStyleSmooth() {
        this.style = 1;
        this.setStyle(ShadingStyle.SMOOTH);
        this.setFillingStyle(FillingStyle.SOLID);
        this.modelAppearance.setDiffuseColor(edu.cmu.cs.stage3.alice.scenegraph.Color.WHITE);
        this.modelAppearance.setDiffuseColorMap(this.modelTextureMap);
    }

    private void setStyle(ShadingStyle style) {
        this.modelAppearance.setShadingStyle(style);
    }

    private void setFillingStyle(FillingStyle style) {
        this.modelAppearance.setFillingStyle(style);
    }

    public ShadingStyle getStyle() {
        return this.modelAppearance.getShadingStyle();
    }

    public void addSurfaceLine(List stroke, boolean laser) {
        this.addSurfaceLine_main(stroke, false);
        if (laser) {
            this.addSurfaceLine_main(stroke, true);
        }
    }

    public void addSurfaceLine_main(List stroke, boolean on_back) {
        SurfacePath surfacePath = this.getSurfacePath(stroke, on_back);
        SurfaceLine surfaceLine = new SurfaceLine(this, surfacePath);
        surfaceLine.lineVisual.setParent((Container)this.modelVehicle);
        this.surfaceLines.add(surfaceLine);
    }

    public void addSurfaceLine(SurfacePath surfacePath) {
        SurfaceLine surfaceLine = new SurfaceLine(this, surfacePath);
        surfaceLine.lineVisual.setParent((Container)this.modelVehicle);
        this.surfaceLines.add(surfaceLine);
    }

    public void addSurfaceLine(SurfacePath surfacePath, edu.cmu.cs.stage3.alice.scenegraph.Color color) {
        this.surfaceLine = new SurfaceLine(this, color);
        if (surfacePath == null || surfacePath.size() == 0) {
            return;
        }
        int i = 0;
        while (i < surfacePath.size()) {
            Vector3 normal = this.teddyVector3_to_jaliceVector3(surfacePath.getNormal(i));
            Vector3 pos = this.teddyVertex_to_jaliceVector3(surfacePath.getVertex(i));
            this.surfaceLine.addPoint(pos, normal);
            ++i;
        }
        if (surfacePath.loop) {
            Vector3 normal = this.teddyVector3_to_jaliceVector3(surfacePath.getNormal(0));
            Vector3 pos = this.teddyVertex_to_jaliceVector3(surfacePath.getVertex(0));
            this.surfaceLine.addPoint(pos, normal);
        }
        this.surfaceLine.lineVisual().setParent((Container)this.modelVehicle);
    }

    public void removeSurfaceLine(SurfaceLine surfaceLine) {
        surfaceLine.delete();
        this.surfaceLines.remove(surfaceLine);
    }

    public void removeSurfaceLine() {
        this.surfaceLine.delete();
        this.surfaceLines.remove(this.surfaceLine);
    }

    public SurfacePath getSurfacePathForCut(List stroke, boolean loop) {
        stroke = CleanStroke.clean((List)stroke, (int)30, (int)60, (boolean)loop);
        stroke = Inflation.counter_clockwise((List)stroke);
        TmpCamera camera = new TmpCamera(this);
        return new SurfacePath(this.polyhedron, stroke, (CameraInterface)camera, loop);
    }

    public SurfacePath getSurfacePathForExtrusion(List stroke, boolean loop) {
        if ((stroke = CleanStroke.clean((List)stroke, (int)5, (int)10, (boolean)loop)).size() == 0) {
            return null;
        }
        stroke = Inflation.counter_clockwise((List)stroke);
        TmpCamera camera = new TmpCamera(this);
        return new SurfacePath(this.polyhedron, stroke, (CameraInterface)camera, loop);
    }

    public SurfacePath getSurfacePath(List stroke, boolean loop) {
        stroke = CleanStroke.clean((List)stroke, (int)30, (int)60, (boolean)loop);
        TmpCamera camera = new TmpCamera(this);
        return new SurfacePath(this.polyhedron, stroke, (CameraInterface)camera, loop);
    }

    public SurfacePath getSurfacePathForDrawSeamLine(List stroke, boolean loop) {
        teddy.Vertex startV = this.pickVertex((Point)stroke.get(0));
        teddy.Vertex endV = this.pickVertex((Point)stroke.get(stroke.size() - 1));
        stroke = CleanStroke.clean((List)stroke, (int)10, (int)20, (boolean)loop);
        stroke = Inflation.counter_clockwise((List)stroke);
        TmpCamera camera = new TmpCamera(this);
        return new SurfacePath(this.polyhedron, stroke, (CameraInterface)camera, loop, true, startV, endV);
    }

    public teddy.Vertex pickVertex(Point p) {
        TmpCamera camera = new TmpCamera(this);
        return SurfacePath.pickVertex((Polyhedron)this.polyhedron, (Point)p, (CameraInterface)camera);
    }

    public teddy.Vertex getVertex_onFace(Point p) {
        TmpCamera camera = new TmpCamera(this);
        return SurfacePath.getVertex_onFace((Polyhedron)this.polyhedron, (Point)p, (CameraInterface)camera);
    }

    public Vertex3d teddyVertex_to_jaliceVertex(teddy.Vertex v) {
        Vertex3d vertex = new Vertex3d(19);
        vertex.position.set(v.x, v.y, v.z);
        vertex.normal.set(v.normal.x, v.normal.y, v.normal.z);
        vertex.textureCoordinate0.set((float)v.x, (float)v.y);
        return vertex;
    }

    public Vertex teddyVertex_to_jaliceVertex(teddy.Vertex v, teddy.Vector3 normal) {
        Vertex vertex = new Vertex(19);
        vertex.setXYZ(new Vector3(v.x, v.y, v.z));
        vertex.setIJK(new Vector3(normal.x, normal.y, normal.z));
        vertex.setV(v.v);
        vertex.setU(v.u);
        return vertex;
    }

    public Vector3 teddyVertex_to_jaliceVector3(teddy.Vertex v) {
        return new Vector3(v.x, v.y, v.z);
    }

    public Vector3 teddyVector3_to_jaliceVector3(teddy.Vector3 v) {
        return new Vector3(v.x, v.y, v.z);
    }

    public teddy.Vertex jaliceVector3_to_teddyVertex(Vector3 v) {
        return new teddy.Vertex(v.x, v.y, v.z);
    }

    public teddy.Vertex jaliceVector3_to_teddyVector3(Vector3 v) {
        return new teddy.Vertex(v.x, v.y, v.z);
    }

    public void setITA() {
        this.prepare_patchITA_and_patchVisuals();
        this.setClothITA();
    }

    public void setITA_old(Polyhedron h) {
        Vertex[] vertices = new Vertex[h.vertices.size()];
        int[] indices = new int[h.faces.size() * 3];
        int j = 0;
        while (j < h.vertices.size()) {
            teddy.Vertex v = h.vertices(j);
            vertices[j] = this.teddyVertex_to_jaliceVertex(v, v.get_normal());
            vertices[j].setU(v.u);
            vertices[j].setV(v.v);
            ++j;
        }
        j = 0;
        while (j < h.faces.size()) {
            Face f = (Face)h.faces.get(j);
            indices[j * 3 + 0] = f.get_vertex((int)0).index;
            indices[j * 3 + 1] = f.get_vertex((int)1).index;
            indices[j * 3 + 2] = f.get_vertex((int)2).index;
            ++j;
        }
        this.modelITA.setVertices((Vertex3d[])vertices);
        this.modelITA.setIndices(indices);
        this.setLineArray();
        Sweater.jaliceFrame.repaint();
    }

    public void setClothITA() {
        if (this.patches == null) {
            return;
        }
        int i = 0;
        while (i < this.patches.size()) {
            Polyhedron patch = (Polyhedron)this.patches.get(i);
            Vertex[] vertices = new Vertex[patch.vertices.size()];
            int[] indices = new int[patch.faces.size() * 3];
            int j = 0;
            while (j < patch.vertices.size()) {
                PatchVertex v = (PatchVertex)patch.vertices(j);
                vertices[j] = this.teddyVertex_to_jaliceVertex(v.position, v.position.get_normal());
                vertices[j].setU((v.u + 2.0) / 4.0);
                vertices[j].setV((v.v + 2.0) / 4.0);
                ++j;
            }
            j = 0;
            while (j < patch.faces.size()) {
                Face f = (Face)patch.faces.get(j);
                indices[j * 3 + 0] = f.get_vertex((int)0).index;
                indices[j * 3 + 1] = f.get_vertex((int)1).index;
                indices[j * 3 + 2] = f.get_vertex((int)2).index;
                ++j;
            }
            IndexedTriangleArray patchITA = (IndexedTriangleArray)this.patchITAs.get(i);
            patchITA.setVertices((Vertex3d[])vertices);
            patchITA.setIndices(indices);
            ++i;
        }
        this.setLineArray();
        Sweater.jaliceFrame.repaint();
    }

    private Appearance set_color_from_piece(Piece piece) {
        Appearance pieceAppearance = new Appearance();
        if (piece.color == Color.BLACK) {
            pieceAppearance.setDiffuseColor(BLACK);
            pieceAppearance.setDiffuseColorMap(null);
        } else if (piece.color == Color.WHITE) {
            pieceAppearance.setDiffuseColor(WHITE);
            pieceAppearance.setDiffuseColorMap(null);
        } else {
            pieceAppearance.setDiffuseColor(BODY_COLOR);
            pieceAppearance.setDiffuseColorMap(this.modelTextureMap);
        }
        return pieceAppearance;
    }

    public void init_patches() {
        this.remove_patchITA_and_patchVisuals();
        this.patchITAs = new ArrayList();
        this.patchVisuals = new ArrayList();
        int i = 0;
        while (i < this.patches.size()) {
            Polyhedron patch = (Polyhedron)this.patches.get(i);
            Appearance pieceAppearance = this.set_color_from_piece(patch.piece);
            IndexedTriangleArray patchITA = new IndexedTriangleArray();
            Visual patchVisual = new Visual();
            patchVisual.setParent((Container)this.modelVehicle);
            patchVisual.setGeometry((Geometry)patchITA);
            patchVisual.setFrontFacingAppearance(pieceAppearance);
            this.patchITAs.add(patchITA);
            this.patchVisuals.add(patchVisual);
            ++i;
        }
    }

    void remove_patchITA_and_patchVisuals() {
        while (this.patchITAs.size() > 0) {
            Visual patchVisual = (Visual)this.patchVisuals.get(this.patchVisuals.size() - 1);
            patchVisual.setParent(null);
            this.patchITAs.remove(this.patchITAs.size() - 1);
            this.patchVisuals.remove(this.patchVisuals.size() - 1);
        }
    }

    void prepare_patchITA_and_patchVisuals() {
        while (this.patchITAs.size() < this.patches.size()) {
            IndexedTriangleArray patchITA = new IndexedTriangleArray();
            Visual patchVisual = new Visual();
            patchVisual.setParent((Container)this.modelVehicle);
            patchVisual.setGeometry((Geometry)patchITA);
            patchVisual.setFrontFacingAppearance(this.modelAppearance);
            this.patchITAs.add(patchITA);
            this.patchVisuals.add(patchVisual);
        }
        while (this.patchITAs.size() > this.patches.size()) {
            Visual patchVisual = (Visual)this.patchVisuals.get(this.patchVisuals.size() - 1);
            patchVisual.setParent(null);
            this.patchITAs.remove(this.patchITAs.size() - 1);
            this.patchVisuals.remove(this.patchVisuals.size() - 1);
        }
    }

    public void setLineArray() {
        if (this.lineVisual != null) {
            this.lineVisual.setParent(null);
        }
        this.lineVisual = new Visual();
        this.lineVisual.setParent((Container)this.modelVehicle);
        this.lineAppearance = new Appearance();
        this.lineVisual.setFrontFacingAppearance(this.lineAppearance);
        this.lineAppearance.setDiffuseColor(new edu.cmu.cs.stage3.alice.scenegraph.Color(0.0f, 0.0f, 0.0f));
        this.lineArray = new LineArray();
        this.lineVisual.setGeometry((Geometry)this.lineArray);
        ArrayList lines = new ArrayList();
        this.setLineArray(this.polyhedron, lines);
        Vertex[] vertices = new Vertex[lines.size() * 2];
        int i = 0;
        while (i < lines.size()) {
            Edge edge = (Edge)lines.get(i);
            vertices[i * 2] = new Vertex(19);
            vertices[i * 2 + 1] = new Vertex(19);
            teddy.Vertex v = edge.start;
            vertices[i * 2] = this.teddyVertex_to_jaliceVertex(teddy.Vertex.translate((teddy.Vertex)v, (teddy.Vector3)teddy.Vector3.multiply((teddy.Vector3)v.get_normal(), (double)0.0)), v.get_normal());
            v = edge.end;
            vertices[i * 2 + 1] = this.teddyVertex_to_jaliceVertex(teddy.Vertex.translate((teddy.Vertex)v, (teddy.Vector3)teddy.Vector3.multiply((teddy.Vector3)v.get_normal(), (double)0.0)), v.get_normal());
            ++i;
        }
        this.lineArray.setVertices((Vertex3d[])vertices);
    }

    private void setLineArray(Polyhedron polyhedron, List lines) {
        int i = 0;
        while (i < polyhedron.edges.size()) {
            Edge edge = polyhedron.edges(i);
            if (edge.left_face == null || edge.right_face == null || edge.seam) {
                lines.add(edge);
            }
            ++i;
        }
        i = 0;
        while (i < polyhedron.child_polyhedrons.size()) {
            this.setLineArray((Polyhedron)polyhedron.child_polyhedrons.get(i), lines);
            ++i;
        }
    }

    public static List adjust_stroke_direction(List stroke) {
        double total_area = 0.0;
        Point prev = (Point)stroke.get(stroke.size() - 1);
        int i = 0;
        while (i < stroke.size()) {
            Point next = (Point)stroke.get(i);
            total_area += (double)((prev.y + next.y) * (next.x - prev.x));
            prev = next;
            ++i;
        }
        if (total_area < 0.0) {
            return Util.reverse(stroke);
        }
        return stroke;
    }

    public TmpCamera get_camera() {
        return new TmpCamera(this);
    }

    private static List cloneCurveList(List curveList, Model model, Polyhedron polyhedron) {
        ArrayList<ControlCurve> result = new ArrayList<ControlCurve>(curveList.size());
        Iterator iter = curveList.iterator();
        while (iter.hasNext()) {
            result.add(((ControlCurve)iter.next()).copy(model, polyhedron));
        }
        return result;
    }

    public Model copy() {
        HashMap vertices_old_and_new = new HashMap();
        HashMap edges_old_and_new = new HashMap();
        HashMap faces_old_and_new = new HashMap();
        Model clone = new Model(this.polyhedron.copy(vertices_old_and_new, edges_old_and_new, faces_old_and_new));
        clone.modelVehicle.setTransformation((Matrix4d)this.modelVehicle.getTransformation(null), null);
        clone.curves = Model.cloneCurveList(this.curves, clone, clone.polyhedron);
        clone.patches = new ArrayList(this.patches.size());
        int i = 0;
        while (i < this.patches.size()) {
            Polyhedron patch = (Polyhedron)this.patches.get(i);
            Polyhedron new_patch = patch.copy_for_patch(vertices_old_and_new, edges_old_and_new, faces_old_and_new);
            new_patch.piece = Piece.create_piece_from_polyhedron((Polyhedron)new_patch);
            clone.patches.add(new_patch);
            ++i;
        }
        clone.update();
        clone.getPolyhedron().check_consistent();
        return clone;
    }

    public void updateControlCurves() {
        int i = 0;
        while (i < this.curves.size()) {
            ControlCurve curve = (ControlCurve)this.curves.get(i);
            curve.surfaceLine.delete();
            ++i;
        }
        this.curves = new ArrayList();
        this.updateControlCurves(this.polyhedron);
    }

    private void updateControlCurves(Polyhedron polyhedron) {
        boolean[] visited = new boolean[polyhedron.edges.size()];
        int i = 0;
        while (i < polyhedron.edges.size()) {
            Edge edge = polyhedron.edges(i);
            if (edge.seam && !visited[i]) {
                SurfacePath path = SurfacePath.extend_and_get_surfacePath((Edge)edge, (boolean[])visited);
                this.addControlCurve(path);
            }
            ++i;
        }
        i = 0;
        while (i < polyhedron.child_polyhedrons.size()) {
            this.updateControlCurves((Polyhedron)polyhedron.child_polyhedrons.get(i));
            ++i;
        }
    }

    void addControlCurve(SurfacePath surfacePath) {
        this.curves.add(new ControlCurve(this, surfacePath));
    }

    public boolean isInsideModel(teddy.Vertex vertex) {
        int i = 0;
        while (i < this.polyhedron.faces.size()) {
            Face face = this.polyhedron.faces(i);
            boolean isInside = face.inSide(vertex);
            if (!isInside) {
                return false;
            }
            ++i;
        }
        return true;
    }

    List make_vertex_pairs(List base_vertices) {
        ArrayList<teddy.Vertex> new_base_vertices = new ArrayList<teddy.Vertex>();
        int i = 0;
        while (i < base_vertices.size()) {
            teddy.Vertex base_vertex = (teddy.Vertex)base_vertices.get(i);
            teddy.Vertex new_base_vertex = base_vertex.copy();
            new_base_vertices.add(new_base_vertex);
            VertexPair vertexPair = new VertexPair(base_vertex, new_base_vertex);
            this.vertex_pairs.add(vertexPair);
            ++i;
        }
        return new_base_vertices;
    }

    void make_edge_pairs(List base_edges) {
        int i = 0;
        while (i < base_edges.size()) {
            Edge edge = (Edge)base_edges.get(i);
            teddy.Vertex opposite_start = this.get_opposite_vertex_from_vertex_pairs(edge.start);
            teddy.Vertex opposite_end = this.get_opposite_vertex_from_vertex_pairs(edge.end);
            Edge opposite_edge = opposite_start.get_common_edge(opposite_end);
            this.edge_pairs.add(new EdgePair(edge, opposite_edge));
            ++i;
        }
    }

    teddy.Vertex get_opposite_vertex_from_vertex_pairs(teddy.Vertex v) {
        int i = 0;
        while (i < this.vertex_pairs.size()) {
            VertexPair vertexPair = (VertexPair)this.vertex_pairs.get(i);
            if (vertexPair.child == v) {
                return vertexPair.parent;
            }
            if (vertexPair.parent == v) {
                return vertexPair.child;
            }
            ++i;
        }
        return null;
    }

    public Polyhedron getPolyhedron() {
        return this.polyhedron;
    }

    public List getStuffs() {
        return this.stuffs;
    }

    public void setStuffs(List _stuffs) {
        this.stuffs = _stuffs;
    }

    public void setSurfacePath(SurfacePath _surfacePath) {
        this.surfacePath = _surfacePath;
    }

    public SurfacePath getSurfacePath() {
        return this.surfacePath;
    }

    public void setSurfaceLine(SurfaceLine _surfaceLine) {
        this.surfaceLine = _surfaceLine;
    }

    public SurfaceLine getSurfaceLine() {
        return this.surfaceLine;
    }

    public void setSurfaceLines(List _surfaceLines) {
        this.surfaceLines = _surfaceLines;
    }

    public List getSurfaceLines() {
        return this.surfaceLines;
    }

    public Transformable getModelVehicle() {
        return this.modelVehicle;
    }

    public void setModelVehicle(Transformable _modelVehicle) {
        this.modelVehicle = _modelVehicle;
    }

    public void setTextureEnabled(boolean _textureEnabled) {
        this.TEXTURE_ENABLED = _textureEnabled;
    }

    public boolean isTextureEnabled() {
        return this.TEXTURE_ENABLED;
    }

    public void setReverseSideEnabled(boolean _reverseSideEnabled) {
        this.REVERSE_SIDE_ENABLED = _reverseSideEnabled;
    }

    public boolean isReverseSideEnabled() {
        return this.REVERSE_SIDE_ENABLED;
    }

    public List getPatches() {
        return this.patches;
    }

    public void setPatches(List _patches) {
        this.patches = _patches;
    }

    public List getDecorations() {
        return this.decorations;
    }

    public void setDecorations(List _decorations) {
        this.decorations = _decorations;
    }
}

