/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.AmbientLight;
import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.DirectionalLight;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RendererInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.directx7renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetListener;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.vecmath.Vector3d;
import sweater.Buttons;
import sweater.Cursors;
import sweater.MyMenuBar;
import sweater.Sweater;
import sweater.VisualPickInfo;

public class JaliceFrame
extends Frame
implements WindowListener,
RenderTargetListener,
ComponentListener {
    public static final Color BACKGROUND_COLOR = new Color(1.0f, 1.0f, 1.0f);
    public static final Color SUN_COLOR = new Color(1.0, 1.0, 1.0);
    public static final Color AMBIENT_COLOR = new Color(0.5, 0.5, 0.5);
    public RendererInfo rendererInfo;
    public OnscreenRenderTarget renderTarget;
    public MouseListener mouseListener;
    public MouseMotionListener mouseMotionListener;
    public Sweater target;
    public Scene scene;
    public Transformable cameraVehicle;
    public Visual groundVisual;
    public Color pickedColor = null;
    public Visual pickedVisual = null;
    public double prevTime = System.currentTimeMillis();
    public double scale = 1.0;
    public Camera camera;
    edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer renderer;
    public Component awtComponent;
    public RenderTarget m_offscreenRenderTarget;
    public RenderTarget m_offscreenRenderTarget_small;

    public JaliceFrame(RendererInfo rendererInfo, Sweater target) {
        this.rendererInfo = rendererInfo;
        this.target = target;
        Sweater.jaliceFrame = this;
        this.setTitle("Plushie");
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(512, 720));
    }

    public void loadITA(IndexedTriangleArray ita, String dirname) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(dirname) + "/vertices.bin");
            IndexedTriangleArray.loadVertices((InputStream)is);
            ((InputStream)is).close();
            is = new FileInputStream(String.valueOf(dirname) + "/indices.bin");
            IndexedTriangleArray.loadIndices((InputStream)is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public Camera initSceneGraph() {
        this.scene = new Scene();
        this.cameraVehicle = new Transformable();
        this.cameraVehicle.setParent((Container)this.scene);
        OrthographicCamera camera = new OrthographicCamera();
        double l = 1.5;
        camera.setParent((Container)this.cameraVehicle);
        Background background = new Background();
        background.setColor(BACKGROUND_COLOR);
        this.scene.setBackground(background);
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setParent((Container)this.scene);
        ambientLight.setColor(AMBIENT_COLOR);
        Transformable sunVehicle = new Transformable();
        sunVehicle.setParent((Container)this.scene);
        DirectionalLight sunLight = new DirectionalLight();
        sunLight.setColor(SUN_COLOR);
        sunLight.setParent((Container)sunVehicle);
        sunVehicle.setOrientation((Vector3d)new Vector3(-1.0, -1.0, 0.8), (Vector3d)Vector3.Y_AXIS, null);
        this.cameraVehicle.setPosition((Vector3d)new Vector3(0.0, 0.0, -4.0), null);
        this.cameraVehicle.pointAt((ReferenceFrame)this.scene, (Vector3d)new Vector3(0.0, 0.0, 0.0), (Vector3d)Vector3.Y_AXIS, (ReferenceFrame)this.scene);
        return camera;
    }

    public void update_camera() {
        if (this.camera instanceof OrthographicCamera) {
            ((OrthographicCamera)this.camera).setPlane(Double.NaN, -this.scale, Double.NaN, this.scale);
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.update_camera();
    }

    public void lock() {
        if (this.renderTarget != null) {
            this.renderTarget.setUpdateIsAutomatic(false);
        }
    }

    public void unlock() {
        if (this.renderTarget != null) {
            this.renderTarget.setUpdateIsAutomatic(true);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.camera = this.initSceneGraph();
        this.initRenderer(this.camera);
        Cursors.init_cursors();
        this.target.initialize();
    }

    public Vector3 getCameraPosition(ReferenceFrame reference) {
        return this.cameraVehicle.getPosition(reference);
    }

    public Vector3 getCameraDirection(ReferenceFrame reference) {
        Matrix33 axes = this.cameraVehicle.getAxes(reference);
        return axes.getRow(2);
    }

    public void simulate(double currTime) {
        double dt = currTime - this.prevTime;
        if (dt > 0.0 && this.pickedVisual != null && this.pickedVisual != this.groundVisual) {
            Transformable trans = (Transformable)this.pickedVisual.getParent();
            trans.rotate((Vector3d)Vector3.Z_AXIS, dt, null);
        }
        this.prevTime = currTime;
    }

    public void cleared(RenderTargetEvent renderEvent) {
    }

    public void rendered(RenderTargetEvent renderEvent) {
        RenderTarget renderTarget = (RenderTarget)renderEvent.getSource();
        this.paint(renderTarget.getOffscreenGraphics());
    }

    public void swapped(RenderTargetEvent renderEvent) {
    }

    public void paint(Graphics g) {
        this.target.paintOverlay(g);
        g.dispose();
    }

    public void paintOverlay() {
        this.target.paintOverlay(this.renderTarget.getAWTComponent().getGraphics());
    }

    public void repaint() {
        if (this.renderTarget != null) {
            this.renderTarget.markDirty();
        }
    }

    public void initRenderer(Camera camera) {
        Class cls = this.rendererInfo.getRendererClass();
        this.renderer = null;
        try {
            this.renderer = (edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer)cls.newInstance();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        if (this.renderer != null) {
            this.renderTarget = this.renderer.createHeavyweightOnscreenRenderTarget();
            if (this.renderer instanceof Renderer) {
                this.renderTarget.setDisplayDevice(this.renderer.getDisplayDrivers()[0].getFirstDevice(false));
            }
            this.awtComponent = this.renderTarget.getAWTComponent();
            this.add("Center", this.awtComponent);
            this.awtComponent.addMouseListener(this.target);
            this.awtComponent.addMouseMotionListener(this.target);
            Buttons buttons = new Buttons(this.target);
            this.add("South", buttons);
            this.setMenuBar(new MyMenuBar(this.target));
            this.invalidate();
            this.doLayout();
            this.awtComponent.doLayout();
            buttons.doLayout();
            this.update_camera();
            this.renderTarget.addCamera(camera);
            this.renderTarget.addRenderTargetListener((RenderTargetListener)this);
            this.addKeyListener(this.target);
        }
    }

    public Image getOffscreenImage() {
        OffscreenRenderTarget offscreenRenderTarget = this.renderer.createOffscreenRenderTarget();
        offscreenRenderTarget.addCamera(this.camera);
        offscreenRenderTarget.setSize(this.getWidth(), this.getHeight());
        offscreenRenderTarget.clearAndRenderOffscreen();
        Image offscreenImage = offscreenRenderTarget.getOffscreenImage();
        return offscreenImage;
    }

    public IndexedTriangleArray loadIndexedTriangleArray(String dirname) {
        IndexedTriangleArray ita = new IndexedTriangleArray();
        try {
            FileInputStream is = new FileInputStream(new File(String.valueOf(dirname) + "/vertices.bin"));
            IndexedTriangleArray.loadVertices((InputStream)is);
            ((InputStream)is).close();
            is = new FileInputStream(new File(String.valueOf(dirname) + "/indices.bin"));
            IndexedTriangleArray.loadIndices((InputStream)is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ita;
    }

    public TextureMap loadTextureMap(String dirname) {
        Toolkit toolkit = this.getToolkit();
        Image image = toolkit.getImage("samples/media/ground/texture.jpg");
        while (image.getWidth(this) == -1 && image.getWidth(this) == -1) {
            Thread.yield();
        }
        TextureMap textureMap = new TextureMap();
        textureMap.setImage(image);
        return textureMap;
    }

    public VisualPickInfo visualPick(Visual visual, int x, int y) {
        PickInfo pickInfo = this.renderTarget.pick(x, y, true, true);
        Visual[] visuals = pickInfo.getVisuals();
        if (visuals != null && visuals.length > 0) {
            int n = 0;
            while (visuals[n] != visual) {
                ++n;
            }
            int[] faces = pickInfo.getSubElements();
            Vector3d localPt = pickInfo.getLocalPosition(n);
            Vector3 _localPt = new Vector3(localPt.x, localPt.y, localPt.z);
            return new VisualPickInfo(visual, _localPt, faces[n]);
        }
        return null;
    }

    public Vector3 local_coords_to_screen_coords(Vector3 localPt, ReferenceFrame targetVehicle) {
        Vector3 cameraPt = targetVehicle.transformTo((Vector3d)localPt, (ReferenceFrame)this.cameraVehicle);
        Vector3d v = this.renderTarget.transformFromCameraToViewport((Vector3d)cameraPt, this.camera);
        return new Vector3(v.x, v.y, v.z);
    }

    public Vector3 scene_coords_to_screen_coords(Vector3 localPt) {
        return this.local_coords_to_screen_coords(localPt, (ReferenceFrame)this.scene);
    }

    public Vector3 screen_coords_to_scene_coords(Point p) {
        return this.screen_coords_to_local_coords(p.x, p.y, (ReferenceFrame)this.scene);
    }

    public Vector3 screen_coords_to_local_coords(Point p, ReferenceFrame reference) {
        return this.screen_coords_to_local_coords(p.x, p.y, reference);
    }

    public Vector3 screen_coords_to_local_coords(double x, double y, ReferenceFrame reference) {
        if (reference == null) {
            reference = this.scene;
        }
        Vector3 viewportPt = new Vector3(x, y, 0.97);
        Vector3d cameraPt = this.renderTarget.transformFromViewportToCamera((Vector3d)viewportPt, this.camera);
        return this.cameraVehicle.transformTo(cameraPt, reference);
    }

    public Vector3 change_coords(Vector3 v, ReferenceFrame current, ReferenceFrame target) {
        Transformable dammy = new Transformable();
        dammy.setParent((Container)this.scene);
        dammy.setPosition((Vector3d)v, current);
        Vector3 w = dammy.getPosition(target);
        dammy.setParent(null);
        return w;
    }

    public void print(Graphics g) {
        this.renderTarget.setUpdateIsAutomatic(false);
        OffscreenRenderTarget offscreenRenderTarget = this.renderer.createOffscreenRenderTarget();
        offscreenRenderTarget.addCamera(this.camera);
        offscreenRenderTarget.setSize(this.getWidth(), this.getHeight());
        System.out.println("this.getWidth " + this.getWidth() + "this.getHeight " + this.getHeight());
        offscreenRenderTarget.clearAndRenderOffscreen();
        Image offscreenImage = offscreenRenderTarget.getOffscreenImage();
        g.drawImage(offscreenImage, 0, 0, null);
        this.target.paintOverlay(g);
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g2 = bufferedImage.getGraphics();
        g2.drawImage(offscreenImage, 0, 0, null);
        g2.dispose();
        File file = new File("hello.png");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
        offscreenRenderTarget.release();
        this.renderTarget.setUpdateIsAutomatic(true);
    }

    public void paintSuggestionBox(Graphics g) {
        if (this.renderTarget == null) {
            return;
        }
        this.renderTarget.setUpdateIsAutomatic(false);
        OffscreenRenderTarget offscreenRenderTarget = this.renderer.createOffscreenRenderTarget();
        offscreenRenderTarget.addCamera(this.camera);
        offscreenRenderTarget.setSize(this.getWidth() / 10, this.getHeight() / 10);
        offscreenRenderTarget.clearAndRenderOffscreen();
        Image offscreenImage = offscreenRenderTarget.getOffscreenImage();
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = 0;
        y[0] = 0;
        x[1] = 100;
        y[1] = 0;
        x[2] = 100;
        y[2] = 100;
        x[3] = 0;
        y[3] = 100;
        g.fillPolygon(x, y, 4);
        TextureMap modelTextureMap = new TextureMap();
        modelTextureMap.setImage(Sweater.jaliceFrame.getToolkit().getImage("texture\\pup1.PNG"));
        offscreenRenderTarget.copyOffscreenImageToTextureMap(modelTextureMap);
        this.target.paintOverlay(g);
        offscreenRenderTarget.release();
        this.renderTarget.setUpdateIsAutomatic(true);
    }
}

