/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import java.util.ArrayList;
import java.util.List;
import pattern.DrawPanel;
import pattern.Piece;
import sweater.Debug;
import sweater.Model;
import sweater.PatchGenerater;
import sweater.TmpCamera;
import sweater.Util;
import teddy.AdjustPatchScale;
import teddy.Edge;
import teddy.PatchVertex;
import teddy.Polyhedron;
import teddy.Vertex;

public class Flattening {
    public static void flatteningForGenerate(Model model) {
        if (model == null) {
            return;
        }
        DrawPanel.connectores = new ArrayList();
        DrawPanel.pieces = new ArrayList();
        PatchGenerater.segmentation(model);
        int i = 0;
        while (i < model.patches.size()) {
            Piece piece;
            Polyhedron patch = (Polyhedron)model.patches.get(i);
            TmpCamera camera = new TmpCamera(model);
            patch.apply_texture_coord(camera);
            AdjustPatchScale.adjust((Polyhedron)patch);
            patch.piece = piece = Piece.create_piece_from_polyhedron((Polyhedron)patch);
            piece.update_network();
            DrawPanel.pieces.add(piece);
            ++i;
        }
        DrawPanel panel = DrawPanel.getInstance();
        if (panel.isMergeSeamsMode()) {
            panel.mergeSeams();
        }
        DrawPanel.connectores = DrawPanel.sort_connectores();
        DrawPanel.setSewNumbers();
        if (panel.isLayoutMode()) {
            panel.layout();
        }
        panel.repaint();
    }

    public static void flattening_update(Model model) {
        if (model == null) {
            return;
        }
        DrawPanel.connectores = new ArrayList();
        try {
            PatchGenerater.update_patches(model);
        }
        catch (Exception e) {
            System.err.println("PatchGenerater.update_patches");
            return;
        }
        DrawPanel.pieces = new ArrayList();
        List patches = model.getPatches();
        System.out.println("patches" + patches.size());
        int i = 0;
        while (i < patches.size()) {
            Piece piece;
            Polyhedron patch = (Polyhedron)patches.get(i);
            Flattening.split_mesh_at_internal_seams(patch);
            if (patch.piece == null) {
                TmpCamera camera = new TmpCamera(model);
                Vertex v = (Vertex)patch.vertices.get(patch.vertices.size() / 2);
                boolean front_facing = camera.front_facing(v, v.normal);
                patch.apply_texture_coord(camera, front_facing);
                AdjustPatchScale.adjust((Polyhedron)patch);
            }
            if ((piece = Piece.create_piece_from_polyhedron((Polyhedron)patch)) != null) {
                patch.piece = piece;
                piece.update_network();
                DrawPanel.pieces.add(piece);
            } else {
                System.err.println("piece == null in flattening_update");
            }
            ++i;
        }
        DrawPanel panel = DrawPanel.getInstance();
        if (panel.isMergeSeamsMode()) {
            panel.mergeSeams();
        }
        DrawPanel.connectores = DrawPanel.sort_connectores();
        DrawPanel.setSewNumbers();
        if (panel.isLayoutMode()) {
            panel.layout();
        }
        panel.repaint();
    }

    static void split_mesh_at_internal_seams(Polyhedron mesh) {
        ArrayList<Edge> edges_to_split = new ArrayList<Edge>();
        int i = 0;
        while (i < mesh.edges.size()) {
            Edge edge = (Edge)mesh.edges.get(i);
            if (edge.parent_edge.seam && edge.left_face != null && edge.right_face != null) {
                edges_to_split.add(edge);
            }
            ++i;
        }
        ArrayList<Vertex> vertices_to_split = new ArrayList<Vertex>();
        int i2 = 0;
        while (i2 < edges_to_split.size()) {
            Edge edge = (Edge)edges_to_split.get(i2);
            vertices_to_split.add(edge.start);
            vertices_to_split.add(edge.end);
            Edge left_edge = new Edge(edge.start, edge.end);
            Edge right_edge = new Edge(edge.start, edge.end);
            edge.left_face.replace_edge(edge, left_edge);
            edge.right_face.replace_edge(edge, right_edge);
            left_edge.left_face = edge.left_face;
            right_edge.right_face = edge.right_face;
            mesh.remove(edge);
            mesh.add(left_edge);
            mesh.add(right_edge);
            left_edge.parent_edge = edge.parent_edge;
            right_edge.parent_edge = edge.parent_edge;
            edge.parent_edge.child_edges.remove(edge);
            edge.parent_edge.child_edges.add(left_edge);
            edge.parent_edge.child_edges.add(right_edge);
            ++i2;
        }
        i2 = 0;
        while (i2 < vertices_to_split.size()) {
            PatchVertex v = (PatchVertex)vertices_to_split.get(i2);
            if (!v.disposed) {
                List edges = Util.duplicate(v.edges);
                while (edges.size() > 0) {
                    ArrayList team_edges = Flattening.collect_team_edges((Vertex)v, (Edge)edges.get(0), edges);
                    PatchVertex new_v = new PatchVertex((Vertex)v, v.patch);
                    new_v.position = v.position;
                    new_v.u = v.u;
                    new_v.v = v.v;
                    int j = 0;
                    while (j < team_edges.size()) {
                        Edge edge = (Edge)team_edges.get(j);
                        if (edge.start == v) {
                            edge.start = new_v;
                        } else if (edge.end == v) {
                            edge.end = new_v;
                        }
                        ++j;
                    }
                    new_v.edges = team_edges;
                    mesh.add((Vertex)new_v);
                }
                mesh.remove((Vertex)v);
            }
            ++i2;
        }
        mesh.set_parameters();
    }

    static ArrayList collect_team_edges(Vertex v, Edge edge, List edges) {
        Edge next_edge;
        ArrayList<Edge> collected_edges = new ArrayList<Edge>();
        collected_edges.add(edge);
        edges.remove(edge);
        if (edge.left_face != null && edges.contains(next_edge = edge.left_face.get_opposite_edge(edge.get_opposite_vertex(v)))) {
            collected_edges.addAll(Flattening.collect_team_edges(v, next_edge, edges));
        }
        if (edge.right_face != null && edges.contains(next_edge = edge.right_face.get_opposite_edge(edge.get_opposite_vertex(v)))) {
            collected_edges.addAll(Flattening.collect_team_edges(v, next_edge, edges));
        }
        return collected_edges;
    }

    public static void flattening_update_for_adjustmentInputStroke(Model model) {
        if (model == null) {
            return;
        }
        DrawPanel.connectores = new ArrayList();
        PatchGenerater.update_patches(model);
        DrawPanel.pieces = new ArrayList();
        int i = 0;
        while (i < model.patches.size()) {
            Polyhedron patch = (Polyhedron)model.patches.get(i);
            Piece piece = Piece.create_piece_from_polyhedron((Polyhedron)patch);
            piece.beautify();
            if (piece != null) {
                patch.piece = piece;
                piece.update_network();
                DrawPanel.pieces.add(piece);
            }
            ++i;
        }
        DrawPanel panel = DrawPanel.getInstance();
        if (panel.isMergeSeamsMode()) {
            panel.mergeSeams();
        }
        DrawPanel.connectores = DrawPanel.sort_connectores();
        DrawPanel.setSewNumbers();
        if (panel.isLayoutMode()) {
            panel.layout();
        }
        panel.repaint();
    }

    public static void flattening_update_for_cut(Model model) {
        if (model == null) {
            return;
        }
        DrawPanel.connectores = new ArrayList();
        PatchGenerater.update_patches(model);
        DrawPanel.pieces = new ArrayList();
        int i = 0;
        while (i < model.patches.size()) {
            Piece piece;
            Polyhedron patch = (Polyhedron)model.patches.get(i);
            if (patch.piece == null) {
                int j = 0;
                while (j < patch.vertices.size()) {
                    Vertex v = patch.vertices(j);
                    Debug.vertices_max.add(v);
                    ++j;
                }
                PatchGenerater.apply(patch);
                Flattening.setPatternCoord_fromUV(patch);
                AdjustPatchScale.adjust((Polyhedron)patch);
            }
            if ((piece = Piece.create_piece_from_polyhedron((Polyhedron)patch)) != null) {
                patch.piece = piece;
                piece.update_network();
                DrawPanel.pieces.add(piece);
            }
            ++i;
        }
        DrawPanel panel = DrawPanel.getInstance();
        if (panel.isMergeSeamsMode()) {
            panel.mergeSeams();
        }
        DrawPanel.connectores = DrawPanel.sort_connectores();
        DrawPanel.setSewNumbers();
        if (panel.isLayoutMode()) {
            panel.layout();
        }
        panel.repaint();
    }

    public static void flattening_update_usingABF(Model model) {
        if (model == null) {
            return;
        }
        DrawPanel.connectores = new ArrayList();
        PatchGenerater.update_patches(model);
        DrawPanel.pieces = new ArrayList();
        int i = 0;
        while (i < model.patches.size()) {
            Piece piece;
            Polyhedron patch = (Polyhedron)model.patches.get(i);
            if (patch.piece == null) {
                PatchGenerater.apply(patch);
                Flattening.setPatternCoord_fromUV(patch);
                AdjustPatchScale.adjust((Polyhedron)patch);
            }
            if ((piece = Piece.create_piece_from_polyhedron((Polyhedron)patch)) != null) {
                patch.piece = piece;
                piece.update_network();
                DrawPanel.pieces.add(piece);
            }
            ++i;
        }
        DrawPanel panel = DrawPanel.getInstance();
        if (panel.isMergeSeamsMode()) {
            panel.mergeSeams();
        }
        DrawPanel.connectores = DrawPanel.sort_connectores();
        DrawPanel.setSewNumbers();
        if (panel.isLayoutMode()) {
            panel.layout();
        }
        panel.repaint();
    }

    public static void ABF(Model model, boolean flag) {
        if (model == null) {
            return;
        }
        Polyhedron h = model.polyhedron;
        if (h == null) {
            return;
        }
        PatchGenerater.segmentation(model);
        DrawPanel.pieces = new ArrayList();
        if (model.patches == null) {
            return;
        }
        int i = 0;
        while (i < model.patches.size()) {
            Polyhedron polyhedron = (Polyhedron)model.patches.get(i);
            PatchGenerater.apply(polyhedron);
            Flattening.setPatternCoord_fromUV(polyhedron);
            if (flag) {
                Piece piece;
                AdjustPatchScale.adjust((Polyhedron)polyhedron);
                polyhedron.piece = piece = Piece.create_piece_from_polyhedron((Polyhedron)polyhedron);
                piece.update_network();
                DrawPanel.pieces.add(piece);
            } else {
                Piece piece;
                List points = PatchGenerater.trace_boundary2D(polyhedron);
                polyhedron.piece = piece = Piece.create_piece_from_points((List)points);
                piece.update_network();
                DrawPanel.pieces.add(piece);
            }
            ++i;
        }
        DrawPanel panel = DrawPanel.getInstance();
        if (flag && panel.isMergeSeamsMode()) {
            panel.mergeSeams();
        }
        DrawPanel.connectores = DrawPanel.sort_connectores();
        DrawPanel.setSewNumbers();
        if (panel.isLayoutMode()) {
            panel.layout();
        }
        panel.repaint();
    }

    private static void setPatternCoord_fromUV(Polyhedron polyhedron) {
        int i = 0;
        while (i < polyhedron.vertices.size()) {
            Vertex v = polyhedron.vertices(i);
            v.setTextureCoord(v.u, v.v);
            v.setPatternCoord(v.u, v.v);
            ++i;
        }
    }
}

