/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import sweater.AddingParts;
import sweater.Flattening;
import sweater.Model;
import sweater.Suggestion;
import sweater.Sweater;
import teddy.CleanStroke;
import teddy.Inflate;
import teddy.SurfacePath;
import teddy.Vector2;
import teddy.Vertex;

public class ExtrusionOneStroke {
    List suggestionModels = new ArrayList();
    public static int base_shape;
    public static final int LINE = 0;
    public static final int CIRCLE = 1;

    static void extrude_one_stroke_base_curve_line(Model model, List stroke) {
        List base_stroke = ExtrusionOneStroke.create_base_line(stroke);
        if (base_stroke != null || base_stroke.size() > 0) {
            SurfacePath surfacePath = model.getSurfacePathForExtrusion(base_stroke, false);
            if (surfacePath == null) {
                return;
            }
            surfacePath.loop = false;
            model.setSurfacePath(surfacePath);
            model.addSurfaceLine(surfacePath, Color.RED);
            model.remesh_no_loop(model.getSurfacePath());
            stroke = CleanStroke.clean((List)stroke, (int)30, (int)50, (boolean)false);
            List base_vertices = ExtrusionOneStroke.get_base_vertices_from_surfacePath(surfacePath);
            AddingParts.addingParts(model, base_vertices, stroke);
            model.update();
            model.removeSurfaceLine();
            Flattening.flattening_update(model);
            Inflate.update_target_length((Model)model);
        }
    }

    static void extrude_one_stroke_base_curve_ellipse(Model model, List stroke) {
        List base_stroke = ExtrusionOneStroke.create_base_stroke(stroke, 10.0);
        if (base_stroke != null || base_stroke.size() > 0) {
            SurfacePath surfacePath = model.getSurfacePathForExtrusion(base_stroke, true);
            if (surfacePath == null) {
                return;
            }
            surfacePath.loop = true;
            model.setSurfacePath(surfacePath);
            model.addSurfaceLine(surfacePath, Color.RED);
            model.extrude(model.getSurfacePath(), stroke);
            model.update();
            model.removeSurfaceLine();
            Flattening.flattening_update(model);
            Inflate.update_target_length((Model)model);
        }
    }

    static void extrude_one_stroke(Model model, List stroke) {
        Sweater.sweater.getPickedModel().hide();
        ExtrusionOneStroke.make_suggestions(model, stroke);
        Sweater.sweater.setOngoingOperation(Sweater.sweater.NONE);
        Sweater.sweater.operation_status = Sweater.sweater.NONE;
        model.show();
        Flattening.flattening_update(model);
        Inflate.update_target_length((Model)model);
    }

    static void make_suggestions(Model model, List stroke) {
        Model model0 = model.copy();
        model0.show();
        ExtrusionOneStroke.extrude_one_stroke_base_curve_line(model0, stroke);
        model0.hide();
        Model model1 = model.copy();
        model1.show();
        ExtrusionOneStroke.extrude_one_stroke_base_curve_ellipse(model1, stroke);
        model1.hide();
        int i = 0;
        while (i < 10) {
            model0.inflate();
            model1.inflate();
            ++i;
        }
        Suggestion s0 = new Suggestion(model0);
        Suggestion s1 = new Suggestion(model1);
        s0.add_thumbnail_to_scenegraph();
        s1.add_thumbnail_to_scenegraph();
    }

    private static List create_base_stroke(List stroke, double size) {
        Point point;
        double length;
        ArrayList<Point> base_stroke = new ArrayList<Point>();
        Point start_point = (Point)stroke.get(0);
        Point end_point = (Point)stroke.get(stroke.size() - 1);
        Vector2 vec = new Vector2((double)(end_point.x - start_point.x), (double)(end_point.y - start_point.y));
        double max_length = vec.length();
        vec.normalize();
        Vector2 normal_vec = Vector2.rotate90((Vector2)vec);
        normal_vec.multiply(size);
        base_stroke.add(start_point);
        Point p = new Point((int)((double)start_point.x + normal_vec.x), (int)((double)start_point.y + normal_vec.y));
        for (length = 10.0; !(length >= max_length); length += 10.0) {
            point = new Point((int)((double)p.x + length * vec.x), (int)((double)p.y + length * vec.y));
            base_stroke.add(point);
        }
        base_stroke.add(end_point);
        p = new Point((int)((double)end_point.x - normal_vec.x), (int)((double)end_point.y - normal_vec.y));
        base_stroke.add(p);
        for (length = 10.0; !(length >= max_length); length += 10.0) {
            point = new Point((int)((double)p.x - length * vec.x), (int)((double)p.y - length * vec.y));
            base_stroke.add(point);
        }
        return base_stroke;
    }

    private static List create_base_line(List stroke) {
        ArrayList<Point> base_stroke = new ArrayList<Point>();
        Point start_point = (Point)stroke.get(0);
        Point end_point = (Point)stroke.get(stroke.size() - 1);
        Vector2 vec = new Vector2((double)(end_point.x - start_point.x), (double)(end_point.y - start_point.y));
        double max_length = vec.length();
        vec.normalize();
        base_stroke.add(start_point);
        Point p = new Point(start_point.x, start_point.y);
        for (double length = 10.0; !(length >= max_length); length += 10.0) {
            Point point = new Point((int)((double)p.x + length * vec.x), (int)((double)p.y + length * vec.y));
            base_stroke.add(point);
        }
        base_stroke.add(end_point);
        return base_stroke;
    }

    private static List get_base_vertices_from_surfacePath(SurfacePath path) {
        ArrayList<Vertex> base_vertices = new ArrayList<Vertex>();
        int i = 0;
        while (i < path.size()) {
            base_vertices.add(path.getVertex(i));
            ++i;
        }
        return base_vertices;
    }
}

