/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3d;
import sweater.Model;
import sweater.Plane;
import sweater.SurfaceLine;
import sweater.Sweater;
import teddy.CleanStroke;
import teddy.Vertex2D;

public class Extrusion {
    public static Model extrude(Model model, List stroke) {
        Vector3 y_axis;
        Vector3 z_axis;
        SurfaceLine surfaceLine = model.getSurfaceLine();
        Vector3 base_center = surfaceLine.getCenter();
        Vector3 base_normal = surfaceLine.getNormal();
        Vector3 local_camera = Sweater.jaliceFrame.cameraVehicle.getPosition((ReferenceFrame)model.modelVehicle);
        Vector3 camera_to_center = Vector3.subtract((Vector3d)base_center, (Vector3d)local_camera);
        camera_to_center.normalize();
        Vector3 cross = Vector3.crossProduct((Vector3d)camera_to_center, (Vector3d)base_normal);
        Vector3 plane_normal = Vector3.crossProduct((Vector3d)cross, (Vector3d)base_normal);
        plane_normal.normalize();
        if (Vector3.dotProduct((Vector3d)camera_to_center, (Vector3d)base_normal) > -0.7) {
            z_axis = plane_normal;
            y_axis = base_normal;
        } else {
            z_axis = base_normal;
            y_axis = Vector3.multiply((Vector3d)plane_normal, (double)-1.0);
        }
        Plane plane = new Plane(base_center, z_axis, y_axis, (ReferenceFrame)model.modelVehicle);
        stroke = CleanStroke.clean((List)stroke, (int)20, (int)100);
        ArrayList projected_vertices = new ArrayList();
        ArrayList<Vertex2D> list = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < stroke.size()) {
            Point p = ((Vertex2D)stroke.get(i)).point();
            Vector3 pos = plane.project_coords(p);
            if (pos != null) {
                list.add(new Vertex2D(pos.x, pos.y));
            }
            ++i;
        }
        double max_height = 0.0;
        max_height = Sweater.inflation_mode == 0 ? 1.0 : 0.1;
        Model newModel = new Model();
        newModel.modelVehicle.setPosition((Vector3d)base_center, (ReferenceFrame)model.modelVehicle);
        newModel.modelVehicle.setOrientation((Vector3d)z_axis, (Vector3d)y_axis, (ReferenceFrame)model.modelVehicle);
        newModel.stroke = list;
        return newModel;
    }
}

