/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import sweater.Eye;
import sweater.Model;
import sweater.Nose;
import sweater.Pin;
import sweater.SnapTarget;
import sweater.Sweater;

public class Decorations
extends Pin {
    static void paint(Graphics g) {
        Model pickedModel = Sweater.sweater.getPickedModel();
        if (pickedModel == null) {
            return;
        }
        List decorations = pickedModel.getDecorations();
        int i = 0;
        while (i < decorations.size()) {
            Object object = decorations.get(i);
            if (object instanceof Eye) {
                Decorations.paintEye(g, pickedModel, (Eye)object);
            } else if (object instanceof Nose) {
                Decorations.paintNose(g, pickedModel, (Nose)object);
            }
            ++i;
        }
    }

    static void paintEye(Graphics g, Model model, Eye eye) {
        if (!SnapTarget.front_facing(eye.vertex)) {
            return;
        }
        Vector3 p = model.teddyVertex_to_jaliceVector3(eye.vertex);
        Vector3 q = Sweater.jaliceFrame.local_coords_to_screen_coords(p, (ReferenceFrame)model.modelVehicle);
        g.setColor(Color.black);
        int j = 0;
        while (j < 6) {
            g.fillOval((int)q.x - 5, (int)q.y - j, 12, 12);
            ++j;
        }
        g.setColor(Color.white);
        g.fillOval((int)q.x - 5, (int)q.y - 3, 6, 6);
    }

    static void paintNose(Graphics g, Model model, Nose nose) {
        if (!SnapTarget.front_facing(nose.vertex)) {
            return;
        }
        Vector3 p = model.teddyVertex_to_jaliceVector3(nose.vertex);
        Vector3 q = Sweater.jaliceFrame.local_coords_to_screen_coords(p, (ReferenceFrame)model.modelVehicle);
        Color color = new Color(128, 64, 0);
        g.setColor(color);
        g.fillOval((int)q.x - 10, (int)q.y - 5, 10, 10);
        g.fillOval((int)q.x - 5, (int)q.y - 5, 10, 10);
        g.fillOval((int)q.x, (int)q.y - 5, 10, 10);
        g.fillOval((int)q.x - 5, (int)q.y, 10, 10);
    }
}

