/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import sweater.Model;
import sweater.SurfaceLine;
import teddy.Edge;
import teddy.Face;
import teddy.Plane;
import teddy.Polyhedron;
import teddy.SurfacePath;
import teddy.Vertex;

public class ControlCurve {
    Model model;
    SurfacePath surfacePath;
    SurfaceLine surfaceLine;

    ControlCurve(Model model, SurfacePath surfacePath) {
        this.model = model;
        this.surfacePath = surfacePath;
        this.surfaceLine = new SurfaceLine(model, surfacePath);
    }

    public Plane createPlane(SurfacePath surfacePath) {
        if (surfacePath.size() <= 2) {
            return null;
        }
        Vertex v0 = surfacePath.getVertex(0);
        Vertex v1 = surfacePath.getVertex(1);
        Vertex v2 = surfacePath.getVertex(2);
        if (v0 == null || v1 == null || v2 == null) {
            return null;
        }
        return new Plane(v0, v1, v2);
    }

    public ControlCurve copy(Model model, Polyhedron h) {
        SurfacePath new_surfacePath = new SurfacePath();
        int i = 0;
        while (i < this.surfacePath.size()) {
            Vertex v = this.surfacePath.getVertex(i);
            v = h.vertices(v.index);
            if (this.surfacePath.onEdge(i)) {
                Edge edge = this.surfacePath.getEdge(i);
                edge = h.edges(edge.index);
                new_surfacePath.add(v, edge);
            } else if (this.surfacePath.onFace(i)) {
                Face face = this.surfacePath.getFace(i);
                face = h.faces(face.index);
                new_surfacePath.add(v, face);
            } else if (this.surfacePath.onVertex(i)) {
                Vertex base = this.surfacePath.getParentVertex(i);
                base = h.vertices(base.index);
                new_surfacePath.add(v, base);
            }
            ++i;
        }
        new_surfacePath.loop = this.surfacePath.loop;
        return new ControlCurve(model, new_surfacePath);
    }
}

