/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import java.util.ArrayList;
import java.util.List;
import pattern.DrawPanel;
import pattern.Piece;
import sweater.Model;
import sweater.Util;
import teddy.Edge;
import teddy.Edge2D;
import teddy.Polyhedron;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class AdjustmentInputStroke {
    private static boolean adjust = true;
    static double nearest_evaluate_value = Double.MAX_VALUE;

    public static void setInputVertices(Model model) {
        Polyhedron h = model.getPolyhedron();
        int i = 0;
        while (i < h.edges.size()) {
            Edge edge = h.edges(i);
            if (edge.seam) {
                AdjustmentInputStroke.setInputVertices_to_patchVertices(edge.start);
                AdjustmentInputStroke.setInputVertices_to_patchVertices(edge.end);
            }
            ++i;
        }
    }

    private static void setInputVertices_to_patchVertices(Vertex v) {
        Vertex inputVertex = v.getInputVertex();
        if (inputVertex != null) {
            System.out.println("inputVertex != null");
            return;
        }
        Vertex target_v = v.copy();
        v.setInputVertex(target_v);
        int i = 0;
        while (i < v.child_vertices.size()) {
            Vertex child = (Vertex)v.child_vertices.get(i);
            child.setInputVertex(target_v);
            ++i;
        }
    }

    public static void adjustment_to_input_stroke(Model model) {
        Polyhedron h = model.getPolyhedron();
        int i = 0;
        while (i < h.edges.size()) {
            Edge edge = h.edges(i);
            if (edge.seam) {
                AdjustmentInputStroke.adjustment_to_input_stroke_sub(edge.start);
                AdjustmentInputStroke.adjustment_to_input_stroke_sub(edge.end);
            }
            ++i;
        }
        DrawPanel.getInstance().meshBeautify();
        DrawPanel.getInstance().repaint();
    }

    private static void adjustment_to_input_stroke_sub(Vertex picked_v) {
        Vertex target_v = picked_v.getInputVertex();
        if (target_v == null || target_v.x == 0.0 && target_v.y == 0.0) {
            return;
        }
        Vector3 normal = picked_v.get_normal();
        Vector3 vec = new Vector3((Vector3)picked_v, (Vector3)target_v);
        double length = Vector3.dot_product((Vector3)vec, (Vector3)normal);
        length *= 20.0;
        int i = 0;
        while (i < picked_v.child_vertices.size()) {
            Vertex child = (Vertex)picked_v.child_vertices.get(i);
            Vertex2D patternCoord = child.getPatternCoord();
            if (patternCoord == null) {
                return;
            }
            Vector2 normal_patternCoord = patternCoord.get_normal();
            normal_patternCoord.multiply(length);
            if (!AdjustmentInputStroke.collision_detection(patternCoord, normal_patternCoord)) {
                patternCoord.add(normal_patternCoord);
            }
            ++i;
        }
    }

    static boolean collision_detection(Vertex2D vertex, Vector2 normal) {
        Vertex2D v = vertex.copy();
        Vertex2D target_v = new Vertex2D(v.x + normal.x, v.y + normal.y);
        Edge2D edge = new Edge2D(v, target_v);
        List near_edges = AdjustmentInputStroke.get_near_edges(vertex);
        int i = 0;
        while (i < near_edges.size()) {
            Edge2D near_edge = (Edge2D)near_edges.get(i);
            if (edge.cross(near_edge)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static List get_near_edges(Vertex2D vertex) {
        ArrayList<Edge2D> near_edges = new ArrayList<Edge2D>();
        Piece piece = vertex.piece;
        List outside_vertices = piece.getOutsideVertices();
        int index = -1;
        int i = 0;
        while (i < outside_vertices.size()) {
            Vertex2D v = (Vertex2D)outside_vertices.get(i);
            if (v == vertex) {
                index = i;
            }
            ++i;
        }
        index = Util.mod(index - 2, outside_vertices.size());
        Vertex2D v0 = (Vertex2D)outside_vertices.get(Util.mod(index, outside_vertices.size()));
        int i2 = 1;
        while (i2 < 5) {
            Vertex2D v1 = (Vertex2D)outside_vertices.get(Util.mod(index + i2, outside_vertices.size()));
            Edge2D edge = v0.get_common_edge(v1);
            near_edges.add(edge);
            v0 = v1;
            ++i2;
        }
        return near_edges;
    }

    private static double evaluate_function(Model model) {
        return AdjustmentInputStroke.evaluate_function_sub(model.getPolyhedron());
    }

    private static double evaluate_function_sub(Polyhedron h) {
        boolean[] vertices = new boolean[h.vertices.size()];
        double val = 0.0;
        int i = 0;
        while (i < h.edges.size()) {
            Edge edge = h.edges(i);
            if (edge.seam) {
                if (!vertices[edge.start.index]) {
                    val += AdjustmentInputStroke.get_gap_from_input_stroke(edge.start);
                    vertices[edge.start.index] = true;
                }
                if (!vertices[edge.end.index]) {
                    val += AdjustmentInputStroke.get_gap_from_input_stroke(edge.end);
                    vertices[edge.end.index] = true;
                }
            }
            ++i;
        }
        return val;
    }

    private static double get_gap_from_input_stroke(Vertex v) {
        Vertex input_v = v.getInputVertex();
        return Vertex.distance((Vertex)v, (Vertex)input_v);
    }

    static boolean nearest_input_stroke(Model model) {
        double val = AdjustmentInputStroke.evaluate_function(model);
        System.out.println("val" + val);
        if (val < nearest_evaluate_value) {
            nearest_evaluate_value = val;
            return true;
        }
        return true;
    }

    public static void setAdjust(boolean _adjust) {
        adjust = _adjust;
    }

    public static boolean isAdjust() {
        return adjust;
    }
}

