/*
 * Decompiled with CFR 0.152.
 */
package sweater;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import sweater.Flattening;
import sweater.Model;
import sweater.SnapTarget;
import sweater.Sweater;
import sweater.TmpCamera;
import sweater.VertexPair;
import teddy.CleanStroke;
import teddy.CleanStroke3D;
import teddy.Edge;
import teddy.Face;
import teddy.GridMesh;
import teddy.Inflate;
import teddy.Inflation;
import teddy.Line;
import teddy.Plane;
import teddy.Polyhedron;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class AddingParts {
    private static List stroke;
    private static SnapTarget startSnapTarget;
    private static SnapTarget endSnapTarget;
    private static Model model;

    public static void startStroke(Point p) {
        Sweater.sweater.timer.turn_off();
        stroke = Sweater.sweater.stroke;
        startSnapTarget = SnapTarget.get_grabbed_snap_target();
        model = Sweater.sweater.getPickedModel();
        if (model == null) {
            model = (Model)Sweater.sweater.getModels().get(0);
        }
        AddingParts.extendStroke(p);
    }

    public static void extendStroke(Point p) {
        stroke.add(p);
        Sweater.sweater.do_not_paint_laser = true;
        Sweater.sweater.do_not_paint_label = true;
        Sweater.jaliceFrame.paintOverlay();
        Sweater.sweater.do_not_paint_laser = false;
    }

    public static void finishStroke(Point p) {
        Sweater.jaliceFrame.lock();
        endSnapTarget = SnapTarget.nearist_snap_target(p);
        if (AddingParts.startSnapTarget.curve == AddingParts.endSnapTarget.curve) {
            System.out.println("startSnap == endSnap");
        } else {
            System.out.println("startSnap != endSnap");
        }
        stroke.remove(0);
        stroke.remove(stroke.size() - 1);
        stroke = CleanStroke.clean((List)stroke, (int)30, (int)50, (boolean)false);
        SurfacePath path = AddingParts.startSnapTarget.curve.surfacePath;
        List base_vertices = AddingParts.get_base_vertices_from_surfacePath(path);
        AddingParts.addingParts(model, base_vertices, stroke);
        model.update();
        System.out.println("model.vertex_pairs" + AddingParts.model.vertex_pairs);
        int i = 0;
        while (i < AddingParts.model.vertex_pairs.size()) {
            VertexPair vertexPair = (VertexPair)AddingParts.model.vertex_pairs.get(i);
            ++i;
        }
        Flattening.flattening_update(model);
        Inflate.update_target_length((Model)model);
        Sweater.sweater.inflate();
        Sweater.sweater.operation_status = Sweater.sweater.NONE;
        Sweater.sweater.stroke = new ArrayList();
        if (model != null) {
            SnapTarget.update_onscreen_snap_targets(model);
        }
        Sweater.jaliceFrame.unlock();
    }

    private static List get_base_vertices_from_surfacePath(SurfacePath path) {
        ArrayList<Vertex> base_vertices = new ArrayList<Vertex>();
        int startIndex = Math.min(AddingParts.startSnapTarget.index, AddingParts.endSnapTarget.index);
        int endIndex = Math.max(AddingParts.startSnapTarget.index, AddingParts.endSnapTarget.index);
        int i = startIndex;
        while (i <= endIndex) {
            if (path.onVertex(i)) {
                base_vertices.add(path.getVertex(i));
            }
            ++i;
        }
        return base_vertices;
    }

    public static void addingParts(Model model, List base_vertices, List stroke) {
        Polyhedron h = model.getPolyhedron();
        TmpCamera camera = model.get_camera();
        stroke = Inflation.counter_clockwise((List)stroke);
        List new_base_vertices = model.make_vertex_pairs(base_vertices);
        List base_edges = AddingParts.get_base_edges_from_base_vertices(base_vertices, h);
        Vertex center = new Vertex();
        int i = 0;
        while (i < base_vertices.size()) {
            Vertex v = (Vertex)base_vertices.get(i);
            center.add((Vector3)v);
            ++i;
        }
        center.multiply(1.0 / (double)base_vertices.size());
        Vertex startVertex = (Vertex)new_base_vertices.get(0);
        Vertex endVertex = (Vertex)new_base_vertices.get(new_base_vertices.size() - 1);
        Plane pop_surface = new Plane(startVertex, Vector3.cross_product((Vector3)new Vector3((Vector3)startVertex, (Vector3)endVertex), (Vector3)startVertex.normal));
        List<Vertex> silhouette_vertices = new ArrayList<Vertex>();
        int i2 = 0;
        while (i2 < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.get(i2);
            Vertex v = camera.screen_coords_to_local_coords(p);
            v = pop_surface.cross_point(new Line(v, camera.get_camera_lay(p)));
            silhouette_vertices.add(v);
            ++i2;
        }
        if (Vertex.distance((Vertex)startVertex, (Vertex)((Vertex)silhouette_vertices.get(0))) > Vertex.distance((Vertex)endVertex, (Vertex)((Vertex)silhouette_vertices.get(0)))) {
            System.out.println("reverse");
            silhouette_vertices = Util.reverse(silhouette_vertices);
        }
        silhouette_vertices.add(0, startVertex);
        silhouette_vertices.add(endVertex);
        silhouette_vertices = CleanStroke3D.resample(silhouette_vertices);
        silhouette_vertices.remove(0);
        silhouette_vertices.remove(silhouette_vertices.size() - 1);
        i2 = 0;
        while (i2 < silhouette_vertices.size()) {
            Vertex v = (Vertex)silhouette_vertices.get(i2);
            v.fixed = true;
            ++i2;
        }
        ArrayList<Vertex> loop3D = new ArrayList<Vertex>();
        new_base_vertices = Util.reverse((List)new_base_vertices);
        int i3 = 0;
        while (i3 < new_base_vertices.size()) {
            loop3D.add((Vertex)new_base_vertices.get(i3));
            ++i3;
        }
        loop3D.addAll(silhouette_vertices);
        Vector3 x_vec = new Vector3((Vector3)startVertex, (Vector3)endVertex);
        x_vec.normalize();
        Vector3 y_vec = Vector3.cross_product((Vector3)x_vec, (Vector3)pop_surface.normal);
        y_vec.normalize();
        y_vec.multiply(-1.0);
        ArrayList<Vertex2D> loop2D = new ArrayList<Vertex2D>();
        int i4 = 0;
        while (i4 < loop3D.size()) {
            Vertex v = (Vertex)loop3D.get(i4);
            Vector3 vec = new Vector3((Vector3)center, (Vector3)v);
            Vertex2D u = new Vertex2D(Vector3.dot_product((Vector3)vec, (Vector3)x_vec), Vector3.dot_product((Vector3)vec, (Vector3)y_vec));
            loop2D.add(u);
            ++i4;
        }
        Polyhedron addedPart = null;
        try {
            addedPart = Inflation.generate(loop2D);
        }
        catch (Exception e) {
            System.err.println("can not create addedPart!");
            return;
        }
        base_vertices = Util.reverse((List)base_vertices);
        ArrayList<Vertex[]> pairs = new ArrayList<Vertex[]>();
        int i5 = 0;
        while (i5 < new_base_vertices.size()) {
            Vertex child_vertex = addedPart.vertices(i5);
            Vertex parent_vertex = (Vertex)base_vertices.get(i5);
            Vertex[] pair = new Vertex[]{child_vertex, parent_vertex};
            pairs.add(pair);
            ++i5;
        }
        System.out.println("pairs " + pairs.size());
        addedPart.connections = pairs;
        model.make_edge_pairs(base_edges);
        addedPart.set_parameters();
        addedPart.parent = h;
        i5 = 0;
        while (i5 < addedPart.vertices.size()) {
            Vertex v = addedPart.vertices(i5);
            v.set_position(AddingParts.global_coord_to_local_coord(v, center, x_vec, y_vec, pop_surface.normal));
            ++i5;
        }
        addedPart.set_parameters();
        h.child_polyhedrons.add(addedPart);
    }

    private static Vertex global_coord_to_local_coord(Vertex local, Vertex base, Vector3 x_vec, Vector3 y_vec, Vector3 z_vec) {
        Vertex v = new Vertex((Vector3)base);
        v.add(x_vec.multiple(local.x));
        v.add(y_vec.multiple(local.y));
        v.add(z_vec.multiple(local.z));
        return v;
    }

    public static void mesh_generate_sub(Polyhedron h, List loop3D, Vertex center, Vector3 x_vec, Vector3 y_vec, Vector3 offset) {
        ArrayList<double[]> loop2D = new ArrayList<double[]>();
        int i = 0;
        while (i < loop3D.size()) {
            Vertex v = (Vertex)loop3D.get(i);
            Vector3 vec = new Vector3((Vector3)center, (Vector3)v);
            double[] u = new double[]{Vector3.dot_product((Vector3)vec, (Vector3)x_vec), Vector3.dot_product((Vector3)vec, (Vector3)y_vec)};
            loop2D.add(u);
            ++i;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int i2 = 0;
        while (i2 < loop2D.size()) {
            double[] v = (double[])loop2D.get(i2);
            System.out.println(" (" + v[0] + "," + v[1] + ")");
            lines.add(v[0] + " " + v[1]);
            ++i2;
        }
        List mesh2D = GridMesh.create_mesh(loop2D, (double)0.1);
        if (mesh2D == null) {
            System.err.println("mesh2D == null at AddingParts.java");
            return;
        }
        List vertices2D = (List)mesh2D.get(0);
        List edges2D = (List)mesh2D.get(1);
        List faces2D = (List)mesh2D.get(2);
        System.out.println("mesh2D" + mesh2D);
        ArrayList<Vertex> vertices3D = new ArrayList<Vertex>();
        int i3 = 0;
        while (i3 < vertices2D.size()) {
            Vertex v = null;
            if (i3 < loop2D.size()) {
                v = (Vertex)loop3D.get(i3);
            } else {
                double[] u = (double[])vertices2D.get(i3);
                v = new Vertex((Vector3)center);
                v.add(Vector3.multiply((Vector3)x_vec, (double)u[0]));
                v.add(Vector3.multiply((Vector3)y_vec, (double)u[1]));
                h.add(v);
            }
            vertices3D.add(v);
            ++i3;
        }
        ArrayList faces3D = new ArrayList();
        int i4 = 0;
        while (i4 < faces2D.size()) {
            int[] f = (int[])faces2D.get(i4);
            Vertex v0 = (Vertex)vertices3D.get(f[0]);
            Vertex v1 = (Vertex)vertices3D.get(f[1]);
            Vertex v2 = (Vertex)vertices3D.get(f[2]);
            Face face = new Face(AddingParts.get_edge(v0, v1, h), AddingParts.get_edge(v1, v2, h), AddingParts.get_edge(v2, v0, h));
            h.add(face);
            ++i4;
        }
        Vertex v_prev = (Vertex)loop3D.get(0);
        int i5 = 1;
        while (i5 < loop3D.size()) {
            Vertex v = (Vertex)loop3D.get(i5);
            Edge edge = v.get_common_edge(v_prev);
            edge.seam = true;
            v_prev = v;
            ++i5;
        }
    }

    static Edge get_edge(Vertex v0, Vertex v1, Polyhedron h) {
        Edge edge = v0.get_common_edge(v1);
        if (edge == null) {
            edge = new Edge(v0, v1);
            h.add(edge);
        }
        return edge;
    }

    static List get_base_edges_from_base_vertices(List base_vertices, Polyhedron h) {
        ArrayList<Edge> base_edges = new ArrayList<Edge>();
        Vertex prev_v = (Vertex)base_vertices.get(0);
        int i = 1;
        while (i < base_vertices.size()) {
            Vertex v = (Vertex)base_vertices.get(i);
            Edge edge = AddingParts.get_edge(prev_v, v, h);
            base_edges.add(edge);
            prev_v = v;
            ++i;
        }
        return base_edges;
    }

    private static List counter_clockwise(List points) {
        double total_area = 0.0;
        Point prev = (Point)points.get(points.size() - 1);
        int i = 0;
        while (i < points.size()) {
            Point next = (Point)points.get(i);
            total_area += (double)((prev.y + next.y) * (next.x - prev.x));
            prev = next;
            ++i;
        }
        if (total_area < 0.0) {
            return Util.reverse((List)points);
        }
        return points;
    }
}

