/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.DrawPanel;
import board.Util;
import board.Vector2D;
import board.Vertex2D;
import board.VertexOnStroke;
import board.Vessel;
import java.util.ArrayList;

public class VesselDrag {
    static Vessel drag_vessel;
    static ArrayList snap_targets;
    static Vertex2D mouse_v_original;
    static Vertex2D first_v_original;
    static double SNAP_DISTANCE;

    static {
        snap_targets = new ArrayList();
        SNAP_DISTANCE = 30.0;
    }

    public static void start_dragging(DrawPanel panel, Vertex2D v) {
        Vessel vessel = panel.pick_vessel(v);
        if (vessel == null) {
            drag_vessel = null;
            return;
        }
        drag_vessel = vessel.get_root();
        mouse_v_original = new Vertex2D(v);
        first_v_original = new Vertex2D(drag_vessel.firstPoint());
        ArrayList descendants = drag_vessel.collect_descendants();
        snap_targets = Util.subtractArrayList(panel.record.getVessels(), descendants);
    }

    public static void dragging(DrawPanel panel, Vertex2D v) {
        if (drag_vessel != null) {
            Vertex2D first_v_target = Vertex2D.translate(first_v_original, new Vector2D(mouse_v_original, v));
            VertexOnStroke snap_target = VesselDrag.find_snap_target(first_v_target);
            if (snap_target != null) {
                first_v_target = snap_target.v;
            }
            Vertex2D first_v_current = drag_vessel.firstPoint();
            Vector2D vec = new Vector2D(first_v_current, first_v_target);
            drag_vessel.move_relative_with_descendants(vec);
        }
        panel.repaint_all();
    }

    static VertexOnStroke find_snap_target(Vertex2D v) {
        double min = SNAP_DISTANCE;
        VertexOnStroke closest = null;
        int i = 0;
        while (i < snap_targets.size()) {
            Vessel vessel = (Vessel)snap_targets.get(i);
            VertexOnStroke vs = vessel.find_closest_VertexOnStroke(v);
            if (vs.distance < min) {
                closest = vs;
                min = vs.distance;
            }
            ++i;
        }
        return closest;
    }

    public static void finish_dragging(DrawPanel panel) {
        Vessel.update_connectivity(panel.record.getVessels());
    }
}

