/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Artery;
import board.Bypass;
import board.DrawPanel;
import board.Stenosis;
import board.Stroke;
import board.Util;
import board.Vector2D;
import board.Vertex2D;
import board.VertexOnStroke;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;

public class Vessel
extends Stroke
implements Serializable {
    int id;
    boolean bypass = false;
    Vessel predecessor;
    Vessel successor;
    boolean absent = false;
    Vessel parent;
    int parent_index;
    ArrayList branches = new ArrayList();
    ArrayList stenoses = new ArrayList();
    ArrayList stents = new ArrayList();
    int merged_index = 0;
    double[] original_radius;
    int width = 10;
    static final int LARGE = 15;
    static final int NORMAL = 10;
    static final int SMALL = 5;
    static final int ZERO = 0;
    static Stenosis stenosis;
    double BypassRadius = 6.0;

    Vessel() {
    }

    Vessel(Stroke stroke) {
        this.points = stroke.points;
        this.id = stroke.index;
        this.name = stroke.name;
        this.original_radius = new double[this.points.size()];
    }

    Vessel appendVessel(Stroke stroke) {
        Vessel ret_vessel = this;
        ret_vessel.points.add(stroke.points);
        return ret_vessel;
    }

    public void paint_outside(Graphics g) {
    }

    public void paint_inside(Graphics g) {
    }

    static void update_connectivity(ArrayList vessels) {
        Vessel vessel;
        int i = 0;
        while (i < vessels.size()) {
            vessel = (Vessel)vessels.get(i);
            vessel.clear_connectivity();
            ++i;
        }
        i = 0;
        while (i < vessels.size()) {
            vessel = (Vessel)vessels.get(i);
            vessel.set_connectivity(vessels);
            ++i;
        }
    }

    void clear_connectivity() {
        this.predecessor = null;
        this.successor = null;
        this.parent = null;
        this.branches = new ArrayList();
    }

    void set_connectivity(ArrayList vessels) {
        Vessel vessel;
        int i = 0;
        while (i < vessels.size()) {
            vessel = (Vessel)vessels.get(i);
            if (vessel != this && Vessel.is_connected(this.firstPoint(), vessel.lastPoint()) && vessel.successor == null) {
                this.predecessor = vessel;
                vessel.successor = this;
                this.firstPoint().warp(vessel.lastPoint());
                return;
            }
            ++i;
        }
        i = 0;
        while (i < vessels.size()) {
            vessel = (Vessel)vessels.get(i);
            if (vessel != this) {
                VertexOnStroke v = vessel.find_closest_VertexOnStroke(this.firstPoint());
                if (v.distance < 20.0) {
                    this.parent = vessel;
                    this.parent_index = v.index;
                    this.parent.branches.add(this);
                    this.firstPoint().warp(v.v);
                    return;
                }
            }
            ++i;
        }
    }

    static boolean is_connected(Vertex2D v0, Vertex2D v1) {
        return Vertex2D.distance(v0, v1) < 10.0;
    }

    static ArrayList convert_strokes_to_arteries(ArrayList strokes) {
        ArrayList<Artery> vessels = new ArrayList<Artery>();
        int i = strokes.size() - 1;
        while (i >= 1) {
            Stroke stroke = (Stroke)strokes.get(i);
            Artery vessel = new Artery(stroke);
            vessels.add(vessel);
            --i;
        }
        Vessel.update_connectivity(vessels);
        Vessel.adjust_vessel_radius(vessels);
        return vessels;
    }

    static ArrayList convert_strokes_to_vessels(ArrayList strokes) {
        ArrayList<Vessel> vessels = new ArrayList<Vessel>();
        int i = strokes.size() - 1;
        while (i >= 0) {
            Stroke stroke = (Stroke)strokes.get(i);
            if (stroke.type == 1) {
                Vessel vessel = new Vessel(stroke);
                vessels.add(vessel);
            }
            --i;
        }
        Vessel.update_connectivity(vessels);
        Vessel.adjust_vessel_radius(vessels);
        return vessels;
    }

    static void adjust_vessel_radius(ArrayList vessels) {
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            if (vessel.successor == null) {
                Vessel.set_tapered_radius(vessel, vessel.width);
            } else {
                Vessel.set_constant_radius(vessel, vessel.width);
            }
            String vessel_name = vessel.name;
            if (vessel_name == "LITA" || vessel_name == "RITA" || vessel_name == "GEA") {
                Vessel.set_constant_radius(vessel, vessel.width);
            }
            ++i;
        }
    }

    void set_width(String string) {
        if (string == "large") {
            this.width = 15;
        } else if (string == "normal") {
            this.width = 10;
        } else if (string == "small") {
            this.width = 5;
        } else if (string == "absent") {
            this.absent = !this.absent;
            this.width = 0;
        }
        if (this.name == "GEA" || this.name == "LITA" || this.name == "RITA") {
            Vessel.set_constant_radius(this, this.width);
        } else {
            this.set_width(this, this.width);
        }
        DrawPanel panel = DrawPanel.getInstance();
        ArrayList vessels = panel.record.getArteries();
        Vessel.adjust_vessel_radius(vessels);
    }

    void set_width(Vessel vessel, int size) {
        vessel.width = size;
        Vessel vessel0 = vessel.successor;
        while (vessel0 != null) {
            vessel0.width = size;
            vessel0 = vessel0.successor;
        }
        Vessel vessel1 = vessel.predecessor;
        while (vessel1 != null) {
            vessel1.width = size;
            vessel1 = vessel1.predecessor;
        }
    }

    static void set_tapered_radius(Vessel vessel, double radius) {
        int n = vessel.points.size();
        int i = 0;
        while (i < n) {
            Vertex2D v = vessel.getPoint(i);
            double t = 1.0 - 1.0 * (double)i * (double)i / (double)(n * n);
            vessel.original_radius[i] = 1.0 + (radius - 1.0) * t;
            ++i;
        }
    }

    static void set_constant_radius(Vessel vessel, double radius) {
        int n = vessel.points.size();
        int i = 0;
        while (i < n) {
            vessel.original_radius[i] = radius;
            ++i;
        }
    }

    void set_original_radius() {
        int n = this.points.size();
        int i = 0;
        while (i < n) {
            Vertex2D v = this.getPoint(i);
            v.radius = this.isBypass() ? this.BypassRadius : this.original_radius[i];
            ++i;
        }
    }

    boolean isBypass() {
        return this instanceof Bypass;
    }

    static void compute_rendering_radius(ArrayList vessels) {
        Vessel vessel;
        int i = 0;
        while (i < vessels.size()) {
            vessel = (Vessel)vessels.get(i);
            vessel.set_original_radius();
            ++i;
        }
        i = 0;
        while (i < vessels.size()) {
            vessel = (Vessel)vessels.get(i);
            int j = 0;
            while (j < vessel.stenoses.size()) {
                Stenosis stenosis = (Stenosis)vessel.stenoses.get(j);
                if (stenosis.ratio >= 100.0) {
                    Vessel.close_descendent_vessels(vessel, stenosis.start_index);
                }
                ++j;
            }
            ++i;
        }
        ArrayList bypasses = DrawPanel.getInstance().record.getBypasses();
        int j = 0;
        while (j < bypasses.size()) {
            Bypass bypass = (Bypass)bypasses.get(j);
            int i2 = 0;
            while (i2 < vessels.size()) {
                Vessel vessel2 = (Vessel)vessels.get(i2);
                if (bypass.is_bypassLastPointOnVessel(vessel2)) {
                    int index = bypass.bypassLastPointOnVessel(vessel2);
                    Vessel.open_descendent_vessels(vessel2, index);
                }
                ++i2;
            }
            ++j;
        }
    }

    static void close_descendent_vessels(Vessel vessel, int start_index) {
        int i = start_index;
        while (i < vessel.points.size()) {
            vessel.getPoint((int)i).radius = 0.0;
            ++i;
        }
        if (vessel.successor != null) {
            Vessel.close_descendent_vessels(vessel.successor, 0);
        }
        i = 0;
        while (i < vessel.branches.size()) {
            Vessel child = (Vessel)vessel.branches.get(i);
            if (child.parent_index >= start_index) {
                Vessel.close_descendent_vessels(child, 0);
            }
            ++i;
        }
    }

    static void open_descendent_vessels(Vessel vessel, int start_index) {
        int end_index = Vessel.find_first_100_stenosis_after_start_index(vessel, start_index);
        int i = start_index;
        while (i < end_index) {
            vessel.getPoint((int)i).radius = vessel.original_radius[i];
            ++i;
        }
        if (vessel.successor != null && end_index == vessel.points.size()) {
            Vessel.open_descendent_vessels(vessel.successor, 0);
        }
        i = 0;
        while (i < vessel.branches.size()) {
            Vessel child = (Vessel)vessel.branches.get(i);
            if (child.parent_index >= start_index && child.parent_index <= end_index) {
                Vessel.open_descendent_vessels(child, 0);
            }
            ++i;
        }
    }

    static int find_first_100_stenosis_after_start_index(Vessel vessel, int start_index) {
        int min = vessel.points.size();
        int i = 0;
        while (i < vessel.stenoses.size()) {
            Stenosis stenosis = (Stenosis)vessel.stenoses.get(i);
            if (stenosis.ratio == 100.0 && stenosis.end_index > start_index) {
                if (stenosis.start_index <= start_index) {
                    if (start_index < min) {
                        min = start_index;
                    }
                } else {
                    min = stenosis.start_index;
                }
            }
            ++i;
        }
        return min;
    }

    Vessel get_root() {
        if (this.predecessor == null) {
            return this;
        }
        return this.predecessor.get_root();
    }

    ArrayList collect_descendants() {
        ArrayList descendants = new ArrayList();
        descendants.add(this);
        if (this.successor != null) {
            descendants = Util.appendArrayList(descendants, this.successor.collect_descendants());
        }
        int i = 0;
        while (i < this.branches.size()) {
            Vessel child = (Vessel)this.branches.get(i);
            descendants = Util.appendArrayList(descendants, child.collect_descendants());
            ++i;
        }
        return descendants;
    }

    void move_relative_with_descendants(Vector2D vec) {
        int i = 0;
        while (i < this.points.size()) {
            this.getPoint(i).move_relative(vec);
            ++i;
        }
        if (this.successor != null) {
            this.successor.move_relative_with_descendants(vec);
        }
        i = 0;
        while (i < this.branches.size()) {
            Vessel child = (Vessel)this.branches.get(i);
            child.move_relative_with_descendants(vec);
            ++i;
        }
    }

    Vessel make_merged_vessel(Vessel merged_vessel, int n) {
        int i = 0;
        while (i < this.points.size() - 1) {
            merged_vessel.addPoint(this.getPoint(i));
            ++i;
        }
        if (this.successor != null) {
            this.removePointAt(this.points.size() - 1);
            this.addPoint(this.successor.firstPoint());
            this.successor.make_merged_vessel(merged_vessel, n + 1);
        } else {
            merged_vessel.addPoint(this.lastPoint());
        }
        return merged_vessel;
    }

    void delete() {
        DrawPanel panel = DrawPanel.getInstance();
        panel.record.remove(this);
        Vessel.update_connectivity(panel.record.getVessels());
    }
}

