/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.DrawPanel;
import board.Main;
import board.Stenosis;
import board.Vessel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class Table {
    public static JFrame objFrm;
    public static DefaultTableModel objModel;
    public static Container objCnt;
    public static JTable objTbl;
    public static JScrollPane objScr;

    public static void prepare_Tabel() {
        objFrm = new JFrame("Stenosis Status");
        objCnt = objFrm.getContentPane();
        objCnt.setLayout(new BorderLayout());
        objModel = new DefaultTableModel();
        objModel.addColumn("Segment");
        objModel.addColumn("Pre PCI");
        objModel.addColumn("Irregular");
        objModel.addColumn("Calcification");
        objModel.addColumn("Diffuse");
        objModel.addColumn("Segmental");
        objModel.addColumn("Undefined");
        objTbl = new JTable(objModel);
        objScr = new JScrollPane(objTbl, 20, 30);
        objCnt.add(objScr);
    }

    public static void main() {
        if (objFrm == null) {
            Table.prepare_Tabel();
        }
        int rowCount = objModel.getRowCount();
        System.out.println("" + rowCount);
        while (objModel.getRowCount() > 0) {
            objModel.removeRow(0);
        }
        Object[] aryStr = new String[7];
        ArrayList stenoses = new ArrayList();
        ArrayList vessels = DrawPanel.getInstance().record.getVessels();
        int i = vessels.size() - 1;
        while (i > 0) {
            Vessel vessel = (Vessel)vessels.get(i);
            if (vessel.stenoses != null && vessel.stenoses.size() != 0) {
                Stenosis stenosis = (Stenosis)vessel.stenoses.get(0);
                aryStr[0] = "#" + stenosis.vessel.id;
                aryStr[1] = (int)stenosis.ratio + "%";
                aryStr[2] = stenosis.type == 3 ? "\u25cb" : "\u00d7";
                aryStr[3] = stenosis.type == 1 ? "\u25cb" : "\u00d7";
                aryStr[4] = stenosis.type == 2 ? "\u25cb" : "\u00d7";
                aryStr[5] = stenosis.type == 4 ? "\u25cb" : "\u00d7";
                aryStr[6] = stenosis.type == 0 ? "\u25cb" : "\u00d7";
                objModel.addRow(aryStr);
            }
            --i;
        }
        TableModel tableModel = objTbl.getModel();
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                System.out.println("table changed");
                ArrayList vessels = DrawPanel.getInstance().record.getVessels();
                int i = 0;
                while (i < objModel.getRowCount()) {
                    String str_index = (String)objModel.getValueAt(i, 0);
                    str_index = str_index.substring(1);
                    int index = Integer.parseInt(str_index);
                    Vessel vessel = (Vessel)vessels.get(index - 1);
                    if (vessel.stenoses == null || vessel.stenoses.size() == 0) {
                        System.out.println("do not have stenosis");
                    } else {
                        Stenosis stenosis = (Stenosis)vessel.stenoses.get(0);
                        String str_ratio = (String)objModel.getValueAt(i, 1);
                        str_ratio = str_ratio.substring(0, 2);
                        stenosis.set_ratio(Integer.parseInt(str_ratio));
                    }
                    ++i;
                }
                Main.drawPanel.repaint();
            }
        });
        objFrm.addWindowListener(new WindowAdapter(){

            public void WindowClosing(WindowEvent e) {
            }
        });
        objFrm.setSize(345, 200);
        objFrm.setVisible(true);
    }
}

