/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.DrawPanel;
import board.Line2D;
import board.Stroke;
import board.Util;
import board.Vector2D;
import board.Vertex2D;
import board.Vessel;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class Smoother {
    Stroke stroke;
    DrawPanel drawPanel;
    int prev_index;
    int prev_direction = 1;
    int min_index;
    int max_index;
    int range;
    static boolean vertex_is_inserted;

    Smoother() {
    }

    public Smoother(Vertex2D p, DrawPanel drawPanel) {
        this.drawPanel = drawPanel;
        Vessel target_vessel = drawPanel.pick_vessel(p);
        if (target_vessel == null) {
            return;
        }
        Vessel root_vessel = target_vessel.get_root();
        Vessel temp_vessel = root_vessel.make_merged_vessel(new Vessel(), 0);
        this.stroke = temp_vessel;
        Vertex2D v = p;
        this.min_index = this.max_index = (this.prev_index = Smoother.find_closest_vertex(v, this.stroke));
    }

    public void display(Graphics g) {
        ArrayList<Vertex2D> points = new ArrayList<Vertex2D>();
        int i = this.min_index;
        while (i <= this.max_index) {
            Vertex2D v = new Vertex2D(this.stroke.getPoint(i));
            points.add(v);
            ++i;
        }
        Stroke pstroke = new Stroke(points);
        pstroke.color = Color.red;
        pstroke.radius = this.stroke.radius;
        pstroke.paint(g, false);
    }

    public void finish_smoothing() {
        ArrayList vessels = DrawPanel.getInstance().record.getVessels();
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            Vertex2D v = new Vertex2D(vessel.lastPoint());
            vessel.points.remove(vessel.points.size() - 1);
            vessel.points.add(v);
            ++i;
        }
    }

    public void smooth(Vertex2D p) {
        vertex_is_inserted = false;
        int next_index = this.find_closest_vertex(p, this.stroke, this.prev_index);
        if (this.prev_index == next_index) {
            return;
        }
        this.min_index = Math.min(this.min_index, next_index);
        this.max_index = Math.max(this.max_index, next_index);
        this.range = Math.max(2, (this.max_index - this.min_index) / 2);
        if (next_index > this.prev_index) {
            if (this.prev_direction == 1) {
                Smoother.smooth_vertex(this.prev_index, this.stroke, this.range);
            }
            int i = this.prev_index + 1;
            while (i < next_index) {
                Smoother.smooth_vertex(i, this.stroke, this.range);
                ++i;
            }
            this.prev_direction = 1;
        } else {
            if (this.prev_direction == -1) {
                Smoother.smooth_vertex(this.prev_index, this.stroke, this.range);
            }
            int i = this.prev_index - 1;
            while (i > next_index) {
                Smoother.smooth_vertex(i, this.stroke, this.range);
                --i;
            }
            this.prev_direction = -1;
        }
        this.prev_index = next_index;
        this.stroke.update_bbox();
    }

    public static void insert_vertex(Vertex2D v, Stroke stroke, int index) {
        vertex_is_inserted = true;
        if (index == stroke.points.size()) {
            stroke.points.add(v);
        } else {
            index = stroke.adjust_index(index);
            stroke.points.add(index, v);
        }
    }

    static void smooth_all(Stroke stroke, int count) {
        int j = 0;
        while (j < count) {
            int i = 0;
            while (i < stroke.points.size()) {
                Smoother.smooth_vertex(i, stroke, 5);
                ++i;
            }
            ++j;
        }
    }

    public static void smooth_vertex(int i, Stroke stroke, int range) {
        Vertex2D v;
        if (!(stroke.is_loop() || i >= 1 && i <= stroke.points.size() - 2)) {
            return;
        }
        Vertex2D target = Smoother.find_target_position(i = Util.mod(i, stroke.points.size()), stroke, range);
        if (Vertex2D.distance(target, v = (Vertex2D)stroke.points.get(i)) > 2.0) {
            Vector2D vec = Vector2D.normalize(new Vector2D(v, target));
            target = Vertex2D.translate(v, Vector2D.multiply(vec, 2.0));
        }
        v.warp(target);
    }

    public static int find_closest_vertex(Vertex2D v, Stroke stroke) {
        int closest = -1;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < stroke.points.size()) {
            Vertex2D u = (Vertex2D)stroke.points.get(i);
            double d = Vertex2D.distance(u, v);
            if (d < min) {
                min = d;
                closest = i;
            }
            ++i;
        }
        return closest;
    }

    public int find_closest_vertex(Vertex2D p, Stroke stroke, int index) {
        double d_current = Double.MAX_VALUE;
        double d_prev = Double.MAX_VALUE;
        double d_next = Double.MAX_VALUE;
        int prev_index = index - 1;
        int next_index = index + 1;
        d_current = Vertex2D.distance(p, stroke.getPoint(index));
        if (stroke.is_loop() || index > 0) {
            d_prev = Vertex2D.distance(p, stroke.getPoint(prev_index));
        }
        if (stroke.is_loop() || index < stroke.points.size() - 1) {
            d_next = Vertex2D.distance(p, stroke.getPoint(next_index));
        }
        if (d_current <= d_prev && d_current <= d_next) {
            return index;
        }
        if (d_prev <= d_current && d_prev <= d_next) {
            return this.find_closest_vertex(p, stroke, prev_index);
        }
        return this.find_closest_vertex(p, stroke, next_index);
    }

    public static Vertex2D find_target_position(int index, Stroke stroke, int range) {
        int prev_index = index - 1;
        int next_index = index + 1;
        Vertex2D v = stroke.getPoint(index);
        Vertex2D p = stroke.getPoint(prev_index);
        Vertex2D q = stroke.getPoint(next_index);
        Vector2D p_to_q = new Vector2D(p, q);
        double w = 0.5 * p_to_q.length();
        Vertex2D mid_point = Vertex2D.mid_point(p, q);
        Vector2D normal = Vector2D.rotate90(p_to_q);
        normal = Vector2D.normalize(normal);
        double min_x = -w;
        double max_x = w;
        double x = Vector2D.cross_product(new Vector2D(mid_point, v), normal);
        int i = 0;
        while (i < 10) {
            Vertex2D new_v = Vertex2D.translate(mid_point, Vector2D.multiply(normal, x));
            boolean too_large = Smoother.x_is_too_large(new_v, index, stroke, range);
            if (too_large) {
                max_x = x;
            } else {
                min_x = x;
            }
            x = 0.5 * (min_x + max_x);
            ++i;
        }
        return new Vertex2D(Vertex2D.translate(mid_point, Vector2D.multiply(normal, x)));
    }

    public static boolean x_is_too_large(Vertex2D v, int i, Stroke stroke, int range) {
        double angle_at_v = Smoother.get_angle_at(stroke, i, v);
        double average_angle = 0.0;
        int count = 0;
        int j = i - range;
        while (j <= i + range) {
            if (j != i && (stroke.is_loop() || j >= 1 && j <= stroke.points.size() - 2)) {
                average_angle += Smoother.get_angle_at(stroke, j);
                ++count;
            }
            ++j;
        }
        return angle_at_v > (average_angle /= (double)count);
    }

    public static double get_angle_at(Stroke stroke, int index) {
        return Smoother.get_angle_at(stroke, index, stroke.getPoint(index));
    }

    public static double get_angle_at(Stroke stroke, int index, Vertex2D current) {
        index = Util.mod(index, stroke.points.size());
        int prev_index = index - 1;
        int next_index = index + 1;
        if (index == 0) {
            prev_index = stroke.number_of_points() - 2;
        }
        if (index == stroke.number_of_points() - 1) {
            next_index = 1;
        }
        Vertex2D prev = (Vertex2D)stroke.points.get(prev_index);
        Vertex2D next = (Vertex2D)stroke.points.get(next_index);
        return Vector2D.sin(new Vector2D(prev, current), new Vector2D(current, next));
    }

    public Vertex2D find_target_position(Vertex2D pp, Vertex2D p, Vertex2D q, Vertex2D qq) {
        Vector2D p_to_pp = Vector2D.normalize(new Vector2D(p, pp));
        Vector2D q_to_qq = Vector2D.normalize(new Vector2D(q, qq));
        Vector2D cross = new Vector2D(p, q);
        double w = 0.5 * cross.length();
        Vertex2D mid_point = Vertex2D.mid_point(p, q);
        Vector2D normal = Vector2D.rotate90(cross);
        Vector2D q_to_qq_flip = Vector2D.flip(q_to_qq, normal = Vector2D.normalize(normal));
        Vector2D p_to_pp_average = Vector2D.normalize(Vector2D.add(p_to_pp, q_to_qq_flip));
        if (Vector2D.dot_product(p_to_pp_average, normal) > 0.0) {
            normal = Vector2D.multiply(normal, -1.0);
        }
        Vector2D p_to_center = Vector2D.rotate90(p_to_pp_average);
        Vertex2D center = Line2D.cross_point(new Line2D(p, p_to_center), new Line2D(mid_point, normal));
        double radius = Vertex2D.distance(center, p);
        double min_x = 0.0;
        double max_x = radius - Vertex2D.distance(center, mid_point);
        int i = 0;
        while (i < 10) {
            double x = 0.5 * (min_x + max_x);
            boolean too_large = this.x_is_outside_of_circle(p_to_pp_average, p, q, cross, normal, w, x);
            if (too_large) {
                max_x = x;
            } else {
                min_x = x;
            }
            ++i;
        }
        double x = min_x;
        return new Vertex2D(Vertex2D.translate(mid_point, Vector2D.multiply(normal, x)));
    }

    public boolean x_is_outside_of_circle(Vector2D p_to_pp_average, Vertex2D p, Vertex2D q, Vector2D cross, Vector2D normal, double w, double x) {
        Vertex2D v = Vertex2D.translate(Vertex2D.mid_point(p, q), Vector2D.multiply(normal, x));
        Vector2D p_to_v = new Vector2D(p, v);
        double angle_at_pp = -Vector2D.cos(p_to_pp_average, p_to_v);
        Vector2D v_to_p = new Vector2D(v, p);
        Vector2D v_to_q = new Vector2D(v, q);
        double angle_at_v = -Vector2D.cos(v_to_p, v_to_q);
        return angle_at_v < angle_at_pp;
    }

    public boolean connect_with_another_stroke(int next_index, Vertex2D p) {
        Vertex2D v = (Vertex2D)this.stroke.points.get(next_index);
        ArrayList strokes = this.drawPanel.record.getStrokes();
        int i = 0;
        while (i < strokes.size()) {
            Stroke stroke2 = (Stroke)strokes.get(i);
            if (stroke2.firstPoint() != v && Vertex2D.distance(stroke2.firstPoint(), v) < this.stroke.radius + stroke2.radius && this.connect(this.stroke, next_index, stroke2, 0, p)) {
                return true;
            }
            if (stroke2.lastPoint() != v && Vertex2D.distance(stroke2.lastPoint(), v) < this.stroke.radius + stroke2.radius && this.connect(this.stroke, next_index, stroke2, stroke2.points.size() - 1, p)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean connect(Stroke stroke0, int index0, Stroke stroke1, int index1, Vertex2D p) {
        ArrayList new_points;
        int closest_index = this.find_closest_vertex(p, stroke1, index1);
        if (Vertex2D.distance(p, (Vertex2D)stroke0.points.get(index0)) <= Vertex2D.distance(p, (Vertex2D)stroke1.points.get(closest_index))) {
            return false;
        }
        System.out.println("connect ! ");
        if (stroke0 == stroke1) {
            Vertex2D v1;
            stroke1.is_loop = true;
            Vertex2D v0 = (Vertex2D)stroke0.points.get(index0);
            if (Vertex2D.distance(v0, v1 = (Vertex2D)stroke0.points.get(index1)) < 1.0E-5) {
                stroke0.removePointAt(index1);
            }
            return true;
        }
        ArrayList new_points0 = index0 == 0 ? Util.reverseArrayList(stroke0.points) : Util.duplicateArrayList(stroke0.points);
        ArrayList new_points1 = index1 == 0 ? Util.duplicateArrayList(stroke1.points) : Util.reverseArrayList(stroke1.points);
        stroke0.points = new_points = Util.connectArrayList(new_points0, new_points1);
        this.drawPanel.record.removeStroke(stroke1);
        this.min_index = this.max_index = (this.prev_index = Smoother.find_closest_vertex(p, this.stroke));
        return true;
    }
}

