/*
 * Decompiled with CFR 0.152.
 */
package board;

import VisualNumerics.math.DoubleLU;
import VisualNumerics.math.DoubleMatrix;
import board.Rigid;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;

public class ScaleAdjust {
    int n_laplacians;
    int n_involved;
    Vertex2D[] vs;
    boolean[] fixed;
    double[] W;
    double[][] _E;
    double[][] ET;
    DoubleLU doubleLU;
    double[] original_edge_length;
    double[] original_laplacian_length;
    int handle_index;
    int weight = 2;

    void compile(Stroke stroke, int index_low, int index_handle, int index_high) {
        int index_low_involved = index_low - 1;
        int index_high_involved = index_high + 1;
        if (!stroke.is_loop()) {
            if (index_low == 0) {
                index_low = 0;
                index_low_involved = 0;
            }
            if (index_high == stroke.number_of_points() - 1) {
                index_high_involved = index_high = stroke.number_of_points() - 1;
            }
        }
        this.n_involved = index_high_involved - index_low_involved + 1;
        this.n_laplacians = this.n_involved - 2;
        this.vs = new Vertex2D[this.n_involved];
        int i = index_low_involved;
        while (i <= index_high_involved) {
            Vertex2D v;
            this.vs[i - index_low_involved] = v = stroke.getPoint(i);
            ++i;
        }
        this.fixed = new boolean[this.n_involved];
        this.fixed[index_low_involved - index_low_involved] = true;
        this.fixed[index_low - index_low_involved] = true;
        this.fixed[index_handle - index_low_involved] = true;
        this.fixed[index_high - index_low_involved] = true;
        this.fixed[index_high_involved - index_low_involved] = true;
        this.original_laplacian_length = new double[this.n_laplacians];
        i = 0;
        while (i < this.n_laplacians) {
            Vector2D laplacian = Vector2D.subtract(this.vs[i + 1], (Vector2D)Vertex2D.mid_point(this.vs[i], this.vs[i + 2]));
            this.original_laplacian_length[i] = laplacian.length();
            ++i;
        }
        this._E = new double[this.n_laplacians][this.n_involved];
        i = 0;
        while (i < this.n_laplacians) {
            double[] dArray = this._E[i];
            int n = i + 0;
            dArray[n] = dArray[n] + -0.5;
            double[] dArray2 = this._E[i];
            int n2 = i + 1;
            dArray2[n2] = dArray2[n2] + 1.0;
            double[] dArray3 = this._E[i];
            int n3 = i + 2;
            dArray3[n3] = dArray3[n3] + -0.5;
            ++i;
        }
        this.W = new double[this.n_laplacians];
        if (Rigid.USE_WEIGHT) {
            i = 0;
            while (i < this.n_laplacians) {
                int index = i + index_low;
                Vertex2D prev = this.vs[i];
                Vertex2D next = this.vs[i + 2];
                Vector2D vec = new Vector2D(prev, next);
                this.W[i] = 1.0 / vec.length();
                ++i;
            }
            i = 0;
            while (i < this.n_laplacians) {
                int j = 0;
                while (j < this.n_involved) {
                    double[] dArray = this._E[i];
                    int n = j++;
                    dArray[n] = dArray[n] * this.W[i];
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.n_laplacians) {
                this.W[i] = 1.0;
                ++i;
            }
        }
        int n_output = 0;
        int i2 = 0;
        while (i2 < this.n_involved) {
            if (!this.fixed[i2]) {
                ++n_output;
            }
            ++i2;
        }
        double[][] E = new double[this.n_laplacians][n_output];
        int i3 = 0;
        while (i3 < this.n_laplacians) {
            int column = 0;
            int j = 0;
            while (j < this.n_involved) {
                if (!this.fixed[j]) {
                    E[i3][column] = this._E[i3][j];
                    ++column;
                }
                ++j;
            }
            ++i3;
        }
        this.ET = DoubleMatrix.transpose((double[][])E);
        double[][] ETE = DoubleMatrix.multiply((double[][])this.ET, (double[][])E);
        this.doubleLU = this.construct_doubleLU(ETE);
    }

    void update() {
        Vector2D[] laplacians = new Vector2D[this.n_laplacians];
        int i = 0;
        while (i < this.n_laplacians) {
            Vector2D laplacian = Vector2D.subtract(this.vs[i + 1], (Vector2D)Vertex2D.mid_point(this.vs[i], this.vs[i + 2]));
            laplacians[i] = Vector2D.multiply(laplacian, this.original_laplacian_length[i] / laplacian.length());
            ++i;
        }
        double[] Lx = new double[this.n_laplacians];
        double[] Ly = new double[this.n_laplacians];
        int i2 = 0;
        while (i2 < this.n_laplacians) {
            int n = i2;
            Lx[n] = Lx[n] + laplacians[i2].x * this.W[i2];
            int n2 = i2;
            Ly[n2] = Ly[n2] + laplacians[i2].y * this.W[i2];
            int j = 0;
            while (j < this.n_involved) {
                if (this.fixed[j]) {
                    int n3 = i2;
                    Lx[n3] = Lx[n3] - this._E[i2][j] * this.vs[j].x;
                    int n4 = i2;
                    Ly[n4] = Ly[n4] - this._E[i2][j] * this.vs[j].y;
                }
                ++j;
            }
            ++i2;
        }
        double[] x = this.doubleLU.solve(this.multiply(this.ET, Lx));
        double[] y = this.doubleLU.solve(this.multiply(this.ET, Ly));
        int count = 0;
        int j = 0;
        while (j < this.n_involved) {
            if (!this.fixed[j]) {
                this.vs[j].x = x[count];
                this.vs[j].y = y[count];
                ++count;
            }
            ++j;
        }
    }

    double[][] multiply(double[][] A, double[][] B) {
        return DoubleMatrix.multiply((double[][])A, (double[][])B);
    }

    double[][] transpose(double[][] A) {
        return DoubleMatrix.transpose((double[][])A);
    }

    public double[][] inverse(double[][] A) {
        double[][] _A = null;
        try {
            _A = DoubleMatrix.inverse((double[][])A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return _A;
    }

    public double[] multiply(double[][] A, double[] x) {
        return DoubleMatrix.multiply((double[][])A, (double[])x);
    }

    public double[] multiply(double[] x, double m) {
        double[] r = new double[x.length];
        int i = 0;
        while (i < x.length) {
            r[i] = x[i] * m;
            ++i;
        }
        return r;
    }

    public DoubleLU construct_doubleLU(double[][] A) {
        DoubleLU doubleLU = null;
        try {
            doubleLU = new DoubleLU(A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return doubleLU;
    }
}

