/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Circle2D;
import board.DrawPanel;
import board.LaplacianEdit;
import board.Record;
import board.Rigid;
import board.ScaleAdjust;
import board.Smoother;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;
import board.VertexOnStroke;
import board.Vessel;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class Pull {
    public static double SCOPE_SCALE = 2.0;
    public static int pull_stroke_id;
    private ArrayList strokes = Pull.record.getStrokes();
    static ArrayList locked_vertices;
    static Record record;
    int index;
    int index0;
    int index1;
    Rigid rigid;
    LaplacianEdit laplacianEdit;
    ScaleAdjust scaleAdjust;
    Stroke original_stroke;
    Vertex2D start_v;
    Stroke stroke;
    double max_pull_length;

    static {
        locked_vertices = new ArrayList();
    }

    public static Pull start_pulling(DrawPanel panel, Vertex2D p) {
        record = panel.record;
        Vessel target_vessel = panel.pick_vessel(p);
        if (target_vessel == null) {
            return null;
        }
        Vessel root_vessel = target_vessel.get_root();
        Vessel temp_vessel = root_vessel.make_merged_vessel(new Vessel(), 0);
        Vessel stroke = temp_vessel;
        if (stroke == null) {
            return null;
        }
        pull_stroke_id = stroke.index;
        return new Pull(panel.record, p, stroke);
    }

    static void clear_locked_vertices() {
        locked_vertices = new ArrayList();
    }

    static void display_locked_vertices(Graphics g) {
        int i = 0;
        while (i < locked_vertices.size()) {
            VertexOnStroke u = (VertexOnStroke)locked_vertices.get(i);
            Pull.draw_pin(g, u.v);
            ++i;
        }
    }

    public static void add_or_remove_locked_vertex(Stroke stroke, int index) {
        int i = 0;
        while (i < locked_vertices.size()) {
            VertexOnStroke vc = (VertexOnStroke)locked_vertices.get(i);
            if (vc.stroke == stroke && vc.index == index) {
                locked_vertices.remove(i);
                return;
            }
            ++i;
        }
        locked_vertices.add(new VertexOnStroke(stroke.getPoint(index), stroke, index));
    }

    public void display(Graphics g) {
        ArrayList<Vertex2D> points = new ArrayList<Vertex2D>();
        int i = this.index0;
        while (i <= this.index1) {
            Vertex2D v = new Vertex2D(this.stroke.getPoint(i));
            v.depth = 0.9;
            points.add(v);
            ++i;
        }
        Stroke pstroke = new Stroke(points);
        pstroke.color = Color.red;
        pstroke.radius = this.stroke.radius;
        pstroke.paint(g, false);
    }

    public static void draw_pin(Graphics g, Vertex2D v) {
        v.depth = 0.99;
        g.setColor(new Color(0, 0, 0));
        new Circle2D(v, 10.0).display_fill(g);
        v.depth = 1.0;
        g.setColor(new Color(50, 200, 0));
        new Circle2D(v, 6.0).display_fill(g);
    }

    private Pull(Record record, Vertex2D p, Stroke _stroke) {
        Pull.record = record;
        Vertex2D v = p;
        this.stroke = _stroke;
        this.index = Smoother.find_closest_vertex(v, this.stroke);
        this.max_pull_length = -1.0;
        this.index1 = 1;
        this.index0 = 1;
        this.original_stroke = this.stroke.get_duplicated();
        this.start_v = v;
    }

    public void pulling(Vertex2D v) {
        Vector2D vec = new Vector2D(this.start_v, v);
        boolean scope_adjusted = this.adjust_scope(vec);
        if (Math.abs(this.index0 - this.index1) <= 2) {
            this.stroke.getPoint(this.index).warp(Vertex2D.translate(this.original_stroke.getPoint(this.index), vec));
            return;
        }
        if (scope_adjusted) {
            this.rigid = new Rigid();
            this.scaleAdjust = new ScaleAdjust();
            int i = 0;
            while (i < this.original_stroke.number_of_points()) {
                this.stroke.getPoint(i).warp(this.original_stroke.getPoint(i));
                ++i;
            }
            this.rigid.compile(this.stroke, this.index0, this.index, this.index1);
            this.scaleAdjust.compile(this.stroke, this.index0, this.index, this.index1);
        }
        this.stroke.getPoint(this.index).warp(Vertex2D.translate(this.original_stroke.getPoint(this.index), vec));
        this.rigid.update();
        this.scaleAdjust.update();
        this.stroke.update_bbox();
    }

    public void finish_pulling(DrawPanel panel) {
        ArrayList vessels = panel.record.getVessels();
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            Vertex2D v = new Vertex2D(vessel.lastPoint());
            vessel.points.remove(vessel.points.size() - 1);
            vessel.points.add(v);
            ++i;
        }
    }

    public int search_pull_stroke_arrayID(int n) {
        int i = 0;
        while (i < this.strokes.size()) {
            Stroke s = (Stroke)this.strokes.get(i);
            if (s.index == pull_stroke_id && s.type == 1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean adjust_scope(Vector2D vec) {
        double pull_length = vec.length() * SCOPE_SCALE;
        double stroke_length = this.original_stroke.length();
        if (this.stroke.is_loop() && pull_length >= 0.9 * stroke_length / 2.0) {
            pull_length = 0.9 * stroke_length / 2.0;
        }
        if (pull_length <= this.max_pull_length) {
            return false;
        }
        this.max_pull_length = pull_length;
        if (!this.is_locked(this.index0)) {
            this.index0 = this.adjust_scope_sub(pull_length, -1);
        }
        if (!this.is_locked(this.index1)) {
            this.index1 = this.adjust_scope_sub(pull_length, 1);
        }
        return true;
    }

    boolean is_locked(int index) {
        int i = 0;
        while (i < locked_vertices.size()) {
            VertexOnStroke v = (VertexOnStroke)locked_vertices.get(i);
            if (v.stroke == this.stroke && v.index == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int adjust_scope_sub(double pull_length, int step) {
        double total = 0.0;
        int i = this.index;
        Vertex2D prev_v = this.original_stroke.getPoint(i);
        i += step;
        while (!this.is_locked(i)) {
            if (!(this.original_stroke.is_loop() || i >= 0 && i <= this.original_stroke.number_of_points() - 1)) {
                return i - step;
            }
            Vertex2D v = this.original_stroke.getPoint(i);
            if ((total += Vertex2D.distance(prev_v, v)) > pull_length) {
                return i;
            }
            i += step;
            prev_v = v;
        }
        return i;
    }

    int find_local_curvature_maximum(Stroke stroke, int index, int step) {
        double curvature0 = Math.abs(this.get_curvature(stroke, index += step));
        double curvature1 = Math.abs(this.get_curvature(stroke, index += step));
        index += step;
        do {
            double curvature2 = Math.abs(this.get_curvature(stroke, index));
            if (curvature1 >= curvature0 && curvature1 >= curvature2) {
                return index - step;
            }
            curvature0 = curvature1;
            curvature1 = curvature2;
        } while ((index += step) != 0 && index != stroke.number_of_points() - 1);
        return index;
    }

    double get_curvature(Stroke stroke, int index) {
        Vertex2D v0 = stroke.getPoint(index - 1);
        Vertex2D v1 = stroke.getPoint(index);
        Vertex2D v2 = stroke.getPoint(index + 1);
        Vector2D vec0 = new Vector2D(v0, v1);
        Vector2D vec1 = new Vector2D(v1, v2);
        return Vector2D.sin(vec0, vec1);
    }

    Stroke get_smoothed_stroke(Stroke original_stroke) {
        Stroke stroke = original_stroke.get_duplicated();
        this.get_smoothed_stroke_sub(stroke);
        this.get_smoothed_stroke_sub(stroke);
        this.get_smoothed_stroke_sub(stroke);
        this.get_smoothed_stroke_sub(stroke);
        return stroke;
    }

    void get_smoothed_stroke_sub(Stroke stroke) {
        ArrayList<Vertex2D> new_points = new ArrayList<Vertex2D>();
        new_points.add(stroke.firstPoint());
        int i = 1;
        while (i < stroke.points.size() - 1) {
            Vertex2D v0 = stroke.getPoint(i - 1);
            Vertex2D v1 = stroke.getPoint(i);
            Vertex2D v2 = stroke.getPoint(i + 1);
            new_points.add(Vertex2D.mid_point(v1, Vertex2D.mid_point(v0, v2)));
            ++i;
        }
        new_points.add(stroke.lastPoint());
        stroke.points = new_points;
    }
}

