/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.AnnotatePanel;
import board.Artery;
import board.Bypass;
import board.DrawPanel;
import board.Stenosis;
import board.Stent;
import board.VesselProperty;
import board.Visual;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MyPopupMenu
extends JPopupMenu {
    private static final String[] stenosis_labels = new String[]{"delete", "property"};
    private static final String[] stent_labels = new String[]{"delete"};
    private static final String[] bypass_labels = new String[]{"delete"};
    private static final String[] artery_labels = new String[]{"delete", "property"};
    private static final String[] absent_labels = new String[]{"delete"};
    private static final String[] background_labels = new String[]{"Pull", "Smooth", "Move", "\u72ed\u7a84", "\u30b9\u30c6\u30f3\u30c8", "\u8840\u7ba1", "\u30d0\u30a4\u30d1\u30b9", "\u5074\u526f\u8840\u884c\u8def", "arrow", "text", "\u30bb\u30b0\u30e1\u30f3\u30c8\u5883\u754c\u7ddaON/OFF"};
    static MyPopupMenu stenosis_menu = new MyPopupMenu(stenosis_labels);
    static MyPopupMenu bypass_menu = new MyPopupMenu(bypass_labels);
    static MyPopupMenu artery_menu = new MyPopupMenu(artery_labels);
    static MyPopupMenu absent_menu = new MyPopupMenu(absent_labels);
    static MyPopupMenu background_menu = new MyPopupMenu(background_labels);
    static MyPopupMenu stent_menu = new MyPopupMenu(stent_labels);
    private Visual target;

    static void show_popup(Visual target, Component c, Point p) {
        if (target instanceof Stenosis) {
            stenosis_menu.show(target, c, p);
        } else if (target instanceof Stent) {
            stent_menu.show(target, c, p);
        } else if (target instanceof Bypass) {
            bypass_menu.show(target, c, p);
        } else if (target instanceof Artery) {
            if (!((Artery)target).absent) {
                artery_menu.show(target, c, p);
            } else {
                absent_menu.show(target, c, p);
            }
        } else if (target == null) {
            background_menu.show(target, c, p);
        }
    }

    public void show(Visual target, Component c, Point p) {
        this.target = target;
        super.show(c, p.x, p.y);
    }

    MyPopupMenu(String[] labels) {
        MyPopupMenuAction action = new MyPopupMenuAction();
        int i = 0;
        while (i < labels.length) {
            JMenuItem menuItem = new JMenuItem(labels[i]);
            menuItem.addActionListener(action);
            this.add(menuItem);
            ++i;
        }
    }

    class MyPopupMenuAction
    implements ActionListener {
        MyPopupMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            String label = source.getText();
            DrawPanel panel = DrawPanel.getInstance();
            Point p = panel.getLocationOnScreen();
            int posX = p.x + panel.mouse_x;
            int posY = p.y + panel.mouse_y;
            if (MyPopupMenu.this.target instanceof Stenosis) {
                Stenosis stenosis = (Stenosis)MyPopupMenu.this.target;
                if (label.equals("delete")) {
                    stenosis.delete();
                } else if (label.equals("property")) {
                    AnnotatePanel.Annotate(panel, stenosis, posX, posY);
                }
            } else if (MyPopupMenu.this.target instanceof Stent) {
                Stent stent = (Stent)MyPopupMenu.this.target;
                if (label.equals("delete")) {
                    stent.delete();
                }
            } else if (MyPopupMenu.this.target instanceof Bypass) {
                if (label.equals("delete")) {
                    ((Bypass)MyPopupMenu.this.target).delete();
                }
            } else if (MyPopupMenu.this.target instanceof Artery) {
                Artery artery = (Artery)MyPopupMenu.this.target;
                if (!artery.absent) {
                    if (label.equals("delete")) {
                        artery.delete();
                    } else if (label.equals("absent")) {
                        artery.absent = true;
                    } else if (label.equals("property")) {
                        VesselProperty.Annotate(panel, artery, posX, posY);
                    }
                } else if (label.equals("delete")) {
                    artery.delete();
                } else if (label.equals("not absent")) {
                    artery.absent = false;
                }
            } else if (MyPopupMenu.this.target == null) {
                panel.click_background(label);
            }
            panel.repaint_all();
            new SleepThread(panel).start();
        }
    }

    private static class SleepThread
    extends Thread {
        private final DrawPanel panel;

        private SleepThread(DrawPanel panel) {
            this.panel = panel;
        }

        @Override
        public void run() {
            try {
                SleepThread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.panel.repaint_all();
        }
    }
}

