/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Vector2D;
import board.Vertex2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Graphics2 {
    public static void paint_wide_stroke(Graphics g, ArrayList points, double radius_offset, boolean draw_first_cap, boolean draw_last_cap) {
        Graphics2.paint_wide_stroke_main(g, points, radius_offset, draw_first_cap, draw_last_cap, true);
    }

    public static void clip_wide_stroke(Graphics g, ArrayList points, double radius_offset, boolean draw_first_cap, boolean draw_last_cap) {
        Graphics2.paint_wide_stroke_main(g, points, radius_offset, draw_first_cap, draw_last_cap, false);
    }

    private static void paint_wide_stroke_main(Graphics g, ArrayList points, double radius_offset, boolean draw_first_cap, boolean draw_last_cap, boolean paint_or_clip) {
        ArrayList<Vertex2D> resampled = new ArrayList<Vertex2D>();
        Vertex2D prev_v = (Vertex2D)points.get(0);
        resampled.add(prev_v);
        int i = 1;
        while (i < points.size()) {
            Vertex2D v = (Vertex2D)points.get(i);
            if (Vertex2D.distance(prev_v, v) >= 1.0) {
                resampled.add(v);
                prev_v = v;
            }
            ++i;
        }
        points = resampled;
        double step_angle = 22.5;
        if (points.size() == 1) {
            return;
        }
        ArrayList strip = new ArrayList();
        int i2 = 0;
        while (i2 < points.size() - 1) {
            Vertex2D v0 = (Vertex2D)points.get(i2);
            Vertex2D v1 = (Vertex2D)points.get(i2 + 1);
            Vector2D side = Graphics2.get_side_vector(v0, v1);
            Vector2D side0 = Vector2D.multiply(side, Math.max(1.0, v0.radius + radius_offset));
            Vector2D side1 = Vector2D.multiply(side, Math.max(1.0, v1.radius + radius_offset));
            if (v0.radius + radius_offset > 0.0 && v1.radius + radius_offset > 0.0) {
                Graphics2.addPointSubtract(strip, v0, side0);
                Graphics2.addPointAdd(strip, v0, side0);
                Graphics2.addPointSubtract(strip, v1, side1);
                Graphics2.addPointAdd(strip, v1, side1);
            } else if (v0.radius + radius_offset > 0.0 && v1.radius + radius_offset <= 0.0) {
                Graphics2.addPointSubtract(strip, v0, side0);
                Graphics2.addPointAdd(strip, v0, side0);
                Graphics2.addPoint(strip, v1);
            } else if (v0.radius + radius_offset <= 0.0 && v1.radius + radius_offset > 0.0) {
                Graphics2.addPoint(strip, v0);
                Graphics2.addPointSubtract(strip, v1, side1);
                Graphics2.addPointAdd(strip, v1, side1);
            }
            if (i2 != points.size() - 2 && !(v1.radius + radius_offset <= 0.0)) {
                Vertex2D v2 = (Vertex2D)points.get(i2 + 2);
                Vector2D side2 = Vector2D.multiply(Graphics2.get_side_vector(v1, v2), Math.max(1.0, v2.radius + radius_offset));
                double angle = Vector2D.get_angle_360(side1, side2);
                if (angle > 180.0) {
                    angle -= 360.0;
                }
                int n = (int)(Math.abs(angle) / step_angle);
                double side1_length = side1.length();
                double side2_length = side2.length();
                Vector2D side1_normalized = Vector2D.normalize(side1);
                int j = 1;
                while (j < n) {
                    Vector2D vec = Vector2D.rotate(side1_normalized, angle / (double)n * (double)j);
                    vec = Vector2D.multiply(vec, (side1_length * (double)(n - j) + side2_length * (double)j) / (double)n);
                    Graphics2.addPointSubtract(strip, v1, vec);
                    Graphics2.addPointAdd(strip, v1, vec);
                    ++j;
                }
            }
            ++i2;
        }
        Graphics2.paint_strip(g, strip, paint_or_clip);
        if (draw_first_cap) {
            Graphics2.draw_cap(g, (Vertex2D)points.get(0), (Vertex2D)points.get(1), ((Vertex2D)points.get((int)0)).radius + radius_offset, step_angle, paint_or_clip);
        }
        if (draw_last_cap) {
            Graphics2.draw_cap(g, (Vertex2D)points.get(points.size() - 1), (Vertex2D)points.get(points.size() - 2), ((Vertex2D)points.get((int)(points.size() - 1))).radius + radius_offset, step_angle, paint_or_clip);
        }
    }

    public static Vector2D get_side_vector(Vector2D v0, Vector2D v1) {
        double x = v1.x - v0.x;
        double y = v1.y - v0.y;
        double length = Math.sqrt(x * x + y * y);
        double nx = x / length;
        double ny = y / length;
        return new Vector2D(ny, -nx);
    }

    public static Vector2D get_side_vector(Vector2D v0, Vector2D v1, double radius) {
        double x = v1.x - v0.x;
        double y = v1.y - v0.y;
        double length = Math.sqrt(x * x + y * y);
        double nx = x / length * radius;
        double ny = y / length * radius;
        return new Vector2D(ny, -nx);
    }

    public static void draw_cap(Graphics g, Vertex2D v0, Vertex2D v1, double radius, double step_angle, boolean paint_or_clip) {
        if (radius < 1.0) {
            return;
        }
        if (paint_or_clip) {
            ((Graphics2D)g).fill(new Ellipse2D.Double(v0.x - radius, v0.y - radius, radius * 2.0, radius * 2.0));
        } else {
            ((Graphics2D)g).clip(new Ellipse2D.Double(v0.x - radius, v0.y - radius, radius * 2.0, radius * 2.0));
        }
    }

    public static void _draw_cap(Graphics g, Vertex2D v0, Vertex2D v1, double radius, double step_angle) {
        if (radius < 1.0) {
            return;
        }
        Vector2D side0 = Graphics2.get_side_vector(v1, v0, radius);
        int n = (int)(180.0 / step_angle);
        Polygon polygon = new Polygon();
        int i = 0;
        while (i < n) {
            Vector2D side = Vector2D.rotate(side0, i * 180 / n);
            Graphics2.addPointAdd(polygon, v0, side);
            ++i;
        }
        Graphics2.addPointSubtract(polygon, v0, side0);
        g.fillPolygon(polygon);
    }

    public static void draw_box(Graphics g, Vertex2D v0, Vertex2D v1, double radius, double step_angle) {
        if (radius < 1.0) {
            return;
        }
        Vector2D new_p = Vertex2D.subtract(v0, (Vector2D)v1);
        new_p.normalize();
        Vertex2D new_point = new Vertex2D(2.0 * v0.x - v1.x, 2.0 * v0.y - v1.y);
        ((Graphics2D)g).fill(new Rectangle2D.Double(v0.x, v0.y, new_point.x, new_point.y));
    }

    static void addPointAdd(Polygon polygon, Vertex2D p, Vector2D v) {
        polygon.addPoint((int)(p.x + v.x), (int)(p.y + v.y));
    }

    static void addPointSubtract(Polygon polygon, Vertex2D p, Vector2D v) {
        polygon.addPoint((int)(p.x - v.x), (int)(p.y - v.y));
    }

    static void addPointAdd(ArrayList strip, Vertex2D p, Vector2D v) {
        strip.add(new Vertex2D(p.x + v.x, p.y + v.y));
    }

    static void addPointSubtract(ArrayList strip, Vertex2D p, Vector2D v) {
        strip.add(new Vertex2D(p.x - v.x, p.y - v.y));
    }

    static void addPoint(ArrayList strip, Vertex2D p) {
        strip.add(p);
    }

    static void paint_strip(Graphics g, ArrayList points, boolean paint_or_clip) {
        Vertex2D v;
        if (points.size() <= 2) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath polygon = new GeneralPath(1);
        Vertex2D v0 = (Vertex2D)points.get(0);
        polygon.moveTo((float)v0.x, (float)v0.y);
        int i = 1;
        while (i < points.size()) {
            v = (Vertex2D)points.get(i);
            polygon.lineTo((float)v.x, (float)v.y);
            i += 2;
        }
        i = (points.size() - 1) / 2 * 2;
        while (i > 0) {
            v = (Vertex2D)points.get(i);
            polygon.lineTo((float)v.x, (float)v.y);
            i -= 2;
        }
        polygon.lineTo((float)v0.x, (float)v0.y);
        if (paint_or_clip) {
            g2.fill(polygon);
        } else {
            g2.clip(polygon);
        }
    }

    static void _paint_strip(Graphics g, ArrayList points) {
        int i = 2;
        while (i < points.size()) {
            Vertex2D v0 = (Vertex2D)points.get(i - 2);
            Vertex2D v1 = (Vertex2D)points.get(i - 1);
            Vertex2D v2 = (Vertex2D)points.get(i - 0);
            Polygon polygon = new Polygon();
            polygon.addPoint((int)v0.x, (int)v0.y);
            polygon.addPoint((int)v1.x, (int)v1.y);
            polygon.addPoint((int)v2.x, (int)v2.y);
            g.fillPolygon(polygon);
            ++i;
        }
    }
}

