/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.AnnotateArrow;
import board.AnnotatePanel;
import board.AnnotateTextPanel;
import board.Artery;
import board.BorderLine;
import board.Buttons;
import board.ButtonsInterface;
import board.Bypass;
import board.Corateral;
import board.Main;
import board.MyPopupMenu;
import board.Pull;
import board.Record;
import board.Serialization;
import board.Smoother;
import board.Stenosis;
import board.Stent;
import board.Stroke;
import board.StrokeAnalyzer;
import board.Table;
import board.Text;
import board.Util;
import board.Vertex2D;
import board.VertexOnStroke;
import board.Vessel;
import board.VesselDrag;
import board.VesselProperty;
import board.Visual;
import board.XML;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class DrawPanel
extends JPanel
implements ButtonsInterface {
    private JFileChooser chooser = new JFileChooser();
    private int label = -1;
    int paint_vessel_id = -1;
    String paintVesselName;
    int mouse_x;
    int mouse_y;
    private static final DrawPanel INSTANCE = new DrawPanel();
    Record record;
    Hashtable name_to_cbox;
    public Stroke rootArtery;
    ArrayList strokes = new ArrayList();
    Stroke stroke = null;
    DrawPanel drawPanel;
    public static int UNIT_LENGTH = 5;
    boolean positive_undo = false;
    double travel_length;
    Smoother smoother;
    Pull pull;
    Vertex2D prev_v;
    boolean pull_started = false;
    MyTimer timer;
    boolean border_line = false;
    public int current_tool = 3;
    public static final int PULL_TOOL = 0;
    public static final int SMOOTH_TOOL = 1;
    public static final int DRAG_TOOL = 2;
    public static final int DRAW_STENOSIS = 3;
    public static final int DRAW_VESSEL = 4;
    public static final int DRAW_BYPASS = 5;
    public static final int ARROW = 6;
    public static final int DRAW_CORATERAL = 7;
    public static final int TEXT = 9;
    public static final int DRAW_STENT = 10;
    public int operation_status;
    public static final int NONE = 0;
    public static final int DRAWING = 1;
    public static final int DRAGGING = 2;
    public static final int SMOOTHING = 3;
    public static final int PULLING = 4;
    public static final int DRAWING_STENOSIS = 5;
    public static final int DRAWING_ARTERY = 6;
    public static final int DRAWING_BYPASS = 7;
    public static final int DRAWING_ARROW = 8;
    public static final int DRAWING_CORATERAL = 9;
    public static final int DRAWING_TEXT = 10;
    public static final int DRAGGING_STENOSIS = 11;
    public static final int DRAWING_STENT = 12;
    public static final int DRAGGING_STENT = 13;
    Visual picked_visual;
    public static Cursor fingerCursor;
    public static Cursor defaultCursor;
    public static Cursor pullingCursor;
    public static Cursor pullCursor;
    public static Cursor pullCursorEdge;
    public static Cursor brushCursor;
    public static Cursor brushCursorRed;
    public static Cursor brushCursorPurple;
    public static Cursor brushCursorBlue;

    public static DrawPanel getInstance() {
        return INSTANCE;
    }

    private DrawPanel() {
        MouseDispatcher mouseDispatcher = new MouseDispatcher();
        this.addMouseListener(mouseDispatcher);
        this.addMouseMotionListener(mouseDispatcher);
        this.init_record();
        Serialization.save("./temp.dat", this.record);
        this.setDoubleBuffered(true);
        this.setBackground(Color.WHITE);
    }

    private void init_record() {
        Record tmp_record = new Record();
        tmp_record.load("./default.dat");
        ArrayList vessels = Vessel.convert_strokes_to_arteries(tmp_record.getStrokes());
        this.rootArtery = (Stroke)tmp_record.getStrokes().get(0);
        this.record = new Record();
        this.record.addAll(vessels);
        Pull.clear_locked_vertices();
        this.smoother = null;
        this.repaint_all();
    }

    @Override
    public void initializeButtons(Buttons buttons) {
        buttons.addButton("quit");
        buttons.addButton("clear");
        buttons.addButton("save");
        buttons.addButton("load");
        buttons.addButton("undo");
        buttons.addButton("table");
        buttons.addButton("capture");
        buttons.addButton("export XML");
        ButtonGroup cbg = new ButtonGroup();
        String[] toolnames = new String[]{"Pull", "Move", "\u72ed\u7a84", "\u30b9\u30c6\u30f3\u30c8", "\u8840\u7ba1", "\u30d0\u30a4\u30d1\u30b9", "\u5074\u526f\u8840\u884c\u8def", "arrow", "text"};
        this.name_to_cbox = new Hashtable();
        int i = 0;
        while (i < toolnames.length) {
            String name = toolnames[i];
            MyCheckbox cbox = new MyCheckbox(name, cbg, false);
            buttons.add(cbox);
            this.name_to_cbox.put(name, cbox);
            ++i;
        }
        ((MyCheckbox)this.name_to_cbox.get("\u72ed\u7a84")).setSelected(true);
    }

    @Override
    public void buttonPressed(String label) {
        if (label.equals("quit")) {
            System.exit(0);
        } else if (label.equals("clear")) {
            this.init_record();
        } else if (label.equals("save")) {
            int returnVal = this.chooser.showSaveDialog(this);
            try {
                if (returnVal == 0) {
                    File file = this.chooser.getSelectedFile();
                    Serialization.save(file.getAbsolutePath(), this.record);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (label.equals("load")) {
            int returnVal = this.chooser.showOpenDialog(this);
            try {
                if (returnVal == 0) {
                    File file = this.chooser.getSelectedFile();
                    this.record = new Record();
                    this.record = (Record)Serialization.load(file.getAbsolutePath());
                    this.repaint_all();
                }
            }
            catch (Exception file) {}
        } else if (label.equals("undo")) {
            this.undo();
        } else if (label.equals("table")) {
            Table.main();
        } else if (label.equals("capture")) {
            int returnVal = this.chooser.showSaveDialog(this);
            try {
                if (returnVal == 0) {
                    File file = this.chooser.getSelectedFile();
                    this.store_image(file);
                }
            }
            catch (Exception file) {}
        } else if (label.equals("export XML")) {
            int returnVal = this.chooser.showSaveDialog(this);
            try {
                if (returnVal == 0) {
                    File file = this.chooser.getSelectedFile();
                    XML.save(file.toString(), this.record.getArteries());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (label.equals("Pull")) {
            this.switch_tool(0);
        } else if (label.equals("Move")) {
            this.switch_tool(2);
        } else if (label.equals("\u72ed\u7a84")) {
            this.switch_tool(3);
        } else if (label.equals("\u30b9\u30c6\u30f3\u30c8")) {
            this.switch_tool(10);
        } else if (label.equals("\u8840\u7ba1")) {
            this.switch_tool(4);
        } else if (label.equals("\u30d0\u30a4\u30d1\u30b9")) {
            this.switch_tool(5);
        } else if (label.equals("\u5074\u526f\u8840\u884c\u8def")) {
            this.switch_tool(7);
        } else if (label.equals("text")) {
            this.switch_tool(9);
        } else if (label.equals("arrow")) {
            this.switch_tool(6);
        }
    }

    public void repaint_all() {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (defaultCursor == null) {
            this.init_cursors();
            this.switch_tool(this.current_tool);
        }
        Graphics bg = g;
        this.paint_strokes(bg);
        Pull.display_locked_vertices(bg);
        if (this.pull != null && this.pull_started) {
            this.pull.display(bg);
        }
        Stenosis.paint_new_stenosis(bg);
        Stent.paint_new_stent(bg);
        bg.setFont(new Font("Helvetica", 0, 20));
        bg.setColor(Color.blue);
        if (this.paint_vessel_id != -1) {
            bg.drawString(String.valueOf(this.paintVesselName) + " (" + this.get_label() + ")", 400, 30);
        }
        if (this.stroke != null) {
            this.stroke.paint(g, false);
        }
    }

    public void paint_strokes(Graphics g) {
        Vessel.compute_rendering_radius(this.record.getArteries());
        this.paint_main_stroke(g);
        this.paint_vessels(g);
        this.paint_bypasses(g);
        this.paint_stenoses(g);
        this.paint_stents(g);
        this.paint_corateral(g);
        this.paint_annotate_arrows(g);
        this.paint_texts(g);
        this.paint_vesselID(g);
        if (this.border_line) {
            BorderLine.paint_border_lines(g, this.record);
        }
    }

    public void paint_texts(Graphics g) {
        ArrayList texts = this.record.getTexts();
        g.setFont(new Font("Helvetica", 0, 20));
        int i = 0;
        while (i < texts.size()) {
            Text text = (Text)texts.get(i);
            g.setColor(Color.black);
            g.drawString(text.s, text.x, text.y);
            ++i;
        }
    }

    public void paint_main_stroke(Graphics g) {
        this.rootArtery.paint(g, true);
    }

    public void paint_annotate_arrows(Graphics g) {
        ArrayList annotate_arrows = this.record.getAnnotateArrows();
        int i = 0;
        while (i < annotate_arrows.size()) {
            AnnotateArrow annotate_arrow = (AnnotateArrow)annotate_arrows.get(i);
            annotate_arrow.paint(g);
            ++i;
        }
    }

    public void paint_corateral(Graphics g) {
        ArrayList coraterals = this.record.getCoraterals();
        int i = 0;
        while (i < coraterals.size()) {
            Corateral corateral = (Corateral)coraterals.get(i);
            corateral.paint(g);
            ++i;
        }
    }

    public void paint_vessels(Graphics g) {
        Artery vessel;
        ArrayList vessels = this.record.getArteries();
        int i = 0;
        while (i < vessels.size()) {
            vessel = (Artery)vessels.get(i);
            vessel.paint_outside(g);
            ++i;
        }
        i = 0;
        while (i < vessels.size()) {
            vessel = (Artery)vessels.get(i);
            if (!vessel.absent) {
                vessel.paint_inside(g);
            }
            ++i;
        }
        i = 0;
        while (i < vessels.size()) {
            vessel = (Artery)vessels.get(i);
            if (vessel.bypass) {
                vessel.paint_outside(g);
            }
            ++i;
        }
        i = 0;
        while (i < vessels.size()) {
            vessel = (Artery)vessels.get(i);
            if (vessel.bypass) {
                vessel.paint_inside(g);
            }
            ++i;
        }
    }

    public void paint_vesselID(Graphics g) {
        ArrayList vessels = this.record.getVessels();
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            g.setFont(new Font("Helvetica", 0, 20));
            g.setColor(Color.black);
            Vertex2D centerPoint = vessel.getPoint(vessel.points.size() / 2);
            g.drawString("#" + vessel.id, (int)centerPoint.x, (int)centerPoint.y);
            ++i;
        }
    }

    public void paint_bypasses(Graphics g) {
        ArrayList bypasses = this.record.getBypasses();
        int i = 0;
        while (i < bypasses.size()) {
            Bypass bypass = (Bypass)bypasses.get(i);
            bypass.paint_outside(g);
            bypass.paint_inside(g);
            ++i;
        }
    }

    public void paint_stenoses(Graphics g) {
        Stenosis stenosis;
        ArrayList vessels = this.record.getVessels();
        ArrayList stenoses = new ArrayList();
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            stenoses = Util.appendArrayList(stenoses, vessel.stenoses);
            ++i;
        }
        i = 0;
        while (i < stenoses.size()) {
            stenosis = (Stenosis)stenoses.get(i);
            stenosis.paint_outside(g);
            ++i;
        }
        i = 0;
        while (i < stenoses.size()) {
            stenosis = (Stenosis)stenoses.get(i);
            stenosis.paint_inside(g);
            ++i;
        }
    }

    public void paint_stents(Graphics g) {
        ArrayList vessels = this.record.getVessels();
        ArrayList stents = new ArrayList();
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            stents = Util.appendArrayList(stents, vessel.stents);
            ++i;
        }
        i = 0;
        while (i < stents.size()) {
            Stent stent = (Stent)stents.get(i);
            stent.paint(g);
            ++i;
        }
    }

    public String get_label() {
        switch (this.label) {
            case 1: {
                return "Ostium";
            }
            case 2: {
                return "PROCIMAL";
            }
            case 3: {
                return "MIDDLE";
            }
            case 4: {
                return "DISTAL";
            }
        }
        return "";
    }

    public Visual pick(Vertex2D v) {
        ArrayList vessels = this.record.getVessels();
        Stenosis picked_stenosis = Stenosis.pick_stenosis(v, vessels);
        if (picked_stenosis != null) {
            return picked_stenosis;
        }
        Stent picked_stent = Stent.pick_stent(v, vessels);
        if (picked_stent != null) {
            return picked_stent;
        }
        return this.pick_stroke(v);
    }

    public Vessel pick_vessel(Vertex2D v) {
        return (Vessel)this.pick_stroke(v, Vessel.class);
    }

    public Bypass pick_bypass(Vertex2D v) {
        return (Bypass)this.pick_stroke(v, Bypass.class);
    }

    public Stroke pick_stroke(Vertex2D v) {
        return this.pick_stroke(v, Stroke.class);
    }

    public Stroke pick_stroke(Vertex2D v, Class classname) {
        ArrayList strokes = this.record.get(classname);
        double min = 10.0;
        Stroke stroke = null;
        int i = 0;
        while (i < strokes.size()) {
            Stroke s = (Stroke)strokes.get(i);
            double d = s.distance(v) - s.radius;
            if (d < min) {
                stroke = s;
                min = d;
            }
            ++i;
        }
        return stroke;
    }

    public void start_artery(Vertex2D v) {
        Pull.clear_locked_vertices();
        this.stroke = new Stroke();
        this.stroke.color = Color.red;
        this.stroke.radius = 8.0;
        this.stroke.index = this.record.getArteries().size() + 1;
        this.stroke.type = 1;
        this.extend_artery(v);
    }

    public void extend_artery(Vertex2D v) {
        this.stroke.addPoint(v);
        this.repaint();
    }

    public void finish_artery(Vertex2D v) {
        this.stroke = this.stroke_filter(this.stroke);
        Smoother.smooth_all(this.stroke, 3);
        if (this.stroke.points.size() > 1) {
            Artery vessel = new Artery(this.stroke);
            vessel.name = "no_name";
            VesselProperty.Annotate(this, vessel, (int)v.x, (int)v.y);
            this.record.add(vessel);
            ArrayList vessels = this.record.getArteries();
            Vessel.update_connectivity(vessels);
            Vessel.adjust_vessel_radius(vessels);
        }
        this.stroke = null;
        this.repaint_all();
    }

    public void start_bypass(Vertex2D v) {
        Pull.clear_locked_vertices();
        this.stroke = new Stroke();
        this.stroke.color = Color.magenta;
        this.stroke.radius = 8.0;
        this.stroke.index = this.record.getBypasses().size();
        this.stroke.type = 1;
        this.extend_bypass(v);
    }

    public void extend_bypass(Vertex2D v) {
        this.stroke.addPoint(v);
        this.repaint();
    }

    public void finish_bypass(Vertex2D v) {
        VertexOnStroke vertexOnStroke = Bypass.findOnVessel(v);
        this.stroke.addPoint(vertexOnStroke.v);
        this.stroke = this.stroke_filter(this.stroke);
        Smoother.smooth_all(this.stroke, 3);
        if (this.stroke.points.size() > 1) {
            Bypass bypass = new Bypass(this.stroke);
            bypass.name = "bypass";
            this.record.add(bypass);
            ArrayList vessels = this.record.getArteries();
            Vessel.update_connectivity(vessels);
            Vessel.adjust_vessel_radius(vessels);
            bypass.set_live();
        }
        this.stroke = null;
        this.repaint_all();
    }

    public void start_annotate_arrow(Vertex2D v) {
        Pull.clear_locked_vertices();
        this.stroke = new Stroke();
        this.stroke.color = Color.black;
        this.stroke.radius = 2.0;
        this.stroke.index = this.record.getAnnotateArrows().size();
        this.stroke.type = 6;
        this.extend_annotate_arrow(v);
    }

    public void extend_annotate_arrow(Vertex2D v) {
        this.stroke.addPoint(v);
        this.repaint();
    }

    public void finish_annotate_arrow(Vertex2D v) {
        AnnotateArrow arrow = new AnnotateArrow(this.stroke);
        this.record.add(arrow);
        this.stroke = null;
        this.repaint_all();
    }

    public void start_corateral(Vertex2D v) {
        Pull.clear_locked_vertices();
        this.stroke = new Stroke();
        this.stroke.color = Color.blue;
        this.stroke.radius = 2.0;
        this.stroke.index = this.record.getCoraterals().size();
        this.stroke.type = 7;
        this.extend_corateral(v);
    }

    public void extend_corateral(Vertex2D v) {
        this.stroke.addPoint(v);
        this.repaint();
    }

    public void finish_corateral(Vertex2D v) {
        this.stroke = this.stroke_filter(this.stroke);
        Smoother.smooth_all(this.stroke, 3);
        Corateral corateral = new Corateral(this.stroke);
        this.record.add(corateral);
        this.stroke = null;
        this.repaint_all();
    }

    public void start_stroke(Vertex2D v, int index) {
        Pull.clear_locked_vertices();
        ArrayList strokes = this.record.getStrokes();
        this.stroke = (Stroke)strokes.get(strokes.size() - 1);
        this.stroke = new Stroke();
        this.extend_stroke(v, index);
    }

    public void extend_stroke(Vertex2D v) {
        this.stroke.addPoint(v);
        this.repaint();
    }

    public void extend_stroke(Vertex2D v, int index) {
        this.stroke.addPoint(v);
        this.repaint();
    }

    public Vertex2D most_closest_VertexOnStroke(Vertex2D vec) {
        ArrayList strokes = this.record.getStrokes();
        double min = Double.MAX_VALUE;
        Vertex2D new_vec = new Vertex2D();
        int i = 0;
        while (i < strokes.size()) {
            Stroke stroke = (Stroke)strokes.get(strokes.size() - i - 1);
            if (stroke.radius == 8.0) {
                VertexOnStroke closest_vertex = stroke.find_closest_VertexOnStroke(vec);
                double distance = Vertex2D.distance(closest_vertex.v, vec);
                if (distance < min) {
                    new_vec = closest_vertex.v;
                    min = distance;
                }
            }
            ++i;
        }
        return new_vec;
    }

    public int most_closest_VertexOnStrokeID(Vertex2D vec) {
        ArrayList strokes = this.record.getStrokes();
        double min = Double.MAX_VALUE;
        Stroke s = new Stroke();
        int i = 0;
        while (i < strokes.size()) {
            Stroke stroke = (Stroke)strokes.get(strokes.size() - i - 1);
            if (stroke.radius == 8.0) {
                VertexOnStroke closest_vertex = stroke.find_closest_VertexOnStroke(vec);
                double distance = Vertex2D.distance(closest_vertex.v, vec);
                if (distance < min) {
                    s = closest_vertex.stroke;
                    min = distance;
                }
            }
            ++i;
        }
        return s.index;
    }

    Stroke stroke_filter(Stroke stroke) {
        return StrokeAnalyzer.resample_by_length(stroke, (double)UNIT_LENGTH);
    }

    public void undo() {
        this.positive_undo = false;
        System.out.println("undo");
        this.record = (Record)Serialization.load("./temp.dat");
        this.repaint_all();
    }

    public void save_for_undo() {
        System.out.println("save_for_undo");
        Serialization.save("./temp1.dat", this.record);
        this.positive_undo = true;
    }

    Vessel find_closest_vessel(Vertex2D v) {
        double min = 10.0;
        Vessel closest = null;
        ArrayList vessels = this.record.getVessels();
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            double d = vessel.distance(v);
            if (d < min) {
                closest = vessel;
                min = d;
            }
            ++i;
        }
        return closest;
    }

    public void start_smoothing(Vertex2D v) {
        this.travel_length = 0.0;
        this.prev_v = v;
        this.pull = Pull.start_pulling(this, v);
        if (this.pull != null) {
            this.pull_started = false;
            this.timer = new MyTimer();
            this.timer.start();
            return;
        }
        Pull.locked_vertices = new ArrayList();
        this.smoother = new Smoother(v, this);
        this.repaint_all();
    }

    public void smoothing(Vertex2D v) {
        this.travel_length += Vertex2D.distance(this.prev_v, v);
        this.prev_v = v;
        if (this.pull != null) {
            if (this.timer != null) {
                this.pull = null;
                this.timer = null;
                this.smoother = new Smoother(v, this);
                Pull.locked_vertices = new ArrayList();
                return;
            }
            this.pull_started = true;
            this.pull.pulling(v);
            this.repaint_all();
            return;
        }
        if (this.smoother.stroke == null) {
            return;
        }
        this.smoother.smooth(v);
        this.repaint_all();
    }

    public void finish_smoothing() {
        Main._setCursor(fingerCursor);
        if (this.pull != null) {
            this.pull.finish_pulling(this);
            if (this.travel_length < 10.0) {
                Pull.add_or_remove_locked_vertex(this.pull.stroke, this.pull.index);
            }
            this.pull = null;
            this.repaint_all();
            this.smoother = null;
            return;
        }
        this.smoother.finish_smoothing();
        this.smoother = null;
        this.repaint_all();
    }

    public void start_pulling(Vertex2D v) {
        this.pull = Pull.start_pulling(this, v);
        this.travel_length = 0.0;
        this.prev_v = v;
        if (this.pull != null) {
            Main._setCursor(pullingCursor);
        }
    }

    public void pulling(Vertex2D v) {
        this.travel_length += Vertex2D.distance(this.prev_v, v);
        this.prev_v = v;
        if (this.pull == null) {
            return;
        }
        this.pull_started = true;
        this.pull.pulling(v);
        this.repaint_all();
    }

    public void finish_pulling() {
        if (this.pull == null) {
            if (this.travel_length < 10.0) {
                Pull.clear_locked_vertices();
            }
            this.repaint_all();
            return;
        }
        this.pull.finish_pulling(this);
        if (this.travel_length < 10.0) {
            Pull.add_or_remove_locked_vertex(this.pull.stroke, this.pull.index);
        }
        this.pull_started = false;
        this.pull = null;
        Main._setCursor(pullCursor);
        this.repaint_all();
    }

    public void switch_tool(int tool) {
        this.current_tool = tool;
        switch (tool) {
            case 0: {
                Main._setCursor(pullCursor);
                break;
            }
            case 1: 
            case 2: {
                Main._setCursor(fingerCursor);
                break;
            }
            case 3: {
                Main._setCursor(brushCursor);
                break;
            }
            case 4: {
                Main._setCursor(brushCursorRed);
                break;
            }
            case 5: {
                Main._setCursor(brushCursorPurple);
                break;
            }
            case 6: {
                Main._setCursor(brushCursor);
                break;
            }
            case 7: {
                Main._setCursor(brushCursorBlue);
                break;
            }
            case 9: {
                Main._setCursor(Cursor.getDefaultCursor());
            }
        }
        Pull.clear_locked_vertices();
        this.repaint_all();
    }

    public boolean border_line_on_off() {
        this.border_line = !this.border_line;
        return this.border_line;
    }

    void click_background(String label) {
        System.out.println("click_background");
        String selected_tool_name = "";
        if (label.equals("Pull")) {
            selected_tool_name = "Pull";
            this.switch_tool(0);
        } else if (label.equals("Smooth")) {
            selected_tool_name = "Smooth";
            this.switch_tool(1);
        } else if (label.equals("Move")) {
            this.switch_tool(2);
            selected_tool_name = "Move";
        } else if (label.equals("\u72ed\u7a84")) {
            this.switch_tool(3);
            selected_tool_name = "\u72ed\u7a84";
        } else if (label.equals("\u30b9\u30c6\u30f3\u30c8")) {
            this.switch_tool(10);
            selected_tool_name = "\u30b9\u30c6\u30f3\u30c8";
        } else if (label.equals("\u8840\u7ba1")) {
            selected_tool_name = "\u8840\u7ba1";
            this.switch_tool(4);
        } else if (label.equals("\u30d0\u30a4\u30d1\u30b9")) {
            selected_tool_name = "\u30d0\u30a4\u30d1\u30b9";
            this.switch_tool(5);
        } else if (label.equals("\u5074\u526f\u8840\u884c\u8def")) {
            selected_tool_name = "\u5074\u526f\u8840\u884c\u8def";
            this.switch_tool(7);
        } else if (label.equals("arrow")) {
            this.switch_tool(6);
        } else if (label.equals("text")) {
            this.switch_tool(9);
        } else if (label.equals("\u30bb\u30b0\u30e1\u30f3\u30c8\u5883\u754c\u7ddaON/OFF")) {
            this.border_line_on_off();
        }
        if (!(label.equals("arrow") || label.equals("\u30bb\u30b0\u30e1\u30f3\u30c8\u5883\u754c\u7ddaON/OFF") || label.equals("text"))) {
            ((MyCheckbox)this.name_to_cbox.get(selected_tool_name)).setSelected(true);
        }
    }

    void delete_picked_object() {
        if (this.picked_visual instanceof Stenosis) {
            ((Stenosis)this.picked_visual).delete();
        } else if (this.picked_visual instanceof Artery) {
            ((Artery)this.picked_visual).delete();
        } else if (this.picked_visual instanceof Bypass) {
            ((Bypass)this.picked_visual).delete();
        } else if (this.picked_visual instanceof Corateral) {
            ((Corateral)this.picked_visual).delete();
        } else if (this.picked_visual instanceof AnnotateArrow) {
            ((AnnotateArrow)this.picked_visual).delete();
        } else if (this.picked_visual instanceof Text) {
            ((Text)this.picked_visual).delete();
        }
    }

    public void store_image(File file) {
        Dimension size = this.getSize();
        BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 1);
        Graphics g = bufferedImage.getGraphics();
        this.paint(g);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
    }

    public void init_cursors() {
        defaultCursor = Cursor.getDefaultCursor();
        fingerCursor = this.init_cursor("images/c_finger.gif", new Point(0, 0));
        pullingCursor = this.init_cursor("images/c_pulling.gif", new Point(5, 3));
        pullCursor = this.init_cursor("images/c_pull.gif", new Point(5, 3));
        pullCursorEdge = this.init_cursor("images/c_pull_edge.gif", new Point(5, 3));
        brushCursor = this.init_cursor("images/c_brush.gif", new Point(3, 4));
        brushCursorRed = this.init_cursor("images/c_brush_red.gif", new Point(3, 4));
        brushCursorPurple = this.init_cursor("images/c_brush_p.gif", new Point(3, 4));
        brushCursorBlue = this.init_cursor("images/c_brush_blue.gif", new Point(3, 4));
    }

    public Cursor init_cursor(String filename, Point hotSpot) {
        return Toolkit.getDefaultToolkit().createCustomCursor(this.loadImage(filename), hotSpot, "");
    }

    protected Image loadImage(String pathname) {
        Image image = Main.loadImage(pathname);
        if (image != null) {
            MediaTracker mt = new MediaTracker(this);
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return image;
    }

    public class MouseDispatcher
    extends MouseAdapter
    implements MouseMotionListener {
        boolean right_button;

        @Override
        public void mouseMoved(MouseEvent e) {
            DrawPanel.this.mouse_x = e.getX();
            DrawPanel.this.mouse_y = e.getY();
            Point p = e.getPoint();
            Vertex2D v = new Vertex2D(p);
            DrawPanel.this.label = 0;
            DrawPanel.this.paint_vessel_id = -1;
            ArrayList vessels = DrawPanel.this.record.getVessels();
            int i = 0;
            while (i < vessels.size()) {
                Vessel vessel = (Vessel)vessels.get(vessels.size() - i - 1);
                VertexOnStroke closest_vertex = vessel.find_closest_VertexOnStroke(v);
                double d = Vertex2D.distance(closest_vertex.v, v);
                if (d <= vessel.getPoint((int)closest_vertex.index).radius) {
                    int n = closest_vertex.stroke.points.size();
                    DrawPanel.this.paint_vessel_id = i;
                    DrawPanel.this.paintVesselName = closest_vertex.stroke.name;
                    if (closest_vertex.index < n / 4) {
                        DrawPanel.this.label = 2;
                    } else if (closest_vertex.index > n * 3 / 4) {
                        DrawPanel.this.label = 4;
                    } else {
                        DrawPanel.this.label = 3;
                    }
                    if (DrawPanel.this.current_tool == 0) {
                        if (closest_vertex.index == 0) {
                            Main._setCursor(pullCursorEdge);
                        } else if (closest_vertex.index == n - 2) {
                            Main._setCursor(pullCursorEdge);
                        } else {
                            Main._setCursor(pullCursor);
                        }
                    }
                }
                ++i;
            }
            DrawPanel.this.repaint_all();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DrawPanel.this.mouse_x = e.getX();
            DrawPanel.this.mouse_y = e.getY();
            Point p = e.getPoint();
            Vertex2D v = new Vertex2D(p);
            boolean bl = this.right_button = (e.getModifiers() & 4) != 0;
            if (this.right_button) {
                return;
            }
            switch (DrawPanel.this.current_tool) {
                case 2: {
                    DrawPanel.this.operation_status = 2;
                    VesselDrag.start_dragging(DrawPanel.this, v);
                    break;
                }
                case 3: {
                    Stenosis.classification(DrawPanel.this, v);
                    break;
                }
                case 4: {
                    DrawPanel.this.operation_status = 6;
                    DrawPanel.this.start_artery(v);
                    break;
                }
                case 10: {
                    DrawPanel.this.operation_status = 12;
                    Stent.classification(DrawPanel.this, v);
                    break;
                }
                case 5: {
                    DrawPanel.this.operation_status = 7;
                    DrawPanel.this.start_bypass(v);
                    break;
                }
                case 0: {
                    DrawPanel.this.operation_status = 4;
                    DrawPanel.this.start_pulling(v);
                    break;
                }
                case 1: {
                    DrawPanel.this.operation_status = 3;
                    DrawPanel.this.start_smoothing(v);
                    break;
                }
                case 6: {
                    DrawPanel.this.operation_status = 8;
                    DrawPanel.this.start_annotate_arrow(v);
                    break;
                }
                case 7: {
                    DrawPanel.this.operation_status = 9;
                    DrawPanel.this.start_corateral(v);
                    break;
                }
                case 9: {
                    DrawPanel.this.operation_status = 10;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DrawPanel.this.mouse_x = e.getX();
            DrawPanel.this.mouse_y = e.getY();
            Point p = e.getPoint();
            Vertex2D v = new Vertex2D(p);
            if (this.right_button) {
                return;
            }
            switch (DrawPanel.this.operation_status) {
                case 1: {
                    DrawPanel.this.extend_stroke(v);
                    break;
                }
                case 5: {
                    Stenosis.drawing_stenosis(DrawPanel.this, v);
                    break;
                }
                case 11: {
                    Stenosis.dragging_stenosis(DrawPanel.this, v);
                    break;
                }
                case 12: {
                    Stent.drawing_stent(DrawPanel.this, v);
                    break;
                }
                case 13: {
                    Stent.dragging_stent(DrawPanel.this, v);
                    break;
                }
                case 6: {
                    DrawPanel.this.extend_artery(v);
                    break;
                }
                case 7: {
                    DrawPanel.this.extend_bypass(v);
                    break;
                }
                case 8: {
                    DrawPanel.this.extend_annotate_arrow(v);
                    break;
                }
                case 2: {
                    VesselDrag.dragging(DrawPanel.this, v);
                    break;
                }
                case 3: {
                    DrawPanel.this.smoothing(v);
                    break;
                }
                case 4: {
                    DrawPanel.this.pulling(v);
                    break;
                }
                case 9: {
                    DrawPanel.this.extend_corateral(v);
                    break;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DrawPanel.this.mouse_x = e.getX();
            DrawPanel.this.mouse_y = e.getY();
            Point p = e.getPoint();
            Vertex2D v = new Vertex2D(p);
            if (this.right_button) {
                return;
            }
            switch (DrawPanel.this.operation_status) {
                case 2: {
                    VesselDrag.finish_dragging(DrawPanel.this);
                    break;
                }
                case 5: {
                    Stenosis.finish_drawing_stenosis(DrawPanel.this, v);
                    break;
                }
                case 11: {
                    Stenosis.finish_dragging_stenosis(DrawPanel.this, v);
                    break;
                }
                case 12: {
                    Stent.finish_drawing_stent(DrawPanel.this, v);
                    break;
                }
                case 13: {
                    Stent.finish_dragging_stent(DrawPanel.this, v);
                    break;
                }
                case 6: {
                    DrawPanel.this.finish_artery(v);
                    break;
                }
                case 7: {
                    DrawPanel.this.finish_bypass(v);
                    break;
                }
                case 8: {
                    DrawPanel.this.finish_annotate_arrow(v);
                    break;
                }
                case 9: {
                    DrawPanel.this.finish_corateral(v);
                    break;
                }
                case 3: {
                    DrawPanel.this.finish_smoothing();
                    break;
                }
                case 4: {
                    DrawPanel.this.finish_pulling();
                    break;
                }
                case 10: {
                    AnnotateTextPanel.AnnotateText(DrawPanel.this, DrawPanel.this.mouse_x, DrawPanel.this.mouse_y);
                }
            }
            DrawPanel.this.save_for_undo();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DrawPanel.this.mouse_x = e.getX();
            DrawPanel.this.mouse_y = e.getY();
            if (AnnotatePanel.objFrm != null && AnnotatePanel.objFrm.isVisible()) {
                AnnotatePanel.objFrm.setVisible(false);
                DrawPanel.this.repaint_all();
                return;
            }
            if (VesselProperty.objFrm != null && VesselProperty.objFrm.isVisible()) {
                VesselProperty.objFrm.setVisible(false);
                DrawPanel.this.repaint_all();
                return;
            }
            int n = e.getClickCount();
            Point p = e.getPoint();
            Vertex2D v = new Vertex2D(p);
            DrawPanel.this.picked_visual = DrawPanel.this.pick(v);
            if (!this.right_button) {
                if (n == 2 && DrawPanel.this.picked_visual instanceof Stenosis) {
                    Point p0 = DrawPanel.this.getLocationOnScreen();
                    AnnotatePanel.Annotate(DrawPanel.this, (Stenosis)DrawPanel.this.picked_visual, e.getX() + p0.x, e.getY() + p0.y);
                }
                return;
            }
            MyPopupMenu.show_popup(DrawPanel.this.picked_visual, e.getComponent(), p);
        }
    }

    private class MyCheckbox
    extends JRadioButton {
        MyCheckbox(String label, ButtonGroup group, boolean flag) {
            super(label, flag);
            group.add(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DrawPanel.this.buttonPressed(MyCheckbox.this.getText());
                }
            });
        }
    }

    class MyTimer
    extends Thread {
        MyTimer() {
        }

        @Override
        public void run() {
            try {
                MyTimer.sleep(200L);
            }
            catch (InterruptedException e) {
                System.out.println("" + e);
            }
            if (DrawPanel.this.timer != null) {
                DrawPanel.this.timer = null;
                DrawPanel.this.stroke = null;
                Main._setCursor(pullingCursor);
                DrawPanel.this.repaint_all();
            }
        }
    }
}

