/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.BLAS;
import VisualNumerics.math.DoubleMatrix;
import VisualNumerics.math.DoubleVector;
import VisualNumerics.math.MathException;

public class DoubleSVD {
    private double[][] a;
    private double[][] u;
    private double[][] v;
    private double[] s;
    private static final double SMALLEST = 2.2250738585072E-308;
    private static final double LARGEST = 1.7976931348623E308;
    private static final double EPSILON_LARGE = 2.2204460492503E-16;
    boolean usean;
    boolean wantu;
    boolean wantv;
    double ztest;
    double[] e;
    double[] work;
    double stol;
    double anorm = 0.0;
    double scale;
    double sm;
    double smm1;
    double t;
    double test;
    double emm1;
    double c;
    double sl;
    double el;
    double b;
    double shift;
    double[] t1;
    double[] f;
    double[] g;
    double[] cs;
    double[] sn;
    int irank;
    int ji;
    int nra;
    int nca;
    int ipath = 11;
    int nctp1;
    int nrtp1;
    int ncu;
    int jnfo;
    int nrt;
    int nct;
    int i = 0;
    int iter;
    int j;
    int jobu;
    int k;
    int kase;
    int kk;
    int l;
    int ll;
    int lu;
    int lls;
    int ls;
    int m;
    int maxit;
    int minmn;
    int mm;
    int mm1;
    int[] nr = new int[1];
    int[] nc = new int[1];

    public DoubleSVD(double[][] dArray) {
        this(dArray, 2.2204460492503E-14);
    }

    public DoubleSVD(double[][] dArray, double d) {
        DoubleMatrix.CheckMatrix(dArray, this.nr, this.nc);
        this.nra = this.nr[0];
        this.nca = this.nc[0];
        this.i = 0;
        while (this.i < this.nra) {
            this.anorm = Math.max(this.anorm, BLAS.dasum(this.nca, dArray[this.i], 0, 1));
            ++this.i;
        }
        this.usean = false;
        this.stol = d < 0.0 ? Math.abs(d) * this.anorm : d;
        this.maxit = 30;
        this.wantu = false;
        this.wantv = false;
        this.jobu = this.ipath % 100 / 10;
        this.ncu = this.nra;
        if (this.jobu == 2) {
            this.ncu = Math.min(this.nra, this.nca);
        }
        if (this.jobu != 0) {
            this.wantu = true;
        }
        if (this.ipath % 10 != 0) {
            this.wantv = true;
        }
        this.jnfo = 0;
        this.nct = Math.min(this.nra - 1, this.nca);
        this.nrt = Math.max(0, Math.min(this.nca - 2, this.nra));
        this.lu = Math.max(this.nct, this.nrt);
        this.e = new double[this.nca];
        this.work = new double[this.nra + Math.max(this.nra, this.nca)];
        this.s = new double[Math.min(this.nra + 1, this.nca)];
        this.u = new double[this.ncu][this.nra];
        this.v = new double[this.nca][this.nca];
        this.t1 = new double[1];
        this.f = new double[1];
        this.g = new double[1];
        this.cs = new double[1];
        this.sn = new double[1];
        this.a = DoubleMatrix.transpose(dArray);
        if (this.lu >= 1) {
            this.l = 1;
            while (this.l <= this.lu) {
                this.s[this.l - 1] = 0.0;
                if (this.l <= this.nct) {
                    this.s[this.l - 1] = BLAS.dnrm2(this.nra - this.l + 1, this.a[this.l - 1], this.l - 1, 1);
                    if (this.s[this.l - 1] >= 2.2250738585072E-308) {
                        if (this.a[this.l - 1][this.l - 1] != 0.0) {
                            this.s[this.l - 1] = Math.abs(this.s[this.l - 1]);
                            if (this.a[this.l - 1][this.l - 1] < 0.0) {
                                this.s[this.l - 1] = -this.s[this.l - 1];
                            }
                        }
                        BLAS.dscal(this.nra - this.l + 1, 1.0 / this.s[this.l - 1], this.a[this.l - 1], this.l - 1, 1);
                        this.a[this.l - 1][this.l - 1] = 1.0 + this.a[this.l - 1][this.l - 1];
                    }
                    this.s[this.l - 1] = -this.s[this.l - 1];
                }
                if (this.nca >= this.l + 1) {
                    if (this.l <= this.nct && Math.abs(this.s[this.l - 1]) >= 2.2250738585072E-308) {
                        BLAS.dgemv('T', this.nra - this.l + 1, this.nca - (this.l + 1) + 1, -1.0 / this.a[this.l - 1][this.l - 1], this.a, this.l, this.l - 1, this.nra, this.a[this.l - 1], this.l - 1, 1, 0.0, this.work, this.nra, 1);
                        BLAS.dger(this.nra - this.l + 1, this.nca - (this.l + 1) + 1, 1.0, this.a[this.l - 1], this.l - 1, 1, this.work, this.nra, 1, this.a, this.l, this.l - 1, this.nra);
                    }
                    this.i = this.l;
                    while (this.i < this.nca) {
                        this.e[this.i] = this.a[this.i][this.l - 1];
                        ++this.i;
                    }
                }
                if (this.wantu && this.l <= this.nct) {
                    this.ji = this.l - 1;
                    while (this.ji < this.nra) {
                        this.u[this.l - 1][this.ji] = this.a[this.l - 1][this.ji];
                        ++this.ji;
                    }
                }
                if (this.l <= this.nrt) {
                    this.e[this.l - 1] = BLAS.dnrm2(this.nca - this.l, this.e, this.l, 1);
                    if (this.e[this.l - 1] >= 2.2250738585072E-308) {
                        if (this.e[this.l] != 0.0) {
                            this.e[this.l - 1] = Math.abs(this.e[this.l - 1]);
                            if (this.e[this.l] < 0.0) {
                                this.e[this.l - 1] = -this.e[this.l - 1];
                            }
                        }
                        BLAS.dscal(this.nca - this.l, 1.0 / this.e[this.l - 1], this.e, this.l, 1);
                        this.e[this.l] = 1.0 + this.e[this.l];
                    }
                    this.e[this.l - 1] = -this.e[this.l - 1];
                    if (this.l + 1 <= this.nra && Math.abs(this.e[this.l - 1]) >= 2.2250738585072E-308) {
                        BLAS.dgemv('N', this.nra - this.l, this.nca - (this.l + 1) + 1, 1.0, this.a, this.l, this.l, this.nra, this.e, this.l, 1, 0.0, this.work, this.l, 1);
                        BLAS.dger(this.nra - this.l, this.nca - (this.l + 1) + 1, -1.0 / this.e[this.l], this.work, this.l, 1, this.e, this.l, 1, this.a, this.l, this.l, this.nra);
                    }
                    if (this.wantv) {
                        this.ji = this.l;
                        while (this.ji < this.nca) {
                            this.v[this.l - 1][this.ji] = this.e[this.ji];
                            ++this.ji;
                        }
                    }
                }
                ++this.l;
            }
        }
        this.m = Math.min(this.nca, this.nra + 1);
        this.nctp1 = this.nct + 1;
        this.nrtp1 = this.nrt + 1;
        if (this.nct < this.nca) {
            this.s[this.nct] = this.a[this.nct][this.nct];
        }
        if (this.nra < this.m) {
            this.s[this.m - 1] = 0.0;
        }
        if (this.nrtp1 < this.m) {
            this.e[this.nrt] = this.a[this.m - 1][this.nrt];
        }
        this.e[this.m - 1] = 0.0;
        if (this.wantu) {
            if (this.ncu >= this.nctp1) {
                this.j = this.nct;
                while (this.j < this.ncu) {
                    this.u[this.j][this.j] = 1.0;
                    ++this.j;
                }
            }
            if (this.nct >= 1) {
                this.ll = 1;
                while (this.ll <= this.nct) {
                    this.l = this.nct - this.ll + 1;
                    if (Math.abs(this.s[this.l - 1]) >= 2.2250738585072E-308) {
                        if (this.ncu >= this.l + 1) {
                            BLAS.dgemv('T', this.nra - this.l + 1, this.ncu - (this.l + 1) + 1, -1.0 / this.u[this.l - 1][this.l - 1], this.u, this.l, this.l - 1, this.nra, this.u[this.l - 1], this.l - 1, 1, 0.0, this.work, this.nra, 1);
                            BLAS.dger(this.nra - this.l + 1, this.ncu - (this.l + 1) + 1, 1.0, this.u[this.l - 1], this.l - 1, 1, this.work, this.nra, 1, this.u, this.l, this.l - 1, this.nra);
                        }
                        BLAS.dscal(this.nra - this.l + 1, -1.0, this.u[this.l - 1], this.l - 1, 1);
                        this.u[this.l - 1][this.l - 1] = 1.0 + this.u[this.l - 1][this.l - 1];
                        if (this.l - 1 >= 1) {
                            BLAS.dset(this.l - 1, 0.0, this.u[this.l - 1], 0, 1);
                        }
                    } else {
                        BLAS.dset(this.nra, 0.0, this.u[this.l - 1], 0, 1);
                        this.u[this.l - 1][this.l - 1] = 1.0;
                    }
                    ++this.ll;
                }
            }
        }
        if (this.wantv) {
            this.ll = 1;
            while (this.ll <= this.nca) {
                this.l = this.nca - this.ll + 1;
                if (this.l <= this.nrt && Math.abs(this.e[this.l - 1]) >= 2.2250738585072E-308) {
                    BLAS.dgemv('T', this.nca - this.l, this.nca - (this.l + 1) + 1, -1.0 / this.v[this.l - 1][this.l], this.v, this.l, this.l, this.nca, this.v[this.l - 1], this.l, 1, 0.0, this.work, this.nra, 1);
                    BLAS.dger(this.nca - this.l, this.nca - (this.l + 1) + 1, 1.0, this.v[this.l - 1], this.l, 1, this.work, this.nra, 1, this.v, this.l, this.l, this.nca);
                }
                BLAS.dset(this.nca, 0.0, this.v[this.l - 1], 0, 1);
                this.v[this.l - 1][this.l - 1] = 1.0;
                ++this.ll;
            }
        }
        this.mm = this.m;
        this.iter = 0;
        while (this.m != 0 && this.iter <= this.maxit) {
            this.ll = 1;
            while (this.ll <= this.m) {
                this.l = this.m - this.ll;
                if (this.l == 0) break;
                this.test = Math.abs(this.s[this.l - 1]) + Math.abs(this.s[this.l]);
                this.ztest = this.test + Math.abs(this.e[this.l - 1]);
                boolean bl = this.usean = this.usean || this.iter == this.maxit - 1;
                if (Math.abs(this.ztest - this.test) <= 2.2204460492503E-16 * this.ztest || this.usean && Math.abs(this.e[this.l - 1]) <= 2.2204460492503E-16 * this.anorm) {
                    this.e[this.l - 1] = 0.0;
                    break;
                }
                ++this.ll;
            }
            if (this.l == this.m - 1) {
                this.kase = 4;
            } else {
                this.lls = this.l + 1;
                while (this.lls <= this.m + 1) {
                    this.ls = this.m - this.lls + (this.l + 1);
                    if (this.ls == this.l) break;
                    this.test = 0.0;
                    if (this.ls != this.m) {
                        this.test += Math.abs(this.e[this.ls - 1]);
                    }
                    if (this.ls != this.l + 1) {
                        this.test += Math.abs(this.e[this.ls - 2]);
                    }
                    this.ztest = this.test + Math.abs(this.s[this.ls - 1]);
                    if (this.ztest == this.test) {
                        this.s[this.ls - 1] = 0.0;
                        break;
                    }
                    ++this.lls;
                }
                if (this.ls == this.l) {
                    this.kase = 3;
                } else if (this.ls == this.m) {
                    this.kase = 1;
                } else {
                    this.kase = 2;
                    this.l = this.ls;
                }
            }
            ++this.l;
            if (this.kase == 1) {
                this.mm1 = this.m - 1;
                this.f[0] = this.e[this.m - 2];
                this.e[this.m - 2] = 0.0;
                this.kk = this.l;
                while (this.kk <= this.mm1) {
                    this.k = this.mm1 - this.kk + this.l;
                    this.t1[0] = this.s[this.k - 1];
                    BLAS.drotg(this.t1, this.f, this.cs, this.sn);
                    this.s[this.k - 1] = this.t1[0];
                    if (this.k != this.l) {
                        this.f[0] = -this.sn[0] * this.e[this.k - 2];
                        this.e[this.k - 2] = this.cs[0] * this.e[this.k - 2];
                    }
                    if (this.wantv) {
                        BLAS.drot(this.nca, this.v[this.k - 1], 0, 1, this.v[this.m - 1], 0, 1, this.cs, this.sn);
                    }
                    ++this.kk;
                }
                continue;
            }
            if (this.kase == 2) {
                this.f[0] = this.e[this.l - 2];
                this.e[this.l - 2] = 0.0;
                this.k = this.l;
                while (this.k <= this.m) {
                    this.t1[0] = this.s[this.k - 1];
                    BLAS.drotg(this.t1, this.f, this.cs, this.sn);
                    this.s[this.k - 1] = this.t1[0];
                    this.f[0] = -this.sn[0] * this.e[this.k - 1];
                    this.e[this.k - 1] = this.cs[0] * this.e[this.k - 1];
                    if (this.wantu) {
                        BLAS.drot(this.nra, this.u[this.k - 1], 0, 1, this.u[this.l - 2], 0, 1, this.cs, this.sn);
                    }
                    ++this.k;
                }
                continue;
            }
            if (this.kase == 3) {
                this.scale = Math.max(Math.abs(this.s[this.m - 1]), Math.abs(this.s[this.m - 2]));
                this.scale = Math.max(this.scale, Math.abs(this.e[this.m - 2]));
                this.scale = Math.max(this.scale, Math.abs(this.s[this.l - 1]));
                this.scale = Math.max(this.scale, Math.abs(this.e[this.l - 1]));
                this.sm = this.s[this.m - 1] / this.scale;
                this.smm1 = this.s[this.m - 2] / this.scale;
                this.emm1 = this.e[this.m - 2] / this.scale;
                this.sl = this.s[this.l - 1] / this.scale;
                this.el = this.e[this.l - 1] / this.scale;
                this.b = ((this.smm1 + this.sm) * (this.smm1 - this.sm) + this.emm1 * this.emm1) / 2.0;
                this.c = this.sm * this.emm1 * (this.sm * this.emm1);
                this.shift = 0.0;
                if (this.b != 0.0 || this.c != 0.0) {
                    this.shift = Math.sqrt(this.b * this.b + this.c);
                    if (this.b < 0.0) {
                        this.shift = -this.shift;
                    }
                    this.shift = this.c / (this.b + this.shift);
                }
                this.f[0] = (this.sl + this.sm) * (this.sl - this.sm) - this.shift;
                this.g[0] = this.sl * this.el;
                this.mm1 = this.m - 1;
                this.k = this.l;
                while (this.k <= this.mm1) {
                    BLAS.drotg(this.f, this.g, this.cs, this.sn);
                    if (this.k != this.l) {
                        this.e[this.k - 2] = this.f[0];
                    }
                    this.f[0] = this.cs[0] * this.s[this.k - 1] + this.sn[0] * this.e[this.k - 1];
                    this.e[this.k - 1] = this.cs[0] * this.e[this.k - 1] - this.sn[0] * this.s[this.k - 1];
                    this.g[0] = this.sn[0] * this.s[this.k];
                    this.s[this.k] = this.cs[0] * this.s[this.k];
                    if (this.wantv) {
                        BLAS.drot(this.nca, this.v[this.k - 1], 0, 1, this.v[this.k], 0, 1, this.cs, this.sn);
                    }
                    BLAS.drotg(this.f, this.g, this.cs, this.sn);
                    this.s[this.k - 1] = this.f[0];
                    this.f[0] = this.cs[0] * this.e[this.k - 1] + this.sn[0] * this.s[this.k];
                    this.s[this.k] = -this.sn[0] * this.e[this.k - 1] + this.cs[0] * this.s[this.k];
                    this.g[0] = this.sn[0] * this.e[this.k];
                    this.e[this.k] = this.cs[0] * this.e[this.k];
                    if (this.wantu && this.k < this.nra) {
                        BLAS.drot(this.nra, this.u[this.k - 1], 0, 1, this.u[this.k], 0, 1, this.cs, this.sn);
                    }
                    ++this.k;
                }
                this.e[this.m - 2] = this.f[0];
                ++this.iter;
                continue;
            }
            if (this.kase != 4) continue;
            if (this.s[this.l - 1] < 0.0) {
                this.s[this.l - 1] = -this.s[this.l - 1];
                if (this.wantv) {
                    BLAS.dscal(this.nca, -1.0, this.v[this.l - 1], 0, 1);
                }
            }
            while (this.l != this.mm) {
                if (this.s[this.l - 1] < this.s[this.l]) {
                    this.t = this.s[this.l - 1];
                    this.s[this.l - 1] = this.s[this.l];
                    this.s[this.l] = this.t;
                    if (this.wantv && this.l < this.nca) {
                        BLAS.dswap(this.nca, this.v[this.l - 1], 0, 1, this.v[this.l], 0, 1);
                    }
                    if (this.wantu && this.l < this.nra) {
                        BLAS.dswap(this.nra, this.u[this.l - 1], 0, 1, this.u[this.l], 0, 1);
                    }
                }
                ++this.l;
            }
            this.iter = 0;
            --this.m;
        }
        if (this.iter > this.maxit) {
            this.jnfo = this.m;
        }
    }

    public double[] S() {
        return this.s;
    }

    public double[][] U() {
        return DoubleMatrix.transpose(this.u);
    }

    public double[][] V() {
        return DoubleMatrix.transpose(this.v);
    }

    public int info() {
        return this.jnfo + 1;
    }

    public double[][] inverse() throws MathException {
        double[][] dArray = this.U();
        double[][] dArray2 = this.V();
        double[] dArray3 = this.S();
        double[][] dArray4 = DoubleMatrix.transpose(dArray2);
        int n = 0;
        n = this.rank();
        int n2 = dArray3.length;
        double[] dArray5 = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray5[n3] = Math.abs(dArray3[n3]) < this.stol ? 0.0 : 1.0 / dArray3[n3];
            ++n3;
        }
        double[][] dArray6 = DoubleMatrix.zero(this.nca, this.nra);
        if (n != 0) {
            int n4 = 0;
            while (n4 < Math.min(this.nca, this.nra)) {
                DoubleVector.scale(dArray5[n4], dArray4[n4]);
                ++n4;
            }
            double[][] dArray7 = DoubleMatrix.transpose(dArray4);
            double[][] dArray8 = DoubleMatrix.transpose(dArray);
            int n5 = 0;
            while (n5 < dArray7.length) {
                int n6 = 0;
                while (n6 < dArray8[0].length) {
                    int n7 = 0;
                    while (n7 < Math.min(dArray7[0].length, dArray8.length)) {
                        double[] dArray9 = dArray6[n5];
                        int n8 = n6;
                        dArray9[n8] = dArray9[n8] + dArray7[n5][n7] * dArray8[n7][n6];
                        ++n7;
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        return dArray6;
    }

    public int rank() throws MathException {
        if (this.jnfo == 0) {
            this.ls = Math.min(this.nca + 1, this.nra);
            this.irank = this.minmn = Math.min(this.nca, this.nra);
            this.i = 1;
            while (this.i <= this.minmn) {
                if (Math.abs(this.s[this.i - 1]) <= this.stol) {
                    this.irank = this.i - 1;
                    return this.irank;
                }
                ++this.i;
            }
        } else {
            ++this.jnfo;
            throw new MathException("Rank can not be determined because convergence can only be obtained for the " + this.jnfo + ",...," + Math.min(this.nra, this.nca) + " singular values and their corresponding singular vectors.");
        }
        return this.irank;
    }
}

