/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.BLAS;
import VisualNumerics.math.BLASA;
import VisualNumerics.math.Complex;
import VisualNumerics.math.ComplexA;
import VisualNumerics.math.ComplexMatrix;
import VisualNumerics.math.ComplexVector;
import VisualNumerics.math.MathException;

public class ComplexSVD {
    private double[][][] a;
    private double[][][] u;
    private double[][][] v;
    private double[][] s;
    private static final double SMALLEST = 2.2250738585072E-308;
    private static final double LARGEST = 1.7976931348623E308;
    private static final double EPSILON_LARGE = 2.2204460492503E-16;
    boolean usean;
    boolean wantu;
    boolean wantv;
    double ztest;
    double[][] e;
    double[][] work;
    double[] r;
    double[] t;
    double[] ztmp;
    double[] zero;
    double[] one;
    double[] negone;
    double[] dtmp = new double[2];
    double stol;
    double anorm = 0.0;
    double scale;
    double sm;
    double smm1;
    double test;
    double emm1;
    double c;
    double sl;
    double el;
    double b;
    double shift;
    double[] t1;
    double[] f;
    double[] g;
    double[] cs;
    double[] sn;
    int irank;
    int ji;
    int nra;
    int nca;
    int ipath = 11;
    int nctp1;
    int nrtp1;
    int ncu;
    int jnfo;
    int nrt;
    int nct;
    int i = 0;
    int iter;
    int j;
    int jobu;
    int k;
    int kase;
    int kk;
    int l;
    int ll;
    int lu;
    int lls;
    int ls;
    int m;
    int maxit;
    int minmn;
    int mm;
    int mm1;
    int[] nr = new int[1];
    int[] nc = new int[1];

    public ComplexSVD(Complex[][] complexArray) {
        this(complexArray, 2.2204460492503E-14);
    }

    public ComplexSVD(Complex[][] complexArray, double d) throws IllegalArgumentException {
        int n;
        ComplexMatrix.CheckMatrix(complexArray, this.nr, this.nc);
        this.nra = this.nr[0];
        this.nca = this.nc[0];
        this.i = 0;
        while (this.i < this.nra) {
            this.anorm = Math.max(this.anorm, BLAS.dzasum(this.nca, complexArray[this.i], 0, 1));
            ++this.i;
        }
        this.usean = false;
        this.stol = d < 0.0 ? Math.abs(d) * this.anorm : d;
        this.maxit = 30;
        this.wantu = false;
        this.wantv = false;
        this.jobu = this.ipath % 100 / 10;
        this.ncu = this.nra;
        if (this.jobu == 2) {
            this.ncu = Math.min(this.nra, this.nca);
        }
        if (this.jobu != 0) {
            this.wantu = true;
        }
        if (this.ipath % 10 != 0) {
            this.wantv = true;
        }
        this.jnfo = 0;
        this.nct = Math.min(this.nra - 1, this.nca);
        this.nrt = Math.max(0, Math.min(this.nca - 2, this.nra));
        this.lu = Math.max(this.nct, this.nrt);
        this.e = new double[this.nca][2];
        this.work = new double[this.nra + Math.max(this.nra, this.nca)][2];
        this.s = new double[Math.min(this.nra + 1, this.nca)][2];
        this.u = new double[this.ncu][this.nra][2];
        this.v = new double[this.nca][this.nca][2];
        this.t1 = new double[1];
        this.f = new double[1];
        this.g = new double[1];
        this.cs = new double[1];
        this.sn = new double[1];
        this.a = new double[this.nca][this.nra][2];
        int n2 = 0;
        while (n2 < this.nra) {
            n = 0;
            while (n < this.nca) {
                this.a[n][n2][0] = complexArray[n2][n].re;
                this.a[n][n2][1] = complexArray[n2][n].im;
                ++n;
            }
            ++n2;
        }
        this.zero = new double[2];
        this.zero[0] = 0.0;
        this.zero[1] = 0.0;
        this.one = new double[2];
        this.one[0] = 1.0;
        this.one[1] = 0.0;
        this.negone = new double[2];
        this.negone[0] = -1.0;
        this.negone[1] = 0.0;
        this.t = new double[2];
        if (this.lu >= 1) {
            this.l = 1;
            while (this.l <= this.lu) {
                this.s[this.l - 1][0] = 0.0;
                this.s[this.l - 1][1] = 0.0;
                if (this.l <= this.nct) {
                    this.s[this.l - 1][0] = BLASA.dznrm2(this.nra - this.l + 1, this.a[this.l - 1], this.l - 1, 1);
                    this.s[this.l - 1][1] = 0.0;
                    if (ComplexA.zabs1(this.s[this.l - 1]) >= 2.2250738585072E-308) {
                        if (ComplexA.zabs1(this.a[this.l - 1][this.l - 1]) != 0.0) {
                            this.ztmp = ComplexA.divide(this.a[this.l - 1][this.l - 1], ComplexA.abs(this.a[this.l - 1][this.l - 1]));
                            ComplexA.multiply(this.ztmp, ComplexA.abs(this.s[this.l - 1]));
                            this.s[this.l - 1][0] = this.ztmp[0];
                            this.s[this.l - 1][1] = this.ztmp[1];
                            this.ztmp = ComplexA.divide(this.one, this.s[this.l - 1]);
                            BLASA.zscal(this.nra - this.l + 1, this.ztmp, this.a[this.l - 1], this.l - 1, 1);
                            ComplexA.add(this.a[this.l - 1][this.l - 1], this.one);
                        }
                        ComplexA.multiply(this.s[this.l - 1], this.negone);
                    }
                }
                if (this.nca >= this.l + 1) {
                    if (this.l <= this.nct && ComplexA.zabs1(this.s[this.l - 1]) >= 2.2250738585072E-308) {
                        this.ztmp = ComplexA.divide(this.negone, ComplexA.conjugate(this.a[this.l - 1][this.l - 1]));
                        BLASA.zgemv('C', this.nra - this.l + 1, this.nca - (this.l + 1) + 1, this.ztmp, this.a, this.l, this.l - 1, this.nra, this.a[this.l - 1], this.l - 1, 1, this.zero, this.work, this.l, 1);
                        BLASA.zgerc(this.nra - this.l + 1, this.nca - (this.l + 1) + 1, this.one, this.a[this.l - 1], this.l - 1, 1, this.work, this.l, 1, this.a, this.l, this.l - 1, this.nra);
                    }
                    this.i = this.l;
                    while (this.i < this.nca) {
                        this.e[this.i][0] = this.a[this.i][this.l - 1][0];
                        this.e[this.i][1] = -this.a[this.i][this.l - 1][1];
                        ++this.i;
                    }
                }
                if (this.wantu && this.l <= this.nct) {
                    this.ji = this.l - 1;
                    while (this.ji < this.nra) {
                        this.u[this.l - 1][this.ji][0] = this.a[this.l - 1][this.ji][0];
                        this.u[this.l - 1][this.ji][1] = this.a[this.l - 1][this.ji][1];
                        ++this.ji;
                    }
                }
                if (this.l <= this.nrt) {
                    this.e[this.l - 1][0] = BLASA.dznrm2(this.nca - this.l, this.e, this.l, 1);
                    this.e[this.l - 1][1] = 0.0;
                    if (ComplexA.zabs1(this.e[this.l - 1]) >= 2.2250738585072E-308 && ComplexA.zabs1(this.e[this.l]) != 0.0) {
                        this.ztmp = ComplexA.divide(this.e[this.l], ComplexA.abs(this.e[this.l]));
                        ComplexA.multiply(this.ztmp, ComplexA.abs(this.e[this.l - 1]));
                        this.e[this.l - 1][0] = this.ztmp[0];
                        this.e[this.l - 1][1] = this.ztmp[1];
                        this.ztmp = ComplexA.divide(this.one, this.e[this.l - 1]);
                        BLASA.zscal(this.nca - this.l, this.ztmp, this.e, this.l, 1);
                        ComplexA.add(this.e[this.l], this.one);
                    }
                    double[] dArray = this.e[this.l - 1];
                    dArray[0] = dArray[0] * -1.0;
                    if (this.l + 1 <= this.nra && ComplexA.zabs1(this.e[this.l - 1]) >= 2.2250738585072E-308) {
                        BLASA.zgemv('N', this.nra - this.l, this.nca - (this.l + 1) + 1, this.one, this.a, this.l, this.l, this.nra, this.e, this.l, 1, this.zero, this.work, this.l, 1);
                        this.ztmp = ComplexA.divide(this.negone, ComplexA.conjugate(this.e[this.l]));
                        BLASA.zgerc(this.nra - this.l, this.nca - (this.l + 1) + 1, this.ztmp, this.work, this.l, 1, this.e, this.l, 1, this.a, this.l, this.l, this.nra);
                    }
                    if (this.wantv) {
                        this.ji = this.l;
                        while (this.ji < this.nca) {
                            this.v[this.l - 1][this.ji][0] = this.e[this.ji][0];
                            this.v[this.l - 1][this.ji][1] = this.e[this.ji][1];
                            ++this.ji;
                        }
                    }
                }
                ++this.l;
            }
        }
        this.m = Math.min(this.nca, this.nra + 1);
        this.nctp1 = this.nct + 1;
        this.nrtp1 = this.nrt + 1;
        if (this.nct < this.nca) {
            this.s[this.nct][0] = this.a[this.nct][this.nct][0];
            this.s[this.nct][1] = this.a[this.nct][this.nct][1];
        }
        if (this.nra < this.m) {
            this.s[this.m - 1][0] = 0.0;
            this.s[this.m - 1][1] = 0.0;
        }
        if (this.nrtp1 < this.m) {
            this.e[this.nrt][0] = this.a[this.m - 1][this.nrt][0];
            this.e[this.nrt][1] = this.a[this.m - 1][this.nrt][1];
        }
        this.e[this.m - 1][0] = 0.0;
        this.e[this.m - 1][1] = 0.0;
        if (this.wantu) {
            if (this.ncu >= this.nctp1) {
                this.j = this.nct;
                while (this.j < this.ncu) {
                    BLASA.zset(this.nra, this.zero, this.u[this.j], 0, 1);
                    this.u[this.j][this.j][0] = 1.0;
                    this.u[this.j][this.j][1] = 0.0;
                    ++this.j;
                }
            }
            if (this.nct >= 1) {
                this.ll = 1;
                while (this.ll <= this.nct) {
                    this.l = this.nct - this.ll + 1;
                    if (ComplexA.zabs1(this.s[this.l - 1]) >= 2.2250738585072E-308) {
                        this.ztmp = ComplexA.divide(this.negone, ComplexA.conjugate(this.u[this.l - 1][this.l - 1]));
                        BLASA.zgemv('C', this.nra - this.l + 1, this.ncu - (this.l + 1) + 1, this.ztmp, this.u, this.l, this.l - 1, this.nra, this.u[this.l - 1], this.l - 1, 1, this.zero, this.work, this.nra, 1);
                        BLASA.zgerc(this.nra - this.l + 1, this.ncu - (this.l + 1) + 1, this.one, this.u[this.l - 1], this.l - 1, 1, this.work, this.nra, 1, this.u, this.l, this.l - 1, this.nra);
                        BLASA.zscal(this.nra - this.l + 1, this.negone, this.u[this.l - 1], this.l - 1, 1);
                        ComplexA.add(this.u[this.l - 1][this.l - 1], this.one);
                        BLASA.zset(this.l - 1, this.zero, this.u[this.l - 1], 0, 1);
                    } else {
                        BLASA.zset(this.nra, this.zero, this.u[this.l - 1], 0, 1);
                        this.u[this.l - 1][this.l - 1][0] = 1.0;
                        this.u[this.l - 1][this.l - 1][1] = 0.0;
                    }
                    ++this.ll;
                }
            }
        }
        if (this.wantv) {
            this.ll = 1;
            while (this.ll <= this.nca) {
                this.l = this.nca - this.ll + 1;
                if (this.l <= this.nrt && ComplexA.zabs1(this.e[this.l - 1]) >= 2.2250738585072E-308) {
                    this.ztmp = ComplexA.divide(this.negone, ComplexA.conjugate(this.v[this.l - 1][this.l]));
                    BLASA.zgemv('C', this.nca - this.l, this.nca - (this.l + 1) + 1, this.ztmp, this.v, this.l, this.l, this.nca, this.v[this.l - 1], this.l, 1, this.zero, this.work, this.nra, 1);
                    BLASA.zgerc(this.nca - this.l, this.nca - (this.l + 1) + 1, this.one, this.v[this.l - 1], this.l, 1, this.work, this.nra, 1, this.v, this.l, this.l, this.nca);
                }
                BLASA.zset(this.nca, this.zero, this.v[this.l - 1], 0, 1);
                this.v[this.l - 1][this.l - 1][0] = 1.0;
                this.v[this.l - 1][this.l - 1][1] = 0.0;
                ++this.ll;
            }
        }
        this.i = 0;
        while (this.i < this.m) {
            if (ComplexA.zabs1(this.s[this.i]) >= 2.2250738585072E-308) {
                this.t[0] = ComplexA.abs(this.s[this.i]);
                this.t[1] = 0.0;
                this.r = ComplexA.divide(this.s[this.i], this.t);
                this.s[this.i][0] = this.t[0];
                this.s[this.i][1] = this.t[1];
                if (this.i < this.m - 1) {
                    this.e[this.i] = ComplexA.divide(this.e[this.i], this.r);
                }
                if (this.wantu) {
                    BLASA.zscal(this.nra, this.r, this.u[this.i], 0, 1);
                }
            }
            if (this.i != this.m - 1 && ComplexA.zabs1(this.e[this.i]) >= 2.2250738585072E-308) {
                this.t[0] = ComplexA.abs(this.e[this.i]);
                this.t[1] = 0.0;
                this.r = ComplexA.divide(this.t, this.e[this.i]);
                this.e[this.i][0] = this.t[0];
                this.e[this.i][1] = this.t[1];
                ComplexA.multiply(this.s[this.i + 1], this.r);
                if (this.wantv) {
                    BLASA.zscal(this.nca, this.r, this.v[this.i + 1], 0, 1);
                }
            }
            ++this.i;
        }
        this.mm = this.m;
        this.iter = 0;
        while (this.m != 0 && this.iter <= this.maxit) {
            this.usean = this.usean || this.iter == this.maxit - 1;
            this.ll = 1;
            while (this.ll <= this.m) {
                this.l = this.m - this.ll;
                if (this.l == 0) break;
                this.test = ComplexA.abs(this.s[this.l - 1]) + ComplexA.abs(this.s[this.l]);
                this.ztest = this.test + ComplexA.abs(this.e[this.l - 1]);
                if (Math.abs(this.ztest - this.test) <= 2.2204460492503E-16 * this.ztest || this.usean && ComplexA.abs(this.e[this.l - 1]) <= 2.2204460492503E-16 * this.anorm) {
                    this.e[this.l - 1][0] = 0.0;
                    this.e[this.l - 1][1] = 0.0;
                    break;
                }
                ++this.ll;
            }
            if (this.l == this.m - 1) {
                this.kase = 4;
            } else {
                this.lls = this.l + 1;
                while (this.lls <= this.m + 1) {
                    this.ls = this.m - this.lls + (this.l + 1);
                    if (this.ls == this.l) break;
                    this.test = 0.0;
                    if (this.ls != this.m) {
                        this.test += ComplexA.abs(this.e[this.ls - 1]);
                    }
                    if (this.ls != this.l + 1) {
                        this.test += ComplexA.abs(this.e[this.ls - 2]);
                    }
                    this.ztest = this.test + ComplexA.abs(this.s[this.ls - 1]);
                    if (this.ztest == this.test || this.usean && ComplexA.abs(this.s[this.ls - 1]) <= 2.2204460492503E-16 * this.anorm) {
                        this.s[this.ls - 1][0] = 0.0;
                        this.s[this.ls - 1][1] = 0.0;
                        break;
                    }
                    ++this.lls;
                }
                if (this.ls == this.l) {
                    this.kase = 3;
                } else if (this.ls == this.m) {
                    this.kase = 1;
                } else {
                    this.kase = 2;
                    this.l = this.ls;
                }
            }
            ++this.l;
            if (this.kase == 1) {
                this.mm1 = this.m - 1;
                this.f[0] = this.e[this.m - 2][0];
                this.e[this.m - 2][0] = 0.0;
                this.e[this.m - 2][1] = 0.0;
                this.kk = this.l;
                while (this.kk <= this.mm1) {
                    this.k = this.mm1 - this.kk + this.l;
                    this.t1[0] = this.s[this.k - 1][0];
                    BLAS.drotg(this.t1, this.f, this.cs, this.sn);
                    this.s[this.k - 1][0] = this.t1[0];
                    this.s[this.k - 1][1] = 0.0;
                    if (this.k != this.l) {
                        this.f[0] = -this.sn[0] * this.e[this.k - 2][0];
                        ComplexA.multiply(this.e[this.k - 2], this.cs[0]);
                    }
                    if (this.wantv) {
                        BLASA.zdrot(this.nca, this.v[this.k - 1], 0, 1, this.v[this.m - 1], 0, 1, this.cs, this.sn);
                    }
                    ++this.kk;
                }
                continue;
            }
            if (this.kase == 2) {
                this.f[0] = this.e[this.l - 2][0];
                this.e[this.l - 2][0] = 0.0;
                this.e[this.l - 2][1] = 0.0;
                this.k = this.l;
                while (this.k <= this.m) {
                    this.t1[0] = this.s[this.k - 1][0];
                    BLAS.drotg(this.t1, this.f, this.cs, this.sn);
                    this.s[this.k - 1][0] = this.t1[0];
                    this.s[this.k - 1][1] = 0.0;
                    this.f[0] = -this.sn[0] * this.e[this.k - 1][0];
                    ComplexA.multiply(this.e[this.k - 1], this.cs[0]);
                    if (this.wantu) {
                        BLASA.zdrot(this.nra, this.u[this.k - 1], 0, 1, this.u[this.l - 2], 0, 1, this.cs, this.sn);
                    }
                    ++this.k;
                }
                continue;
            }
            if (this.kase == 3) {
                this.scale = Math.max(ComplexA.abs(this.s[this.m - 1]), ComplexA.abs(this.s[this.m - 2]));
                this.scale = Math.max(this.scale, ComplexA.abs(this.e[this.m - 2]));
                this.scale = Math.max(this.scale, ComplexA.abs(this.s[this.l - 1]));
                this.scale = Math.max(this.scale, ComplexA.abs(this.e[this.l - 1]));
                this.sm = this.s[this.m - 1][0] / this.scale;
                this.smm1 = this.s[this.m - 2][0] / this.scale;
                this.emm1 = this.e[this.m - 2][0] / this.scale;
                this.sl = this.s[this.l - 1][0] / this.scale;
                this.el = this.e[this.l - 1][0] / this.scale;
                this.b = ((this.smm1 + this.sm) * (this.smm1 - this.sm) + this.emm1 * this.emm1) / 2.0;
                this.c = this.sm * this.emm1 * (this.sm * this.emm1);
                this.shift = 0.0;
                if (this.b != 0.0 || this.c != 0.0) {
                    this.shift = Math.sqrt(this.b * this.b + this.c);
                    if (this.b < 0.0) {
                        this.shift = -this.shift;
                    }
                    this.shift = this.c / (this.b + this.shift);
                }
                this.f[0] = (this.sl + this.sm) * (this.sl - this.sm) - this.shift;
                this.g[0] = this.sl * this.el;
                this.mm1 = this.m - 1;
                this.k = this.l;
                while (this.k <= this.mm1) {
                    BLAS.drotg(this.f, this.g, this.cs, this.sn);
                    if (this.k != this.l) {
                        this.e[this.k - 2][0] = this.f[0];
                        this.e[this.k - 2][1] = 0.0;
                    }
                    this.f[0] = this.cs[0] * this.s[this.k - 1][0] + this.sn[0] * this.e[this.k - 1][0];
                    this.ztmp[0] = this.sn[0] * this.s[this.k - 1][0];
                    this.ztmp[1] = this.sn[0] * this.s[this.k - 1][1];
                    ComplexA.multiply(this.e[this.k - 1], this.cs[0]);
                    ComplexA.subtract(this.e[this.k - 1], this.ztmp);
                    this.g[0] = this.sn[0] * this.s[this.k][0];
                    ComplexA.multiply(this.s[this.k], this.cs[0]);
                    if (this.wantv) {
                        BLASA.zdrot(this.nca, this.v[this.k - 1], 0, 1, this.v[this.k], 0, 1, this.cs, this.sn);
                    }
                    BLAS.drotg(this.f, this.g, this.cs, this.sn);
                    this.s[this.k - 1][0] = this.f[0];
                    this.s[this.k - 1][1] = 0.0;
                    this.f[0] = this.cs[0] * this.e[this.k - 1][0] + this.sn[0] * this.s[this.k][0];
                    this.ztmp[0] = -this.sn[0] * this.e[this.k - 1][0];
                    this.ztmp[1] = -this.sn[0] * this.e[this.k - 1][1];
                    ComplexA.multiply(this.s[this.k], this.cs[0]);
                    ComplexA.add(this.s[this.k], this.ztmp);
                    this.g[0] = this.sn[0] * this.e[this.k][0];
                    ComplexA.multiply(this.e[this.k], this.cs[0]);
                    if (this.wantu && this.k < this.nra) {
                        BLASA.zdrot(this.nra, this.u[this.k - 1], 0, 1, this.u[this.k], 0, 1, this.cs, this.sn);
                    }
                    ++this.k;
                }
                this.e[this.m - 2][0] = this.f[0];
                this.e[this.m - 2][1] = 0.0;
                ++this.iter;
                continue;
            }
            if (this.kase != 4) continue;
            if (this.s[this.l - 1][0] < 0.0) {
                ComplexA.multiply(this.s[this.l - 1], this.negone);
                if (this.wantv) {
                    BLASA.zscal(this.nca, this.negone, this.v[this.l - 1], 0, 1);
                }
            }
            while (this.l != this.mm) {
                if (this.s[this.l - 1][0] < this.s[this.l][0]) {
                    this.t[0] = this.s[this.l - 1][0];
                    this.t[1] = this.s[this.l - 1][1];
                    this.s[this.l - 1][0] = this.s[this.l][0];
                    this.s[this.l - 1][1] = this.s[this.l][1];
                    this.s[this.l][0] = this.t[0];
                    this.s[this.l][1] = this.t[1];
                    if (this.wantv && this.l < this.nca) {
                        n = 0;
                        while (n < this.nca) {
                            this.dtmp[0] = this.v[this.l - 1][n][0];
                            this.dtmp[1] = this.v[this.l - 1][n][1];
                            this.v[this.l - 1][n][0] = this.v[this.l][n][0];
                            this.v[this.l - 1][n][1] = this.v[this.l][n][1];
                            this.v[this.l][n][0] = this.dtmp[0];
                            this.v[this.l][n][1] = this.dtmp[1];
                            ++n;
                        }
                    }
                    if (this.wantu && this.l < this.nra) {
                        n = 0;
                        while (n < this.nra) {
                            this.dtmp[0] = this.u[this.l - 1][n][0];
                            this.dtmp[1] = this.u[this.l - 1][n][1];
                            this.u[this.l - 1][n][0] = this.u[this.l][n][0];
                            this.u[this.l - 1][n][1] = this.u[this.l][n][1];
                            this.u[this.l][n][0] = this.dtmp[0];
                            this.u[this.l][n][1] = this.dtmp[1];
                            ++n;
                        }
                    }
                }
                ++this.l;
            }
            this.iter = 0;
            --this.m;
        }
        if (this.iter > this.maxit) {
            this.jnfo = this.m;
        }
    }

    public Complex[] S() {
        int n = this.s.length;
        Complex[] complexArray = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex(this.s[n2][0], this.s[n2][1]);
            ++n2;
        }
        return complexArray;
    }

    public Complex[][] U() {
        int n = this.u.length;
        int n2 = this.u[0].length;
        Complex[][] complexArray = new Complex[n2][n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray[n4][n3] = new Complex(this.u[n3][n4][0], this.u[n3][n4][1]);
                ++n4;
            }
            ++n3;
        }
        return complexArray;
    }

    public Complex[][] V() {
        int n = this.v.length;
        int n2 = this.v[0].length;
        Complex[][] complexArray = new Complex[n2][n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray[n4][n3] = new Complex(this.v[n3][n4][0], this.v[n3][n4][1]);
                ++n4;
            }
            ++n3;
        }
        return complexArray;
    }

    public int info() {
        return this.jnfo + 1;
    }

    public Complex[][] inverse() {
        Complex complex = new Complex(1.0);
        Complex[][] complexArray = this.U();
        Complex[][] complexArray2 = this.V();
        Complex[] complexArray3 = this.S();
        Complex[][] complexArray4 = ComplexMatrix.transpose(complexArray2);
        int n = 0;
        try {
            n = this.rank();
        }
        catch (MathException mathException) {
            mathException.toString();
        }
        int n2 = complexArray3.length;
        Complex[] complexArray5 = new Complex[n2];
        int n3 = 0;
        while (n3 < n2) {
            complexArray5[n3] = Complex.zabs1(complexArray3[n3]) < this.stol ? new Complex() : Complex.divide(complex, complexArray3[n3]);
            ++n3;
        }
        Complex[][] complexArray6 = ComplexMatrix.zero(this.nca, this.nra);
        if (n != 0) {
            int n4 = 0;
            while (n4 < Math.min(this.nca, this.nra)) {
                ComplexVector.multiplyEq(complexArray4[n4], complexArray5[n4]);
                ++n4;
            }
            Complex[][] complexArray7 = ComplexMatrix.transpose(complexArray4);
            Complex[][] complexArray8 = ComplexMatrix.adjoint(complexArray);
            int n5 = 0;
            while (n5 < complexArray7.length) {
                int n6 = 0;
                while (n6 < complexArray8[0].length) {
                    int n7 = 0;
                    while (n7 < Math.min(complexArray7[0].length, complexArray8.length)) {
                        complexArray6[n5][n6].add(Complex.multiply(complexArray7[n5][n7], complexArray8[n7][n6]));
                        ++n7;
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        return complexArray6;
    }

    public int rank() throws MathException {
        if (this.jnfo == 0) {
            this.ls = Math.min(this.nca + 1, this.nra);
            this.irank = this.minmn = Math.min(this.nca, this.nra);
            this.i = 1;
            while (this.i <= this.minmn) {
                if (ComplexA.zabs1(this.s[this.i - 1]) <= this.stol) {
                    this.irank = this.i - 1;
                    return this.irank;
                }
                ++this.i;
            }
        } else {
            ++this.jnfo;
            throw new MathException("Rank can not be determined because convergence can only be obtained for the " + this.jnfo + ",...," + Math.min(this.nra, this.nca) + " singular values and their corresponding singular vectors.");
        }
        return this.irank;
    }
}

