/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.BLAS;
import VisualNumerics.math.DoubleMatrix;
import VisualNumerics.math.MathException;

public class DoubleQR {
    private double[][] qr;
    private double[] qraux;
    private int[] jpvt;
    private int nra;
    private int nca;
    private static final double SMALLEST = 2.2250738585072E-308;
    private static final double LARGEST = 1.7976931348623E308;
    private static final double EPSILON_LARGE = 2.2204460492503E-16;

    public DoubleQR(double[][] dArray) throws IllegalArgumentException {
        int n;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        this.nra = n2;
        this.nca = n3;
        int n4 = Math.min(n2, n3);
        this.jpvt = new int[1];
        this.qr = DoubleMatrix.transpose(dArray);
        this.qraux = new double[n3];
        this.jpvt = new int[n3];
        double[] dArray2 = new double[n3];
        int n5 = 1;
        int n6 = 0;
        int n7 = 1;
        while (n7 <= n3) {
            boolean bl = this.jpvt[n7 - 1] > 0;
            boolean bl2 = this.jpvt[n7 - 1] < 0;
            this.jpvt[n7 - 1] = n7;
            if (bl2) {
                this.jpvt[n7 - 1] = -n7;
            }
            if (bl) {
                if (n7 != n5) {
                    BLAS.dswap(n2, this.qr[n5 - 1], 0, 1, this.qr[n7 - 1], 0, 1);
                }
                this.jpvt[n7 - 1] = this.jpvt[n5 - 1];
                this.jpvt[n5 - 1] = n7;
                ++n5;
            }
            ++n7;
        }
        n6 = n3;
        n7 = n3;
        while (n7 >= 1) {
            if (this.jpvt[n7 - 1] < 0) {
                this.jpvt[n7 - 1] = -this.jpvt[n7 - 1];
                if (n7 != n6) {
                    BLAS.dswap(n2, this.qr[n6 - 1], 0, 1, this.qr[n7 - 1], 0, 1);
                    n = this.jpvt[n6 - 1];
                    this.jpvt[n6 - 1] = this.jpvt[n7 - 1];
                    this.jpvt[n7 - 1] = n;
                }
                --n6;
            }
            --n7;
        }
        if (n6 >= n5) {
            n7 = n5;
            while (n7 <= n6) {
                this.qraux[n7 - 1] = BLAS.dnrm2(n2, this.qr[n7 - 1], 0, 1);
                dArray2[n7 - 1] = this.qraux[n7 - 1];
                ++n7;
            }
        }
        n4 = Math.min(n2, n3);
        int n8 = 1;
        while (n8 <= n4) {
            double d;
            if (n8 >= n5 && n8 < n6) {
                double d2 = 0.0;
                int n9 = n8 - 1;
                n7 = n8;
                while (n7 <= n6) {
                    if (this.qraux[n7 - 1] > d2) {
                        d2 = this.qraux[n7 - 1];
                        n9 = n7 - 1;
                    }
                    ++n7;
                }
                if (n9 != n8 - 1) {
                    BLAS.dswap(n2, this.qr[n8 - 1], 0, 1, this.qr[n9], 0, 1);
                    this.qraux[n9] = this.qraux[n8 - 1];
                    dArray2[n9] = dArray2[n8 - 1];
                    n = this.jpvt[n9];
                    this.jpvt[n9] = this.jpvt[n8 - 1];
                    this.jpvt[n8 - 1] = n;
                }
            }
            this.qraux[n8 - 1] = 0.0;
            if (n8 != n2 && (d = BLAS.dnrm2(n2 - n8 + 1, this.qr[n8 - 1], n8 - 1, 1)) != 0.0) {
                if (this.qr[n8 - 1][n8 - 1] != 0.0) {
                    d = Math.abs(d);
                    if (this.qr[n8 - 1][n8 - 1] < 0.0) {
                        d = -d;
                    }
                }
                BLAS.dscal(n2 - n8 + 1, 1.0 / d, this.qr[n8 - 1], n8 - 1, 1);
                this.qr[n8 - 1][n8 - 1] = 1.0 + this.qr[n8 - 1][n8 - 1];
                int n10 = n8 + 1;
                if (n3 >= n10) {
                    n7 = n10;
                    while (n7 <= n3) {
                        double d3 = -BLAS.ddot(n2 - n8 + 1, this.qr[n8 - 1], n8 - 1, 1, this.qr[n7 - 1], n8 - 1, 1) / this.qr[n8 - 1][n8 - 1];
                        BLAS.daxpy(n2 - n8 + 1, d3, this.qr[n8 - 1], n8 - 1, 1, this.qr[n7 - 1], n8 - 1, 1);
                        if (n7 >= n5 && n7 <= n6 && this.qraux[n7 - 1] != 0.0) {
                            double d4 = 1.0 - Math.abs(this.qr[n7 - 1][n8 - 1]) / this.qraux[n7 - 1] * (Math.abs(this.qr[n7 - 1][n8 - 1]) / this.qraux[n7 - 1]);
                            d3 = d4 = Math.max(d4, 0.0);
                            if ((d4 = 1.0 + 0.05 * d4 * (this.qraux[n7 - 1] / dArray2[n7 - 1]) * (this.qraux[n7 - 1] / dArray2[n7 - 1])) == 1.0) {
                                this.qraux[n7 - 1] = BLAS.dnrm2(n2 - n8, this.qr[n7 - 1], n8, 1);
                                dArray2[n7 - 1] = this.qraux[n7 - 1];
                            } else {
                                this.qraux[n7 - 1] = this.qraux[n7 - 1] * Math.sqrt(d3);
                            }
                        }
                        ++n7;
                    }
                }
                this.qraux[n8 - 1] = this.qr[n8 - 1][n8 - 1];
                this.qr[n8 - 1][n8 - 1] = -d;
            }
            ++n8;
        }
    }

    public double[][] Q() {
        int n = this.qr.length;
        int n2 = this.qr[0].length;
        int n3 = Math.min(n, n2);
        double[][] dArray = new double[n2][n2];
        int n4 = n2;
        if (n3 > 0) {
            double[] dArray2 = new double[n2 + n2];
            int n5 = n2;
            int n6 = 1;
            while (n6 <= n3) {
                System.arraycopy(this.qr[n6 - 1], n2 - n5, dArray[n6 - 1], n2 - n5, n5);
                --n5;
                ++n6;
            }
            n6 = n3;
            while (n6 < n2) {
                dArray[n6][n6] = 1.0;
                ++n6;
            }
            int n7 = n3;
            while (n7 >= 1) {
                int n8 = n2 - n7;
                dArray2[n7 - 1] = this.qraux[n7 - 1];
                if (n8 != 0) {
                    BLAS.dcopy(n8, dArray[n7 - 1], n7, 1, dArray2, n7, 1);
                }
                dArray[n7 - 1][n7 - 1] = 1.0;
                if (n8 != 0) {
                    BLAS.dset(n8, 0.0, dArray[n7 - 1], n7, 1);
                }
                if (Math.abs(dArray2[n7 - 1]) >= 2.2250738585072E-308) {
                    int n9 = n2 - n7 + 1;
                    BLAS.dgemv('T', n9, n9, 1.0 / dArray2[n7 - 1], dArray, n7 - 1, n7 - 1, n4, dArray2, n7 - 1, 1, 0.0, dArray2, n2, 1);
                    BLAS.dger(n9, n9, -1.0, dArray2, n7 - 1, 1, dArray2, n2, 1, dArray, n7 - 1, n7 - 1, n4);
                }
                --n7;
            }
        }
        return DoubleMatrix.transpose(dArray);
    }

    private double[] QTb(double[] dArray, int n) {
        double[] dArray2;
        if (n == 0) {
            dArray2 = new double[]{dArray[0]};
        } else {
            int n2 = dArray.length;
            dArray2 = new double[n2];
            System.arraycopy(dArray, 0, dArray2, 0, n2);
            int n3 = 0;
            while (n3 < n) {
                if (this.qraux[n3] != 0.0) {
                    double d = this.qr[n3][n3];
                    this.qr[n3][n3] = this.qraux[n3];
                    double d2 = BLAS.ddot(this.nra - n3, this.qr[n3], n3, 1, dArray2, n3, 1);
                    BLAS.daxpy(this.nra - n3, d2 /= -1.0 * this.qr[n3][n3], this.qr[n3], n3, 1, dArray2, n3, 1);
                    this.qr[n3][n3] = d;
                }
                ++n3;
            }
        }
        return dArray2;
    }

    public double[][] R() {
        int n = this.qr.length;
        int n2 = this.qr[0].length;
        double[][] dArray = new double[n2][n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n3;
            while (n5 < n) {
                dArray[n4][n5] = this.qr[n5][n4];
                ++n5;
            }
            ++n3;
            ++n4;
        }
        return dArray;
    }

    public int[] ipvt() {
        return this.jpvt;
    }

    public int rank() {
        double d = 2.2204460492503E-16;
        int n = this.rank(d);
        return n;
    }

    public int rank(double d) {
        int n = 0;
        int n2 = Math.min(this.qr.length, this.qr[0].length);
        int n3 = 0;
        while (n3 < n2) {
            if (Math.abs(this.qr[n3][n3]) <= d * Math.abs(this.qr[0][0])) break;
            ++n;
            ++n3;
        }
        return n;
    }

    public double[] solve(double[] dArray) throws MathException {
        double d = 2.2204460492503E-16;
        return this.solve(dArray, d);
    }

    public double[] solve(double[] dArray, double d) throws MathException {
        int n = this.rank(d);
        int n2 = Math.min(n, this.nra - 1);
        double[] dArray2 = new double[n];
        if (n2 == 0) {
            if (this.qr[0][0] == 0.0) {
                throw new MathException();
            }
            dArray2[0] = dArray[0] / this.qr[0][0];
            return dArray2;
        }
        double[] dArray3 = this.QTb(dArray, n2);
        System.arraycopy(dArray3, 0, dArray2, 0, n);
        int n3 = n - 1;
        while (n3 >= 0) {
            if (this.qr[n3][n3] == 0.0) {
                throw new MathException();
            }
            int n4 = n3;
            dArray2[n4] = dArray2[n4] / this.qr[n3][n3];
            double d2 = -dArray2[n3];
            BLAS.daxpy(n3, d2, this.qr[n3], 0, 1, dArray2, 0, 1);
            --n3;
        }
        return dArray2;
    }
}

