/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.BLAS;
import VisualNumerics.math.Complex;
import VisualNumerics.math.ComplexMatrix;
import VisualNumerics.math.MathException;

public class ComplexQR {
    private Complex[][] qr;
    private Complex[] qraux;
    private int[] jpvt;
    private int nra;
    private int nca;
    private static final double SMALLEST = 2.2250738585072E-308;
    private static final double LARGEST = 1.7976931348623E308;
    private static final double EPSILON_LARGE = 2.2204460492503E-16;

    public ComplexQR(Complex[][] complexArray) throws IllegalArgumentException {
        int n;
        Complex complex = new Complex();
        Complex complex2 = new Complex();
        Complex complex3 = new Complex(1.0, 0.0);
        Complex complex4 = new Complex(0.0, 0.0);
        Complex complex5 = new Complex(-1.0, 0.0);
        Complex complex6 = new Complex();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        this.nra = n2;
        this.nca = n3;
        int n4 = Math.min(n2, n3);
        this.jpvt = new int[1];
        this.qr = ComplexMatrix.transpose(complexArray);
        this.qraux = new Complex[n2];
        this.jpvt = new int[n2];
        Complex[] complexArray2 = new Complex[n3];
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            this.qraux[n7] = new Complex();
            ++n7;
        }
        int n8 = 0;
        while (n8 < n3) {
            complexArray2[n8] = new Complex();
            ++n8;
        }
        int n9 = 1;
        while (n9 <= n3) {
            boolean bl = this.jpvt[n9 - 1] > 0;
            boolean bl2 = this.jpvt[n9 - 1] < 0;
            this.jpvt[n9 - 1] = n9;
            if (bl2) {
                this.jpvt[n9 - 1] = -n9;
            }
            if (bl) {
                if (n9 != n5) {
                    BLAS.zswap(n2, this.qr[n5 - 1], 0, 1, this.qr[n9 - 1], 0, 1);
                }
                this.jpvt[n9 - 1] = this.jpvt[n5 - 1];
                this.jpvt[n5 - 1] = n9;
                ++n5;
            }
            ++n9;
        }
        n6 = n3;
        n9 = n3;
        while (n9 >= 1) {
            if (this.jpvt[n9 - 1] < 0) {
                this.jpvt[n9 - 1] = -this.jpvt[n9 - 1];
                if (n9 != n6) {
                    BLAS.zswap(n2, this.qr[n6 - 1], 0, 1, this.qr[n9 - 1], 0, 1);
                    n = this.jpvt[n6 - 1];
                    this.jpvt[n6 - 1] = this.jpvt[n9 - 1];
                    this.jpvt[n9 - 1] = n;
                }
                --n6;
            }
            --n9;
        }
        if (n6 >= n5) {
            n9 = n5;
            while (n9 <= n6) {
                double d = BLAS.dznrm2(n2, this.qr[n9 - 1], 0, 1);
                this.qraux[n9 - 1] = new Complex(d, 0.0);
                complexArray2[n9 - 1] = new Complex(this.qraux[n9 - 1]);
                ++n9;
            }
        }
        n4 = Math.min(n2, n3);
        int n10 = 1;
        while (n10 <= n4) {
            if (n10 >= n5 && n10 < n6) {
                double d = 0.0;
                int n11 = n10 - 1;
                n9 = n10;
                while (n9 <= n6) {
                    if (this.qraux[n9 - 1].re > d) {
                        d = this.qraux[n9 - 1].re;
                        n11 = n9 - 1;
                    }
                    ++n9;
                }
                if (n11 != n10 - 1) {
                    BLAS.zswap(n2, this.qr[n10 - 1], 0, 1, this.qr[n11], 0, 1);
                    this.qraux[n11] = new Complex(this.qraux[n10 - 1]);
                    complexArray2[n11] = new Complex(complexArray2[n10 - 1]);
                    n = this.jpvt[n11];
                    this.jpvt[n11] = this.jpvt[n10 - 1];
                    this.jpvt[n10 - 1] = n;
                }
            }
            this.qraux[n10 - 1] = new Complex();
            if (n10 != n2 && Complex.zabs1(complex = new Complex(BLAS.dznrm2(n2 - n10 + 1, this.qr[n10 - 1], n10 - 1, 1), 0.0)) != 0.0) {
                if (Complex.zabs1(this.qr[n10 - 1][n10 - 1]) != 0.0) {
                    complex6 = Complex.divide(this.qr[n10 - 1][n10 - 1], Complex.abs(this.qr[n10 - 1][n10 - 1]));
                    complex = Complex.multiply(Complex.abs(complex), complex6);
                }
                complex6 = Complex.divide(complex3, complex);
                BLAS.zscal(n2 - n10 + 1, complex6, this.qr[n10 - 1], n10 - 1, 1);
                this.qr[n10 - 1][n10 - 1] = Complex.add(complex3, this.qr[n10 - 1][n10 - 1]);
                int n12 = n10 + 1;
                if (n3 >= n12) {
                    n9 = n12;
                    while (n9 <= n3) {
                        complex6 = Complex.negate(BLAS.zdotc(n2 - n10 + 1, this.qr[n10 - 1], n10 - 1, 1, this.qr[n9 - 1], n10 - 1, 1));
                        complex2 = Complex.divide(complex6, this.qr[n10 - 1][n10 - 1]);
                        BLAS.zaxpy(n2 - n10 + 1, complex2, this.qr[n10 - 1], n10 - 1, 1, this.qr[n9 - 1], n10 - 1, 1);
                        if (n9 >= n5 && n9 <= n6 && Complex.zabs1(this.qraux[n9 - 1]) != 0.0) {
                            double d = 1.0 - Complex.abs(this.qr[n9 - 1][n10 - 1]) / this.qraux[n9 - 1].re * (Complex.abs(this.qr[n9 - 1][n10 - 1]) / this.qraux[n9 - 1].re);
                            d = Math.max(d, 0.0);
                            complex2 = new Complex(d, 0.0);
                            if ((d = 1.0 + 0.05 * d * (this.qraux[n9 - 1].re / complexArray2[n9 - 1].re) * (this.qraux[n9 - 1].re / complexArray2[n9 - 1].re)) == 1.0) {
                                this.qraux[n9 - 1] = new Complex(BLAS.dznrm2(n2 - n10, this.qr[n9 - 1], n10, 1), 0.0);
                                complexArray2[n9 - 1] = new Complex(this.qraux[n9 - 1]);
                            } else {
                                this.qraux[n9 - 1] = Complex.multiply(this.qraux[n9 - 1], Complex.sqrt(complex2));
                            }
                        }
                        ++n9;
                    }
                }
                this.qraux[n10 - 1] = new Complex(this.qr[n10 - 1][n10 - 1]);
                this.qr[n10 - 1][n10 - 1] = Complex.negate(complex);
            }
            ++n10;
        }
    }

    public Complex[][] Q() {
        Complex complex = new Complex();
        Complex complex2 = new Complex(1.0, 0.0);
        Complex complex3 = new Complex(-1.0, 0.0);
        Complex complex4 = new Complex();
        int n = this.qr.length;
        int n2 = this.qr[0].length;
        int n3 = Math.min(n, n2);
        Complex[][] complexArray = new Complex[n2][n2];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n2) {
                complexArray[n4][n5] = new Complex();
                ++n5;
            }
            ++n4;
        }
        int n6 = n2;
        if (n3 <= 0) {
            System.out.println("From Q: minmn, the row dimension of Q must be ");
            System.out.println("greater than zero but minmn is " + n3);
        } else {
            int n7;
            Complex[] complexArray2 = new Complex[n2 + n2];
            int n8 = 0;
            while (n8 < n2 + n2) {
                complexArray2[n8] = new Complex();
                ++n8;
            }
            int n9 = n2;
            int n10 = 1;
            while (n10 <= n3) {
                n7 = 0;
                while (n7 < n9) {
                    complexArray[n10 - 1][n2 - n9 + n7] = new Complex(this.qr[n10 - 1][n2 - n9 + n7]);
                    ++n7;
                }
                --n9;
                ++n10;
            }
            n10 = 0;
            while (n10 < n3) {
                BLAS.zset(n10 + 1, complex, complexArray[n10], 0, 1);
                ++n10;
            }
            n10 = n3;
            while (n10 < n2) {
                BLAS.zset(n2, complex, complexArray[n10], 0, 1);
                complexArray[n10][n10] = complex2;
                ++n10;
            }
            int n11 = n3;
            while (n11 >= 1) {
                int n12 = n2 - n11;
                complexArray2[n11 - 1] = new Complex(this.qraux[n11 - 1]);
                if (n12 != 0) {
                    n7 = 0;
                    while (n7 < n12) {
                        complexArray2[n11 + n7] = complexArray[n11 - 1][n11 + n7];
                        ++n7;
                    }
                }
                complexArray[n11 - 1][n11 - 1] = new Complex(1.0, 0.0);
                if (n12 != 0) {
                    BLAS.zset(n12, complex, complexArray[n11 - 1], n11, 1);
                }
                if (Complex.abs(complexArray2[n11 - 1]) >= 2.2250738585072E-308) {
                    int n13 = n2 - n11 + 1;
                    complex4 = Complex.divide(complex2, Complex.conjugate(complexArray2[n11 - 1]));
                    BLAS.zgemv('C', n13, n13, complex4, complexArray, n11 - 1, n11 - 1, n6, complexArray2, n11 - 1, 1, complex, complexArray2, n2, 1);
                    BLAS.zgerc(n13, n13, Complex.negate(complex2), complexArray2, n11 - 1, 1, complexArray2, n2, 1, complexArray, n11 - 1, n11 - 1, n6);
                }
                --n11;
            }
        }
        return ComplexMatrix.transpose(complexArray);
    }

    private Complex[] QTb(Complex[] complexArray, int n) {
        Complex[] complexArray2;
        Complex complex = new Complex();
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        if (n == 0) {
            complexArray2 = new Complex[]{new Complex(complexArray[0])};
        } else {
            int n2 = complexArray.length;
            complexArray2 = new Complex[n2];
            int n3 = 0;
            while (n3 < n2) {
                complexArray2[n3] = new Complex(complexArray[n3]);
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                if (!this.qraux[n4].equals(complex3)) {
                    complex2 = this.qr[n4][n4];
                    this.qr[n4][n4] = this.qraux[n4];
                    complex = BLAS.zdotc(this.nra - n4, this.qr[n4], n4, 1, complexArray2, n4, 1);
                    complex.divide(Complex.negate(this.qr[n4][n4]));
                    BLAS.zaxpy(this.nra - n4, complex, this.qr[n4], n4, 1, complexArray2, n4, 1);
                    this.qr[n4][n4] = complex2;
                }
                ++n4;
            }
        }
        return complexArray2;
    }

    public Complex[][] R() {
        Complex complex = new Complex();
        int n = this.qr.length;
        int n2 = this.qr[0].length;
        Complex[][] complexArray = new Complex[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                complexArray[n3][n4] = new Complex();
                ++n4;
            }
            ++n3;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            BLAS.zset(n, complex, complexArray[n6], 0, 1);
            int n7 = n5;
            while (n7 < n) {
                complexArray[n6][n7] = this.qr[n7][n6];
                ++n7;
            }
            ++n5;
            ++n6;
        }
        return complexArray;
    }

    public int[] ipvt() {
        return this.jpvt;
    }

    public int rank() {
        return this.rank(2.2204460492503E-16);
    }

    public int rank(double d) {
        int n = 0;
        int n2 = Math.min(this.qr.length, this.qr[0].length);
        int n3 = 0;
        while (n3 < n2) {
            if (Complex.abs(this.qr[n3][n3]) <= d * Complex.abs(this.qr[0][0])) break;
            ++n;
            ++n3;
        }
        return n;
    }

    public Complex[] solve(Complex[] complexArray) throws MathException {
        return this.solve(complexArray, 2.2204460492503E-16);
    }

    public Complex[] solve(Complex[] complexArray, double d) throws MathException {
        int n = this.rank(d);
        int n2 = Math.min(n, this.nra - 1);
        Complex[] complexArray2 = new Complex[n];
        Complex complex = new Complex();
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        if (n2 == 0) {
            if (this.qr[0][0].equals(complex3)) {
                throw new MathException();
            }
            complexArray2[0] = Complex.divide(complexArray[0], this.qr[0][0]);
            return complexArray2;
        }
        Complex[] complexArray3 = this.QTb(complexArray, n2);
        int n3 = 0;
        while (n3 < n) {
            complexArray2[n3] = new Complex(complexArray3[n3]);
            ++n3;
        }
        int n4 = n - 1;
        while (n4 >= 0) {
            if (this.qr[n4][n4].equals(complex3)) {
                throw new MathException();
            }
            complexArray2[n4].divide(this.qr[n4][n4]);
            complex = Complex.negate(complexArray2[n4]);
            BLAS.zaxpy(n4, complex, this.qr[n4], 0, 1, complexArray2, 0, 1);
            --n4;
        }
        return complexArray2;
    }
}

