/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.Complex;

final class BLAS {
    BLAS() {
    }

    static final double dasum(int n, double[] dArray, int n2, int n3) {
        double d;
        block5: {
            d = 0.0;
            if (n <= 0) break block5;
            if (n3 == 1) {
                int n4;
                int n5 = n % 6;
                int n6 = 0;
                while (n6 < n5) {
                    d += Math.abs(dArray[n6 + n2]);
                    ++n6;
                }
                n6 = n4 = n5 + n2;
                while (n6 < n + n2) {
                    d = d + Math.abs(dArray[n6]) + Math.abs(dArray[n6 + 1]) + Math.abs(dArray[n6 + 2]) + Math.abs(dArray[n6 + 3]) + Math.abs(dArray[n6 + 4]) + Math.abs(dArray[n6 + 5]);
                    n6 += 6;
                }
            } else {
                int n7 = n * n3;
                int n8 = 0;
                while (n8 < n7) {
                    d += Math.abs(dArray[n8 + n2]);
                    n8 += n3;
                }
            }
        }
        return d;
    }

    static final void daxpy(int n, double d, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
        block7: {
            if (n <= 0 || d == 0.0) break block7;
            if (n3 != 1 || n5 != 1) {
                int n6 = n2;
                int n7 = n4;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3 + n2;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5 + n4;
                }
                int n8 = 0;
                while (n8 < n) {
                    int n9 = n7;
                    dArray2[n9] = dArray2[n9] + d * dArray[n6];
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                int n10 = n % 4;
                int n11 = 0;
                while (n11 < n10) {
                    int n12 = n11 + n4;
                    dArray2[n12] = dArray2[n12] + d * dArray[n11 + n2];
                    ++n11;
                }
                int n13 = n10;
                while (n13 < n) {
                    int n14;
                    int n15 = n13 + n2;
                    int n16 = n14 = n13 + n4;
                    dArray2[n16] = dArray2[n16] + d * dArray[n15];
                    int n17 = n14 + 1;
                    dArray2[n17] = dArray2[n17] + d * dArray[n15 + 1];
                    int n18 = n14 + 2;
                    dArray2[n18] = dArray2[n18] + d * dArray[n15 + 2];
                    int n19 = n14 + 3;
                    dArray2[n19] = dArray2[n19] + d * dArray[n15 + 3];
                    n13 += 4;
                }
            }
        }
    }

    static void dcopy(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
        block6: {
            if (n <= 0) break block6;
            if (n3 != 1 || n5 != 1) {
                int n6 = n2;
                int n7 = n4;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3 + n2;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5 + n4;
                }
                int n8 = 0;
                while (n8 < n) {
                    dArray2[n7] = dArray[n6];
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                int n9 = n % 7;
                int n10 = n2;
                int n11 = n4;
                System.arraycopy(dArray, n10, dArray2, n11, n9);
                int n12 = n9;
                while (n12 < n) {
                    int n13 = n12 + n2;
                    int n14 = n12 + n4;
                    dArray2[n14] = dArray[n13];
                    dArray2[n14 + 1] = dArray[n13 + 1];
                    dArray2[n14 + 2] = dArray[n13 + 2];
                    dArray2[n14 + 3] = dArray[n13 + 3];
                    dArray2[n14 + 4] = dArray[n13 + 4];
                    dArray2[n14 + 5] = dArray[n13 + 5];
                    dArray2[n14 + 6] = dArray[n13 + 6];
                    n12 += 7;
                }
            }
        }
    }

    static final double ddot(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
        double d;
        block7: {
            d = 0.0;
            if (n <= 0) break block7;
            if (n3 != 1 || n5 != 1) {
                int n6 = n2;
                int n7 = n4;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3 + n2;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5 + n4;
                }
                int n8 = 0;
                while (n8 < n) {
                    d += dArray[n6] * dArray2[n7];
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                int n9 = n % 5;
                int n10 = 0;
                while (n10 < n9) {
                    d += dArray[n10 + n2] * dArray2[n10 + n4];
                    ++n10;
                }
                int n11 = n9;
                while (n11 < n) {
                    int n12 = n11 + n2;
                    int n13 = n11 + n4;
                    d += dArray[n12] * dArray2[n13] + dArray[n12 + 1] * dArray2[n13 + 1] + dArray[n12 + 2] * dArray2[n13 + 2] + dArray[n12 + 3] * dArray2[n13 + 3] + dArray[n12 + 4] * dArray2[n13 + 4];
                    n11 += 5;
                }
            }
        }
        return d;
    }

    static final void dgemv(char c, int n, int n2, double d, double[][] dArray, int n3, int n4, int n5, double[] dArray2, int n6, int n7, double d2, double[] dArray3, int n8, int n9) {
        block17: {
            int n10;
            int n11;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (c == 'N' || c == 'n') {
                bl = true;
            }
            if (c == 'T' || c == 't') {
                bl2 = true;
            }
            if (c == 'C' || c == 'c') {
                bl3 = true;
            }
            if (n < 0 || n2 < 0 || n5 < n || n5 == 0 || n7 == 0 || n9 == 0 || !bl && !bl2 && !bl3 || n == 0 || n2 == 0 || d == 0.0 && d2 == 1.0) break block17;
            if (bl) {
                n11 = n2;
                n10 = n;
            } else {
                n11 = n;
                n10 = n2;
            }
            double[] dArray4 = new double[Math.max(n, n2)];
            int n12 = 1 + n6;
            int n13 = 1 + n8;
            if (n7 < 0) {
                n12 = (-n11 + 1) * n7 + 1 + n6;
            }
            if (n9 < 0) {
                n13 = (-n10 + 1) * n9 + 1 + n8;
            }
            if (d2 != 1.0) {
                if (n9 == 0) {
                    dArray3[n8] = d2 == 0.0 ? 0.0 : Math.pow(d2, (double)n10 * dArray3[0]);
                } else if (d2 == 0.0) {
                    BLAS.dset(n10, 0.0, dArray3, n8, Math.abs(n9));
                } else {
                    BLAS.dscal(n10, d2, dArray3, n8, Math.abs(n9));
                }
            }
            if (d != 0.0) {
                if (bl) {
                    int n14 = n12;
                    int n15 = 1;
                    while (n15 <= n2) {
                        System.arraycopy(dArray[n3 + n15 - 1], n4, dArray4, 0, n);
                        BLAS.daxpy(n, d * dArray2[n14 - 1], dArray4, 0, 1, dArray3, n8, n9);
                        System.arraycopy(dArray4, 0, dArray[n3 + n15 - 1], n4, n);
                        n14 += n7;
                        ++n15;
                    }
                } else {
                    int n16 = n13;
                    int n17 = 1;
                    while (n17 <= n2) {
                        System.arraycopy(dArray[n3 + n17 - 1], n4, dArray4, 0, n);
                        dArray3[n16 - 1] = dArray3[n16 - 1] + d * BLAS.ddot(n, dArray4, 0, 1, dArray2, n6, n7);
                        System.arraycopy(dArray4, 0, dArray[n3 + n17 - 1], n4, n);
                        n16 += n9;
                        ++n17;
                    }
                }
            }
        }
    }

    static final void dger(int n, int n2, double d, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[][] dArray3, int n7, int n8, int n9) {
        if (n >= 0 && n2 >= 0 && n9 >= n && n9 != 0 && n4 != 0 && n6 != 0 && n != 0 && n2 != 0 && d != 0.0) {
            double[] dArray4 = new double[Math.max(n, n2)];
            int n10 = 1 + n5;
            if (n6 < 0) {
                n10 = (-n2 + 1) * n6 + 1 + n5;
            }
            int n11 = 1;
            while (n11 <= n2) {
                System.arraycopy(dArray3[n7 + n11 - 1], n8, dArray4, 0, n);
                BLAS.daxpy(n, d * dArray2[n10 - 1], dArray, n3, n4, dArray4, 0, 1);
                System.arraycopy(dArray4, 0, dArray3[n7 + n11 - 1], n8, n);
                n10 += n6;
                ++n11;
            }
        }
    }

    static final double dnr1rr(int n, int n2, double[][] dArray) {
        if (n <= 0) {
            System.out.println("From dnr1rr: The number of rows of the input matrix must be ");
            System.out.println("greater than zero but nra = " + n);
        }
        if (n2 <= 0) {
            System.out.println("From dnr1rr: The number of columns of the input matrix must ");
            System.out.println("be greater than zero but nca = " + n2);
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < n) {
                d2 += Math.abs(dArray[n4][n3]);
                ++n4;
            }
            d = Math.max(d2, d);
            ++n3;
        }
        return d;
    }

    static final double dnrm2(int n, double[] dArray, int n2, int n3) {
        double[] dArray2 = new double[6];
        double d = 0.0;
        double d2 = 1.0;
        dArray2[0] = 1.0010415475916E-146;
        dArray2[1] = 4.4989137945432E161;
        dArray2[2] = 2.2227587494851E-162;
        dArray2[3] = 1.9979190722022E146;
        dArray2[4] = 5.0104209000224E-293;
        dArray2[5] = 1.9958403095347E292;
        double d3 = d;
        if (n > 0 && n3 >= 0) {
            if (n3 == 0) {
                d3 = n;
                d3 = Math.abs(dArray[0]) * Math.sqrt(d3);
            } else {
                double d4 = d;
                int n4 = 1;
                while (n4 <= n * n3) {
                    if ((d4 += Math.abs(dArray[n4 - 1 + n2])) > dArray2[3]) {
                        d4 = dArray2[4];
                        double d5 = dArray2[5];
                        d3 = d;
                        int n5 = 1;
                        while (n5 <= n * n3) {
                            d3 += d4 * dArray[n5 - 1 + n2] * (d4 * dArray[n5 - 1 + n2]);
                            ++n5;
                        }
                        d3 = Math.sqrt(d3) * d5;
                        return d3;
                    }
                    ++n4;
                }
                if (d4 < (double)n * dArray2[0]) {
                    d4 = dArray2[1];
                    double d6 = dArray2[2];
                    d3 = d;
                    int n6 = 1;
                    while (n6 <= n * n3) {
                        d3 += d4 * dArray[n6 - 1 + n2] * (d4 * dArray[n6 - 1 + n2]);
                        ++n6;
                    }
                    d3 = Math.sqrt(d3) * d6;
                    return d3;
                }
                n4 = 1;
                while (n4 <= n * n3) {
                    d3 += dArray[n4 - 1 + n2] * dArray[n4 - 1 + n2];
                    ++n4;
                }
                d3 = Math.sqrt(d3);
                return d3;
            }
        }
        return d3;
    }

    static final void drot(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, double[] dArray3, double[] dArray4) {
        block6: {
            if (n <= 0) break block6;
            if (n3 != 1 || n5 != 1) {
                int n6 = 1 + n2;
                int n7 = 1 + n4;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3 + 1 + n2;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5 + 1 + n4;
                }
                int n8 = 0;
                while (n8 < n) {
                    double d = dArray3[0] * dArray[n6] + dArray4[0] * dArray2[n7];
                    dArray2[n7] = dArray3[0] * dArray2[n7] - dArray4[0] * dArray[n6];
                    dArray[n6] = d;
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                int n9 = 0;
                while (n9 < n) {
                    double d = dArray3[0] * dArray[n9 + n2] + dArray4[0] * dArray2[n9 + n4];
                    dArray2[n9 + n4] = dArray3[0] * dArray2[n9 + n4] - dArray4[0] * dArray[n9 + n2];
                    dArray[n9 + n2] = d;
                    ++n9;
                }
            }
        }
    }

    static final void drotg(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (Math.abs(dArray[0]) > Math.abs(dArray2[0])) {
            double d = dArray[0] + dArray[0];
            double d2 = dArray2[0] / d;
            double d3 = Math.sqrt(0.25 + d2 * d2) * d;
            dArray3[0] = dArray[0] / d3;
            dArray4[0] = d2 * (dArray3[0] + dArray3[0]);
            dArray2[0] = dArray4[0];
            dArray[0] = d3;
        } else if (dArray2[0] == 0.0) {
            dArray3[0] = 1.0;
            dArray4[0] = 0.0;
            dArray[0] = 0.0;
            dArray2[0] = 0.0;
        } else {
            double d = dArray2[0] + dArray2[0];
            double d4 = dArray[0] / d;
            dArray[0] = Math.sqrt(0.25 + d4 * d4) * d;
            dArray4[0] = dArray2[0] / dArray[0];
            dArray3[0] = d4 * (dArray4[0] + dArray4[0]);
            dArray2[0] = dArray3[0] == 0.0 ? 1.0 : 1.0 / dArray3[0];
        }
    }

    static final void dscal(int n, double d, double[] dArray, int n2, int n3) {
        block5: {
            if (n <= 0) break block5;
            if (n3 != 1) {
                int n4 = n * n3;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = n5 + n2;
                    dArray[n6] = dArray[n6] * d;
                    n5 += n3;
                }
            } else {
                int n7 = n - n / 5 * 5;
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = n8 + n2;
                    dArray[n9] = dArray[n9] * d;
                    ++n8;
                }
                n8 = n7;
                while (n8 < n) {
                    int n10;
                    int n11 = n10 = n8 + n2;
                    dArray[n11] = dArray[n11] * d;
                    int n12 = n10 + 1;
                    dArray[n12] = dArray[n12] * d;
                    int n13 = n10 + 2;
                    dArray[n13] = dArray[n13] * d;
                    int n14 = n10 + 3;
                    dArray[n14] = dArray[n14] * d;
                    int n15 = n10 + 4;
                    dArray[n15] = dArray[n15] * d;
                    n8 += 5;
                }
            }
        }
    }

    static final void dset(int n, double d, double[] dArray, int n2, int n3) {
        block5: {
            if (n <= 0) break block5;
            if (n3 == 1) {
                int n4 = n % 8 + n2;
                int n5 = n2;
                while (n5 < n4) {
                    dArray[n5] = d;
                    ++n5;
                }
                int n6 = n4 + 1;
                n5 = n4;
                while (n5 < n + n2) {
                    dArray[n5] = d;
                    dArray[n5 + 1] = d;
                    dArray[n5 + 2] = d;
                    dArray[n5 + 3] = d;
                    dArray[n5 + 4] = d;
                    dArray[n5 + 5] = d;
                    dArray[n5 + 6] = d;
                    dArray[n5 + 7] = d;
                    n5 += 8;
                }
            } else {
                int n7 = n * n3 + n2;
                int n8 = n2;
                while (n8 < n7) {
                    dArray[n8] = d;
                    n8 += n3;
                }
            }
        }
    }

    static final void dswap(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
        block7: {
            if (n <= 0) break block7;
            if (n3 != 1 || n5 != 1) {
                int n6 = n2;
                int n7 = n4;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3 + n2;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5 + n4;
                }
                int n8 = 0;
                while (n8 < n) {
                    double d = dArray[n6];
                    dArray[n6] = dArray2[n7];
                    dArray2[n7] = d;
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                double d;
                int n9 = n % 3;
                int n10 = 0;
                while (n10 < n9) {
                    d = dArray[n10 + n2];
                    dArray[n10 + n2] = dArray2[n10 + n4];
                    dArray2[n10 + n4] = d;
                    ++n10;
                }
                n10 = n9;
                while (n10 < n) {
                    d = dArray[n10 + n2];
                    dArray[n10 + n2] = dArray2[n10 + n4];
                    dArray2[n10 + n4] = d;
                    d = dArray[n10 + 1 + n2];
                    dArray[n10 + 1 + n2] = dArray2[n10 + 1 + n4];
                    dArray2[n10 + 1 + n4] = d;
                    d = dArray[n10 + 2 + n2];
                    dArray[n10 + 2 + n2] = dArray2[n10 + 2 + n4];
                    dArray2[n10 + 2 + n4] = d;
                    n10 += 3;
                }
            }
        }
    }

    static final double dzasum(int n, Complex[] complexArray, int n2, int n3) {
        double d;
        block5: {
            d = 0.0;
            if (n <= 0) break block5;
            if (n3 == 1) {
                int n4;
                int n5 = n % 6;
                int n6 = 0;
                while (n6 < n5) {
                    d += Complex.zabs1(complexArray[n6 + n2]);
                    ++n6;
                }
                n6 = n4 = n5 + n2;
                while (n6 < n + n2) {
                    d += Complex.zabs1(complexArray[n6]) + Complex.zabs1(complexArray[n6 + 1]) + Complex.zabs1(complexArray[n6 + 2]) + Complex.zabs1(complexArray[n6 + 3]) + Complex.zabs1(complexArray[n6 + 4]) + Complex.zabs1(complexArray[n6 + 5]);
                    n6 += 6;
                }
            } else {
                int n7 = n * n3;
                int n8 = 0;
                while (n8 < n7) {
                    d += Complex.zabs1(complexArray[n8 + n2]);
                    n8 += n3;
                }
            }
        }
        return d;
    }

    static final double dznrm2(int n, Complex[] complexArray, int n2, int n3) {
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 1.0;
        dArray[0] = 1.0010415475916E-146;
        dArray[1] = 4.4989137945432E161;
        dArray[2] = 2.2227587494851E-162;
        dArray[3] = 1.9979190722022E146;
        dArray[4] = 5.0104209000224E-293;
        dArray[5] = 1.9958403095347E292;
        double d3 = d;
        if (n > 0 && n3 >= 0) {
            if (n3 == 0) {
                d3 = n;
                d3 = Complex.abs(complexArray[0]) * Math.sqrt(d3);
            } else {
                double d4 = d;
                int n4 = 1;
                while (n4 <= n * n3) {
                    if ((d4 += Complex.zabs1(complexArray[n4 - 1 + n2])) > dArray[3]) {
                        d4 = dArray[4];
                        double d5 = dArray[5];
                        d3 = d;
                        int n5 = 1;
                        while (n5 <= n * n3) {
                            d3 = d3 + d4 * complexArray[n5 - 1 + n2].re * (d4 * complexArray[n5 - 1 + n2].re) + d4 * complexArray[n5 - 1 + n2].im * (d4 * complexArray[n5 - 1 + n2].im);
                            ++n5;
                        }
                        d3 = Math.sqrt(d3) * d5;
                        return d3;
                    }
                    ++n4;
                }
                double d6 = (double)n * dArray[0];
                if (d4 < d6) {
                    d4 = dArray[1];
                    double d7 = dArray[2];
                    d3 = d;
                    int n6 = 1;
                    while (n6 <= n * n3) {
                        d3 = d3 + d4 * complexArray[n6 - 1 + n2].re * (d4 * complexArray[n6 - 1 + n2].re) + d4 * complexArray[n6 - 1 + n2].im * (d4 * complexArray[n6 - 1 + n2].im);
                        ++n6;
                    }
                    d3 = Math.sqrt(d3) * d7;
                    return d3;
                }
                n4 = 1;
                while (n4 <= n * n3) {
                    d3 = d3 + complexArray[n4 - 1 + n2].re * complexArray[n4 - 1 + n2].re + complexArray[n4 - 1 + n2].im * complexArray[n4 - 1 + n2].im;
                    ++n4;
                }
                d3 = Math.sqrt(d3);
                return d3;
            }
        }
        return d3;
    }

    static final int idamax(int n, double[] dArray, int n2, int n3) {
        int n4;
        block7: {
            n4 = -1;
            if (n < 1) break block7;
            n4 = 0;
            if (n > 1) {
                if (n3 != 1) {
                    double d = Math.abs(dArray[n2]);
                    int n5 = n * n3;
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < n5) {
                        double d2 = Math.abs(dArray[n7 + n2]);
                        if (d2 > d) {
                            n4 = n6;
                            d = d2;
                        }
                        n6 += n3;
                        n7 += n3;
                    }
                } else {
                    double d = Math.abs(dArray[n2]);
                    int n8 = 1;
                    while (n8 < n) {
                        double d3 = Math.abs(dArray[n8 + n2]);
                        if (d3 > d) {
                            n4 = n8;
                            d = d3;
                        }
                        ++n8;
                    }
                }
            }
        }
        return n4;
    }

    static final int izamax(int n, Complex[] complexArray, int n2, int n3) {
        int n4 = 0;
        if (n < 1) {
            n4 = -1;
        } else if (n == 1) {
            n4 = 0;
        } else if (n3 != 1) {
            double d = Complex.zabs1(complexArray[n2]);
            int n5 = 1 + n3;
            int n6 = 1;
            while (n6 < n) {
                double d2 = Complex.zabs1(complexArray[n5 + n2]);
                if (d2 > d) {
                    n4 = n6;
                    d = d2;
                }
                n5 += n3;
                ++n6;
            }
        } else {
            n4 = 0;
            double d = Complex.zabs1(complexArray[n2]);
            int n7 = 1;
            while (n7 < n) {
                double d3 = Complex.zabs1(complexArray[n7 + n2]);
                if (d3 > d) {
                    n4 = n7;
                    d = d3;
                }
                ++n7;
            }
        }
        return n4;
    }

    static final void zaxpy(int n, Complex complex, Complex[] complexArray, int n2, int n3, Complex[] complexArray2, int n4, int n5) {
        Complex complex2 = new Complex();
        if (n > 0 && Complex.zabs1(complex) != 0.0) {
            if (n3 != 1 || n5 != 1) {
                int n6 = 0;
                int n7 = 0;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5;
                }
                int n8 = 0;
                while (n8 < n) {
                    complex2.re = complex.re * complexArray[n6 + n2].re - complex.im * complexArray[n6 + n2].im;
                    complex2.im = complex.re * complexArray[n6 + n2].im + complex.im * complexArray[n6 + n2].re;
                    complexArray2[n7 + n4].add(complex2);
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
                return;
            }
            int n9 = 0;
            while (n9 < n) {
                complex2.re = complex.re * complexArray[n9 + n2].re - complex.im * complexArray[n9 + n2].im;
                complex2.im = complex.re * complexArray[n9 + n2].im + complex.im * complexArray[n9 + n2].re;
                complexArray2[n9 + n4].add(complex2);
                ++n9;
            }
        }
    }

    static final Complex zdot(int n, Complex[] complexArray, int n2, int n3, Complex[] complexArray2, int n4, int n5) {
        Complex complex;
        block6: {
            complex = new Complex();
            Complex complex2 = new Complex();
            if (n <= 0) break block6;
            if (n3 != 1 || n5 != 1) {
                int n6 = 0;
                int n7 = 0;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5;
                }
                int n8 = 0;
                while (n8 < n) {
                    complex2.re = complexArray[n6 + n2].re * complexArray2[n7 + n4].re - complexArray[n6 + n2].im * complexArray2[n7 + n4].im;
                    complex2.im = complexArray[n6 + n2].re * complexArray2[n7 + n4].im + complexArray[n6 + n2].im * complexArray2[n7 + n4].re;
                    complex.add(complex2);
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                int n9 = 0;
                while (n9 < n) {
                    complex2.re = complexArray[n9 + n2].re * complexArray2[n9 + n4].re - complexArray[n9 + n2].im * complexArray2[n9 + n4].im;
                    complex2.im = complexArray[n9 + n2].re * complexArray2[n9 + n4].im + complexArray[n9 + n2].im * complexArray2[n9 + n4].re;
                    complex.add(complex2);
                    ++n9;
                }
            }
        }
        return complex;
    }

    static final Complex zdotc(int n, Complex[] complexArray, int n2, int n3, Complex[] complexArray2, int n4, int n5) {
        Complex complex;
        block6: {
            complex = new Complex();
            Complex complex2 = new Complex();
            if (n <= 0) break block6;
            if (n3 != 1 || n5 != 1) {
                int n6 = 0;
                int n7 = 0;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5;
                }
                int n8 = 0;
                while (n8 < n) {
                    complex2.re = complexArray[n6 + n2].re;
                    complex2.im = -complexArray[n6 + n2].im;
                    complex2.multiply(complexArray2[n7 + n4]);
                    complex.add(complex2);
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                int n9 = 0;
                while (n9 < n) {
                    complex2.re = complexArray[n9 + n2].re;
                    complex2.im = -complexArray[n9 + n2].im;
                    complex2.multiply(complexArray2[n9 + n4]);
                    complex.add(complex2);
                    ++n9;
                }
            }
        }
        return complex;
    }

    static final Complex zdotu(int n, Complex[] complexArray, int n2, int n3, Complex[] complexArray2, int n4, int n5) {
        Complex complex;
        block6: {
            complex = new Complex();
            Complex complex2 = new Complex();
            if (n <= 0) break block6;
            if (n3 != 1 || n5 != 1) {
                int n6 = 0;
                int n7 = 0;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5;
                }
                int n8 = 0;
                while (n8 < n) {
                    complex2.re = complexArray[n6 + n2].re * complexArray2[n7 + n4].re - complexArray[n6 + n2].im * complexArray2[n7 + n4].im;
                    complex2.im = complexArray[n6 + n2].re * complexArray2[n7 + n4].im + complexArray[n6 + n2].im * complexArray2[n7 + n4].re;
                    complex.add(complex2);
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                int n9 = 0;
                while (n9 < n) {
                    complex2.re = complexArray[n9 + n2].re * complexArray2[n9 + n4].re - complexArray[n9 + n2].im * complexArray2[n9 + n4].im;
                    complex2.im = complexArray[n9 + n2].re * complexArray2[n9 + n4].im + complexArray[n9 + n2].im * complexArray2[n9 + n4].re;
                    complex.add(complex2);
                    ++n9;
                }
            }
        }
        return complex;
    }

    static final void zdscal(int n, double d, Complex[] complexArray, int n2, int n3) {
        block4: {
            if (n <= 0) break block4;
            if (n3 != 1) {
                int n4 = n * n3;
                int n5 = 0;
                while (n5 < n4) {
                    complexArray[n5 + n2].multiply(d);
                    n5 += n3;
                }
            } else {
                int n6 = 0;
                while (n6 < n) {
                    complexArray[n6 + n2].multiply(d);
                    ++n6;
                }
            }
        }
    }

    static final void zgemv(char c, int n, int n2, Complex complex, Complex[][] complexArray, int n3, int n4, int n5, Complex[] complexArray2, int n6, int n7, Complex complex2, Complex[] complexArray3, int n8, int n9) {
        block27: {
            int n10;
            int n11;
            Complex complex3 = new Complex();
            Complex complex4 = new Complex();
            Complex complex5 = new Complex();
            Complex complex6 = new Complex(1.0, 0.0);
            Complex complex7 = new Complex();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (c == 'N' || c == 'n') {
                bl = true;
            }
            if (c == 'T' || c == 't') {
                bl2 = true;
            }
            if (c == 'C' || c == 'c') {
                bl3 = true;
            }
            if (n < 0 || n2 < 0 || n5 < n || n5 == 0 || n7 == 0 || n9 == 0 || !bl && !bl2 && !bl3 || n == 0 || n2 == 0 || complex.equals(complex5) && complex2.equals(complex6)) break block27;
            if (bl) {
                n11 = n2;
                n10 = n;
            } else {
                n11 = n;
                n10 = n2;
            }
            Complex[] complexArray4 = new Complex[Math.max(n, n2)];
            int n12 = 1 + n6;
            int n13 = 1 + n8;
            if (n7 < 0) {
                n12 = (-n11 + 1) * n7 + 1 + n6;
            }
            if (n9 < 0) {
                n13 = (-n10 + 1) * n9 + 1 + n8;
            }
            if (!complex2.equals(complex6)) {
                int n14;
                int n15;
                int n16;
                if (n9 == 0) {
                    complexArray3[n8] = complex2.equals(complex5) ? new Complex() : Complex.pow(complex2, Complex.multiply(n10, complexArray3[0]));
                } else if (complex2.equals(complex5)) {
                    n16 = Math.abs(n9);
                    n15 = 0;
                    n14 = 0;
                    while (n14 < n10) {
                        complexArray3[n15 + n8] = new Complex();
                        n15 += n16;
                        ++n14;
                    }
                } else {
                    n16 = Math.abs(n9);
                    n15 = 0;
                    n14 = 0;
                    while (n14 < n10) {
                        complexArray3[n15 + n8] = Complex.multiply(complexArray3[n15 + n8], complex2);
                        n15 += n16;
                        ++n14;
                    }
                }
            }
            if (!complex.equals(complex5)) {
                if (bl) {
                    int n17 = n12;
                    int n18 = 1;
                    while (n18 <= n2) {
                        int n19 = 0;
                        while (n19 < n) {
                            complexArray4[n19] = new Complex(complexArray[n3 + n18 - 1][n4 + n19]);
                            ++n19;
                        }
                        complex3.re = complex.re * complexArray2[n17 - 1].re - complex.im * complexArray2[n17 - 1].im;
                        complex3.im = complex.re * complexArray2[n17 - 1].im + complex.im * complexArray2[n17 - 1].re;
                        BLAS.zaxpy(n, complex3, complexArray4, 0, 1, complexArray3, n8, n9);
                        n19 = 0;
                        while (n19 < n) {
                            complexArray[n3 + n18 - 1][n4 + n19] = new Complex(complexArray4[n19]);
                            ++n19;
                        }
                        n17 += n7;
                        ++n18;
                    }
                } else if (bl2) {
                    int n20 = n13;
                    int n21 = 1;
                    while (n21 <= n2) {
                        int n22 = 0;
                        while (n22 < n) {
                            complexArray4[n22] = new Complex(complexArray[n3 + n21 - 1][n4 + n22]);
                            ++n22;
                        }
                        complex3 = BLAS.zdotu(n, complexArray4, 0, 1, complexArray2, n6, n7);
                        complex4.re = complex.re * complex3.re - complex.im * complex3.im;
                        complex4.im = complex.re * complex3.im + complex.im * complex3.re;
                        complexArray3[n20 - 1].add(complex4);
                        n22 = 0;
                        while (n22 < n) {
                            complexArray[n3 + n21 - 1][n4 + n22] = new Complex(complexArray4[n22]);
                            ++n22;
                        }
                        n20 += n9;
                        ++n21;
                    }
                } else {
                    int n23 = n13;
                    int n24 = 1;
                    while (n24 <= n2) {
                        int n25 = 0;
                        while (n25 < n) {
                            complexArray4[n25] = new Complex(complexArray[n3 + n24 - 1][n4 + n25]);
                            ++n25;
                        }
                        complex3 = BLAS.zdotc(n, complexArray4, 0, 1, complexArray2, n6, n7);
                        complex4.re = complex.re * complex3.re - complex.im * complex3.im;
                        complex4.im = complex.re * complex3.im + complex.im * complex3.re;
                        complexArray3[n23 - 1].add(complex4);
                        n23 += n9;
                        ++n24;
                    }
                }
            }
        }
    }

    static final void zgerc(int n, int n2, Complex complex, Complex[] complexArray, int n3, int n4, Complex[] complexArray2, int n5, int n6, Complex[][] complexArray3, int n7, int n8, int n9) {
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        if (n >= 0 && n2 >= 0 && n9 >= n && n9 != 0 && n4 != 0 && n6 != 0 && n != 0 && n2 != 0 && !complex.equals(complex2)) {
            Complex[] complexArray4 = new Complex[Math.max(n, n2)];
            int n10 = 1 + n5;
            if (n6 < 0) {
                n10 = (-n2 + 1) * n6 + 1 + n5;
            }
            int n11 = 1;
            while (n11 <= n2) {
                int n12 = 0;
                while (n12 < n) {
                    complexArray4[n12] = new Complex(complexArray3[n7 + n11 - 1][n8 + n12]);
                    ++n12;
                }
                complex3 = Complex.multiply(complex, Complex.conjugate(complexArray2[n10 - 1]));
                BLAS.zaxpy(n, complex3, complexArray, n3, n4, complexArray4, 0, 1);
                n12 = 0;
                while (n12 < n) {
                    complexArray3[n7 + n11 - 1][n8 + n12] = new Complex(complexArray4[n12]);
                    ++n12;
                }
                n10 += n6;
                ++n11;
            }
        }
    }

    static final double znr1rr(int n, int n2, Complex[][] complexArray) {
        if (n <= 0) {
            System.out.println("From znr1rr: The number of rows of the input matrix must be ");
            System.out.println("greater than zero but nra = " + n);
        }
        if (n2 <= 0) {
            System.out.println("From znr1rr: The number of columns of the input matrix must ");
            System.out.println("be greater than zero but nca = " + n2);
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < n) {
                d2 += Complex.zabs1(complexArray[n4][n3]);
                ++n4;
            }
            d = Math.max(d2, d);
            ++n3;
        }
        return d;
    }

    static final void zscal(int n, Complex complex, Complex[] complexArray, int n2, int n3) {
        block4: {
            if (n <= 0) break block4;
            if (n3 != 1) {
                int n4 = n * n3;
                int n5 = 0;
                while (n5 < n4) {
                    complexArray[n5 + n2].multiply(complex);
                    n5 += n3;
                }
            } else {
                int n6 = 0;
                while (n6 < n) {
                    complexArray[n6 + n2].multiply(complex);
                    ++n6;
                }
            }
        }
    }

    static final void zset(int n, Complex complex, Complex[] complexArray, int n2, int n3) {
        block5: {
            if (n <= 0) break block5;
            if (n3 == 1) {
                int n4 = n % 8 + n2;
                int n5 = n2;
                while (n5 < n4) {
                    complexArray[n5] = complex;
                    ++n5;
                }
                int n6 = n4 + 1;
                n5 = n4;
                while (n5 < n + n2) {
                    complexArray[n5] = complex;
                    complexArray[n5 + 1] = complex;
                    complexArray[n5 + 2] = complex;
                    complexArray[n5 + 3] = complex;
                    complexArray[n5 + 4] = complex;
                    complexArray[n5 + 5] = complex;
                    complexArray[n5 + 6] = complex;
                    complexArray[n5 + 7] = complex;
                    n5 += 8;
                }
            } else {
                int n7 = n * n3 + n2;
                int n8 = n2;
                while (n8 < n7) {
                    complexArray[n8] = complex;
                    n8 += n3;
                }
            }
        }
    }

    static final void zswap(int n, Complex[] complexArray, int n2, int n3, Complex[] complexArray2, int n4, int n5) {
        block7: {
            Complex complex = new Complex();
            if (n <= 0) break block7;
            if (n3 != 1 || n5 != 1) {
                int n6 = n2;
                int n7 = n4;
                if (n3 < 0) {
                    n6 = (-n + 1) * n3 + n2;
                }
                if (n5 < 0) {
                    n7 = (-n + 1) * n5 + n4;
                }
                int n8 = 0;
                while (n8 < n) {
                    complex = complexArray[n6];
                    complexArray[n6] = complexArray2[n7];
                    complexArray2[n7] = complex;
                    n6 += n3;
                    n7 += n5;
                    ++n8;
                }
            } else {
                int n9 = n % 3;
                int n10 = 0;
                while (n10 < n9) {
                    complex = complexArray[n10 + n2];
                    complexArray[n10 + n2] = complexArray2[n10 + n4];
                    complexArray2[n10 + n4] = complex;
                    ++n10;
                }
                n10 = n9;
                while (n10 < n) {
                    complex = complexArray[n10 + n2];
                    complexArray[n10 + n2] = complexArray2[n10 + n4];
                    complexArray2[n10 + n4] = complex;
                    complex = complexArray[n10 + 1 + n2];
                    complexArray[n10 + 1 + n2] = complexArray2[n10 + 1 + n4];
                    complexArray2[n10 + 1 + n4] = complex;
                    complex = complexArray[n10 + 2 + n2];
                    complexArray[n10 + 2 + n2] = complexArray2[n10 + 2 + n4];
                    complexArray2[n10 + 2 + n4] = complex;
                    n10 += 3;
                }
            }
        }
    }
}

