/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Stenosis;
import board.Vessel;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

class XML {
    XML() {
    }

    public static void save(String filename, ArrayList vessels) {
        System.out.print("export XML : " + filename + "\n");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            XML.save_xml(out, vessels);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
    }

    public static void save_xml(BufferedWriter out, ArrayList vessels) throws IOException {
        String line = "<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>";
        out.write(line);
        out.newLine();
        out.write("<cag>");
        out.newLine();
        int i = 15;
        while (i >= 0) {
            Vessel vessel = (Vessel)vessels.get(i);
            int prepci = 0;
            Stenosis stenosis = null;
            if (vessel.stenoses.size() != 0) {
                stenosis = (Stenosis)vessel.stenoses.get(0);
                prepci = (int)stenosis.ratio;
            }
            out.write("\t<" + vessel.name + ">");
            out.newLine();
            out.write("\t\t<prepci>" + prepci + "</prepci>");
            out.newLine();
            out.write("\t\t<irregular>0</irregular>");
            out.newLine();
            if (stenosis == null) {
                out.write("\t\t<diffuse>0</diffuse>");
            } else if (stenosis.type == 2) {
                out.write("\t\t<diffuse>1</diffuse>");
            } else {
                out.write("\t\t<diffuse>0</diffuse>");
            }
            out.newLine();
            if (stenosis == null) {
                out.write("\t\t<segmental>0</segmental>");
            } else if (stenosis.type == 4) {
                out.write("\t\t<segmental>1</segmental>");
            } else {
                out.write("\t\t<segmental>0</segmental>");
            }
            out.newLine();
            if (stenosis == null) {
                out.write("\t\t<undefined>0</undefined>");
            } else if (stenosis.type == 0) {
                out.write("\t\t<undefined>1</undefined>");
            } else {
                out.write("\t\t<undefined>0</undefined>");
            }
            out.newLine();
            out.write("\t\t<washeddelay>0</washeddelay>");
            out.newLine();
            out.write("\t</" + vessel.name + ">");
            out.newLine();
            --i;
        }
        out.write("</cag>");
        out.newLine();
    }
}

