/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Vector2D;
import java.awt.Point;
import java.io.Serializable;

public class Vertex2D
extends Vector2D
implements Serializable {
    double radius = 5.0;
    boolean corner = false;
    public double depth = 0.0;

    public Vertex2D() {
    }

    public Vertex2D(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public Vertex2D(double _x, double _y, double _d) {
        this.x = _x;
        this.y = _y;
        this.depth = _d;
    }

    public Vertex2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vertex2D(Vector2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vertex2D(double[] p) {
        this.x = p[0];
        this.y = p[1];
    }

    public Point Point() {
        return new Point((int)this.x, (int)this.y);
    }

    public Vertex2D copy() {
        Vertex2D v = new Vertex2D(this.x, this.y);
        return v;
    }

    public boolean same_position(Vertex2D v) {
        return this.x == v.x && this.y == v.y;
    }

    public static boolean same_position(Vertex2D a, Vertex2D b) {
        return a.x == b.x && a.y == b.y;
    }

    public static boolean touch(Vertex2D v0, Vertex2D v1) {
        return Vertex2D.distance(v0, v1) < 1.0E-5;
    }

    public static Vertex2D mid_point(Vector2D a, Vector2D b) {
        return new Vertex2D((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
    }

    public Vertex2D translate(Vector2D v) {
        return new Vertex2D(this.x + v.x, this.y + v.y);
    }

    public static Vertex2D translate(Vertex2D v, Vector2D vec) {
        return new Vertex2D(v.x + vec.x, v.y + vec.y);
    }

    public void warp(Vector2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void move_relative(Vector2D vec) {
        this.x += vec.x;
        this.y += vec.y;
    }

    public double distance(Vertex2D node) {
        return Math.sqrt((node.x - this.x) * (node.x - this.x) + (node.y - this.y) * (node.y - this.y));
    }

    public static double distance(Vertex2D n1, Vertex2D n2) {
        return Math.sqrt((n1.x - n2.x) * (n1.x - n2.x) + (n1.y - n2.y) * (n1.y - n2.y));
    }

    public static double distance(Vertex2D n1, Point n2) {
        return Math.sqrt((n1.x - (double)n2.x) * (n1.x - (double)n2.x) + (n1.y - (double)n2.y) * (n1.y - (double)n2.y));
    }

    public static Vertex2D interporate(Vertex2D start, Vertex2D end, double t) {
        return new Vertex2D(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t);
    }
}

