/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Line2D;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;

public class StrokeAnalyzer {
    public static Stroke resample_by_length(Stroke stroke, double n) {
        return new Stroke(StrokeAnalyzer.resample_by_length(stroke.points, n), stroke);
    }

    public static Stroke resample_by_length_stable(Stroke stroke, double n) {
        return new Stroke(StrokeAnalyzer.resample_by_length_stable(stroke.points, n), stroke);
    }

    public static Stroke resample_by_length_unstable_with_corners(Stroke stroke, double n) {
        return new Stroke(StrokeAnalyzer.resample_by_length_unstable_with_corners(stroke.points, n), stroke);
    }

    public static Stroke resample_by_length_stable_with_corners(Stroke stroke, double n) {
        return new Stroke(StrokeAnalyzer.resample_by_length_stable_with_corners(stroke.points, n), stroke);
    }

    public static Stroke resample_by_number(Stroke stroke, double n) {
        return new Stroke(StrokeAnalyzer.resample_by_number(stroke.points, n), stroke);
    }

    public static double distance(Stroke stroke, Point p) {
        double min = -1.0;
        int i = 0;
        while (i < stroke.points.size()) {
            Point v = (Point)stroke.points.get(i);
            double d = Vertex2D.distance(v, p);
            if (min == -1.0 || min > d) {
                min = d;
            }
            ++i;
        }
        return min;
    }

    public static Stroke smooth(Stroke stroke) {
        return new Stroke(StrokeAnalyzer.smooth(stroke.points));
    }

    public static Stroke smooth_preserve_sharp(Stroke stroke) {
        return new Stroke(StrokeAnalyzer.smooth_preserve_sharp(stroke.points));
    }

    public static Stroke enlarge(Stroke stroke) {
        Stroke new_stroke = new Stroke();
        int i = 0;
        while (i < stroke.points.size()) {
            Vertex2D v = (Vertex2D)stroke.points.get(i);
            new_stroke.addPoint(new Vertex2D(v.x * 5.0, v.y * 5.0));
            ++i;
        }
        return new_stroke;
    }

    public static void paint_stroke(ArrayList points, Graphics g) {
        int i = 0;
        while (i < points.size() - 1) {
            Vertex2D p = (Vertex2D)points.get(i);
            Vertex2D q = (Vertex2D)points.get(i + 1);
            g.drawLine((int)p.x, (int)p.y, (int)q.x, (int)q.y);
            ++i;
        }
    }

    public static double distance(ArrayList stroke, Vertex2D p) {
        double min = -1.0;
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D v = (Vertex2D)stroke.get(i);
            double d = Vertex2D.distance(v, p);
            if (min == -1.0 || min > d) {
                min = d;
            }
            ++i;
        }
        return min;
    }

    public static double calculate_area(ArrayList stroke) {
        Vertex2D p = (Vertex2D)stroke.get(stroke.size() - 1);
        double area = 0.0;
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D q = (Vertex2D)stroke.get(i);
            area += Vector2D.cross_product(p, q);
            p = q;
            ++i;
        }
        return area;
    }

    public static ArrayList resample_by_length(ArrayList stroke, double UNIT_LENGTH) {
        if (stroke.size() <= 1) {
            return stroke;
        }
        double length = StrokeAnalyzer.get_length(stroke);
        int n = (int)(length / UNIT_LENGTH + 0.5);
        if (n < 2) {
            n = 2;
        }
        return StrokeAnalyzer.resample_by_number(stroke, (double)n);
    }

    public static ArrayList resample_by_number(ArrayList stroke, double n) {
        if (stroke.size() <= 1) {
            return stroke;
        }
        double length = StrokeAnalyzer.get_length(stroke);
        double unit = length / n;
        Vertex2D v0 = (Vertex2D)stroke.get(0);
        Vertex2D v1 = (Vertex2D)stroke.get(stroke.size() - 1);
        ArrayList<Vertex2D> resampled = new ArrayList<Vertex2D>();
        resampled.add(v0);
        double total = 0.0;
        double prev_total = 0.0;
        Vertex2D prev = v0;
        double next_spot = unit;
        int count = 0;
        for (int index = 1; index != stroke.size(); ++index) {
            Vertex2D next = (Vertex2D)stroke.get(index);
            total += Vertex2D.distance(prev, next);
            while (total >= next_spot) {
                Vertex2D new_vertex = Vertex2D.interporate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit;
                if ((double)(++count) == n - 1.0) break;
            }
            if ((double)count == n - 1.0) break;
            prev = next;
            prev_total = total;
        }
        resampled.add(v1);
        return resampled;
    }

    public static double get_length(ArrayList stroke) {
        double length = 0.0;
        int i = 0;
        while (i < stroke.size() - 1) {
            Vertex2D p = (Vertex2D)stroke.get(i);
            Vertex2D q = (Vertex2D)stroke.get(i + 1);
            length += Vertex2D.distance(p, q);
            ++i;
        }
        return length;
    }

    public static ArrayList smooth(ArrayList points) {
        ArrayList<Vertex2D> new_points = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < points.size()) {
            Vertex2D v = (Vertex2D)points.get(i);
            if (i > 0 && i < points.size() - 1) {
                Vertex2D prev = (Vertex2D)points.get(i - 1);
                Vertex2D next = (Vertex2D)points.get(i + 1);
                Vector2D mid = Vector2D.multiply(Vector2D.add(prev, next), 0.5);
                v = Vertex2D.mid_point(v, mid);
            }
            new_points.add(v);
            ++i;
        }
        return new_points;
    }

    public static ArrayList smooth_preserve_sharp(ArrayList points) {
        ArrayList<Vertex2D> new_points = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < points.size()) {
            Vertex2D v = (Vertex2D)points.get(i);
            if (i > 1 && i < points.size() - 2) {
                Vertex2D next;
                Vector2D vec1;
                Vertex2D prev = (Vertex2D)points.get(i - 2);
                Vector2D vec0 = new Vector2D(prev, v);
                if (Vector2D.dot_product(vec0, vec1 = new Vector2D(v, next = (Vertex2D)points.get(i + 2))) >= 0.5) {
                    Vector2D mid = Vector2D.multiply(Vector2D.add(prev, next), 0.5);
                    v = Vertex2D.mid_point(v, mid);
                }
                new_points.add(v);
            } else {
                new_points.add(v);
            }
            ++i;
        }
        return new_points;
    }

    public static ArrayList resample_by_length_stable(ArrayList stroke, double unit) {
        if (stroke.size() <= 2) {
            return stroke;
        }
        Vertex2D v0 = (Vertex2D)stroke.get(0);
        Vertex2D v1 = (Vertex2D)stroke.get(stroke.size() - 1);
        ArrayList<Vertex2D> resampled = new ArrayList<Vertex2D>();
        resampled.add(v0);
        double total = 0.0;
        double prev_total = 0.0;
        Vertex2D prev = v0;
        double next_spot = unit;
        int count = 0;
        for (int index = 1; index != stroke.size(); ++index) {
            Vertex2D next = (Vertex2D)stroke.get(index);
            total += Vertex2D.distance(prev, next);
            while (total > next_spot) {
                Vertex2D new_vertex = Vertex2D.interporate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit;
                ++count;
            }
            prev = next;
            prev_total = total;
        }
        resampled.add(v1);
        return resampled;
    }

    public static ArrayList resample_by_length_loop_with_corners(ArrayList points, double unit) {
        if (points.size() <= 2) {
            return points;
        }
        points.add(points.get(0));
        int[] corners = StrokeAnalyzer.get_corner_indices(points);
        ArrayList new_points = new ArrayList();
        new_points.add(points.get(0));
        int i = 0;
        while (i < corners.length - 1) {
            ArrayList partial_points = new ArrayList();
            int j = corners[i];
            while (j <= corners[i + 1]) {
                partial_points.add(points.get(j));
                ++j;
            }
            partial_points = StrokeAnalyzer.resample_by_length(partial_points, unit);
            j = 1;
            while (j < partial_points.size()) {
                new_points.add(partial_points.get(j));
                ++j;
            }
            ((Vertex2D)new_points.get((int)(new_points.size() - 1))).corner = true;
            ++i;
        }
        return new_points;
    }

    public static ArrayList resample_by_length_unstable_with_corners(ArrayList points, double unit) {
        if (points.size() <= 2) {
            return points;
        }
        int[] corners = StrokeAnalyzer.get_corner_indices(points);
        ArrayList new_points = new ArrayList();
        new_points.add(points.get(0));
        int i = 0;
        while (i < corners.length - 1) {
            ArrayList partial_points = new ArrayList();
            int j = corners[i];
            while (j <= corners[i + 1]) {
                partial_points.add(points.get(j));
                ++j;
            }
            partial_points = StrokeAnalyzer.resample_by_length(partial_points, unit);
            j = 1;
            while (j < partial_points.size()) {
                new_points.add(partial_points.get(j));
                ++j;
            }
            ((Vertex2D)new_points.get((int)(new_points.size() - 1))).corner = true;
            ++i;
        }
        return new_points;
    }

    public static ArrayList resample_by_length_stable_with_corners(ArrayList points, double unit) {
        if (points.size() <= 2) {
            return points;
        }
        int[] corners = StrokeAnalyzer.get_corner_indices(points);
        ArrayList new_points = new ArrayList();
        new_points.add(points.get(0));
        int i = 0;
        while (i < corners.length - 1) {
            ArrayList partial_points = new ArrayList();
            int j = corners[i];
            while (j <= corners[i + 1]) {
                partial_points.add(points.get(j));
                ++j;
            }
            partial_points = i == corners.length - 2 ? StrokeAnalyzer.resample_by_length_stable(partial_points, unit) : StrokeAnalyzer.resample_by_length(partial_points, unit);
            j = 1;
            while (j < partial_points.size()) {
                new_points.add(partial_points.get(j));
                ++j;
            }
            ((Vertex2D)new_points.get((int)(new_points.size() - 1))).corner = true;
            ++i;
        }
        return new_points;
    }

    public static int[] get_corner_indices(ArrayList points) {
        ArrayList<Integer> corners = new ArrayList<Integer>();
        double[] cosines = new double[points.size()];
        int i = 2;
        while (i < points.size() - 2) {
            Vertex2D p0 = (Vertex2D)points.get(i - 2);
            Vertex2D p1 = (Vertex2D)points.get(i);
            Vertex2D p2 = (Vertex2D)points.get(i + 2);
            Vector2D vec0 = new Vector2D(p1, p0);
            Vector2D vec1 = new Vector2D(p1, p2);
            cosines[i] = Vector2D.cos(vec0, vec1);
            ++i;
        }
        Vertex2D p0 = (Vertex2D)points.get(0);
        int i2 = 3;
        while (i2 < points.size() - 3) {
            if (cosines[i2] >= -0.5 && cosines[i2] > cosines[i2 - 1] && cosines[i2] >= cosines[i2 + 1]) {
                corners.add(new Integer(i2));
            }
            ++i2;
        }
        int[] indices = new int[corners.size() + 2];
        indices[0] = 0;
        int i3 = 0;
        while (i3 < corners.size()) {
            indices[i3 + 1] = (Integer)corners.get(i3);
            ++i3;
        }
        indices[corners.size() + 1] = points.size() - 1;
        return indices;
    }

    public static ArrayList split_at_corners(Stroke stroke) {
        ArrayList<Stroke> strokes = new ArrayList<Stroke>();
        ArrayList<Vertex2D> points = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < stroke.number_of_points()) {
            Vertex2D v = stroke.getPoint(i);
            points.add(v);
            if (i == stroke.number_of_points() - 1) break;
            if (v.corner) {
                strokes.add(new Stroke(points, stroke));
                v.corner = false;
                points = new ArrayList();
                points.add(new Vertex2D(v));
            }
            ++i;
        }
        strokes.add(new Stroke(points, stroke));
        return strokes;
    }

    public static ArrayList remove_duplicated_points(ArrayList points) {
        ArrayList<Vertex2D> resampled = new ArrayList<Vertex2D>();
        Vertex2D prev_v = (Vertex2D)points.get(0);
        resampled.add(prev_v);
        int i = 1;
        while (i < points.size()) {
            Vertex2D v = (Vertex2D)points.get(i);
            if (Vertex2D.distance(prev_v, v) >= 1.0) {
                resampled.add(v);
                prev_v = v;
            }
            ++i;
        }
        return resampled;
    }

    public static Stroke resample_by_checking_deviation(Stroke stroke, double threshold, double unit_length) {
        if (stroke.number_of_points() <= 2) {
            return stroke;
        }
        ArrayList points = stroke.points;
        points = StrokeAnalyzer.remove_duplicated_points(points);
        points = StrokeAnalyzer.smooth_preserve_sharp(points);
        stroke = new Stroke(points, stroke);
        Stroke new_stroke = new Stroke(stroke.firstPoint(), stroke);
        Vertex2D prev_v = stroke.firstPoint();
        int prev_index = 0;
        int i = 2;
        while (i < stroke.number_of_points()) {
            Vertex2D v = stroke.getPoint(i);
            int index_of_maximum_deviation_point = StrokeAnalyzer.find_maximum_deviation_point(prev_index, i, stroke, threshold);
            if (index_of_maximum_deviation_point != -1) {
                prev_v = stroke.getPoint(index_of_maximum_deviation_point);
                prev_index = index_of_maximum_deviation_point;
                new_stroke.addPoint(prev_v);
            } else if (Vertex2D.distance(prev_v, v) > unit_length && i < stroke.number_of_points() - 1) {
                prev_v = stroke.getPoint(i);
                prev_index = i;
                new_stroke.addPoint(prev_v);
            }
            ++i;
        }
        new_stroke.addPoint(stroke.lastPoint());
        return new_stroke;
    }

    public static int find_maximum_deviation_point(int prev_index, int current_index, Stroke stroke, double max_deviation) {
        Vertex2D p = stroke.getPoint(prev_index);
        Vertex2D q = stroke.getPoint(current_index);
        Line2D line = new Line2D(p, new Vector2D(p, q));
        int max_deviation_index = -1;
        int i = prev_index + 1;
        while (i < current_index) {
            Vertex2D v = stroke.getPoint(i);
            double d = line.distance(v);
            if (d > max_deviation) {
                max_deviation = d;
                max_deviation_index = i;
            }
            ++i;
        }
        return max_deviation_index;
    }
}

