/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Edge2D;
import board.Graphics2;
import board.Record;
import board.Rectangle2D;
import board.Util;
import board.Vector2D;
import board.Vertex2D;
import board.VertexOnStroke;
import board.Vessel;
import board.Visual;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Stroke
extends Visual
implements Serializable {
    protected ArrayList points = new ArrayList();
    boolean is_loop = false;
    double radius = 10.0;
    public Rectangle2D bbox = new Rectangle2D(-1.0, -1.0, -1.0, -1.0);
    public Color color = Color.black;
    public int index;
    public int type;
    public String name;
    ArrayList grabbed_strokes = new ArrayList();
    Record record;
    public static final int NON_STROKE = 0;
    public static final int OSTIUM = 1;
    public static final int PROXIMAL = 2;
    public static final int MIDDLE = 3;
    public static final int DISTAL = 4;
    public static final int OTHER = 0;
    public static final int VESSEL = 1;
    public static final int KYOSAKU = 2;
    public static final int BYPASS = 3;
    public static final int STENOSIS = 4;
    public static final int MAIN = 5;
    public static final int ARROW = 6;
    public static final int CORATERAL = 7;
    public static final int BORDER_LINE = 8;

    Stroke() {
    }

    Stroke(Color c) {
        this.color = c;
    }

    Stroke(int n) {
        this.index = n;
    }

    Stroke(String s) {
        this.name = s;
    }

    Stroke(int x, int y) {
        this.addPoint(new Vertex2D(x, y));
    }

    Stroke(ArrayList points) {
        this.points = points;
        this.update_bbox();
    }

    Stroke(ArrayList points, double radius) {
        this.radius = radius;
        this.points = points;
        this.update_bbox();
    }

    Stroke(ArrayList points, double radius, Color color) {
        this(points, radius);
        this.color = color;
    }

    Stroke(ArrayList points, double radius, Color color, int index) {
        this(points, radius);
        this.color = color;
        this.index = index;
    }

    Stroke(ArrayList points, double radius, Color color, int index, int type) {
        this(points, radius);
        this.color = color;
        this.index = index;
        this.type = type;
    }

    Stroke(ArrayList points, double radius, Color color, int index, int type, String name) {
        this(points, radius);
        this.color = color;
        this.index = index;
        this.type = type;
        this.name = name;
    }

    Stroke(ArrayList points, Stroke stroke) {
        this.set_style(stroke);
        this.points = points;
        this.update_bbox();
    }

    public void set_style(Stroke stroke) {
        this.radius = stroke.radius;
        this.color = stroke.color;
        this.index = stroke.index;
    }

    Stroke(Vertex2D p0) {
        this();
        this.addPoint(p0);
    }

    Stroke(Vertex2D p0, Stroke stroke) {
        this();
        this.addPoint(p0);
        this.set_style(stroke);
    }

    Stroke(Vertex2D p0, Vertex2D p1) {
        this.addPoint(p0);
        this.addPoint(p1);
    }

    Stroke(Vertex2D p0, Vertex2D p1, Color c) {
        this(p0, p1);
        this.color = c;
    }

    Stroke(Vertex2D p0, Vertex2D p1, Color c, int n) {
        this(p0, p1);
        this.color = c;
        this.index = n;
    }

    Stroke(Vertex2D p0, Vertex2D p1, Color c, int n, int m) {
        this(p0, p1);
        this.color = c;
        this.index = n;
        this.type = m;
    }

    Stroke(Vertex2D p0, Vertex2D p1, Stroke stroke) {
        this(p0, p1);
        this.set_style(stroke);
    }

    Stroke(Vertex2D p0, Vertex2D p1, Vertex2D p2) {
        this.addPoint(p0);
        this.addPoint(p1);
        this.addPoint(p2);
    }

    public void paint(Graphics g, boolean debug) {
        g.setColor(this.color);
        Graphics2.paint_wide_stroke(g, this.points, 0.0, false, false);
    }

    public Stroke get_duplicated() {
        Stroke stroke = new Stroke();
        stroke.points = Stroke.get_duplicated_points(this.points);
        stroke.bbox = new Rectangle2D(this.bbox);
        stroke.set_style(this);
        stroke.is_loop = this.is_loop;
        return stroke;
    }

    public static Stroke move(Stroke stroke, Vertex2D v) {
        Stroke new_stroke = new Stroke();
        int i = 0;
        while (i < stroke.points.size()) {
            Vertex2D p = (Vertex2D)stroke.points.get(i);
            new_stroke.addPoint(p.x + v.x, p.y + v.y);
            ++i;
        }
        new_stroke.update_bbox();
        return new_stroke;
    }

    public static Stroke scale(Stroke stroke, double m) {
        Stroke new_stroke = new Stroke();
        int i = 0;
        while (i < stroke.points.size()) {
            Vertex2D p = (Vertex2D)stroke.points.get(i);
            new_stroke.addPoint((int)(p.x * m), (int)(p.y * m));
            ++i;
        }
        new_stroke.update_bbox();
        return new_stroke;
    }

    public void set_position_and_scale(Stroke stroke) {
        this.set_point_locations(stroke);
        this.radius = stroke.radius;
        this.update_bbox();
    }

    public Stroke get_scaled_and_rotated(Vertex2D center, double scale, double angle) {
        ArrayList new_points = Stroke.get_scaled_and_rotated_points(this.points, center, scale, angle);
        return new Stroke(new_points, this.radius * scale, this.color);
    }

    public Stroke copy() {
        Stroke new_stroke = new Stroke();
        new_stroke.index = this.index;
        new_stroke.color = this.color;
        new_stroke.radius = this.radius;
        new_stroke.type = this.type;
        int i = 0;
        while (i < this.points.size()) {
            new_stroke.addPoint((Vertex2D)this.points.get(i));
            ++i;
        }
        return new_stroke;
    }

    public Stroke remove_start_end() {
        Stroke new_stroke = new Stroke();
        new_stroke.index = this.index;
        new_stroke.color = this.color;
        new_stroke.radius = this.radius;
        new_stroke.type = this.type;
        int i = 1;
        while (i < this.points.size() - 1) {
            new_stroke.addPoint((Vertex2D)this.points.get(i));
            ++i;
        }
        return new_stroke;
    }

    public double direct_length() {
        if (this.points.size() < 2) {
            return 0.0;
        }
        Vertex2D p0 = (Vertex2D)this.points.get(0);
        Vertex2D p1 = (Vertex2D)this.points.get(this.points.size() - 1);
        return Vertex2D.distance(p0, p1);
    }

    public boolean straight() {
        return 1.0 * this.length() / this.direct_length() < 1.2;
    }

    public void update_bbox() {
        this.bbox = Stroke.compute_bbox(this.points);
        this.bbox.x -= this.radius;
        this.bbox.y -= this.radius;
        this.bbox.width += this.radius * 2.0;
        this.bbox.height += this.radius * 2.0;
    }

    public void paint_graph(Graphics g) {
        if (this.color != Color.red) {
            return;
        }
        int y0 = (int)(this.bbox.y + this.bbox.height + 20.0);
        int x0 = (int)this.bbox.x;
        int h = 50;
        int w = 50;
        g.setColor(Color.yellow);
        g.drawRect(x0, y0, w, h);
        g.setColor(Color.red);
        double total_length = this.length();
        Vector2D prev_vec = new Vector2D(1.0, 0.0);
        double angle = 0.0;
        double x = x0;
        double prev_x = x0;
        int i = 0;
        while (i < this.points.size() - 1) {
            Vertex2D p0 = (Vertex2D)this.points.get(i);
            Vertex2D p1 = (Vertex2D)this.points.get(i + 1);
            Vector2D vec = new Vector2D(p0, p1);
            double m = (angle += prev_vec.get_angle180(vec)) / 360.0;
            m -= Math.floor(m);
            int y = (int)((double)y0 + (double)h * m);
            g.drawLine((int)prev_x, y, (int)(x += (double)w * Vertex2D.distance(p0, p1) / total_length), y);
            prev_x = x;
            prev_vec = vec;
            ++i;
        }
    }

    public void save(BufferedWriter out) throws IOException {
        if (this instanceof Vessel) {
            this.index = ((Vessel)this).id;
        }
        out.write("stroke");
        out.newLine();
        out.write(Stroke.save_index(this.index));
        out.newLine();
        out.write(Stroke.save_color(this.color));
        out.newLine();
        out.write(Stroke.save_radius(this.radius));
        out.newLine();
        out.write(Stroke.save_type(this.type));
        out.newLine();
        out.write(Stroke.save_name(this.name));
        out.newLine();
        ArrayList _points = this.points;
        if (this.is_loop) {
            _points = Util.duplicateArrayList(this.points);
            _points.add(_points.get(0));
        }
        out.write(Stroke.save_points(_points));
        out.newLine();
    }

    public static String save_color(Color color) {
        if (color == null) {
            color = Color.black;
        }
        return (double)color.getRed() / 255.0 + " " + (double)color.getGreen() / 255.0 + " " + (double)color.getBlue() / 255.0;
    }

    public static Color load_color(String line) {
        StringTokenizer st = new StringTokenizer(line);
        double[] color = new double[]{new Double(st.nextToken()), new Double(st.nextToken()), new Double(st.nextToken())};
        return new Color((int)(color[0] * 255.0), (int)(color[1] * 255.0), (int)(color[2] * 255.0));
    }

    public static String save_radius(double radius) {
        return "" + radius;
    }

    public static double load_radius(String line) {
        StringTokenizer st = new StringTokenizer(line);
        double[] radius = new double[]{new Double(st.nextToken())};
        return radius[0];
    }

    public static String save_index(int index) {
        return "" + index;
    }

    public static int load_index(String line) {
        int index = Integer.parseInt(line);
        return index;
    }

    public static String save_type(int type) {
        return "" + type;
    }

    public static String save_name(String name) {
        return name;
    }

    public static String load_name(String line) {
        return line;
    }

    public static int load_type(String line) {
        int type = Integer.parseInt(line);
        return type;
    }

    public void load(BufferedReader in) throws IOException {
        String line = in.readLine();
        this.index = Stroke.load_index(line);
        line = in.readLine();
        this.color = Stroke.load_color(line);
        line = in.readLine();
        this.radius = Stroke.load_radius(line);
        line = in.readLine();
        this.type = Stroke.load_type(line);
        line = in.readLine();
        this.name = Stroke.load_name(line);
        line = in.readLine();
        this.points = Stroke.load_points(line);
        if (this.points.size() > 2 && Vertex2D.same_position(this.firstPoint(), this.lastPoint())) {
            this.points.remove(this.points.size() - 1);
            this.is_loop = true;
        }
        this.update_bbox();
    }

    public static double distance(Stroke stroke0, Stroke stroke1) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < stroke0.points.size() - 1) {
            Edge2D edge0 = new Edge2D(stroke0.getPoint(i), stroke0.getPoint(i + 1));
            int j = 0;
            while (j < stroke1.points.size() - 1) {
                Edge2D edge1 = new Edge2D(stroke1.getPoint(j), stroke1.getPoint(j + 1));
                double distance = Edge2D.distance(edge0, edge1);
                if (distance < min) {
                    min = distance;
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public String toString() {
        String string = "";
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D v = this.getPoint(i);
            string = String.valueOf(string) + "{" + (int)v.x + ", " + (int)v.y + "},";
            ++i;
        }
        return string;
    }

    public void set_depth(double depth) {
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D v = this.getPoint(i);
            v.depth = depth;
            ++i;
        }
    }

    public Rectangle2D get_bbox() {
        return this.bbox;
    }

    public static Rectangle2D compute_bbox(ArrayList points) {
        if (points.size() == 0) {
            return new Rectangle2D(0.0, 0.0, 0.0, 0.0);
        }
        double x0 = Double.MAX_VALUE;
        double y0 = Double.MAX_VALUE;
        double x1 = -1.7976931348623157E308;
        double y1 = -1.7976931348623157E308;
        int i = 0;
        while (i < points.size()) {
            Vertex2D point = (Vertex2D)points.get(i);
            if (x0 > point.x) {
                x0 = point.x;
            }
            if (y0 > point.y) {
                y0 = point.y;
            }
            if (x1 < point.x) {
                x1 = point.x;
            }
            if (y1 < point.y) {
                y1 = point.y;
            }
            ++i;
        }
        return new Rectangle2D((int)x0, (int)y0, (int)(x1 - x0 + 1.0), (int)(y1 - y0 + 1.0));
    }

    public int number_of_points() {
        return this.points.size();
    }

    public boolean is_loop() {
        return this.is_loop;
    }

    public boolean is_terminal(int index) {
        if (this.is_loop()) {
            return false;
        }
        return index == 0 || index == this.points.size() - 1;
    }

    public void addEdge(Vertex2D p0, Vertex2D p1) {
        this.addPoint(new Vertex2D(p0));
        this.addPoint(new Vertex2D(p1));
        this.addPoint(null);
    }

    public Vertex2D firstPoint() {
        return this.points.isEmpty() ? null : (Vertex2D)this.points.get(0);
    }

    public Vertex2D lastPoint() {
        return this.points.isEmpty() ? null : (Vertex2D)this.points.get(this.points.size() - 1);
    }

    public Vertex2D getPoint(int index) {
        if (this.is_loop()) {
            while (index < 0) {
                index += this.number_of_points();
            }
            while (index > this.number_of_points() - 1) {
                index -= this.number_of_points();
            }
        }
        if (index < 0 || index >= this.number_of_points()) {
            return null;
        }
        return (Vertex2D)this.points.get(index);
    }

    public ArrayList get_points() {
        return this.points;
    }

    public Edge2D getEdge(int index) {
        if (this.points.size() == 1) {
            if (index == 0) {
                Vertex2D v0 = this.getPoint(0);
                return new Edge2D(v0, v0, this.radius);
            }
            return null;
        }
        Vertex2D v0 = this.getPoint(index);
        Vertex2D v1 = this.getPoint(index + 1);
        if (v0 == null || v1 == null) {
            return null;
        }
        return new Edge2D(v0, v1, this.radius);
    }

    public int number_of_edges() {
        if (this.points.size() == 1) {
            return 1;
        }
        if (this.is_loop) {
            return this.points.size();
        }
        return this.points.size() - 1;
    }

    public int adjust_index(int index) {
        if (this.is_loop()) {
            while (index < 0) {
                index += this.number_of_points();
            }
            while (index > this.number_of_points() - 1) {
                index -= this.number_of_points();
            }
        }
        return index;
    }

    public void addPoint(double x, double y) {
        this.addPoint(new Vertex2D(x, y));
    }

    public void addPoint(Vertex2D p) {
        this.points.add(p);
        this.update_bbox();
    }

    public void set_points(ArrayList points) {
        this.points = points;
    }

    public void removePointAt(int index) {
        this.points.remove(index);
    }

    public static ArrayList get_duplicated_points(ArrayList points) {
        ArrayList<Vertex2D> new_points = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < points.size()) {
            Vertex2D p = (Vertex2D)points.get(i);
            if (p == null) {
                new_points.add(null);
            } else {
                new_points.add(new Vertex2D(p));
            }
            ++i;
        }
        return new_points;
    }

    public Vertex2D get_center() {
        return new Vertex2D(this.bbox.x + this.bbox.width / 2.0, this.bbox.y + this.bbox.height / 2.0);
    }

    public double length() {
        double length = 0.0;
        int i = 0;
        while (i < this.points.size() - 1) {
            Vertex2D p0 = (Vertex2D)this.points.get(i);
            Vertex2D p1 = (Vertex2D)this.points.get(i + 1);
            if (p0 == null || p1 != null) {
                // empty if block
            }
            length += Vertex2D.distance(p0, p1);
            ++i;
        }
        return length;
    }

    public double distance(Vertex2D p) {
        if (this.points.size() == 1) {
            return Vertex2D.distance((Vertex2D)this.points.get(0), p);
        }
        double min = -1.0;
        int i = 0;
        while (i < this.number_of_edges()) {
            Vertex2D v0 = (Vertex2D)this.points.get(i);
            double d = this.getEdge(i).distance(p);
            if (min == -1.0 || min > d) {
                min = d;
            }
            ++i;
        }
        return min;
    }

    public static String save_points(ArrayList points) {
        Vertex2D prev_p = null;
        String line = "";
        int i = 0;
        while (i < points.size()) {
            Vertex2D p = (Vertex2D)points.get(i);
            line = prev_p == null ? String.valueOf(line) + p.x + " " + p.y + " " : String.valueOf(line) + (p.x - prev_p.x) + " " + (p.y - prev_p.y) + " ";
            prev_p = p;
            ++i;
        }
        return line;
    }

    public static ArrayList load_points(String line) {
        ArrayList<Vertex2D> points = new ArrayList<Vertex2D>();
        StringTokenizer st = new StringTokenizer(line);
        Vertex2D prev_p = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            double x = new Double(token);
            if (!st.hasMoreTokens()) break;
            token = st.nextToken();
            double y = new Double(token);
            Vertex2D p = new Vertex2D(x, y);
            if (prev_p != null) {
                p.x += prev_p.x;
                p.y += prev_p.y;
            }
            points.add(p);
            prev_p = p;
        }
        return points;
    }

    public void remove_duplicated_points() {
        int n = this.is_loop() ? this.points.size() : this.points.size() - 1;
        int j = 0;
        while (j < n) {
            if (this.getPoint(j).same_position(this.getPoint(j + 1))) {
                this.points.remove(j);
                --j;
                --n;
            }
            ++j;
        }
    }

    public void set_point_locations(Stroke Stroke2) {
        int i = 0;
        while (i < Stroke2.points.size()) {
            Vertex2D p = (Vertex2D)this.points.get(i);
            Vertex2D new_p = (Vertex2D)Stroke2.points.get(i);
            if (p != null) {
                p.x = new_p.x;
                p.y = new_p.y;
            }
            ++i;
        }
    }

    public static ArrayList get_scaled_and_rotated_points(ArrayList points, Vertex2D center, double scale, double angle) {
        ArrayList<Vertex2D> new_points = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < points.size()) {
            Vertex2D p = (Vertex2D)points.get(i);
            Vector2D v = new Vector2D(center, p);
            v.multiply(scale);
            v = Vector2D.rotate(v, angle);
            new_points.add(new Vertex2D(center.x + v.x, center.y + v.y));
            ++i;
        }
        return new_points;
    }

    public boolean closedBy(Stroke loop) {
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D p = (Vertex2D)this.points.get(i);
            if (!loop.enclose(p)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean enclose(ArrayList points) {
        int i = 0;
        while (i < points.size()) {
            if (!this.enclose((Vertex2D)points.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean enclose(Vertex2D p) {
        return Stroke.enclose(this.points, p);
    }

    public static boolean enclose(ArrayList points, Vertex2D p) {
        Vertex2D q0 = (Vertex2D)points.get(points.size() - 1);
        double angle = 0.0;
        int i = 0;
        while (i < points.size()) {
            Vertex2D q1 = (Vertex2D)points.get(i);
            Vector2D v0 = new Vector2D(p, q0);
            Vector2D v1 = new Vector2D(p, q1);
            angle += v0.get_angle180(v1);
            q0 = q1;
            ++i;
        }
        return angle < -180.0 || angle > 180.0;
    }

    public boolean is_clockwise() {
        Vertex2D q0 = (Vertex2D)this.points.get(this.points.size() - 1);
        double area = 0.0;
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D q1 = (Vertex2D)this.points.get(i);
            area += Vector2D.cross_product(q0, q1);
            q0 = q1;
            ++i;
        }
        return area > 0.0;
    }

    public boolean on_boundary(Vertex2D v) {
        int i = 0;
        while (i < this.number_of_edges()) {
            Edge2D edge = this.getEdge(i);
            if (Edge2D.touch(edge, v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public VertexOnStroke find_closest_VertexOnStroke(Vertex2D p) {
        VertexOnStroke closest_vertex = null;
        double min = -1.0;
        double path_length = 0.0;
        int i = 0;
        while (i < this.points.size() - 1) {
            Vertex2D v0 = (Vertex2D)this.points.get(i);
            Vertex2D v1 = (Vertex2D)this.points.get(i + 1);
            double d = new Edge2D(v0, v1).distance(p);
            if (min == -1.0 || min > d) {
                min = d;
                Vertex2D v = new Edge2D(v0, v1).find_closest_vertex(p);
                closest_vertex = new VertexOnStroke(v, this, path_length + Vertex2D.distance(v0, v), i);
                closest_vertex.distance = d;
            }
            path_length += Vertex2D.distance(v0, v1);
            ++i;
        }
        return closest_vertex;
    }

    public void move_relative(double dx, double dy) {
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D p = (Vertex2D)this.points.get(i);
            if (p != null) {
                p.x += dx;
                p.y += dy;
            }
            ++i;
        }
        this.bbox.x += dx;
        this.bbox.y += dy;
    }

    public void move_absolute(ArrayList new_points) {
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D p = (Vertex2D)this.points.get(i);
            Vertex2D new_p = (Vertex2D)new_points.get(i);
            if (p != null) {
                p.x = new_p.x;
                p.y = new_p.y;
            }
            ++i;
        }
    }

    public Vertex2D get_most_distant_point(Stroke area1) {
        int index = this.get_most_distant_point_index(area1);
        if (index == -1) {
            System.out.println("error in get_most_distant_point in Stroke");
            return null;
        }
        return this.getPoint(index);
    }

    public int get_most_distant_point_index(Stroke area1) {
        Stroke area0 = this;
        double max = Double.MIN_VALUE;
        int index0 = -1;
        int i = 0;
        while (i < area0.points.size()) {
            Vertex2D v0 = area0.getPoint(i);
            VertexOnStroke v1 = area1.find_closest_VertexOnStroke(v0);
            if (v1.distance > max) {
                max = v1.distance;
                index0 = i;
            }
            ++i;
        }
        if (max < 1.0E-5) {
            return -1;
        }
        return index0;
    }

    public static boolean intersects_for_dragging(Stroke stroke0, Stroke stroke1) {
        int i = 0;
        while (i < stroke0.number_of_edges()) {
            Edge2D edge0 = stroke0.getEdge(i);
            int j = 0;
            while (j < stroke1.number_of_edges()) {
                Edge2D edge1 = stroke1.getEdge(j);
                if (Edge2D.distance(edge0, edge1) < 15.0) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean intersects_for_dragging(Vertex2D p, Stroke stroke) {
        int i = 0;
        while (i < stroke.number_of_edges()) {
            Edge2D edge = stroke.getEdge(i);
            if (edge.distance(p) < 15.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean intersects(Stroke stroke0, Stroke stroke1) {
        int i = 0;
        while (i < stroke0.number_of_edges()) {
            Edge2D edge0 = stroke0.getEdge(i);
            int j = 0;
            while (j < stroke1.number_of_edges()) {
                Edge2D edge1 = stroke1.getEdge(j);
                if (Edge2D.cross(edge0, edge1)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

