/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.DrawPanel;
import board.Graphics2;
import board.Main;
import board.Record;
import board.Vertex2D;
import board.VertexOnStroke;
import board.Vessel;
import board.Visual;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;

public class Stent
extends Visual
implements Serializable {
    Vessel vessel;
    int start_index;
    int end_index;
    int type;
    int vessel_id;
    int stent_id;
    static int[] connect_points;
    static final int SNAP_LENGTH = 5;
    static Image texture;
    ArrayList brothers = new ArrayList();
    boolean predesessor = false;
    boolean successor = false;
    static Vessel target_vessel;
    static Stent stent;
    static VertexOnStroke start_v;
    static VertexOnStroke end_v;
    static Record record;
    static int init_point_for_dragging;
    static int init_start_point;
    static int init_end_point;
    static int stent_real_end_index;
    static int stent_real_start_index;
    static Vessel root_vessel;
    static int connect_points_count;

    static {
        init_point_for_dragging = -1;
        init_start_point = -1;
        init_end_point = -1;
        connect_points_count = 0;
    }

    Stent(Vessel vessel) {
        this.vessel = vessel;
        vessel.stents.add(this);
        this.vessel_id = vessel.id;
    }

    void paint(Graphics g) {
        ArrayList<Vertex2D> points = new ArrayList<Vertex2D>();
        int i = this.start_index;
        while (i <= this.end_index) {
            points.add(this.vessel.getPoint(i));
            ++i;
        }
        Graphics2.clip_wide_stroke(g, points, 0.0, false, false);
        if (texture == null) {
            Stent.create_mesh_texture();
        }
        g.drawImage(texture, 0, 0, null);
        g.setClip(null);
    }

    static void create_mesh_texture() {
        texture = Main.drawPanel.createImage(Main.drawPanel.getWidth(), Main.drawPanel.getHeight());
        Graphics g = texture.getGraphics();
        g.setColor(Color.black);
        int width = Main.drawPanel.getWidth();
        int height = Main.drawPanel.getHeight();
        int x = 0;
        while (x < width + height) {
            g.drawLine(x, 0, x - height, height);
            x += 10;
        }
        x = -height;
        while (x < width) {
            g.drawLine(x, 0, x + height, height);
            x += 10;
        }
        g.dispose();
    }

    static void classification(DrawPanel drawPanel, Vertex2D v) {
        target_vessel = drawPanel.find_closest_vessel(v);
        if (target_vessel == null) {
            return;
        }
        ArrayList<Vessel> target_vessel_copy = new ArrayList<Vessel>();
        target_vessel_copy.add(target_vessel);
        Stent target_stent = Stent.pick_stent(v, target_vessel_copy);
        System.out.println("target_stent:" + target_stent);
        if (target_stent == null) {
            drawPanel.operation_status = 12;
            Stent.start_drawing_stent(drawPanel, v);
        } else if (Stent.edge_of_stent(target_stent, v)) {
            drawPanel.operation_status = 12;
            boolean flag = Stent.near_start_point(target_stent, v);
            Stent.edit_drawing_stent(drawPanel, v, target_stent, flag);
        } else {
            drawPanel.operation_status = 13;
            Stent.start_dragging_stent(drawPanel, v, target_stent);
        }
    }

    static void start_drawing_stent(DrawPanel drawPanel, Vertex2D v) {
        target_vessel = drawPanel.find_closest_vessel(v);
        if (target_vessel == null) {
            return;
        }
        target_vessel = Stent.get_merged_vessel(target_vessel);
        start_v = target_vessel.find_closest_VertexOnStroke(v);
        stent = new Stent(target_vessel);
        Stent.stent.start_index = Stent.start_v.index;
        Stent.stent.end_index = Stent.start_v.index + 1;
    }

    static void drawing_stent(DrawPanel drawPanel, Vertex2D v) {
        int connect_point;
        if (target_vessel == null) {
            return;
        }
        end_v = target_vessel.find_closest_VertexOnStroke(v);
        if (Stent.end_v.index > Stent.start_v.index) {
            Stent.stent.start_index = Stent.start_v.index;
            Stent.stent.end_index = Stent.end_v.index;
        } else if (Stent.end_v.index < Stent.start_v.index) {
            Stent.stent.start_index = Stent.end_v.index;
            Stent.stent.end_index = Stent.start_v.index;
        } else {
            Stent.stent.start_index = Stent.start_v.index;
            Stent.stent.end_index = Stent.start_v.index + 1;
        }
        int i = 0;
        while (i < connect_points_count) {
            connect_point = connect_points[i];
            if (-5 < connect_point - Stent.stent.end_index && connect_point - Stent.stent.end_index < 5) {
                Stent.stent.end_index = connect_point;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < connect_points_count) {
            connect_point = connect_points[i];
            if (-5 < connect_point - Stent.stent.start_index && connect_point - Stent.stent.start_index < 5) {
                Stent.stent.start_index = connect_point;
                break;
            }
            ++i;
        }
        drawPanel.repaint_all();
    }

    static void finish_drawing_stent(DrawPanel drawPanel, Vertex2D v) {
        if (target_vessel == null) {
            return;
        }
        end_v = target_vessel.find_closest_VertexOnStroke(v);
        if (Vertex2D.same_position(Stent.start_v.v, Stent.end_v.v)) {
            stent.delete();
        } else {
            Stent.split_stent();
        }
        target_vessel = null;
        stent = null;
    }

    static void paint_new_stent(Graphics g) {
        if (stent == null) {
            return;
        }
        stent.paint(g);
    }

    static void edit_drawing_stent(DrawPanel drawPanel, Vertex2D v, Stent target_stent, boolean flag) {
        target_vessel = drawPanel.find_closest_vessel(v);
        if (target_vessel == null) {
            return;
        }
        stent = target_stent;
        target_vessel = Stent.get_merged_vessel(target_vessel);
        end_v = target_vessel.find_closest_VertexOnStroke(v);
        if (flag) {
            System.out.println("around start point");
            Stent.start_v.index = Stent.stent.end_index;
            Stent.end_v.index = Stent.stent.start_index;
        } else {
            System.out.println("around end point");
            Stent.start_v.index = Stent.stent.start_index;
            Stent.end_v.index = Stent.stent.end_index;
        }
    }

    static void start_dragging_stent(DrawPanel drawPanel, Vertex2D v, Stent target_stent) {
        target_vessel = drawPanel.find_closest_vessel(v);
        if (target_vessel == null) {
            return;
        }
        stent = target_stent;
        stent_real_end_index = Stent.stent.end_index;
        stent_real_start_index = Stent.stent.start_index;
        target_vessel = Stent.get_merged_vessel(target_vessel);
        start_v = target_vessel.find_closest_VertexOnStroke(v);
    }

    static void dragging_stent(DrawPanel drawPanel, Vertex2D v) {
        if (target_vessel == null) {
            return;
        }
        end_v = target_vessel.find_closest_VertexOnStroke(v);
        int move_index = Stent.end_v.index - Stent.start_v.index;
        start_v = end_v;
        Stent.slide_stent(stent, move_index);
        int i = 0;
        while (i < connect_points_count) {
            int connect_point = connect_points[i];
            move_index = connect_point - Stent.stent.end_index;
            if (-5 < move_index && move_index < 5) {
                Stent.slide_stent(stent, move_index);
                break;
            }
            move_index = connect_point - Stent.stent.start_index;
            if (-5 < move_index && move_index < 5) {
                Stent.slide_stent(stent, move_index);
                break;
            }
            ++i;
        }
        drawPanel.repaint_all();
    }

    static void finish_dragging_stent(DrawPanel drawPanel, Vertex2D v) {
        if (target_vessel == null) {
            return;
        }
        Stent.split_stent();
        target_vessel = null;
        stent = null;
    }

    static void slide_stent(Stent target, int _slide) {
        target.start_index += _slide;
        target.end_index += _slide;
        int i = 0;
        while (i < target.brothers.size()) {
            Stent brother = (Stent)target.brothers.get(i);
            brother.start_index += _slide;
            brother.end_index += _slide;
            ++i;
        }
    }

    static Stent pick_stent(Vertex2D v, ArrayList vessels) {
        Stent picked_stent = null;
        double min = 10.0;
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            int j = 0;
            while (j < vessel.stents.size()) {
                Stent stent = (Stent)vessel.stents.get(j);
                double d = stent.distance(v);
                if (d < min) {
                    picked_stent = stent;
                    min = d;
                }
                ++j;
            }
            ++i;
        }
        return picked_stent;
    }

    public double distance(Vertex2D p) {
        double min = -1.0;
        int i = this.start_index;
        while (i < this.end_index) {
            double d = this.vessel.getEdge(i).distance(p);
            if (min == -1.0 || min > d) {
                min = d;
            }
            ++i;
        }
        return min;
    }

    static Vessel get_merged_vessel(Vessel vessel) {
        root_vessel = vessel.get_root();
        Vessel merged_vessel = new Vessel();
        connect_points = new int[10];
        connect_points_count = 0;
        Vessel current_vessel = root_vessel;
        while (true) {
            int index;
            current_vessel.merged_index = merged_vessel.points.size();
            merged_vessel.points.addAll(current_vessel.points);
            Vessel next_vessel = current_vessel.successor;
            if (next_vessel == null) break;
            merged_vessel.points.remove(merged_vessel.points.size() - 1);
            Stent.connect_points[Stent.connect_points_count] = index = merged_vessel.points.size();
            ++connect_points_count;
            current_vessel = next_vessel;
        }
        int start_index = 100;
        int end_index = -1;
        if (stent != null) {
            int j = 0;
            while (j < Stent.stent.brothers.size()) {
                Stent brother = (Stent)Stent.stent.brothers.get(j);
                if (start_index > brother.start_index + brother.vessel.merged_index) {
                    start_index = brother.start_index + brother.vessel.merged_index;
                }
                if (end_index < brother.end_index + brother.vessel.merged_index) {
                    end_index = brother.end_index + brother.vessel.merged_index;
                }
                ++j;
            }
            Stent new_stent = new Stent(merged_vessel);
            new_stent.start_index = start_index;
            new_stent.end_index = end_index;
            new_stent.stent_id = Stent.stent.stent_id;
            stent.delete();
            stent = new_stent;
        }
        return merged_vessel;
    }

    static void split_stent() {
        int start = Stent.stent.start_index;
        int end = Stent.stent.end_index;
        Vessel current_vessel = root_vessel;
        int index = 0;
        ArrayList<Stent> brothers = new ArrayList<Stent>();
        while (start >= index + current_vessel.points.size() - 1) {
            index += current_vessel.points.size() - 1;
            current_vessel = current_vessel.successor;
        }
        Stent child_stent = new Stent(current_vessel);
        child_stent.start_index = start - index;
        brothers.add(child_stent);
        while (end > index + current_vessel.points.size() - 1) {
            child_stent.end_index = current_vessel.points.size() - 1;
            index += current_vessel.points.size();
            current_vessel = current_vessel.successor;
            child_stent.successor = true;
            child_stent = new Stent(current_vessel);
            child_stent.start_index = 0;
            child_stent.stent_id = Stent.stent.stent_id;
            brothers.add(child_stent);
            child_stent.predesessor = true;
        }
        child_stent.end_index = end - index;
        int i = 0;
        while (i < brothers.size()) {
            child_stent = (Stent)brothers.get(i);
            child_stent.brothers = brothers;
            ++i;
        }
        stent = child_stent;
    }

    static Stent set_stent(Vessel vessel, int start_index, int end_index) {
        Stent stent = new Stent(vessel);
        stent.start_index = start_index;
        stent.end_index = end_index;
        return stent;
    }

    static boolean edge_of_stent(Stent target_stent, Vertex2D v) {
        boolean return_val = false;
        if (Stent.near_start_point(target_stent, v) || Stent.near_end_point(target_stent, v)) {
            return_val = true;
        }
        return return_val;
    }

    static boolean near_start_point(Stent target_stent, Vertex2D v) {
        boolean return_val = false;
        int distance = 5;
        VertexOnStroke closest_v = target_vessel.find_closest_VertexOnStroke(v);
        if (closest_v.index - target_stent.start_index < distance && closest_v.index - target_stent.start_index > -distance) {
            return_val = true;
        }
        return return_val;
    }

    static boolean near_end_point(Stent target_stent, Vertex2D v) {
        boolean return_val = false;
        int distance = 5;
        VertexOnStroke closest_v = target_vessel.find_closest_VertexOnStroke(v);
        if (closest_v.index - target_stent.end_index < distance && closest_v.index - target_stent.end_index > -distance) {
            return_val = true;
        }
        return return_val;
    }

    void delete() {
        if (!this.vessel.stents.contains(this)) {
            return;
        }
        this.vessel.stents.remove(this);
        int i = 0;
        while (i < this.brothers.size()) {
            Stent stent = (Stent)this.brothers.get(i);
            if (stent != this) {
                stent.delete();
            }
            ++i;
        }
    }
}

