/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.AnnotatePanel;
import board.DrawPanel;
import board.Graphics2;
import board.Record;
import board.Vertex2D;
import board.VertexOnStroke;
import board.Vessel;
import board.Visual;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;

public class Stenosis
extends Visual
implements Serializable {
    Vessel vessel;
    int start_index;
    int end_index;
    int type;
    int vessel_id;
    int stenosis_id;
    static int[] connect_points;
    private AnnotatePanel annotatePanel;
    static final int SNAP_LENGTH = 5;
    double ratio = 50.0;
    ArrayList brothers = new ArrayList();
    boolean predesessor = false;
    boolean successor = false;
    static Vessel target_vessel;
    static Stenosis stenosis;
    static VertexOnStroke start_v;
    static VertexOnStroke end_v;
    static Record record;
    static int init_point_for_dragging;
    static int init_start_point;
    static int init_end_point;
    static int stenosis_real_end_index;
    static int stenosis_real_start_index;
    static Vessel root_vessel;
    static int connect_points_count;

    static {
        init_point_for_dragging = -1;
        init_start_point = -1;
        init_end_point = -1;
        connect_points_count = 0;
    }

    Stenosis(Vessel vessel) {
        this.vessel = vessel;
        vessel.stenoses.add(this);
        this.vessel_id = vessel.id;
    }

    void paint_outside(Graphics g) {
        ArrayList<Vertex2D> points = new ArrayList<Vertex2D>();
        int i = this.start_index;
        while (i <= this.end_index) {
            points.add(this.vessel.getPoint(i));
            ++i;
        }
        g.setColor(Color.black);
        Graphics2.paint_wide_stroke(g, points, 0.0, this.predesessor, this.successor);
    }

    void paint_inside(Graphics g) {
        ArrayList<Vertex2D> points = new ArrayList<Vertex2D>();
        int i = this.start_index;
        while (i <= this.end_index) {
            Vertex2D v = new Vertex2D(this.vessel.getPoint(i));
            v.radius = Math.sqrt((100.0 - this.ratio) / 100.0) * this.vessel.getPoint((int)i).radius;
            points.add(v);
            ++i;
        }
        g.setColor(Color.white);
        Graphics2.paint_wide_stroke(g, points, 0.0, true, true);
    }

    void set_type(int _type) {
        this.type = _type;
        int i = 0;
        while (i < this.brothers.size()) {
            ((Stenosis)this.brothers.get((int)i)).type = _type;
            ++i;
        }
    }

    void set_ratio(int _ratio) {
        this.ratio = _ratio;
        int i = 0;
        while (i < this.brothers.size()) {
            ((Stenosis)this.brothers.get((int)i)).ratio = _ratio;
            ++i;
        }
    }

    static void classification(DrawPanel drawPanel, Vertex2D v) {
        target_vessel = drawPanel.find_closest_vessel(v);
        if (target_vessel == null) {
            return;
        }
        ArrayList<Vessel> target_vessel_copy = new ArrayList<Vessel>();
        target_vessel_copy.add(target_vessel);
        Stenosis target_stenosis = Stenosis.pick_stenosis(v, target_vessel_copy);
        System.out.println("target_stenosis" + target_stenosis);
        if (target_stenosis == null) {
            drawPanel.operation_status = 5;
            Stenosis.start_drawing_stenosis(drawPanel, v);
        } else if (Stenosis.edge_of_stenosis(target_stenosis, v)) {
            drawPanel.operation_status = 5;
            boolean flag = Stenosis.near_start_point(target_stenosis, v);
            Stenosis.edit_drawing_stenosis(drawPanel, v, target_stenosis, flag);
        } else {
            drawPanel.operation_status = 11;
            Stenosis.start_dragging_stenosis(drawPanel, v, target_stenosis);
        }
    }

    static void start_drawing_stenosis(DrawPanel drawPanel, Vertex2D v) {
        target_vessel = drawPanel.find_closest_vessel(v);
        if (target_vessel == null) {
            return;
        }
        target_vessel = Stenosis.get_merged_vessel(target_vessel);
        start_v = target_vessel.find_closest_VertexOnStroke(v);
        stenosis = new Stenosis(target_vessel);
        Stenosis.stenosis.start_index = Stenosis.start_v.index;
        Stenosis.stenosis.end_index = Stenosis.start_v.index + 1;
        Stenosis.stenosis.ratio = 50.0;
        Stenosis.stenosis.type = 0;
    }

    static void drawing_stenosis(DrawPanel drawPanel, Vertex2D v) {
        int connect_point;
        if (target_vessel == null) {
            return;
        }
        end_v = target_vessel.find_closest_VertexOnStroke(v);
        if (Stenosis.end_v.index > Stenosis.start_v.index) {
            Stenosis.stenosis.start_index = Stenosis.start_v.index;
            Stenosis.stenosis.end_index = Stenosis.end_v.index;
        } else if (Stenosis.end_v.index < Stenosis.start_v.index) {
            Stenosis.stenosis.start_index = Stenosis.end_v.index;
            Stenosis.stenosis.end_index = Stenosis.start_v.index;
        } else {
            Stenosis.stenosis.start_index = Stenosis.start_v.index;
            Stenosis.stenosis.end_index = Stenosis.start_v.index + 1;
        }
        int i = 0;
        while (i < connect_points_count) {
            connect_point = connect_points[i];
            if (-5 < connect_point - Stenosis.stenosis.end_index && connect_point - Stenosis.stenosis.end_index < 5) {
                Stenosis.stenosis.end_index = connect_point;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < connect_points_count) {
            connect_point = connect_points[i];
            if (-5 < connect_point - Stenosis.stenosis.start_index && connect_point - Stenosis.stenosis.start_index < 5) {
                Stenosis.stenosis.start_index = connect_point;
                break;
            }
            ++i;
        }
        drawPanel.repaint_all();
    }

    static void finish_drawing_stenosis(DrawPanel drawPanel, Vertex2D v) {
        if (target_vessel == null) {
            return;
        }
        end_v = target_vessel.find_closest_VertexOnStroke(v);
        if (Vertex2D.same_position(Stenosis.start_v.v, Stenosis.end_v.v)) {
            stenosis.delete();
        } else {
            Stenosis.split_stenosis();
            Point p = drawPanel.getLocationOnScreen();
            AnnotatePanel.Annotate(drawPanel, stenosis, (int)v.x + p.x, (int)v.y + p.y);
        }
        target_vessel = null;
        stenosis = null;
    }

    static void paint_new_stenosis(Graphics g) {
        if (stenosis == null) {
            return;
        }
        stenosis.paint_outside(g);
        stenosis.paint_outside(g);
        stenosis.paint_inside(g);
    }

    static void edit_drawing_stenosis(DrawPanel drawPanel, Vertex2D v, Stenosis target_stenosis, boolean flag) {
        target_vessel = drawPanel.find_closest_vessel(v);
        if (target_vessel == null) {
            return;
        }
        stenosis = target_stenosis;
        target_vessel = Stenosis.get_merged_vessel(target_vessel);
        end_v = target_vessel.find_closest_VertexOnStroke(v);
        if (flag) {
            System.out.println("around start point");
            Stenosis.start_v.index = Stenosis.stenosis.end_index;
            Stenosis.end_v.index = Stenosis.stenosis.start_index;
        } else {
            System.out.println("around end point");
            Stenosis.start_v.index = Stenosis.stenosis.start_index;
            Stenosis.end_v.index = Stenosis.stenosis.end_index;
        }
    }

    static void start_dragging_stenosis(DrawPanel drawPanel, Vertex2D v, Stenosis target_stenosis) {
        target_vessel = drawPanel.find_closest_vessel(v);
        if (target_vessel == null) {
            return;
        }
        stenosis = target_stenosis;
        stenosis_real_end_index = Stenosis.stenosis.end_index;
        stenosis_real_start_index = Stenosis.stenosis.start_index;
        target_vessel = Stenosis.get_merged_vessel(target_vessel);
        start_v = target_vessel.find_closest_VertexOnStroke(v);
    }

    static void dragging_stenosis(DrawPanel drawPanel, Vertex2D v) {
        if (target_vessel == null) {
            return;
        }
        end_v = target_vessel.find_closest_VertexOnStroke(v);
        int move_index = Stenosis.end_v.index - Stenosis.start_v.index;
        start_v = end_v;
        Stenosis.slide_stenosis(stenosis, move_index);
        int i = 0;
        while (i < connect_points_count) {
            int connect_point = connect_points[i];
            move_index = connect_point - Stenosis.stenosis.end_index;
            if (-5 < move_index && move_index < 5) {
                Stenosis.slide_stenosis(stenosis, move_index);
                break;
            }
            move_index = connect_point - Stenosis.stenosis.start_index;
            if (-5 < move_index && move_index < 5) {
                Stenosis.slide_stenosis(stenosis, move_index);
                break;
            }
            ++i;
        }
        drawPanel.repaint_all();
    }

    static void finish_dragging_stenosis(DrawPanel drawPanel, Vertex2D v) {
        if (target_vessel == null) {
            return;
        }
        Stenosis.split_stenosis();
        target_vessel = null;
        stenosis = null;
    }

    static void slide_stenosis(Stenosis target, int _slide) {
        target.start_index += _slide;
        target.end_index += _slide;
        int i = 0;
        while (i < target.brothers.size()) {
            Stenosis brother = (Stenosis)target.brothers.get(i);
            brother.start_index += _slide;
            brother.end_index += _slide;
            ++i;
        }
    }

    static Stenosis pick_stenosis(Vertex2D v, ArrayList vessels) {
        Stenosis picked_stenosis = null;
        double min = 10.0;
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            int j = 0;
            while (j < vessel.stenoses.size()) {
                Stenosis stenosis = (Stenosis)vessel.stenoses.get(j);
                double d = stenosis.distance(v);
                if (d < min) {
                    picked_stenosis = stenosis;
                    min = d;
                }
                ++j;
            }
            ++i;
        }
        return picked_stenosis;
    }

    public double distance(Vertex2D p) {
        double min = -1.0;
        int i = this.start_index;
        while (i < this.end_index) {
            double d = this.vessel.getEdge(i).distance(p);
            if (min == -1.0 || min > d) {
                min = d;
            }
            ++i;
        }
        return min;
    }

    static Vessel get_merged_vessel(Vessel vessel) {
        root_vessel = vessel.get_root();
        Vessel merged_vessel = new Vessel();
        connect_points = new int[10];
        connect_points_count = 0;
        Vessel current_vessel = root_vessel;
        while (true) {
            int index;
            current_vessel.merged_index = merged_vessel.points.size();
            merged_vessel.points.addAll(current_vessel.points);
            Vessel next_vessel = current_vessel.successor;
            if (next_vessel == null) break;
            merged_vessel.points.remove(merged_vessel.points.size() - 1);
            Stenosis.connect_points[Stenosis.connect_points_count] = index = merged_vessel.points.size();
            ++connect_points_count;
            current_vessel = next_vessel;
        }
        int start_index = 100;
        int end_index = -1;
        if (stenosis != null) {
            int j = 0;
            while (j < Stenosis.stenosis.brothers.size()) {
                Stenosis brother = (Stenosis)Stenosis.stenosis.brothers.get(j);
                if (start_index > brother.start_index + brother.vessel.merged_index) {
                    start_index = brother.start_index + brother.vessel.merged_index;
                }
                if (end_index < brother.end_index + brother.vessel.merged_index) {
                    end_index = brother.end_index + brother.vessel.merged_index;
                }
                ++j;
            }
            Stenosis new_stenosis = new Stenosis(merged_vessel);
            new_stenosis.ratio = Stenosis.stenosis.ratio;
            new_stenosis.start_index = start_index;
            new_stenosis.end_index = end_index;
            new_stenosis.stenosis_id = Stenosis.stenosis.stenosis_id;
            stenosis.delete();
            stenosis = new_stenosis;
        }
        return merged_vessel;
    }

    static void split_stenosis() {
        int start = Stenosis.stenosis.start_index;
        int end = Stenosis.stenosis.end_index;
        Vessel current_vessel = root_vessel;
        int index = 0;
        ArrayList<Stenosis> brothers = new ArrayList<Stenosis>();
        while (start >= index + current_vessel.points.size() - 1) {
            index += current_vessel.points.size() - 1;
            current_vessel = current_vessel.successor;
        }
        Stenosis child_stenosis = new Stenosis(current_vessel);
        child_stenosis.start_index = start - index;
        child_stenosis.ratio = Stenosis.stenosis.ratio;
        child_stenosis.stenosis_id = Stenosis.stenosis.stenosis_id;
        brothers.add(child_stenosis);
        while (end > index + current_vessel.points.size() - 1) {
            child_stenosis.end_index = current_vessel.points.size() - 1;
            index += current_vessel.points.size();
            current_vessel = current_vessel.successor;
            child_stenosis.successor = true;
            child_stenosis = new Stenosis(current_vessel);
            child_stenosis.start_index = 0;
            child_stenosis.ratio = Stenosis.stenosis.ratio;
            child_stenosis.stenosis_id = Stenosis.stenosis.stenosis_id;
            brothers.add(child_stenosis);
            child_stenosis.predesessor = true;
        }
        child_stenosis.end_index = end - index;
        int i = 0;
        while (i < brothers.size()) {
            child_stenosis = (Stenosis)brothers.get(i);
            child_stenosis.brothers = brothers;
            ++i;
        }
        stenosis = child_stenosis;
    }

    static Stenosis set_stenosis(Vessel vessel, int start_index, int end_index) {
        Stenosis stenosis = new Stenosis(vessel);
        stenosis.start_index = start_index;
        stenosis.end_index = end_index;
        return stenosis;
    }

    static boolean edge_of_stenosis(Stenosis target_stenosis, Vertex2D v) {
        boolean return_val = false;
        if (Stenosis.near_start_point(target_stenosis, v) || Stenosis.near_end_point(target_stenosis, v)) {
            return_val = true;
        }
        return return_val;
    }

    static boolean near_start_point(Stenosis target_stenosis, Vertex2D v) {
        boolean return_val = false;
        int distance = 5;
        VertexOnStroke closest_v = target_vessel.find_closest_VertexOnStroke(v);
        if (closest_v.index - target_stenosis.start_index < distance && closest_v.index - target_stenosis.start_index > -distance) {
            return_val = true;
        }
        return return_val;
    }

    static boolean near_end_point(Stenosis target_stenosis, Vertex2D v) {
        boolean return_val = false;
        int distance = 5;
        VertexOnStroke closest_v = target_vessel.find_closest_VertexOnStroke(v);
        if (closest_v.index - target_stenosis.end_index < distance && closest_v.index - target_stenosis.end_index > -distance) {
            return_val = true;
        }
        return return_val;
    }

    void delete() {
        if (!this.vessel.stenoses.contains(this)) {
            return;
        }
        this.vessel.stenoses.remove(this);
        int i = 0;
        while (i < this.brothers.size()) {
            Stenosis stenosis = (Stenosis)this.brothers.get(i);
            if (stenosis != this) {
                stenosis.delete();
            }
            ++i;
        }
    }
}

