/*
 * Decompiled with CFR 0.152.
 */
package board;

import VisualNumerics.math.DoubleLU;
import VisualNumerics.math.DoubleMatrix;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;

public class Rigid {
    public static boolean USE_WEIGHT = false;
    int n_laplacians;
    int n_involved;
    Vertex2D[] vs;
    boolean[] fixed;
    double[] Lx;
    double[] Ly;
    double[][] _E;
    double[][] ET;
    DoubleLU doubleLU;
    double[] L;

    void compile(Stroke stroke, int index_low, int index_handle, int index_high) {
        int index_low_involved = index_low - 1;
        int index_high_involved = index_high + 1;
        if (!stroke.is_loop()) {
            if (index_low == 0) {
                index_low = 0;
                index_low_involved = 0;
            }
            if (index_high == stroke.number_of_points() - 1) {
                index_high_involved = index_high = stroke.number_of_points() - 1;
            }
        }
        this.n_involved = index_high_involved - index_low_involved + 1;
        this.n_laplacians = this.n_involved - 2;
        this.vs = new Vertex2D[this.n_involved];
        int i = index_low_involved;
        while (i <= index_high_involved) {
            Vertex2D v;
            this.vs[i - index_low_involved] = v = stroke.getPoint(i);
            ++i;
        }
        this.fixed = new boolean[this.n_involved];
        this.fixed[index_low_involved - index_low_involved] = true;
        this.fixed[index_low - index_low_involved] = true;
        this.fixed[index_handle - index_low_involved] = true;
        this.fixed[index_high - index_low_involved] = true;
        this.fixed[index_high_involved - index_low_involved] = true;
        this._E = new double[this.n_laplacians * 2][this.n_involved * 2];
        i = 0;
        while (i < this.n_laplacians) {
            int index = i + index_low;
            Vertex2D prev = this.vs[i];
            Vertex2D v = this.vs[i + 1];
            Vertex2D next = this.vs[i + 2];
            Vector2D vec = new Vector2D(prev, v);
            Vector2D x_vec = new Vector2D(prev, next);
            Vector2D y_vec = new Vector2D(-x_vec.y, x_vec.x);
            double dx = Vector2D.dot_product(vec, x_vec) / Vector2D.dot_product(x_vec, x_vec);
            double dy = Vector2D.dot_product(vec, y_vec) / Vector2D.dot_product(y_vec, y_vec);
            double[] dArray = this._E[i * 2];
            int n = i * 2 + 0;
            dArray[n] = dArray[n] + -(1.0 - dx);
            double[] dArray2 = this._E[i * 2];
            int n2 = i * 2 + 1;
            dArray2[n2] = dArray2[n2] + -dy;
            double[] dArray3 = this._E[i * 2];
            int n3 = i * 2 + 2;
            dArray3[n3] = dArray3[n3] + 1.0;
            double[] dArray4 = this._E[i * 2];
            int n4 = i * 2 + 3;
            dArray4[n4] = dArray4[n4] + 0.0;
            double[] dArray5 = this._E[i * 2];
            int n5 = i * 2 + 4;
            dArray5[n5] = dArray5[n5] + -dx;
            double[] dArray6 = this._E[i * 2];
            int n6 = i * 2 + 5;
            dArray6[n6] = dArray6[n6] + dy;
            double[] dArray7 = this._E[i * 2 + 1];
            int n7 = i * 2 + 0;
            dArray7[n7] = dArray7[n7] + dy;
            double[] dArray8 = this._E[i * 2 + 1];
            int n8 = i * 2 + 1;
            dArray8[n8] = dArray8[n8] + -(1.0 - dx);
            double[] dArray9 = this._E[i * 2 + 1];
            int n9 = i * 2 + 2;
            dArray9[n9] = dArray9[n9] + 0.0;
            double[] dArray10 = this._E[i * 2 + 1];
            int n10 = i * 2 + 3;
            dArray10[n10] = dArray10[n10] + 1.0;
            double[] dArray11 = this._E[i * 2 + 1];
            int n11 = i * 2 + 4;
            dArray11[n11] = dArray11[n11] + -dy;
            double[] dArray12 = this._E[i * 2 + 1];
            int n12 = i * 2 + 5;
            dArray12[n12] = dArray12[n12] + -dx;
            ++i;
        }
        int n_output = 0;
        int i2 = 0;
        while (i2 < this.n_involved) {
            if (!this.fixed[i2]) {
                ++n_output;
            }
            ++i2;
        }
        if (USE_WEIGHT) {
            double[] W = new double[this.n_laplacians];
            int i3 = 0;
            while (i3 < this.n_laplacians) {
                int index = i3 + index_low;
                Vertex2D prev = this.vs[i3];
                Vertex2D next = this.vs[i3 + 2];
                Vector2D vec = new Vector2D(prev, next);
                W[i3] = 1.0 / vec.length();
                ++i3;
            }
            i3 = 0;
            while (i3 < this.n_laplacians) {
                int j = 0;
                while (j < this.n_involved * 2) {
                    double[] dArray = this._E[i3 * 2];
                    int n = j;
                    dArray[n] = dArray[n] * W[i3];
                    double[] dArray13 = this._E[i3 * 2 + 1];
                    int n13 = j++;
                    dArray13[n13] = dArray13[n13] * W[i3];
                }
                ++i3;
            }
        }
        double[][] E = new double[this.n_laplacians * 2][n_output * 2];
        this.L = new double[this.n_laplacians * 2];
        int i4 = 0;
        while (i4 < this.n_laplacians) {
            int column = 0;
            int j = 0;
            while (j < this.n_involved) {
                if (!this.fixed[j]) {
                    E[i4 * 2][column * 2] = this._E[i4 * 2][j * 2];
                    E[i4 * 2][column * 2 + 1] = this._E[i4 * 2][j * 2 + 1];
                    E[i4 * 2 + 1][column * 2] = this._E[i4 * 2 + 1][j * 2];
                    E[i4 * 2 + 1][column * 2 + 1] = this._E[i4 * 2 + 1][j * 2 + 1];
                    ++column;
                }
                int n = i4 * 2;
                this.L[n] = this.L[n] + (this._E[i4 * 2][j * 2] * this.vs[j].x + this._E[i4 * 2][j * 2 + 1] * this.vs[j].y);
                int n14 = i4 * 2 + 1;
                this.L[n14] = this.L[n14] + (this._E[i4 * 2 + 1][j * 2] * this.vs[j].x + this._E[i4 * 2 + 1][j * 2 + 1] * this.vs[j].y);
                ++j;
            }
            ++i4;
        }
        this.ET = DoubleMatrix.transpose((double[][])E);
        double[][] ETE = DoubleMatrix.multiply((double[][])this.ET, (double[][])E);
        this.doubleLU = this.construct_doubleLU(ETE);
    }

    double[][] multiply(double[][] A, double[][] B) {
        return DoubleMatrix.multiply((double[][])A, (double[][])B);
    }

    double[][] transpose(double[][] A) {
        return DoubleMatrix.transpose((double[][])A);
    }

    public double[][] inverse(double[][] A) {
        double[][] _A = null;
        try {
            _A = DoubleMatrix.inverse((double[][])A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return _A;
    }

    void update() {
        double[] _L = (double[])this.L.clone();
        int i = 0;
        while (i < this.n_laplacians) {
            int j = 0;
            while (j < this.n_involved) {
                if (this.fixed[j]) {
                    int n = i * 2;
                    _L[n] = _L[n] - (this._E[i * 2][j * 2] * this.vs[j].x + this._E[i * 2][j * 2 + 1] * this.vs[j].y);
                    int n2 = i * 2 + 1;
                    _L[n2] = _L[n2] - (this._E[i * 2 + 1][j * 2] * this.vs[j].x + this._E[i * 2 + 1][j * 2 + 1] * this.vs[j].y);
                }
                ++j;
            }
            ++i;
        }
        double[] xy = this.doubleLU.solve(this.multiply(this.ET, _L));
        int count = 0;
        int j = 0;
        while (j < this.n_involved) {
            if (!this.fixed[j]) {
                this.vs[j].x = xy[count * 2];
                this.vs[j].y = xy[count * 2 + 1];
                ++count;
            }
            ++j;
        }
    }

    public double[] multiply(double[][] A, double[] x) {
        return DoubleMatrix.multiply((double[][])A, (double[])x);
    }

    public DoubleLU construct_doubleLU(double[][] A) {
        DoubleLU doubleLU = null;
        try {
            doubleLU = new DoubleLU(A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return doubleLU;
    }
}

