/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.AnnotateArrow;
import board.Arrow;
import board.Artery;
import board.Bypass;
import board.Corateral;
import board.DrawPanel;
import board.Stent;
import board.Stroke;
import board.Text;
import board.Util;
import board.Vessel;
import board.Visual;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class Record
implements Serializable {
    String filename;
    private ArrayList visuals = new ArrayList();

    public Record() {
    }

    public Record(String path, String filename) {
        this.filename = filename.substring(0, filename.length() - 4);
        this.load(String.valueOf(path) + filename);
    }

    public Record(ArrayList strokes, ArrayList areas) {
        this.visuals = Util.connectArrayList(areas, strokes);
    }

    public Record(ArrayList _visuals) {
        this.visuals = Util.duplicateArrayList(_visuals);
    }

    public void set(Record record) {
        this.visuals = record.visuals;
    }

    public void addStroke(Stroke stroke) {
        this.visuals.add(stroke);
    }

    public void add(Visual visual) {
        this.visuals.add(visual);
    }

    public void addAll(ArrayList vs) {
        this.visuals.addAll(vs);
    }

    public void remove(Visual visual) {
        this.visuals.remove(visual);
    }

    public ArrayList getStrokes() {
        return this.get(Stroke.class);
    }

    public ArrayList getVessels() {
        return this.get(Vessel.class);
    }

    public ArrayList getArteries() {
        return this.get(Artery.class);
    }

    public ArrayList getTexts() {
        return this.get(Text.class);
    }

    public ArrayList getArrows() {
        return this.get(Arrow.class);
    }

    public ArrayList getAnnotateArrows() {
        return this.get(AnnotateArrow.class);
    }

    public ArrayList getCoraterals() {
        return this.get(Corateral.class);
    }

    public ArrayList getBypasses() {
        return this.get(Bypass.class);
    }

    public ArrayList getStents() {
        return this.get(Stent.class);
    }

    public ArrayList get(Class classname) {
        ArrayList<Visual> results = new ArrayList<Visual>();
        int i = 0;
        while (i < this.visuals.size()) {
            Visual visual = (Visual)this.visuals.get(i);
            if (classname.isInstance(visual)) {
                results.add(visual);
            }
            ++i;
        }
        return results;
    }

    public Stroke getLastStroke() {
        int i = this.visuals.size() - 1;
        while (i >= 0) {
            Stroke stroke = (Stroke)this.visuals.get(i);
            if (stroke instanceof Stroke) {
                return stroke;
            }
            --i;
        }
        return null;
    }

    public void addStrokes(ArrayList _strokes) {
        this.visuals = Util.appendArrayList(this.visuals, _strokes);
    }

    public void removeStrokes(ArrayList _strokes) {
        int i = 0;
        while (i < _strokes.size()) {
            Stroke stroke = (Stroke)_strokes.get(i);
            this.visuals.remove(stroke);
            ++i;
        }
    }

    public void removeStroke(Stroke stroke) {
        this.visuals.remove(stroke);
    }

    public void clear() {
        this.visuals = new ArrayList();
    }

    public ArrayList getChains() {
        ArrayList chains = new ArrayList();
        int i = 0;
        while (i < this.visuals.size()) {
            Stroke stroke = (Stroke)this.visuals.get(i);
            ++i;
        }
        return chains;
    }

    public Record get_duplicated() {
        ArrayList<Stroke> new_visuals = new ArrayList<Stroke>();
        int i = 0;
        while (i < this.visuals.size()) {
            Stroke visual = (Stroke)this.visuals.get(i);
            new_visuals.add(visual.get_duplicated());
            ++i;
        }
        return new Record(new_visuals);
    }

    public void save(String filename) {
        System.out.print("SAVE : " + filename + "\n");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            ArrayList strokes = this.getStrokes();
            DrawPanel.getInstance().rootArtery.save(out);
            int i = 0;
            while (i < strokes.size()) {
                ((Stroke)strokes.get(i)).save(out);
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
    }

    public void load(String filename) {
        System.out.print("LOAD : " + filename + "\n");
        ArrayList<Stroke> strokes = new ArrayList<Stroke>();
        ArrayList areas = new ArrayList();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("stroke")) continue;
                Stroke stroke = new Stroke();
                stroke.load(in);
                strokes.add(stroke);
            }
            in.close();
            this.visuals = Util.connectArrayList(areas, strokes);
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
    }
}

