/*
 * Decompiled with CFR 0.152.
 */
package board;

import VisualNumerics.math.DoubleLU;
import VisualNumerics.math.DoubleMatrix;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;

public class LaplacianEdit {
    int n_laplacians;
    int n_involved;
    Vertex2D[] vs;
    boolean[] fixed;
    double[] Lx;
    double[] Ly;
    double[][] _E;
    double[][] ET;
    DoubleLU doubleLU;
    double[] L;

    void compile(Stroke stroke, int index_low, int index_handle, int index_high) {
        int index_low_involved = index_low - 1;
        int index_high_involved = index_high + 1;
        if (!stroke.is_loop()) {
            if (index_low == 0) {
                index_low = 0;
                index_low_involved = 0;
            }
            if (index_high == stroke.number_of_points() - 1) {
                index_high_involved = index_high = stroke.number_of_points() - 1;
            }
        }
        this.n_involved = index_high_involved - index_low_involved + 1;
        this.n_laplacians = this.n_involved - 2;
        this.vs = new Vertex2D[this.n_involved];
        int i = index_low_involved;
        while (i <= index_high_involved) {
            Vertex2D v;
            this.vs[i - index_low_involved] = v = stroke.getPoint(i);
            ++i;
        }
        this.fixed = new boolean[this.n_involved];
        this.fixed[index_low_involved - index_low_involved] = true;
        this.fixed[index_low - index_low_involved] = true;
        this.fixed[index_handle - index_low_involved] = true;
        this.fixed[index_high - index_low_involved] = true;
        this.fixed[index_high_involved - index_low_involved] = true;
        double[][][] T = new double[this.n_laplacians][2][2];
        int i2 = 0;
        while (i2 < this.n_laplacians) {
            T[i2] = this.compute_T(this.vs[i2], this.vs[i2 + 1], this.vs[i2 + 2]);
            ++i2;
        }
        this._E = new double[this.n_laplacians * 2][this.n_involved * 2];
        i2 = 0;
        while (i2 < this.n_laplacians) {
            double[] dArray = this._E[i2 * 2];
            int n = i2 * 2 + 0;
            dArray[n] = dArray[n] + (-0.5 + T[i2][0][0]);
            double[] dArray2 = this._E[i2 * 2];
            int n2 = i2 * 2 + 1;
            dArray2[n2] = dArray2[n2] + T[i2][0][1];
            double[] dArray3 = this._E[i2 * 2];
            int n3 = i2 * 2 + 2;
            dArray3[n3] = dArray3[n3] + (1.0 + T[i2][0][2]);
            double[] dArray4 = this._E[i2 * 2];
            int n4 = i2 * 2 + 3;
            dArray4[n4] = dArray4[n4] + T[i2][0][3];
            double[] dArray5 = this._E[i2 * 2];
            int n5 = i2 * 2 + 4;
            dArray5[n5] = dArray5[n5] + (-0.5 + T[i2][0][4]);
            double[] dArray6 = this._E[i2 * 2];
            int n6 = i2 * 2 + 5;
            dArray6[n6] = dArray6[n6] + T[i2][0][5];
            double[] dArray7 = this._E[i2 * 2 + 1];
            int n7 = i2 * 2 + 0;
            dArray7[n7] = dArray7[n7] + T[i2][1][0];
            double[] dArray8 = this._E[i2 * 2 + 1];
            int n8 = i2 * 2 + 1;
            dArray8[n8] = dArray8[n8] + (-0.5 + T[i2][1][1]);
            double[] dArray9 = this._E[i2 * 2 + 1];
            int n9 = i2 * 2 + 2;
            dArray9[n9] = dArray9[n9] + T[i2][1][2];
            double[] dArray10 = this._E[i2 * 2 + 1];
            int n10 = i2 * 2 + 3;
            dArray10[n10] = dArray10[n10] + (1.0 + T[i2][1][3]);
            double[] dArray11 = this._E[i2 * 2 + 1];
            int n11 = i2 * 2 + 4;
            dArray11[n11] = dArray11[n11] + T[i2][1][4];
            double[] dArray12 = this._E[i2 * 2 + 1];
            int n12 = i2 * 2 + 5;
            dArray12[n12] = dArray12[n12] + (-0.5 + T[i2][1][5]);
            ++i2;
        }
        int n_output = 0;
        int i3 = 0;
        while (i3 < this.n_involved) {
            if (!this.fixed[i3]) {
                ++n_output;
            }
            ++i3;
        }
        double[][] E = new double[this.n_laplacians * 2][n_output * 2];
        this.L = new double[this.n_laplacians * 2];
        int i4 = 0;
        while (i4 < this.n_laplacians) {
            int column = 0;
            int j = 0;
            while (j < this.n_involved) {
                if (!this.fixed[j]) {
                    E[i4 * 2][column * 2] = this._E[i4 * 2][j * 2];
                    E[i4 * 2][column * 2 + 1] = this._E[i4 * 2][j * 2 + 1];
                    E[i4 * 2 + 1][column * 2] = this._E[i4 * 2 + 1][j * 2];
                    E[i4 * 2 + 1][column * 2 + 1] = this._E[i4 * 2 + 1][j * 2 + 1];
                    ++column;
                }
                int n = i4 * 2;
                this.L[n] = this.L[n] + (this._E[i4 * 2][j * 2] * this.vs[j].x + this._E[i4 * 2][j * 2 + 1] * this.vs[j].y);
                int n13 = i4 * 2 + 1;
                this.L[n13] = this.L[n13] + (this._E[i4 * 2 + 1][j * 2] * this.vs[j].x + this._E[i4 * 2 + 1][j * 2 + 1] * this.vs[j].y);
                ++j;
            }
            ++i4;
        }
        this.ET = DoubleMatrix.transpose((double[][])E);
        double[][] ETE = DoubleMatrix.multiply((double[][])this.ET, (double[][])E);
        this.doubleLU = this.construct_doubleLU(ETE);
    }

    double[][] compute_T(Vertex2D v0, Vertex2D v1, Vertex2D v2) {
        Vertex2D[] vvs = new Vertex2D[]{v0, v1, v2};
        double[][] A = new double[6][4];
        int i = 0;
        while (i < vvs.length) {
            Vertex2D u = vvs[i];
            A[i * 2 + 0][0] = u.x;
            A[i * 2 + 0][1] = u.y;
            A[i * 2 + 0][2] = 1.0;
            A[i * 2 + 0][3] = 0.0;
            A[i * 2 + 1][0] = u.y;
            A[i * 2 + 1][1] = -u.x;
            A[i * 2 + 1][2] = 0.0;
            A[i * 2 + 1][3] = 1.0;
            ++i;
        }
        double[][] AT = this.transpose(A);
        double[][] ATA_AT = this.multiply(this.inverse(this.multiply(AT, A)), AT);
        double[] a = ATA_AT[0];
        double[] w = ATA_AT[1];
        double[][] T = new double[2][6];
        Vector2D LV = new Vector2D(Vertex2D.mid_point(v0, v2), v1);
        int i2 = 0;
        while (i2 < 6) {
            double[] dArray = T[0];
            int n = i2;
            dArray[n] = dArray[n] - (a[i2] * LV.x + w[i2] * LV.y);
            double[] dArray2 = T[1];
            int n2 = i2;
            dArray2[n2] = dArray2[n2] - (-w[i2] * LV.x + a[i2] * LV.y);
            ++i2;
        }
        return T;
    }

    double[][] multiply(double[][] A, double[][] B) {
        return DoubleMatrix.multiply((double[][])A, (double[][])B);
    }

    double[][] transpose(double[][] A) {
        return DoubleMatrix.transpose((double[][])A);
    }

    public double[][] inverse(double[][] A) {
        double[][] _A = null;
        try {
            _A = DoubleMatrix.inverse((double[][])A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return _A;
    }

    void update() {
        double[] _L = (double[])this.L.clone();
        int i = 0;
        while (i < this.n_laplacians) {
            int j = 0;
            while (j < this.n_involved) {
                if (this.fixed[j]) {
                    int n = i * 2;
                    _L[n] = _L[n] - (this._E[i * 2][j * 2] * this.vs[j].x + this._E[i * 2][j * 2 + 1] * this.vs[j].y);
                    int n2 = i * 2 + 1;
                    _L[n2] = _L[n2] - (this._E[i * 2 + 1][j * 2] * this.vs[j].x + this._E[i * 2 + 1][j * 2 + 1] * this.vs[j].y);
                }
                ++j;
            }
            ++i;
        }
        double[] xy = this.doubleLU.solve(this.multiply(this.ET, _L));
        int count = 0;
        int j = 0;
        while (j < this.n_involved) {
            if (!this.fixed[j]) {
                this.vs[j].x = xy[count * 2];
                this.vs[j].y = xy[count * 2 + 1];
                ++count;
            }
            ++j;
        }
    }

    public double[] multiply(double[][] A, double[] x) {
        return DoubleMatrix.multiply((double[][])A, (double[])x);
    }

    public DoubleLU construct_doubleLU(double[][] A) {
        DoubleLU doubleLU = null;
        try {
            doubleLU = new DoubleLU(A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return doubleLU;
    }
}

