/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Rectangle2D;
import board.Vector2D;
import board.Vertex2D;
import java.awt.Point;

public class Edge2D {
    Vertex2D start;
    Vertex2D end;
    double radius;

    Edge2D() {
    }

    public Edge2D(Vertex2D _start, Vertex2D _end) {
        this.start = _start;
        this.end = _end;
    }

    public Edge2D(Vertex2D _start, Vertex2D _end, double _radius) {
        this.start = _start;
        this.end = _end;
        this.radius = _radius;
    }

    Edge2D(Point _start, Point _end) {
        this.start = new Vertex2D(_start);
        this.end = new Vertex2D(_end);
    }

    public Vertex2D get_the_other_vertex(Vertex2D v) {
        if (v == this.start) {
            return this.end;
        }
        return this.start;
    }

    public static boolean cross(Edge2D e0, Edge2D e1) {
        return Edge2D.cross(e0.start.x, e0.start.y, e0.end.x, e0.end.y, e1.start.x, e1.start.y, e1.end.x, e1.end.y);
    }

    public static Vertex2D cross_point(Edge2D e0, Edge2D e1) {
        return Edge2D.cross_point(e0.start.x, e0.start.y, e0.end.x, e0.end.y, e1.start.x, e1.start.y, e1.end.x, e1.end.y);
    }

    public static boolean cross(double x1, double y1, double x2, double y2, double xx1, double yy1, double xx2, double yy2) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        double a1 = yy1 - yy2;
        double b1 = xx2 - xx1;
        double c1 = yy2 * xx1 - xx2 * yy1;
        if (Math.abs(a0 * b1 - a1 * b0) < 1.0E-5) {
            return false;
        }
        return (a0 * xx1 + b0 * yy1 + c0) * (a0 * xx2 + b0 * yy2 + c0) <= 0.0 && (a1 * x1 + b1 * y1 + c1) * (a1 * x2 + b1 * y2 + c1) <= 0.0;
    }

    public static Vertex2D cross_point(double x1, double y1, double x2, double y2, double xx1, double yy1, double xx2, double yy2) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        double a1 = yy1 - yy2;
        double b1 = xx2 - xx1;
        double c1 = yy2 * xx1 - xx2 * yy1;
        if (Math.abs(a0 * b1 - a1 * b0) < 1.0E-5) {
            return null;
        }
        double x = (b0 * c1 - b1 * c0) / (a0 * b1 - a1 * b0);
        double y = (a0 * c1 - a1 * c0) / (a1 * b0 - a0 * b1);
        return new Vertex2D(x, y);
    }

    public static boolean touch(Edge2D edge, Vertex2D v) {
        if (edge == null) {
            return false;
        }
        Vector2D start_to_end = new Vector2D(edge.start, edge.end);
        Vector2D start_to_v = new Vector2D(edge.start, v);
        Vector2D end_to_v = new Vector2D(edge.end, v);
        if (Vector2D.dot_product(start_to_end, start_to_v) < -1.0E-5) {
            return false;
        }
        if (Vector2D.dot_product(start_to_end, end_to_v) > 1.0E-5) {
            return false;
        }
        Vector2D unit_vec = Vector2D.normalize(start_to_end);
        double distance = Math.abs(Vector2D.cross_product(unit_vec, start_to_v));
        return distance < 1.0E-5;
    }

    public static Vertex2D touch_point(Edge2D edge, Vertex2D v) {
        Vector2D start_to_end = new Vector2D(edge.start, edge.end);
        Vector2D start_to_v = new Vector2D(edge.start, v);
        Vector2D unit_vec = Vector2D.normalize(start_to_end);
        double l = Vector2D.dot_product(unit_vec, start_to_v);
        Vector2D end_to_v = new Vector2D(edge.end, v);
        if (Vector2D.dot_product(start_to_end, start_to_v) < 0.0) {
            return new Vertex2D(edge.start);
        }
        if (Vector2D.dot_product(start_to_end, end_to_v) > 0.0) {
            return new Vertex2D(edge.end);
        }
        return Vertex2D.translate(edge.start, Vector2D.multiply(unit_vec, l));
    }

    public boolean right_side_of_edge(double x1, double y1, double x2, double y2, double x, double y) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        return a0 * x + b0 * y + c0 < 0.0;
    }

    public boolean equals(Vertex2D v0, Vertex2D v1) {
        return v0 == this.start && v1 == this.end || v1 == this.start && v0 == this.end;
    }

    public boolean contains(Vertex2D v) {
        return v == this.start || v == this.end;
    }

    public Vector2D Vector2D() {
        return new Vector2D(this.start, this.end);
    }

    public Vertex2D mid_point() {
        return new Vertex2D((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0);
    }

    public double length() {
        return Vertex2D.distance(this.start, this.end);
    }

    public static Edge2D reverse(Edge2D edge) {
        return new Edge2D(edge.end, edge.start);
    }

    public Vertex2D get_common_vertex(Edge2D edge) {
        if (this.start == edge.start || this.start == edge.end) {
            return this.start;
        }
        return this.end;
    }

    public double distance_as_infinite_line(Vertex2D v) {
        double a = this.end.x - this.start.x;
        double b = this.end.y - this.start.y;
        double bunbo = Math.sqrt(a * a + b * b);
        double bunshi = a * (v.y - this.start.y) - b * (v.x - this.start.x);
        if (bunbo == 0.0) {
            System.out.println("Error in Edge2D.distance");
            return 0.0;
        }
        return Math.abs(bunshi / bunbo);
    }

    public double distance(Vertex2D node) {
        if (this.start == this.end) {
            return Vertex2D.distance(node, this.start);
        }
        Vector2D vec0 = new Vector2D(this.start, this.end);
        Vector2D vec1 = new Vector2D(this.start, node);
        if (Vector2D.dot_product(vec0, vec1) <= 0.0) {
            return Vertex2D.distance(node, this.start);
        }
        vec1 = new Vector2D(this.end, node);
        if (Vector2D.dot_product(vec0, vec1) >= 0.0) {
            return Vertex2D.distance(node, this.end);
        }
        return this.distance_as_infinite_line(node);
    }

    public Vertex2D find_closest_vertex(Vertex2D p) {
        Vector2D vec0 = new Vector2D(this.start, this.end);
        Vector2D vec1 = new Vector2D(this.start, p);
        if (Vector2D.dot_product(vec0, vec1) < 1.0E-5) {
            return this.start;
        }
        vec1 = new Vector2D(this.end, p);
        if (Vector2D.dot_product(vec0, vec1) > -1.0E-5) {
            return this.end;
        }
        Vector2D vec = Vector2D.normalize(new Vector2D(this.start, this.end));
        vec = Vector2D.multiply(vec, Vector2D.dot_product(vec, new Vector2D(this.start, p)));
        return Vertex2D.translate(this.start, vec);
    }

    public static Vertex2D find_closest_vertex(Edge2D edge0, Edge2D edge1) {
        Vertex2D edge1_start = edge1.find_closest_vertex(edge0.start);
        Vertex2D edge1_end = edge1.find_closest_vertex(edge0.end);
        Vertex2D edge0_start = edge0.find_closest_vertex(edge1.start);
        Vertex2D edge0_end = edge0.find_closest_vertex(edge1.end);
        double d_edge1_start = Vertex2D.distance(edge1_start, edge0.start);
        double d_edge1_end = Vertex2D.distance(edge1_end, edge0.end);
        double d_edge0_start = Vertex2D.distance(edge0_start, edge1.start);
        double d_edge0_end = Vertex2D.distance(edge0_end, edge1.end);
        if (d_edge1_start <= d_edge1_end && d_edge1_start <= d_edge0_start && d_edge1_start <= d_edge0_end) {
            return edge1_start;
        }
        if (d_edge1_end <= d_edge0_start && d_edge1_end <= d_edge0_end) {
            return edge1_end;
        }
        if (d_edge0_start <= d_edge0_end) {
            return edge0_start;
        }
        return edge0_end;
    }

    public static double distance(Edge2D edge0, Edge2D edge1) {
        if (Edge2D.cross(edge0, edge1)) {
            return 0.0;
        }
        double d0 = edge0.distance(edge1.start);
        double d1 = edge0.distance(edge1.end);
        double d2 = edge1.distance(edge0.start);
        double d3 = edge1.distance(edge0.end);
        return Math.min(Math.min(d0, d1), Math.min(d2, d3));
    }

    public Rectangle2D get_bbox() {
        return this.get_bbox_main(this.radius);
    }

    public Rectangle2D get_bbox_central_axis() {
        return this.get_bbox_main(this.radius);
    }

    public Rectangle2D get_bbox_main(double r) {
        double x0 = Math.min(this.start.x, this.end.x) - r;
        double y0 = Math.min(this.start.y, this.end.y) - r;
        double width = Math.abs(this.end.x - this.start.x) + r * 2.0;
        double height = Math.abs(this.end.y - this.start.y) + r * 2.0;
        return new Rectangle2D(x0, y0, width, height);
    }
}

