/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Arrow;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;

public class Corateral
extends Arrow
implements Serializable {
    Corateral() {
        super(Color.blue);
    }

    Corateral(Stroke stroke) {
        super(stroke);
    }

    @Override
    public void paint(Graphics g) {
        this.HEAD_WIDTH = 15;
        this.HEAD_LENGTH = 15;
        this.radius = 2.0;
        g.setColor(Color.blue);
        if (this.points.size() <= 1) {
            return;
        }
        int n = this.points.size();
        int base_index = n - 1;
        double sum_length = 0.0;
        boolean stroke_is_long_enough = false;
        while (base_index >= 1) {
            if ((sum_length += Vertex2D.distance(this.getPoint(base_index - 1), this.getPoint(base_index))) > (double)this.HEAD_LENGTH) {
                stroke_is_long_enough = true;
                break;
            }
            --base_index;
        }
        if (base_index == 0) {
            base_index = 1;
        }
        Vertex2D base = this.paint_arrow_head(this.getPoint(n - 1), new Vector2D(this.getPoint(n - 1), this.getPoint(base_index - 1)), g);
        if (stroke_is_long_enough) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke((int)(this.radius * 2.0), 1, 1));
            int i = 0;
            while (i <= base_index - 2) {
                Vertex2D p = (Vertex2D)this.points.get(i);
                Vertex2D q = (Vertex2D)this.points.get(i + 1);
                g2.drawLine((int)p.x, (int)p.y, (int)q.x, (int)q.y);
                ++i;
            }
            Vertex2D p = (Vertex2D)this.points.get(base_index - 1);
            Vertex2D q = base;
            g2.drawLine((int)p.x, (int)p.y, (int)q.x, (int)q.y);
        }
    }
}

