/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.DrawPanel;
import board.Graphics2;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;
import board.VertexOnStroke;
import board.Vessel;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;

public class Bypass
extends Vessel
implements Serializable {
    boolean live = false;
    Vertex2D head;
    Vertex2D tail;
    public double originalRadius = 6.0;
    static double DISTANCE = 15.0;

    Bypass(Stroke stroke) {
        super(stroke);
    }

    @Override
    public void paint_outside(Graphics g) {
        g.setColor(Color.magenta);
        Graphics2.paint_wide_stroke(g, this.points, 2.0, false, false);
    }

    @Override
    public void paint_inside(Graphics g) {
        this.extend();
        g.setColor(Color.white);
        Graphics2.paint_wide_stroke(g, this.points, 0.0, false, false);
        this.extend_recover();
    }

    public void extend() {
        Vertex2D v0 = (Vertex2D)this.points.get(0);
        Vertex2D v1 = (Vertex2D)this.points.get(1);
        Vector2D vec = Vertex2D.subtract(v1, (Vector2D)v0);
        vec.normalize();
        this.head = new Vertex2D(v0);
        if (v0.radius > 0.0) {
            v0.warp(new Vertex2D(v0.x - vec.x, v0.y - vec.y));
        }
        v0 = (Vertex2D)this.points.get(this.points.size() - 1);
        v1 = (Vertex2D)this.points.get(this.points.size() - 2);
        vec = Vertex2D.subtract(v1, (Vector2D)v0);
        vec.normalize();
        this.tail = new Vertex2D(v0);
        if (v0.radius > 0.0) {
            v0.warp(new Vertex2D(v0.x - vec.x, v0.y - vec.y));
        }
    }

    public void extend_recover() {
        ((Vertex2D)this.points.get(0)).warp(this.head);
        ((Vertex2D)this.points.get(this.points.size() - 1)).warp(this.tail);
    }

    @Override
    public void set_original_radius() {
        int n = this.points.size();
        int i = 0;
        while (i < n) {
            Vertex2D v = this.getPoint(i);
            v.radius = this.originalRadius;
            ++i;
        }
    }

    public static VertexOnStroke findOnVessel(Vertex2D v) {
        double min = Double.MAX_VALUE;
        double d = 0.0;
        VertexOnStroke vertexOnStroke = new VertexOnStroke();
        ArrayList vessels = DrawPanel.getInstance().record.getVessels();
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            VertexOnStroke p = vessel.find_closest_VertexOnStroke(v);
            d = Vertex2D.distance(v, p.v);
            if (min > d) {
                min = d;
                vertexOnStroke = p;
            }
            ++i;
        }
        return vertexOnStroke;
    }

    private VertexOnStroke bypassOnVessel(Vertex2D v) {
        double min = Double.MAX_VALUE;
        double d = 0.0;
        VertexOnStroke vertexOnStroke = new VertexOnStroke();
        ArrayList vessels = DrawPanel.getInstance().record.getVessels();
        int i = 0;
        while (i < vessels.size()) {
            Vessel vessel = (Vessel)vessels.get(i);
            if (vessel != this) {
                VertexOnStroke p = vessel.find_closest_VertexOnStroke(v);
                d = Vertex2D.distance(v, p.v);
                if (min > d) {
                    min = d;
                    vertexOnStroke = p;
                }
            }
            ++i;
        }
        return vertexOnStroke;
    }

    public boolean is_bypassLastPointOnVessel(Vessel vessel) {
        double min = Double.MAX_VALUE;
        double d = 0.0;
        int i = 0;
        while (i < vessel.points.size()) {
            Vertex2D p = vessel.getPoint(i);
            d = Vertex2D.distance(p, this.lastPoint());
            if (min > d) {
                min = d;
            }
            ++i;
        }
        return min < DISTANCE;
    }

    public boolean is_bypassLastPointOnVessel() {
        Vertex2D v = this.lastPoint();
        VertexOnStroke vec = this.bypassOnVessel(v);
        double d = Vertex2D.distance(v, vec.v);
        return d < DISTANCE;
    }

    public int bypassLastPointOnVessel(Vessel vessel) {
        double min = Double.MAX_VALUE;
        double d = 0.0;
        int closest_index = -1;
        int i = 0;
        while (i < vessel.points.size()) {
            Vertex2D p = vessel.getPoint(i);
            d = Vertex2D.distance(p, this.lastPoint());
            if (min > d) {
                min = d;
                closest_index = i;
            }
            ++i;
        }
        return closest_index;
    }

    public boolean is_bypassFirstPointOnVessel() {
        Vertex2D v = this.firstPoint();
        VertexOnStroke vec = this.bypassOnVessel(v);
        double d = Vertex2D.distance(v, vec.v);
        return d < DISTANCE;
    }

    public VertexOnStroke bypassFirstPointOnVessel() {
        Vertex2D v = this.firstPoint();
        VertexOnStroke vec = this.bypassOnVessel(v);
        return vec;
    }

    public void set_live() {
        if (this.is_bypassFirstPointOnVessel() && this.is_bypassLastPointOnVessel()) {
            this.live = true;
        }
    }
}

