/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Graphics2;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;
import board.Vessel;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;

public class Artery
extends Vessel
implements Serializable {
    Vertex2D head;
    Vertex2D tail;

    public Artery(Stroke stroke) {
        super(stroke);
    }

    @Override
    public void paint_outside(Graphics g) {
        if (this.absent) {
            g.setColor(Color.gray);
        } else {
            g.setColor(Color.red);
        }
        if (this.name == "GEA" || this.name == "RITA" || this.name == "LITA") {
            Graphics2.paint_wide_stroke(g, this.points, 2.0, false, false);
        } else {
            Graphics2.paint_wide_stroke(g, this.points, 2.0, this.predecessor != null, true);
        }
    }

    @Override
    public void paint_inside(Graphics g) {
        this.extend();
        g.setColor(Color.white);
        ArrayList<Vertex2D> nonzero_points = null;
        Vertex2D prev_p = null;
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D p = (Vertex2D)this.points.get(i);
            if (nonzero_points == null) {
                if (p.radius > 0.0) {
                    nonzero_points = new ArrayList<Vertex2D>();
                    if (prev_p != null) {
                        nonzero_points.add(prev_p);
                    }
                    nonzero_points.add(p);
                }
            } else if (p.radius > 0.0) {
                nonzero_points.add(p);
            } else {
                nonzero_points.add(p);
                Graphics2.paint_wide_stroke(g, nonzero_points, 0.0, false, true);
                nonzero_points = null;
            }
            prev_p = p;
            ++i;
        }
        if (nonzero_points != null) {
            Graphics2.paint_wide_stroke(g, nonzero_points, 0.0, false, true);
        }
        this.extend_recover();
    }

    public void extend() {
        Vertex2D v0 = (Vertex2D)this.points.get(0);
        Vertex2D v1 = (Vertex2D)this.points.get(1);
        Vector2D vec = Vertex2D.subtract(v1, (Vector2D)v0);
        vec.normalize();
        this.head = new Vertex2D(v0);
        if (v0.radius > 0.0) {
            v0.warp(new Vertex2D(v0.x - vec.x, v0.y - vec.y));
        }
    }

    public void extend_recover() {
        ((Vertex2D)this.points.get(0)).warp(this.head);
    }
}

