/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.DrawPanel;
import board.Stroke;
import board.Vector2D;
import board.Vertex2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.ArrayList;

public class Arrow
extends Stroke
implements Serializable {
    private Color color;
    public int HEAD_WIDTH = 20;
    public int HEAD_LENGTH = 20;

    protected Arrow() {
    }

    protected Arrow(Color c) {
        this.color = c;
    }

    protected Arrow(Stroke stroke) {
        this.points = stroke.points;
    }

    public Color getColor() {
        return this.color;
    }

    public void paint(Graphics g) {
    }

    public Vertex2D paint_arrow_head(Vertex2D v, Vector2D vec, Graphics g) {
        vec.normalize();
        Vector2D cross = Vector2D.rotate90(vec);
        Vertex2D base = Vertex2D.translate(v, Vector2D.multiply(vec, this.HEAD_LENGTH));
        Vertex2D v0 = Vertex2D.translate(base, Vector2D.multiply(cross, this.HEAD_WIDTH / 2));
        Vertex2D v1 = Vertex2D.translate(base, Vector2D.multiply(cross, -this.HEAD_WIDTH / 2));
        Polygon polygon = new Polygon();
        polygon.addPoint((int)v.x, (int)v.y);
        polygon.addPoint((int)v0.x, (int)v0.y);
        polygon.addPoint((int)v1.x, (int)v1.y);
        g.fillPolygon(polygon);
        return base;
    }

    static ArrayList convert_strokes_to_arrows(ArrayList strokes) {
        ArrayList<Arrow> arrows = new ArrayList<Arrow>();
        int i = strokes.size() - 1;
        while (i >= 0) {
            Stroke stroke = (Stroke)strokes.get(i);
            if (stroke.type == 6) {
                Arrow arrow = new Arrow(stroke);
                arrows.add(arrow);
            }
            --i;
        }
        return arrows;
    }

    void delete() {
        DrawPanel.getInstance().record.remove(this);
    }
}

